'    Timer control routines for Great Cow BASIC
'    Copyright (C) 2006  Hugh Considine

'    This library is free software; you can redistribute it and/or
'    modify it under the terms of the GNU Lesser General Public
'    License as published by the Free Software Foundation; either
'    version 2.1 of the License, or (at your option) any later version.

'    This library is distributed in the hope that it will be useful,
'    but WITHOUT ANY WARRANTY; without even the implied warranty of
'    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
'    Lesser General Public License for more details.

'    You should have received a copy of the GNU Lesser General Public
'    License along with this library; if not, write to the Free Software
'    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

'********************************************************************************
'IMPORTANT:
'THIS FILE IS ESSENTIAL FOR SOME OF THE COMMANDS IN GCBASIC. DO NOT ALTER THIS FILE
'UNLESS YOU KNOW WHAT YOU ARE DOING. CHANGING THIS FILE COULD RENDER SOME GCBASIC
'COMMANDS UNUSABLE!
'********************************************************************************

'Subroutines:
' InitTimer0 (Source, Prescaler)
' InitTimer1 (Source, Prescaler)
' InitTimer2 (Prescaler)
' ClearTimer(TimerNumber)
' StartTimer(TimerNumber)
' StopTimer(TimerNumber)


'Some simpler names for the timers (use to read)
#define Timer0 TMR0
'#define Timer1 TMR1L
#define Timer2 TMR2

'Sources
#define Osc 1
#define Ext 2
#define ExtOsc 3

'Timer 0 prescales
#define PS0_1/2 0
#define PS0_1/4 1
#define PS0_1/8 2
#define PS0_1/16 3
#define PS0_1/32 4
#define PS0_1/64 5
#define PS0_1/128 6
#define PS0_1/256 7

'Timer 1 prescales
#define PS1_1/1 0
#define PS1_1/2 16
#define PS1_1/4 32
#define PS1_1/8 48

word function Timer1
 Timer1 = TMR1L
 Timer1_H = TMR1H
end function

'Start/Clear/Stop subs
sub StartTimer(TMRNumber) #NR
 'Timer 0 always runs
 if TMRNumber = 1 then SET T1CON.TMR1ON ON
end sub

sub ClearTimer(TMRNumber) #NR
 if TMRNumber = 0 then TMR0 = 0: SysInitTimer0
 if TMRNumber = 1 then TMR1H = 0: TMR1L = 0: SysInitTimer1
 if TMRNumber = 2 then TMR2 = 0
end sub

sub StopTimer(TMRNumber) #NR
 'Timer 0 always runs
 if TMRNumber = 1 then SET T1CON.TMR1ON OFF
end sub

'Initialise subs for individual timers
sub InitTimer0(TMR0Source, TMR0Pres) #NR
 SysInitTimer0
end sub

sub SysInitTimer0
 OPTION_REG = OPTION_REG AND 192
 SET OPTION_REG.PSA OFF
 if TMR0Source = Osc THEN SET OPTION_REG.T0SE OFF
 if TMR0Source = Ext THEN SET OPTION_REG.T0SE ON
 clrwdt
 OPTION_REG = OPTION_REG OR TMR0Pres
end sub

sub InitTimer1(TMR1Source, TMR1Pres) #NR
 SysInitTimer1
end sub

sub SysInitTimer1
 T1CON = TMR1Pres
 if TMR1Source = Ext then SET T1CON.TMR1CS ON
 if TMR1Source = ExtOsc then SET T1CON.TMR1CS ON: SET T1CON.T1OSCEN ON
end sub

sub InitTimer2 (TMR2Pres) #NR

end sub
