'    System routines for Great Cow BASIC
'    Copyright (C) 2006 Hugh Considine

'    This library is free software; you can redistribute it and/or
'    modify it under the terms of the GNU Lesser General Public
'    License as published by the Free Software Foundation; either
'    version 2.1 of the License, or (at your option) any later version.

'    This library is distributed in the hope that it will be useful,
'    but WITHOUT ANY WARRANTY; without even the implied warranty of
'    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
'    Lesser General Public License for more details.

'    You should have received a copy of the GNU Lesser General Public
'    License along with this library; if not, write to the Free Software
'    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

'********************************************************************************
'IMPORTANT:
'THIS FILE IS ESSENTIAL FOR SOME OF THE COMMANDS IN GCBASIC. DO NOT ALTER THIS FILE
'UNLESS YOU KNOW WHAT YOU ARE DOING. CHANGING THIS FILE COULD RENDER SOME GCBASIC
'COMMANDS UNUSABLE!
'********************************************************************************

'Constants
#define ON 1
#define OFF 0
#define TRUE 255
#define FALSE 0

'Tokenise AND, OR, XOR, NOT
#define AND &
#define OR |
#define XOR #
#define NOT !

'System initialisation routine
sub InitSys
'Ensure all ports are set for digital I/O
'Turn off comparator
#IFDEF Var(CMCON)
 CMCON = 7
#ENDIF

'Turn off A/D
#IFDEF Var(ADCON0)
 SET ADCON0.ADON OFF
 #IFDEF NoVar(ANSEL)
  SET ADCON1.PCFG3 OFF
  SET ADCON1.PCFG2 ON
  SET ADCON1.PCFG1 ON
  SET ADCON1.PCFG0 OFF
 #ENDIF
 #IFDEF Var(ANSEL)
  ANSEL = 0
 #ENDIF
 #IFDEF Var(ANSELH)
  ANSELH = 0
 #ENDIF
#ENDIF
end sub

'Multiply sub
sub SysMultSub
 clrf SysCalcTempX
MUL8LOOP:
 movf SysCalcTempA, W
 btfsc SysCalcTempB, 0
 addwf SysCalcTempX, F
 bcf STATUS, C
 rrf SysCalcTempB, F
 bcf STATUS, C
 rlf SysCalcTempA, F
 movf SysCalcTempB, F
 btfss STATUS, Z
 goto MUL8LOOP
end sub

sub SysMultSub16

 dim SysCalcTempA as word
 dim SysCalcTempB as word
 dim SysCalcTempX as word

 dim SysDivMultA as word
 dim SysDivMultB as word
 dim SysDivMultX as word

 SysDivMultA = SysCalcTempA
 SysDivMultB = SysCalcTempB
 SysDivMultX = 0

MUL16LOOP:
 IF SysDivMultB.0 ON then SysDivMultX += SysDivMultA
 set STATUS.C OFF
 rotate SysDivMultB right
 set STATUS.C off
 rotate SysDivMultA left
 if SysDivMultB > 0 then goto MUL16LOOP

 SysCalcTempX = SysDivMultX
end sub

'Divide sub
sub SysDivSub

'Check for div/0
 movf SysCalcTempB, F
 btfsc STATUS, Z
 return

'Main calc routine
 movlw 8
 movwf SysDivLoop
 clrf SysCalcTempX
DIV8LOOP:
 bcf STATUS,C
 rlf SysCalcTempX
 bcf STATUS,C
 rlf SysCalcTempA
 btfsc STATUS,C
 bsf SysCalcTempX,0

 movf SysCalcTempB,W
 subwf SysCalcTempX,W
 btfsc STATUS,C
 bsf SysCalcTempA,0
 btfsc STATUS,C
 movwf SysCalcTempX

 decfsz SysDivLoop,F
 goto DIV8LOOP
end sub

sub SysDivSub16

 dim SysCalcTempA as word
 dim SysCalcTempB as word
 dim SysCalcTempX as word
 dim SysDivMultA as word
 dim SysDivMultB as word
 dim SysDivMultX as word

 SysDivLoop = 16
 SysDivMultA = SysCalcTempA
 SysDivMultB = SysCalcTempB
 SysDivMultX = 0

 'Avoid division by zero
 if SysDivMultB = 0 then
  SysCalcTempA = 0
  exit sub
 end if

DIV16LOOP:
 bcf STATUS,C
 rotate SysDivMultX left
 bcf STATUS,C
 rotate SysDivMultA left
 btfsc STATUS,C
 bsf SysDivMultX,0

 if SysDivMultX >= SysDivMultB then
  bsf SysDivMultA,0
  SysDivMultX = SysDivMultX - SysDivMultB
 end if

 decfsz SysDivLoop,F
 goto DIV16LOOP

 SysCalcTempA = SysDivMultA

end sub

'Condition checking subs

'Equal
sub SysCompEqual
 clrf SysCalcTempX
 movf SysCalcTempA, W
 subwf SysCalcTempB, W
 btfss STATUS, Z
 return
 movlw TRUE
 movwf SysCalcTempX
end sub

sub SysCompEqual16

 dim SysCalcTempA as word
 dim SysCalcTempB as word
 dim SysCalcTempX as word

 'Test low byte
 SysCompEqual
 movf SysCalcTempX,F
 btfsc STATUS, Z
 return

 'Test high byte
 SysCalcTempA = SysCalcTempA_H
 SysCalcTempB = SysCalcTempB_H
 SysCompEqual
end sub

'Not Equal
sub SysCompNotEqual
 clrf SysCalcTempX
 movf SysCalcTempA, W
 subwf SysCalcTempB, W
 btfsc STATUS, Z
 return
 movlw TRUE
 movwf SysCalcTempX
end sub

sub SysCompNotEqual16
 dim SysCalcTempA as word
 dim SysCalcTempB as word
 dim SysCalcTempX as word

 'Test low byte
 SysCompNotEqual
 movf SysCalcTempX, F
 btfsc STATUS, Z
 return

 'Test high byte
 SysCalcTempA = SysCalcTempA_H
 SysCalcTempB = SysCalcTempB_H
 SysCompNotEqual
end sub

'Less than
'A-B - if negative, C is off
'if A is 4 and B is 2, C is on
'if A is 3 and B is 3, C is on
'if A is 2 and B is 4, C is off
sub SysCompLessThan
 clrf SysCalcTempX
 movf SysCalcTempB, W
 subwf SysCalcTempA, W
 btfsc STATUS, C
 return
 movlw TRUE
 movwf SysCalcTempX
end sub

sub SysCompLessThan16
 dim SysCalcTempA as word
 dim SysCalcTempB as word
 dim SysCalcTempX as word

 'Test high byte
 SysCompLessOrEqual
 movf SysCalcTempX, F
 btfsc STATUS, Z
 return

 SysCompLessThan
 movf SysCalcTempX, F
 btfss STATUS, Z
 return

' SysCompLessThan
' movf SysCalcTempX, F
' btfsc STATUS, Z
' goto SCLT16Low
' SysCalcTempX = TRUE
' return
'SCLT16Low:

 'Test low byte
 SysCalcTempA = SysCalcTempA_H
 SysCalcTempB = SysCalcTempB_H
 SysCompLessThan
end sub

'Greater than
'B-A - if negative, C is off
'if A is 4 and B is 2, C is off
'if A is 3 and B is 3, C is on
'if A is 2 and B is 4, C is on
sub SysCompMoreThan
 clrf SysCalcTempX
 movf SysCalcTempA, W
 subwf SysCalcTempB, W
 btfsc STATUS, C
 return
 movlw TRUE
 movwf SysCalcTempX
end sub

sub SysCompMoreThan16
 'Check A is more or equal to B - exit FALSE if not
 'Check A is more than B - exit TRUE if is

 dim SysCalcTempA as word
 dim SysCalcTempB as word
 dim SysCalcTempX as word

 'Test high byte
 SysCompMoreOrEqual
 movf SysCalcTempX, F
 btfsc STATUS, Z
 return

 SysCompMoreThan
 movf SysCalcTempX, F
 btfss STATUS, Z
 return

' SysCompMoreThan
' movf SysCalcTempX, F
' btfsc STATUS, Z
' goto SCMT16Low
' SysCalcTempX = TRUE
' return
'SCMT16Low:

 'Test low byte
 SysCalcTempA = SysCalcTempA_H
 SysCalcTempB = SysCalcTempB_H
 SysCompMoreThan
end sub

'Less than or equal to
'B-A - if negative, C is off
'if A is 4 and B is 2, C is off
'if A is 3 and B is 3, C is on
'if A is 2 and B is 4, C is on
sub SysCompLessOrEqual

 clrf SysCalcTempX
 movf SysCalcTempA, W
 subwf SysCalcTempB, W
 btfss STATUS, C
 return
 movlw TRUE
 movwf SysCalcTempX
end sub

sub SysCompLessOrEqual16
 dim SysCalcTempA as word
 dim SysCalcTempB as word
 dim SysCalcTempX as word

 'Test high byte
 SysCompLessOrEqual
 movf SysCalcTempX, F
 btfsc STATUS, Z
 return

 SysCompLessThan
 movf SysCalcTempX, F
 btfss STATUS, Z
 return

 'Test low byte
 SysCalcTempA = SysCalcTempA_H
 SysCalcTempB = SysCalcTempB_H
 SysCompLessOrEqual
end sub

'Equal to or greater than
'A-B - if negative, C is off
'if A is 4 and B is 2, C is on
'if A is 3 and B is 3, C is off
'if A is 2 and B is 4, C is off
sub SysCompMoreOrEqual
 clrf SysCalcTempX
 movf SysCalcTempB, W
 subwf SysCalcTempA, W
 btfss STATUS, C
 return
 movlw TRUE
 movwf SysCalcTempX
end sub

sub SysCompMoreOrEqual16
 dim SysCalcTempA as word
 dim SysCalcTempB as word
 dim SysCalcTempX as word

 'Test high byte
 SysCompMoreOrEqual
 movf SysCalcTempX, F
 btfsc STATUS, Z
 return

 SysCompMoreThan
 movf SysCalcTempX, F
 btfss STATUS, Z
 return

 'Test low byte
 SysCalcTempA = SysCalcTempA_H
 SysCalcTempB = SysCalcTempB_H
 SysCompMoreOrEqual
end sub

