'    Some common BASIC commands/functions for Great Cow BASIC
'    Copyright (C) 2006 Hugh Considine

'    This library is free software; you can redistribute it and/or
'    modify it under the terms of the GNU Lesser General Public
'    License as published by the Free Software Foundation; either
'    version 2.1 of the License, or (at your option) any later version.

'    This library is distributed in the hope that it will be useful,
'    but WITHOUT ANY WARRANTY; without even the implied warranty of
'    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
'    Lesser General Public License for more details.

'    You should have received a copy of the GNU Lesser General Public
'    License along with this library; if not, write to the Free Software
'    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

'********************************************************************************
'IMPORTANT:
'THIS FILE IS ESSENTIAL FOR SOME OF THE COMMANDS IN GCBASIC. DO NOT ALTER THIS FILE
'UNLESS YOU KNOW WHAT YOU ARE DOING. CHANGING THIS FILE COULD RENDER SOME GCBASIC
'COMMANDS UNUSABLE!
'********************************************************************************

'Misc settings
#define RandomTimer TMR0

'Direct memory access
sub POKE (MemAdr As Word, MemData) #NR
 SET STATUS.IRP OFF
 if MemAdr.8 ON then SET STATUS.IRP ON
 FSR = MemAdr
 INDF = MemData
end sub

function PEEK(MemAdr As Word) #NR
 SET STATUS.IRP OFF
 if MemAdr.8 ON then SET STATUS.IRP ON 
 FSR = MemAdr
 PEEK = INDF
end function

'Software PWM
'Cannot be put in pwm.h, as then the InitPWM sub will be called, even though it is not needed

'Duty is /255, Dur is ms
sub PWMOut(PWMChannel, SoftPWMDuty, SoftPWMCycles) #NR
 For PWMDur = 1 to SoftPWMCycles
  For DOPWM = 1 to 255

   if SoftPWMDuty <= DOPWM then
#IFDEF PWM_Out1
    if PWMChannel = 1 then set PWM_Out1 ON
#ENDIF
#IFDEF PWM_Out2
    if PWMChannel = 2 then set PWM_Out2 ON
#ENDIF
#IFDEF PWM_Out3
    if PWMChannel = 3 then set PWM_Out3 ON
#ENDIF
#IFDEF PWM_Out4
    if PWMChannel = 4 then set PWM_Out4 ON
#ENDIF
   end if

   if SoftPWMDuty > DOPWM then
#IFDEF PWM_Out1
    if PWMChannel = 1 then set PWM_Out1 OFF
#ENDIF
#IFDEF PWM_Out2
    if PWMChannel = 2 then set PWM_Out2 OFF
#ENDIF
#IFDEF PWM_Out3
    if PWMChannel = 3 then set PWM_Out3 OFF
#ENDIF
#IFDEF PWM_Out4
    if PWMChannel = 4 then set PWM_Out4 OFF
#ENDIF
   end if
#IFDEF PWM_Delay
   Wait PWM_Delay
#ENDIF

  next
 next
end sub

'Delay
sub SLEEP (time) #NR
 Wait Time s
end sub

sub Pause (time) #NR
 Wait Time ms
end sub

'String
function LEN (LENTemp())
 LEN = LENTemp(0)
end function

'Random number
function Random
 RandomCount += 1
 Random = (RandomSeed + PORTA + RandomTimer) * RandomCount
 RandomSeed = swap4(Random)
 Random = Random XOR RandomCount * 11
end function

sub Randomize(RandomSeed) #NR
end sub

function Average(SysCalcTempA, SysCalcTempB) #NR
 SET STATUS.C OFF
 Average = SysCalcTempA + SysCalcTempB
 ROTATE Average RIGHT
end sub

'Miscellaneous Variable handling subs
'Written by Geordie Millar

'Swap SysTempA and SysTempB
sub Swap(SysCalcTempA, SysCalcTempB)
 SysCalcTempX = SysCalcTempA
 SysCalcTempA = SysCalcTempB
 SysCalcTempB = SysCalcTempX
end sub

'Swap nibbles (4-byte blocks)
function swap4(SysCalcTempA) #NR
 SWAPF SysCalcTempA, W
 MOVWF swap4
end function