'    Serial/RS232 routines for Great Cow BASIC
'    Copyright (C) 2006 Hugh Considine

'    This library is free software; you can redistribute it and/or
'    modify it under the terms of the GNU Lesser General Public
'    License as published by the Free Software Foundation; either
'    version 2.1 of the License, or (at your option) any later version.

'    This library is distributed in the hope that it will be useful,
'    but WITHOUT ANY WARRANTY; without even the implied warranty of
'    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
'    Lesser General Public License for more details.

'    You should have received a copy of the GNU Lesser General Public
'    License along with this library; if not, write to the Free Software
'    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

'********************************************************************************
'IMPORTANT:
'THIS FILE IS ESSENTIAL FOR SOME OF THE COMMANDS IN GCBASIC. DO NOT ALTER THIS FILE
'UNLESS YOU KNOW WHAT YOU ARE DOING. CHANGING THIS FILE COULD RENDER SOME GCBASIC
'COMMANDS UNUSABLE!
'********************************************************************************

'Usage of Sys232Temp
'Bit		Use
'0		Dummy receive source
'1		Receive buffer

'No. of 232 ports
'Will default to highest possible - to override, define in main program file.
#define Ser_LINKS 3

'I/O command defines
'Note: These all default to dummy ports and MUST BE CHANGED PRIOR TO USE
#define SendALow  nop
#define SendAHigh  nop
#define RecALow Sys232Temp.0 OFF
#define RecAHigh Sys232Temp.0 ON
#define SendBLow  nop
#define SendBHigh  nop
#define RecBLow Sys232Temp.0 OFF
#define RecBHigh Sys232Temp.0 ON
#define SendCLow  nop
#define SendCHigh  nop
#define RecCLow Sys232Temp.0 OFF
#define RecCHigh Sys232Temp.0 ON

'Assign values to key words

'Parity
#define none 0
#define odd 1
#define even 2

'Signal Inversion
#define normal 0
#define invert 1

'Start Bit settings
#define WaitForStart 128

'Bit rate delays
'r* is us delay/52 for 1 bit
#define r300 64
#define r600 32
#define r1200 16
#define r2400 8
#define r4800 4
#define r9600 2
#define r19200 1

'Serial receive buffer
#define SerRxData Sys232Temp.1

'Calculate accurate timing for 1 bit (units: 10us)
#script
 Sendr19200 = 5-40/ChipMHz
 Sendr9600 = 10-40/ChipMHz
 Sendr4800 = 21-40/ChipMHz
 Sendr2400 = 42-40/ChipMHz
 Sendr1200 = 83-40/ChipMHz
 Sendr600 = 166-40/ChipMHz
 Sendr300 = 33-40/ChipMHz
#endscript

sub InitSer(Ser_Select,Ser_Rate,Ser_Start,Ser_Data,Ser_Stop,Ser_Parity,Ser_Invert) #NR
'This sub sets configuration of the serial routines
'Sample usage for communication with Lego RCX:
'InitSer(1,r2400,1,8,1,odd,invert)

Ser_Select_Old = Ser_Select

if Ser_Select = 1 THEN
 Ser_Rate_A = Ser_Rate
 Ser_Start_A = Ser_Start
 Ser_Data_A = Ser_Data 
 Ser_Stop_A = Ser_Stop
 Ser_Parity_A = Ser_Parity
 Ser_Invert_A = Ser_Invert
END IF

#IFDEF Ser_LINKS 2,3
if Ser_Select = 2 THEN
 Ser_Rate_B = Ser_Rate
 Ser_Start_B = Ser_Start
 Ser_Data_B = Ser_Data 
 Ser_Stop_B = Ser_Stop
 Ser_Parity_B = Ser_Parity
 Ser_Invert_B = Ser_Invert
END IF
#ENDIF

#IFDEF Ser_LINKS 3
if Ser_Select = 3 THEN
 Ser_Rate_C = Ser_Rate
 Ser_Start_C = Ser_Start
 Ser_Data_C = Ser_Data 
 Ser_Stop_C = Ser_Stop
 Ser_Parity_C = Ser_Parity
 Ser_Invert_C = Ser_Invert
END IF
#ENDIF
end sub

sub SerSend(Ser_Select,Ser_Byte) #NR

 'Load configuration data
 if Ser_Select <> Ser_Select_Old then SerCfgLoad(Ser_Select)

 'Start
 Ser_Temp2 = Ser_Start and (not WaitForStart)
 for Bit = 1 to Ser_Temp2
  SerTxHigh
 next

 'Data
 TempParity = Ser_Temp2
 for bit = 1 to Ser_Data
  if Ser_Invert = normal then
   if Ser_Byte.0 ON then SerTxHigh: TempParity = TempParity + 1
   if Ser_Byte.0 OFF then SerTxLow
  end if
  if Ser_Invert = invert then
   if Ser_Byte.0 ON then SerTxLow: TempParity = TempParity + 1
   if Ser_Byte.0 OFF then SerTxHigh
  end if
  rotate Ser_Byte right
 next

 'Parity
 if Ser_Parity <> 0 THEN
  if Ser_Parity = odd then TempParity = TempParity + 1
  if Ser_Invert = invert then TempParity = TempParity + 1
  if TempParity.0 ON then SerTxLow
  if TempParity.0 OFF then SerTxHigh
 end if

 'End
 for bit = 1 to Ser_Stop
  SerTxLow
 next

end sub

sub SerReceive(Ser_Select,Ser_Byte)

 'Load configuration data
 if Ser_Select <> Ser_Select_Old then SerCfgLoad(Ser_Select)
 
 'Receive start bit/s
 if Ser_Start.7 on then wait until SerQuickSample = TRUE
 Ser_Temp2 = Ser_Start and (not WaitForStart)
 for Bit = 1 to Ser_Temp2
  SerRxBit
 next

 'Receive byte
 Ser_Byte = 0
 for Bit = 1 to Ser_Data
  ROTATE Ser_Byte RIGHT
  SerRxBit
  if SerRxData ON then SET Ser_Byte.7 ON
  if SerRxData OFF then SET Ser_Byte.7 OFF
 next
 if Ser_Data < 8 then
  SerTemp2 = 8 - Ser_Data
  for SerTemp = 1 to SerTemp2
   ROTATE Ser_Byte RIGHT
  next
 end if
 if Ser_Invert = invert then Ser_Byte = !Ser_Byte
 
 'Receive parity
 if Ser_Parity <> 0 THEN
  TempParity = 0
  SerRxBit
 end if

  'Receive stop bit/s 
 if Ser_Start.7 on then wait until SerQuickSample = FALSE
 if Ser_Start.7 off then
  for Bit = 1 to Ser_Stop
   SerRxBit
  next
 end if

end sub

sub SerPrint (Ser_Select, PrintData$) #NR
 'PrintLen = LEN(PrintData$)
 PrintLen = PrintData(0)

 if PrintLen = 0 then exit sub
 
 'Write Data
 for SysPrintTemp = 1 to PrintLen
  SerSend(Ser_Select, PrintData(SysPrintTemp))
 next
end sub

'Note: When calling this sub, set Ser_Select and Ser_Rate, and read SerRxData
sub SerRxBit
 'Clear bit counters
 RxHighCount = 0
 
 'Read Port
 for SerBitSample = 1 to 3
  if Ser_Select = 1 THEN 
   if RecAHigh then RxHighCount = RxHighCount + 1
  end if
#IFDEF Ser_Links 2,3
  if Ser_Select = 2 THEN 
   if RecBHigh then RxHighCount = RxHighCount + 1
  end if
#ENDIF
#IFDEF Ser_Links 3
  if Ser_Select = 3 THEN 
   if RecCHigh then RxHighCount = RxHighCount + 1
  end if
#ENDIF
  SerThirdBitDelay
 next
 
 'Decide whether received bit is 0 or 1, based on bit counters
 SET SerRxData OFF
 if RxHighCount.1 ON then SET SerRxData ON
end sub

sub SerTxHigh
 if Ser_Select = 1 THEN SendAHigh
#IFDEF Ser_Links 2,3
 if Ser_Select = 2 THEN SendBHigh
#ENDIF
#IFDEF Ser_Links 3
 if Ser_Select = 3 THEN SendCHigh
#ENDIF
 SerBitDelay
end sub

sub SerTxLow
 if Ser_Select = 1 THEN SendALow
#IFDEF Ser_Links 2,3
 if Ser_Select = 2 THEN SendBLow
#ENDIF
#IFDEF Ser_Links 3
 if Ser_Select = 3 THEN SendCLow
#ENDIF
 SerBitDelay
end sub

function SerQuickSample
 'Clear bit counters
 SerQuickSample = FALSE

 'Read Port
  if Ser_Select = 1 THEN 
   if RecAHigh then SerQuickSample = TRUE
  end if
#IFDEF Ser_Links 2,3
  if Ser_Select = 2 THEN 
   if RecBHigh then SerQuickSample = TRUE
  end if
#ENDIF
#IFDEF Ser_Links 3
  if Ser_Select = 3 THEN 
   if RecCHigh then SerQuickSample = TRUE
  end if
#ENDIF
end function

sub SerCfgLoad(Ser_Select) #NR
Ser_Select_Old = Ser_Select
if Ser_Select = 1 THEN 
 Ser_Rate = Ser_Rate_A
 Ser_Start = Ser_Start_A
 Ser_Data = Ser_Data_A
 Ser_Stop = Ser_Stop_A
 Ser_Parity = Ser_Parity_A
 Ser_Invert = Ser_Invert_A
end if
#IFDEF Ser_LINKS 2,3
if Ser_Select = 2 THEN 
 Ser_Rate = Ser_Rate_B
 Ser_Start = Ser_Start_B
 Ser_Data = Ser_Data_B
 Ser_Stop = Ser_Stop_B
 Ser_Parity = Ser_Parity_B
 Ser_Invert = Ser_Invert_B
end if
#ENDIF
#IFDEF Ser_LINKS 3
if Ser_Select = 3 THEN 
 Ser_Rate = Ser_Rate_C
 Ser_Start = Ser_Start_C
 Ser_Data = Ser_Data_C
 Ser_Stop = Ser_Stop_C
 Ser_Parity = Ser_Parity_C
 Ser_Invert = Ser_Invert_C
end if
#ENDIF
end sub

sub SerBitDelay
 'Predefined rates (more accurate)
 if Ser_Rate = 1 then Wait Sendr19200 10us: exit sub	'19200 (52 us)
 if Ser_Rate = 2 then Wait Sendr9600 10us: exit sub 	'9600 (104 us)
 if Ser_Rate = 4 then Wait Sendr4800 10us: exit sub 	'4800 (208 us)
 if Ser_Rate = 8 then Wait Sendr2400 10us: exit sub 	'2400 (417 us)
 if Ser_Rate = 16 then Wait Sendr1200 10us: exit sub 	'1200 (833 us)
 if Ser_Rate = 32 then Wait Sendr600 10us: exit sub 	'600 (1666 us)
 if Ser_Rate = 64 then Wait 3 ms: Wait Sendr300 10us: exit sub '300 (3333 us)

 'Other rates
 for SerDelayLoop = 1 to Ser_Rate
  Wait 5 10us
 next
end sub

sub SerThirdBitDelay
 'Predefined rates (more accurate)
 if Ser_Rate = 1 then Wait 1 10us: exit sub	'19200 (17 us)
 if Ser_Rate = 2 then Wait 2 10us: exit sub 	'9600 (35 us)
 if Ser_Rate = 4 then Wait 6 10us: exit sub 	'4800 (69 us)
 if Ser_Rate = 8 then Wait 13 10us: exit sub 	'2400 (139 us)
 if Ser_Rate = 16 then Wait 26 10us: exit sub 	'1200 (278 us)
 if Ser_Rate = 32 then Wait 54 10us: exit sub 	'600 (555 us)
 if Ser_Rate = 64 then Wait 110 10us: exit sub	'300 (1111 us)

 'Other rates
 for SerDelayLoop = 1 to Ser_Rate
  Wait 17 us
 next
end sub