'    PS/2 keyboard/mouse routines for Great Cow BASIC
'    Copyright (C) 2006 Hugh Considine

'    This library is free software; you can redistribute it and/or
'    modify it under the terms of the GNU Lesser General Public
'    License as published by the Free Software Foundation; either
'    version 2.1 of the License, or (at your option) any later version.

'    This library is distributed in the hope that it will be useful,
'    but WITHOUT ANY WARRANTY; without even the implied warranty of
'    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
'    Lesser General Public License for more details.

'    You should have received a copy of the GNU Lesser General Public
'    License along with this library; if not, write to the Free Software
'    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

'********************************************************************************
'IMPORTANT:
'THIS FILE IS ESSENTIAL FOR SOME OF THE COMMANDS IN GCBASIC. DO NOT ALTER THIS FILE
'UNLESS YOU KNOW WHAT YOU ARE DOING. CHANGING THIS FILE COULD RENDER SOME GCBASIC
'COMMANDS UNUSABLE!
'********************************************************************************

#define PS2Data SysTemp.0 'Set to data pin
#define PS2Clock SysTemp.0 'Set to clock pin

#startup InitPS2

'Initialise
sub InitPS2
 KeyShift = 0
 MouseX = 0
 MouseY = 0
end sub

'Return ASCII value of input key
function INKEY
 'Initialise, and get key scan code
 INKEY = 0
 ScanCode = PS2ReadByte
 if ScanCode = 0 then exit function

 '2-byte key?
 if ScanCode = 0xE0 then
  do while INKEY = 0
   INKEY = PS2ReadByte
  loop
  INKEY = INKEY OR 128
 end if

 'Shift/Capslock
 if ScanCode = 0x12 or ScanCode = 0x59 then KeyShift = 1: exit function
 if ScanCode = 0x58 then 
  if KeyShift = 2 then KeyShift = 0: exit function
  KeyShift = 2
  exit function
 end if

 'Translate scan code to ASCII
 
 'Control Chars
 if ScanCode = 0x5A then INKEY = 13	'Enter
 if ScanCode = 0x66 then INKEY = 8	'Backspace
 if ScanCode = 0x76 then INKEY = 27	'Esc
 if ScanCode = 0x29 then INKEY = 32	'Space

 'Arrows
 

 'Numbers
 if ScanCode = 0x45 then INKEY = 48
 if ScanCode = 0x16 then INKEY = 49
 if ScanCode = 0x1E then INKEY = 50
 if ScanCode = 0x26 then INKEY = 51
 if ScanCode = 0x25 then INKEY = 52
 if ScanCode = 0x2E then INKEY = 53
 if ScanCode = 0x36 then INKEY = 54
 if ScanCode = 0x3D then INKEY = 55
 if ScanCode = 0x3E then INKEY = 56
 if ScanCode = 0x46 then INKEY = 57

 'Letters
 if ScanCode = 0x1C then INKEY = 65 'A
 if ScanCode = 0x32 then INKEY = 66
 if ScanCode = 0x21 then INKEY = 67 'C
 if ScanCode = 0x23 then INKEY = 68
 if ScanCode = 0x24 then INKEY = 69 'E
 if ScanCode = 0x2B then INKEY = 70
 if ScanCode = 0x34 then INKEY = 71 'G
 if ScanCode = 0x33 then INKEY = 72
 if ScanCode = 0x43 then INKEY = 73 'I
 if ScanCode = 0x3B then INKEY = 74
 if ScanCode = 0x42 then INKEY = 75 'K
 if ScanCode = 0x4B then INKEY = 76
 if ScanCode = 0x3A then INKEY = 77 'M
 if ScanCode = 0x31 then INKEY = 78
 if ScanCode = 0x44 then INKEY = 79 'O
 if ScanCode = 0x4D then INKEY = 80
 if ScanCode = 0x15 then INKEY = 81 'Q
 if ScanCode = 0x2D then INKEY = 82
 if ScanCode = 0x1B then INKEY = 83 'S
 if ScanCode = 0x2C then INKEY = 84
 if ScanCode = 0x3C then INKEY = 85 'U
 if ScanCode = 0x2A then INKEY = 86
 if ScanCode = 0x1D then INKEY = 87 'W
 if ScanCode = 0x22 then INKEY = 88
 if ScanCode = 0x35 then INKEY = 89 'Y
 if ScanCode = 0x1A then INKEY = 90 'Z

 if INKEY >= 65 and INKEY <= 90 and KeyShift = 0 then INKEY += 32

 'Symbols
 if ScanCode = 0x0E then INKEY = 96 '`
 if ScanCode = 0x4E then INKEY = 45 '-
 if ScanCode = 0x55 then INKEY = 61 '=
 if ScanCode = 0x5D then INKEY = 92 '\
 if ScanCode = 0x4c then INKEY = 59 ';
 if ScanCode = 0x52 then INKEY = 39 ''
 if ScanCode = 0x41 then INKEY = 44 ',
 if ScanCode = 0x49 then INKEY = 46 '.
 if ScanCode = 0x4A then INKEY = 47 '/

 if KeyShift = 1 then KeyShift = 0

end function

function PS2ReadByte
 PS2ReadByte = 0
 if PS2Clock ON THEN exit function

 'Start Bit
 wait until PS2Clock OFF
 if PS2Data ON then exit function
 wait until PS2Clock ON
 
 '8 data bits
 For PS2Bit = 1 to 8
  wait until PS2Clock OFF 
  set STATUS.C OFF
  if PS2Data ON then set STATUS.C ON
  ROTATE PS2ReadByte RIGHT
  wait until PS2Clock ON
 next

 'Parity
  wait until PS2Clock OFF
  wait until PS2Clock ON

 'End
  wait until PS2Clock OFF
  wait until PS2Clock ON
end function

sub PS2WriteByte

end sub