'    Analog to Digital conversion routines for Great Cow BASIC
'    Copyright (C) 2006 Hugh Considine

'    This library is free software; you can redistribute it and/or
'    modify it under the terms of the GNU Lesser General Public
'    License as published by the Free Software Foundation; either
'    version 2.1 of the License, or (at your option) any later version.

'    This library is distributed in the hope that it will be useful,
'    but WITHOUT ANY WARRANTY; without even the implied warranty of
'    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
'    Lesser General Public License for more details.

'    You should have received a copy of the GNU Lesser General Public
'    License along with this library; if not, write to the Free Software
'    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

'********************************************************************************
'IMPORTANT:
'THIS FILE IS ESSENTIAL FOR SOME OF THE COMMANDS IN GCBASIC. DO NOT ALTER THIS FILE
'UNLESS YOU KNOW WHAT YOU ARE DOING. CHANGING THIS FILE COULD RENDER SOME GCBASIC
'COMMANDS UNUSABLE!
'********************************************************************************

'Known Supported Chips:
'16F88
'16F819
'16F872
'16F873/4/6/7
'Note: Many other PIC chips will work, but the documentation has not been checked.
'      The constants and subroutines in this file should support all PIC chips
'      that are equipped with analog-digital conversion modules.

'Commands:
'var = ReadAD(port)	Reads port, and returns value.
'ADFormat(type)		Choose Left or Right justified
'ADOff			Set A/D converter off. Use if trouble is experienced when
'			attempting to use ports in digital mode

#define Format_Left 0
#define Format_Right 255

'Acquisition time. Can be reduced in some circumstances - see PIC manual for details
#define AD_Delay 2 10us

'Optimisation
#define ADSpeed MediumSpeed

#define HighSpeed 255
#define MediumSpeed 128
#define LowSpeed 0
#define InternalClock 192

'Port names
#define AN0 0
#define AN1 1
#define AN2 2
#define AN3 3
#define AN4 4
#define AN5 5
#define AN6 6
#define AN7 7
#define AN8 8
#define AN9 9
#define AN10 10
#define AN11 11
#define AN12 12
#define AN13 13

function ReadAD(ADReadPort)

'Set up A/D
#IFDEF NoVar(ANSEL)
 SET ADCON1.PCFG3 OFF
 SET ADCON1.PCFG2 OFF
 SET ADCON1.PCFG1 OFF
 SET ADCON1.PCFG0 OFF
#ENDIF
#IFDEF Var(ANSEL)
 ANSELTemp = 0
 IF ADReadPort = AN0 THEN SET ANSELTemp.0 ON
 IF ADReadPort = AN1 THEN SET ANSELTemp.1 ON
 IF ADReadPort = AN2 THEN SET ANSELTemp.2 ON
 IF ADReadPort = AN3 THEN SET ANSELTemp.3 ON
 IF ADReadPort = AN4 THEN SET ANSELTemp.4 ON
 IF ADReadPort = AN5 THEN SET ANSELTemp.5 ON
 IF ADReadPort = AN6 THEN SET ANSELTemp.6 ON
 IF ADReadPort = AN7 THEN SET ANSELTemp.7 ON
 ANSEL = ANSELTemp
#ENDIF
#IFDEF Var(ANSELH)
 ANSELTemp = 0
 IF ADReadPort = AN8 THEN SET ANSELTemp.0 ON
 IF ADReadPort = AN9 THEN SET ANSELTemp.1 ON
 IF ADReadPort = AN10 THEN SET ANSELTemp.2 ON
 IF ADReadPort = AN11 THEN SET ANSELTemp.3 ON
 IF ADReadPort = AN12 THEN SET ANSELTemp.4 ON
 IF ADReadPort = AN13 THEN SET ANSELTemp.5 ON
 ANSELH = ANSELTemp
#ENDIF

'Set conversion clock
#IFDEF ADSpeed HighSpeed
 SET ADCON0.ADCS1 OFF
 SET ADCON0.ADCS0 OFF
#ENDIF
#IFDEF ADSpeed MediumSpeed
 SET ADCON0.ADCS1 OFF
 SET ADCON0.ADCS0 ON
#ENDIF
#IFDEF ADSpeed LowSpeed
 SET ADCON0.ADCS1 ON
 SET ADCON0.ADCS0 ON
#ENDIF
#IFDEF ADSpeed InternalClock
 SET ADCON0.ADCS1 ON
 SET ADCON0.ADCS0 ON
#ENDIF

'Choose port
 SET ADCON0.CHS0 OFF
 SET ADCON0.CHS1 OFF
 SET ADCON0.CHS2 OFF
#IFDEF Var(ANSELH)
 SET ADCON0.CHS3 OFF
#ENDIF
 IF ADReadPort = AN1 THEN SET ADCON0.CHS0 ON
 IF ADReadPort = AN2 THEN SET ADCON0.CHS1 ON
 IF ADReadPort = AN3 THEN SET ADCON0.CHS0 ON: SET ADCON0.CHS1 ON
 IF ADReadPort > AN3 THEN SET ADCON0.CHS2 ON
 IF ADReadPort = AN5 THEN SET ADCON0.CHS0 ON
 IF ADReadPort = AN6 THEN SET ADCON0.CHS1 ON
 IF ADReadPort = AN7 THEN SET ADCON0.CHS0 ON: SET ADCON0.CHS1 ON
#IFDEF Var(ANSELH)
 SET ADCON0.CHS2 OFF
 IF ADReadPort > AN7 THEN SET ADCON0.CHS3 ON
 IF ADReadPort = AN9 THEN SET ADCON0.CHS0 ON
 IF ADReadPort = AN10 THEN SET ADCON0.CHS1 ON
 IF ADReadPort = AN11 THEN SET ADCON0.CHS0 ON: SET ADCON0.CHS1 ON
 IF ADReadPort > AN11 THEN 
  SET ADCON0.CHS0 OFF
  SET ADCON0.CHS1 OFF
  SET ADCON0.CHS2 ON
  SET ADCON0.CHS3 ON
 END IF
 IF ADReadPort = AN12 THEN SET ADCON0.CHS0 ON
#ENDIF

'Enable A/D
 SET ADCON0.ADON ON

'Acquisition Delay
 Wait AD_Delay
 
'Read A/D
 SET ADCON0.GO_DONE ON
 Wait While ADCON0.GO_DONE ON

'Switch off A/D
 SET ADCON0.ADON OFF
#IFDEF NoVar(ANSEL)
 SET ADCON1.PCFG3 OFF
 SET ADCON1.PCFG2 ON
 SET ADCON1.PCFG1 ON
 SET ADCON1.PCFG0 OFF
#ENDIF
#IFDEF Var(ANSEL)
 ANSEL = 0
#ENDIF
#IFDEF Var(ANSELH)
 ANSELH = 0
#ENDIF

'Write output
 ReadAD = ADRESH
end function

sub ADFormat(ADReadFormat)
 SET ADCON1.ADFM OFF
 IF ADReadFormat.1 ON THEN SET ADCON1.ADFM ON  
end sub

sub ADOff
'Disable the A/D converter, and set all ports to digital.
 SET ADCON0.ADON OFF

#IFDEF NoVar(ANSEL)
 SET ADCON1.PCFG3 OFF
 SET ADCON1.PCFG2 ON
 SET ADCON1.PCFG1 ON
 SET ADCON1.PCFG0 OFF
#ENDIF
#IFDEF Var(ANSEL)
 ANSEL = 0
#ENDIF
#IFDEF Var(ANSELH)
 ANSELH = 0
#ENDIF
end sub