'    7 Segment LED/LCD display routines for Great Cow BASIC
'    Copyright (C) 2006 Hugh Considine

'    This library is free software; you can redistribute it and/or
'    modify it under the terms of the GNU Lesser General Public
'    License as published by the Free Software Foundation; either
'    version 2.1 of the License, or (at your option) any later version.

'    This library is distributed in the hope that it will be useful,
'    but WITHOUT ANY WARRANTY; without even the implied warranty of
'    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
'    Lesser General Public License for more details.

'    You should have received a copy of the GNU Lesser General Public
'    License along with this library; if not, write to the Free Software
'    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

'********************************************************************************
'IMPORTANT:
'THIS FILE IS ESSENTIAL FOR SOME OF THE COMMANDS IN GCBASIC. DO NOT ALTER THIS FILE
'UNLESS YOU KNOW WHAT YOU ARE DOING. CHANGING THIS FILE COULD RENDER SOME GCBASIC
'COMMANDS UNUSABLE!
'********************************************************************************

'Assumes following setup:
'	PIC Pin		Display Segment
'	PORTname.0	A
'	PORTname.1	B
'	PORTname.2	C
'	 ...
'	PORTname.5	F
'	PORTname.6	G
'	PORTname.7	Decimal
'If any other setup has been used, then these routines will not work without considerable adjustment.

'Number of displays (1 default, 4 max)
#define DisplayCount 1

'Output Ports
#define DisplayPortA DispTemp
#define DisplayPortB DispTemp
#define DisplayPortC DispTemp
#define DisplayPortD DispTemp

'Commands to enable individual displays
'Only used when several displays are multiplexed on the same port
#define DispSelectA nop
#define DispSelectB nop
#define DispSelectC nop
#define DispSelectD nop

'Write integer between 0 and 9 inclusive
sub DisplayValue(DispPort, DispChar) #NR

'Convert to code for output
 if DispChar = 0 then DispTemp = 63
 if DispChar = 1 then DispTemp = 6
 if DispChar = 2 then DispTemp = 91
 if DispChar = 3 then DispTemp = 79
 if DispChar = 4 then DispTemp = 102
 if DispChar = 5 then DispTemp = 109
 if DispChar = 6 then DispTemp = 125
 if DispChar = 7 then DispTemp = 7
 if DispChar = 8 then DispTemp = 127
 if DispChar = 9 then DispTemp = 111

'Select display and show integer
 if DispPort = 1 then
#ifdef DisplayCount 2,3,4
  DispSelectA
#endif
  DisplayPortA = DispTemp
 end if
#ifdef DisplayCount 2,3,4
 if DispPort = 2 then
  DispSelectB
  DisplayPortB = DispTemp
 end if
#endif
#ifdef DisplayCount 3,4
 if DispPort = 3 then
  DispSelectC
  DisplayPortC = DispTemp
 end if
#endif
#ifdef DisplayCount 4
 if DispPort = 4 then
  DispSelectD
  DisplayPortD = DispTemp
 end if
#endif
end sub

'Write ASCII character
sub DisplayChar(DispPort, DispChar) #NR

 'Only accept letters A-Z
 if DispChar = 32 then DispTemp = 0: goto ShowChar
 if DispChar < 65 then exit sub
 if DispChar > 96 then DispChar = DispChar - 32
 if DispChar > 90 then exit sub

 'Convert to code for output
 if DispChar = 65 then DispTemp = 119 'A
 if DispChar = 66 then DispTemp = 124 'B
 if DispChar = 67 then DispTemp = 57 'C
 if DispChar = 68 then DispTemp = 94 'D
 if DispChar = 69 then DispTemp = 121 'E
 if DispChar = 70 then DispTemp = 113 'F
 if DispChar = 71 then DispTemp = 61 'G
 if DispChar = 72 then DispTemp = 118 'H
 if DispChar = 73 then DispTemp = 6 'I
 if DispChar = 74 then DispTemp = 14 'J
 if DispChar = 75 then DispTemp = 118 'K
 if DispChar = 76 then DispTemp = 56 'L
 if DispChar = 77 then DispTemp = 55 'M
 if DispChar = 78 then DispTemp = 55 'N
 if DispChar = 79 then DispTemp = 63 'O
 if DispChar = 80 then DispTemp = 115 'P
 if DispChar = 81 then DispTemp = 103 'Q
 if DispChar = 82 then DispTemp = 80 'R
 if DispChar = 83 then DispTemp = 109 'S
 if DispChar = 84 then DispTemp = 7 'T
 if DispChar = 85 then DispTemp = 62 'U
 if DispChar = 86 then DispTemp = 62 'V
 if DispChar = 87 then DispTemp = 62 'W
 if DispChar = 88 then DispTemp = 118 'X
 if DispChar = 89 then DispTemp = 110 'Y
 if DispChar = 90 then DispTemp = 27 'Z

ShowChar:

 'Select display and show character
 if DispPort = 1 then
#ifdef DisplayCount 2,3,4
  DispSelectA
#endif
  DisplayPortA = DispTemp
 end if
#ifdef DisplayCount 2,3,4
 if DispPort = 2 then
  DispSelectB
  DisplayPortB = DispTemp
 end if
#endif
#ifdef DisplayCount 3,4
 if DispPort = 3 then
  DispSelectC
  DisplayPortC = DispTemp
 end if
#endif
#ifdef DisplayCount 4
 if DispPort = 4 then
  DispSelectD
  DisplayPortD = DispTemp
 end if
#endif
end sub