DECLARE SUB SortVarList ()
DECLARE SUB ShowBlock (DS$)
DECLARE FUNCTION Message$ (DS$)
DECLARE SUB CompileConditions (Condition$, IfTrue$)
DECLARE FUNCTION ShortName$ (DS$)
DECLARE FUNCTION IsWord! (DS$)
DECLARE FUNCTION GetByte$ (DS$, BS%)
DECLARE FUNCTION AsmTidy$ (DS$)
DECLARE FUNCTION TypeOfVar$ (VarName$)
DECLARE FUNCTION WholeINSTR (DS$, N$)
DECLARE FUNCTION CompleteINSTR! ()
DECLARE FUNCTION MakeDec! (DS$)
DECLARE SUB CompileCalc (SUM$)
DECLARE SUB AddLine (DS$, T%)
DECLARE SUB DelLine (T%)
DECLARE FUNCTION CountOccur! (Source$, Search$)
DECLARE FUNCTION CheckLine! (DS$)
DECLARE FUNCTION IsCalc! (DS$)
DECLARE FUNCTION IsConst! (T$)
DECLARE SUB SCICONV (ST$)
DECLARE SUB Replace (VAR$, FIND$, REP$)

COMMON SHARED APC%, ICC%, DFC%, VLC%, SBC%, SDC%, SLC%, IFC%, ERC%, WSC%, FLC%, DLC%, ARC%, SSC%, SASC%, POC%, COC%, DTC%, LVC%
COMMON SHARED CSC%, CV%, COSC%, MemSize%, FreeRAM%, FoundCount%, PotFound%, ThisCalc%, LongPresent%, DivMultPresent%
COMMON SHARED ChipName$, ChipMhz, OSC$, CONFIG$, Int$, ChipRam%, ConfWords%, DataPass%
COMMON SHARED FI$, OFI$, ID$, VBS%, Version$, SVC%, ProgDir$, CLD$, MakeASM$, ProgWillFail%, MSGC%

COMMON SHARED TempData$(), CheckTemp$(), ConfigOp$(), ERROR$(), FILE$()
COMMON SHARED VARLIST$(), VarType$()

COMMON SHARED /progmem/ PROG$()
COMMON SHARED Messages$()
COMMON SHARED SUBCODE$()

'Code Array
'$DYNAMIC
DIM SHARED PROG$(2000): APC% = 0

DIM SHARED FILE$(100)
DIM SHARED ERROR$(25)
DIM SHARED TempData$(100)
DIM SHARED VARLIST$(400)
DIM SHARED CheckTemp$(100)
DIM SHARED VarType$(400)
DIM SHARED ConfigOp$(100)
DIM SHARED Messages$(1 TO 2, 100)

REM $STATIC
SUB CalcConfig

'Add #OSC to CONFIG
IF OSC$ <> "" THEN
 IF INSTR(OSC$, "OSC") = 0 THEN OSC$ = OSC$ + "_OSC"
 IF CONFIG$ <> "" THEN T$ = ","
 CONFIG$ = CONFIG$ + T$ + OSC$
END IF


'Check to see if WDT and LVP need to be configured
WDT% = 0: LVP% = 0
FOR PD% = 1 TO COC%
 IF INSTR(ConfigOp$(PD%), "WDT_") <> 0 THEN WDT% = 1
 IF INSTR(ConfigOp$(PD%), "LVP_") <> 0 THEN LVP% = 1
NEXT PD%

'Set defaults for WDT and LVP
IF INSTR(CONFIG$, "WDT_") = 0 AND WDT% = 1 THEN
 IF CONFIG$ <> "" THEN T$ = ","
 CONFIG$ = CONFIG$ + T$ + "WDT_OFF"
END IF
T$ = LEFT$(ChipName$, 2)

IF INSTR(CONFIG$, "LVP_") = 0 AND LVP% = 1 THEN
 IF CONFIG$ <> "" THEN T$ = ","
 CONFIG$ = CONFIG$ + T$ + "LVP_OFF"
END IF

'Prepare CONFIG
DO WHILE INSTR(CONFIG$, " ") <> 0: Replace CONFIG$, " ", "": LOOP
DO WHILE INSTR(CONFIG$, ",_") <> 0: Replace CONFIG$, ",_", ",": LOOP
IF LEFT$(CONFIG$, 1) = "_" THEN CONFIG$ = MID$(CONFIG$, 2)

T% = 0
ADDDASH:
T% = T% + 1
IF MID$(CONFIG$, T%, 1) = "," THEN CONFIG$ = LEFT$(CONFIG$, T%) + "_" + RIGHT$(CONFIG$, LEN(CONFIG$) - T%)
IF T% < LEN(CONFIG$) THEN GOTO ADDDASH
IF CONFIG$ <> "" THEN CONFIG$ = "_" + CONFIG$


DO WHILE INSTR(CONFIG$, ",") <> 0: Replace CONFIG$, ",", " & ": LOOP

END SUB

SUB Calculate (SUM$)

SUM$ = UCASE$(SUM$)

REM Replace AND, OR, NOT, XOR with symbols
REPLOGIC:
IF INSTR(SUM$, "AND") <> 0 THEN Replace SUM$, "AND", "&": GOTO REPLOGIC
IF INSTR(SUM$, "OR") <> 0 THEN Replace SUM$, "OR", "|": GOTO REPLOGIC
IF INSTR(SUM$, "XOR") <> 0 THEN Replace SUM$, "XOR", "#": GOTO REPLOGIC

BEGINCALC:
REM Remove all Spaces
Replace SUM$, " ", ""
IF INSTR(SUM$, " ") <> 0 THEN GOTO BEGINCALC
SUM$ = " " + LCASE$(SUM$)
IF INSTR(SUM$, "%") <> 0 THEN GOTO PERCDIFF

REM Calculate Sine, Cosine, Tangent, Arctangent and Pi
PISWAP:
IF INSTR(SUM$, "pi") <> 0 THEN
 Replace SUM$, "pi", "3.14159"
 GOTO PISWAP
END IF

INSMULT:
IF INSTR(SUM$, ")(") <> 0 THEN
 Replace SUM$, ")(", ")*("
 GOTO INSMULT
END IF

FILE$(1) = "cos("
FILE$(2) = "sin("
FILE$(3) = "tan("
FILE$(4) = "atn("
FILE$(5) = "sqr("
FILE$(6) = "abs("
FILE$(7) = "sgn("
FILE$(8) = "int("
FILE$(9) = "log("

FOR CA% = 1 TO 9
CALCLOOP:
 IF INSTR(LCASE$(SUM$), FILE$(CA%)) <> 0 THEN

  CT$ = ""
  PD% = INSTR(LCASE$(SUM$), FILE$(CA%)) + 4
  T% = 1
GETFUNCTION:
   CT$ = CT$ + MID$(SUM$, PD%, 1)
   IF MID$(SUM$, PD%, 1) = "(" THEN T% = T% + 1
   IF MID$(SUM$, PD%, 1) = ")" THEN T% = T% - 1
   PD% = PD% + 1
  IF T% > 0 THEN GOTO GETFUNCTION
  CT$ = LEFT$(CT$, LEN(CT$) - 1)

  OSS$ = FILE$(CA%) + CT$ + ")"
  CLDO$ = CLD$
  CLD$ = "no"
  Calculate CT$
  CLD$ = CLDO$

  IF CA% = 1 THEN CT$ = STR$(COS(VAL(CT$)))
  IF CA% = 2 THEN CT$ = STR$(SIN(VAL(CT$)))
  IF CA% = 3 THEN CT$ = STR$(TAN(VAL(CT$)))
  IF CA% = 4 THEN CT$ = STR$(ATN(VAL(CT$)))
  IF CA% = 5 THEN CT$ = STR$(SQR(VAL(CT$)))
  IF CA% = 6 THEN CT$ = STR$(ABS(VAL(CT$)))
  IF CA% = 7 THEN CT$ = STR$(SGN(VAL(CT$)))
  IF CA% = 8 THEN CT$ = STR$(INT(VAL(CT$)))
  IF CA% = 9 THEN CT$ = STR$(LOG(VAL(CT$)))
  SCICONV CT$
  IF LEFT$(CT$, 1) = " " THEN CT$ = MID$(CT$, 2)
  Replace SUM$, OSS$, CT$
  'IF CLD$ = "" THEN PRINT SUM$
  GOTO CALCLOOP
 END IF
NEXT CA%

REM Solve Brackets using recursion
BRACKETS:
IF INSTR(SUM$, "(") = 0 AND INSTR(SUM$, ")") = 0 THEN GOTO ENDBRACKET
TS$ = ""
PD% = INSTR(SUM$, "(")
T% = 0
GETBRACKET:
 TS$ = TS$ + MID$(SUM$, PD%, 1)
 IF MID$(SUM$, PD%, 1) = "(" THEN T% = T% + 1
 IF MID$(SUM$, PD%, 1) = ")" THEN T% = T% - 1
 PD% = PD% + 1
IF T% > 0 THEN GOTO GETBRACKET
OSS$ = TS$
Replace TS$, "(", "": Replace TS$, ")", ""

CLDO$ = CLD$
CLD$ = "no"
Calculate TS$
SCICONV TS$
CLD$ = CLDO$
DO WHILE INSTR(TS$, " ") <> 0: Replace TS$, " ", "": LOOP
Replace SUM$, OSS$, TS$
GOTO BRACKETS
ENDBRACKET:

REM Find Exponentiation
EXPONENT:
IF INSTR(SUM$, "^") = 0 THEN GOTO ENDEXPONENT
FD% = 0
FINDEXP:
FD% = FD% + 1
T$ = MID$(SUM$, FD%, 1)
IF T$ <> "^" THEN GOTO FINDEXP
ACT$ = T$: AP = FD%

FOR FS% = AP - 1 TO 1 STEP -1
 T$ = MID$(SUM$, FS%, 1)
 IF (T$ <> RIGHT$(STR$(VAL(T$)), 1) AND T$ <> "." AND T$ <> "-" AND T$ <> "E") OR T$ = " " THEN FS% = FS% + 1: EXIT FOR
 M$ = MID$(SUM$, FS% - 1, 1)
 IF T$ = "-" AND (M$ <> "^" AND M$ <> "/" AND M$ <> "*" AND M$ <> "-" AND M$ <> "+" AND M$ <> "&" AND M$ <> "#" AND M$ <> "|" AND M$ <> "!") THEN EXIT FOR
NEXT FS%

N1$ = MID$(SUM$, FS%, AP - FS%)
N1 = VAL(N1$)
N2$ = MID$(SUM$, AP + 1)

IF INSTR(N2$, "^") <> 0 THEN N2$ = LEFT$(N2$, INSTR(N2$, "^") - 1)
IF INSTR(N2$, "/") <> 0 THEN N2$ = LEFT$(N2$, INSTR(N2$, "/") - 1)
IF INSTR(N2$, "*") <> 0 THEN N2$ = LEFT$(N2$, INSTR(N2$, "*") - 1)
IF INSTR(2, N2$, "-") <> 0 THEN N2$ = LEFT$(N2$, INSTR(2, N2$, "-") - 1)
IF INSTR(N2$, "+") <> 0 THEN N2$ = LEFT$(N2$, INSTR(N2$, "+") - 1)

N2 = VAL(N2$)
OS$ = N1$ + ACT$ + N2$
DO WHILE INSTR(OS$, " ") <> 0
Replace OS$, " ", ""
LOOP

IF N1 = 0 AND N2 = 0 THEN Replace SUM$, OS$, "0": GOTO EXPONENT

ANS$ = ""
'IF CLD$ = "" THEN PRINT SUM$

RES = N1 ^ N2

ANS$ = STR$(RES)
IF LEFT$(ANS$, 1) = " " THEN ANS$ = MID$(ANS$, 2)
SCICONV ANS$
IF LEFT$(ANS$, 1) = " " THEN ANS$ = MID$(ANS$, 2)
Replace SUM$, OS$, ANS$
GOTO EXPONENT
ENDEXPONENT:

REM Find Division and Multiplication
DIVMULT:
IF INSTR(SUM$, "/") = 0 AND INSTR(SUM$, "*") = 0 AND INSTR(SUM$, "x") = 0 THEN GOTO ENDDIVMULT
FD% = 0
FINDDIV:
FD% = FD% + 1
T$ = MID$(SUM$, FD%, 1)
IF T$ <> "/" AND T$ <> "*" AND T$ <> "x" THEN GOTO FINDDIV
ACT$ = T$: AP = FD%

FOR FS% = AP - 1 TO 1 STEP -1
 T$ = MID$(SUM$, FS%, 1)
 IF (T$ <> MID$(STR$(VAL(T$)), 2) AND T$ <> ".") OR T$ = " " THEN FS% = FS% + 1: EXIT FOR
 M$ = MID$(SUM$, FS% - 1, 1)
 IF T$ = "-" AND (M$ <> LTRIM$(STR$(VAL(M$))) AND M$ <> "^" AND M$ <> "/" AND M$ <> "*" AND M$ <> "-" AND M$ <> "+" AND M$ <> "&" AND M$ <> "#" AND M$ <> "|" AND M$ <> "!") THEN FS% = FS% - 1: EXIT FOR
NEXT FS%

N1$ = MID$(SUM$, FS%, AP - FS%)
N1 = VAL(N1$)
N2$ = MID$(SUM$, AP + 1)

IF INSTR(N2$, "/") <> 0 THEN N2$ = LEFT$(N2$, INSTR(N2$, "/") - 1)
IF INSTR(N2$, "*") <> 0 THEN N2$ = LEFT$(N2$, INSTR(N2$, "*") - 1)
IF INSTR(2, N2$, "-") <> 0 THEN N2$ = LEFT$(N2$, INSTR(2, N2$, "-") - 1)
IF INSTR(N2$, "+") <> 0 THEN N2$ = LEFT$(N2$, INSTR(N2$, "+") - 1)

N2 = VAL(N2$)
OS$ = N1$ + ACT$ + N2$
DO WHILE INSTR(OS$, " ") <> 0
Replace OS$, " ", ""
LOOP
'IF CLD$ = "" THEN PRINT SUM$

RES = 0
IF ACT$ = "/" AND N2 <> 0 THEN RES = N1 / N2
IF ACT$ = "*" THEN RES = N1 * N2
ANS$ = STR$(RES)
SCICONV ANS$
DO WHILE INSTR(ANS$, " ") <> 0: Replace ANS$, " ", "": LOOP
Replace SUM$, OS$, ANS$
GOTO DIVMULT
ENDDIVMULT:

REM Replace all occurances of "--" with "+"
REMMINUS:
IF INSTR(SUM$, "--") <> 0 THEN
 Replace SUM$, "--", "+"
 GOTO REMMINUS
END IF
IF INSTR(SUM$, "+-") <> 0 THEN
 Replace SUM$, "+-", "-"
 GOTO REMMINUS
END IF

REM Addition and Subtraction
FD% = 0
ADDSUB:
IF INSTR(SUM$, "+") = 0 AND INSTR(FD% + 1, SUM$, "-") = 0 THEN GOTO ENDADDSUB
FINDADD:
 FD% = FD% + 1
 T$ = MID$(SUM$, FD%, 1)
IF T$ <> "+" AND T$ <> "-" THEN GOTO FINDADD

ACT$ = T$: AP = FD%
FOR FS% = AP - 1 TO 1 STEP -1
 T$ = MID$(SUM$, FS%, 1)
 IF (T$ <> RIGHT$(STR$(VAL(T$)), 1) AND T$ <> "." AND T$ <> "-" AND T$ <> "E") OR T$ = " " THEN FS% = FS% + 1: EXIT FOR
 M$ = MID$(SUM$, FS% - 1, 1)
 IF T$ = "-" AND (M$ <> "^" AND M$ <> "/" AND M$ <> "*" AND M$ <> "-" AND M$ <> "+" AND M$ <> "&" AND M$ <> "#" AND M$ <> "|" AND M$ <> "!") THEN FS% = FS% - 1: EXIT FOR
NEXT FS%

N1$ = MID$(SUM$, FS%, AP - FS%)
IF N1$ = " " OR N1$ = "" THEN GOTO ADDSUB
N1 = VAL(N1$)
N2$ = MID$(SUM$, AP + 1)

IF INSTR(2, N2$, "-") <> 0 THEN N2$ = LEFT$(N2$, INSTR(2, N2$, "-") - 1)
IF INSTR(N2$, "+") <> 0 THEN N2$ = LEFT$(N2$, INSTR(N2$, "+") - 1)
IF INSTR(N2$, "&") <> 0 THEN N2$ = LEFT$(N2$, INSTR(N2$, "&") - 1)
IF INSTR(N2$, "|") <> 0 THEN N2$ = LEFT$(N2$, INSTR(N2$, "|") - 1)
IF INSTR(N2$, "#") <> 0 THEN N2$ = LEFT$(N2$, INSTR(N2$, "#") - 1)

N2 = VAL(N2$)
OS$ = N1$ + ACT$ + N2$
DO WHILE INSTR(OS$, " ") <> 0
Replace OS$, " ", ""
LOOP
'IF CLD$ = "" THEN PRINT SUM$

IF ACT$ = "+" THEN ANS$ = STR$(N1 + N2)
IF ACT$ = "-" THEN ANS$ = STR$(N1 - N2)
IF LEFT$(ANS$, 1) = " " THEN ANS$ = MID$(ANS$, 2)
IF N1 = 0 AND N2 <> 0 AND ACT$ = "-" THEN FD% = FD% + 1: GOTO ADDSUB
SCICONV ANS$
Replace SUM$, OS$, ANS$
FD% = FD% + LEN(OS$) - LEN(ANS$) + 1
FD% = 0

MINUS:
IF INSTR(SUM$, "--") <> 0 THEN
 Replace SUM$, "--", "+"
 GOTO MINUS
END IF
GOTO ADDSUB
ENDADDSUB:

REM Find Logical operation results (AND, OR, XOR)
LOGICALOP:
IF INSTR(SUM$, "&") = 0 AND INSTR(SUM$, "|") = 0 AND INSTR(SUM$, "#") = 0 THEN GOTO ENDLOGICALOP
FD% = 0
FINDLOGIC:
FD% = FD% + 1
T$ = MID$(SUM$, FD%, 1)
IF T$ <> "&" AND T$ <> "|" AND T$ <> "#" THEN GOTO FINDLOGIC
ACT$ = T$: AP = FD%

FOR FS% = AP - 1 TO 1 STEP -1
 T$ = MID$(SUM$, FS%, 1)
 IF (T$ <> MID$(STR$(VAL(T$)), 2) AND T$ <> ".") OR T$ = " " THEN FS% = FS% + 1: EXIT FOR
 M$ = MID$(SUM$, FS% - 1, 1)
 IF T$ = "-" AND (M$ <> LTRIM$(STR$(VAL(M$))) AND M$ <> "^" AND M$ <> "/" AND M$ <> "*" AND M$ <> "-" AND M$ <> "+" AND M$ <> "&" AND M$ <> "#" AND M$ <> "|" AND M$ <> "!") THEN FS% = FS% - 1: EXIT FOR
NEXT FS%

N1$ = MID$(SUM$, FS%, AP - FS%)
N1 = VAL(N1$)
N2$ = MID$(SUM$, AP + 1)

IF INSTR(N2$, "/") <> 0 THEN N2$ = LEFT$(N2$, INSTR(N2$, "/") - 1)
IF INSTR(N2$, "*") <> 0 THEN N2$ = LEFT$(N2$, INSTR(N2$, "*") - 1)
IF INSTR(2, N2$, "-") <> 0 THEN N2$ = LEFT$(N2$, INSTR(2, N2$, "-") - 1)
IF INSTR(N2$, "+") <> 0 THEN N2$ = LEFT$(N2$, INSTR(N2$, "+") - 1)
IF INSTR(N2$, "&") <> 0 THEN N2$ = LEFT$(N2$, INSTR(N2$, "&") - 1)
IF INSTR(N2$, "|") <> 0 THEN N2$ = LEFT$(N2$, INSTR(N2$, "|") - 1)
IF INSTR(N2$, "#") <> 0 THEN N2$ = LEFT$(N2$, INSTR(N2$, "#") - 1)

N2 = VAL(N2$)
OS$ = N1$ + ACT$ + N2$
DO WHILE INSTR(OS$, " ") <> 0
Replace OS$, " ", ""
LOOP
'IF CLD$ = "" THEN PRINT SUM$

RES = 0
IF ACT$ = "&" AND N2 <> 0 THEN RES = N1 AND N2
IF ACT$ = "|" THEN RES = N1 OR N2
IF ACT$ = "#" THEN RES = N1 XOR N2
ANS$ = STR$(RES)
SCICONV ANS$
DO WHILE INSTR(ANS$, " ") <> 0: Replace ANS$, " ", "": LOOP
Replace SUM$, OS$, ANS$
GOTO LOGICALOP
ENDLOGICALOP:

REM Test Sum
TESTSUM:
IF INSTR(SUM$, "=") = 0 AND INSTR(SUM$, "<") = 0 AND INSTR(SUM$, ">") = 0 THEN GOTO ENDTESTSUM
FD% = 0
FINDTEST:
FD% = FD% + 1
T$ = MID$(SUM$, FD%, 1)
IF T$ <> "=" AND T$ <> "<" AND T$ <> ">" THEN GOTO FINDTEST
ACT$ = T$: AP = FD%

FOR FS% = AP - 1 TO 1 STEP -1
T$ = MID$(SUM$, FS%, 1)
IF (T$ <> MID$(STR$(VAL(T$)), 2) AND T$ <> "." AND T$ <> "-" AND T$ <> "E") OR T$ = " " THEN FS% = FS% + 1: EXIT FOR
M$ = MID$(SUM$, FS% - 1, 1)
IF T$ = "-" AND (M$ <> "^" AND M$ <> "/" AND M$ <> "*" AND M$ <> "-" AND M$ <> "+") THEN FS% = FS% - 1: EXIT FOR
NEXT FS%

N1$ = MID$(SUM$, FS%, AP - FS%)
N1 = VAL(N1$)
N2$ = MID$(SUM$, AP + 1)

IF INSTR(N2$, "=") <> 0 THEN N2$ = LEFT$(N2$, INSTR(N2$, "=") - 1)
IF INSTR(N2$, "<") <> 0 THEN N2$ = LEFT$(N2$, INSTR(N2$, "<") - 1)
IF INSTR(N2$, ">") <> 0 THEN N2$ = LEFT$(N2$, INSTR(N2$, ">") - 1)
IF INSTR(2, N2$, "-") <> 0 THEN N2$ = LEFT$(N2$, INSTR(2, N2$, "-") - 1)
IF INSTR(N2$, "+") <> 0 THEN N2$ = LEFT$(N2$, INSTR(N2$, "+") - 1)

N2 = VAL(N2$)
OS$ = N1$ + ACT$ + N2$
DO WHILE INSTR(OS$, " ") <> 0
Replace OS$, " ", ""
LOOP
'IF CLD$ = "" THEN PRINT SUM$

IF ACT$ = "=" THEN RES = (N1 = N2) * -1
IF ACT$ = "<" THEN RES = (N1 < N2) * -1
IF ACT$ = ">" THEN RES = (N1 > N2) * -1
ANS$ = STR$(RES)
SCICONV ANS$
IF LEFT$(ANS$, 1) = " " THEN ANS$ = RIGHT$(ANS$, LEN(ANS$) - 1)
Replace SUM$, OS$, ANS$
GOTO TESTSUM
ENDTESTSUM:

REM End of normal calculate
SOL = VAL(SUM$)
EXIT SUB

REM Percentage Section
PERCDIFF:
FD% = 0
FINDSIGN:
FD% = FD% + 1
T$ = MID$(SUM$, FD%, 1)
IF T$ <> "+" AND T$ <> "." AND T$ <> "-" AND T$ <> "x" AND T$ <> "*" AND T$ <> "/" THEN GOTO FINDSIGN
ACT$ = T$: AP = FD%

FOR FS% = AP - 1 TO 1 STEP -1
T$ = MID$(SUM$, FS%, 1)
IF T$ <> RIGHT$(STR$(VAL(T$)), 1) OR T$ = " " AND T$ <> "." THEN EXIT FOR
NEXT FS%

N1 = VAL(MID$(SUM$, FS%, AP - FS%))
N2 = VAL(RIGHT$(SUM$, LEN(SUM$) - AP))
ACT2$ = RIGHT$(SUM$, 1)

IF ACT$ = "+" THEN SOL = (N2 + N1) / N2 * 100
IF ACT$ = "-" THEN SOL = (N2 - N1) / N2 * 100
IF ACT$ = "/" THEN SOL = N1 / N2 * 100
IF ACT$ = "x" OR ACT$ = "*" THEN
 SOL = N1 * (N2 / 100)
 IF ACT2$ = "+" THEN SOL = SOL + N1
 IF ACT2$ = "-" THEN SOL = SOL - N1
END IF
SOL = SOL * SGN(SOL)
SUM$ = STR$(SOL)
END SUB

FUNCTION CheckLine (DS$)

'Check that the line is a known command, and that it has all necessary parameters

'Tidy assembly instructions
T% = 37
TempData$(1) = "ADDWF"
TempData$(2) = "ANDWF"
TempData$(3) = "CLRF"
TempData$(4) = "CLRW"
TempData$(5) = "COMF"
TempData$(6) = "DECF"
TempData$(7) = "DECFSZ"
TempData$(8) = "INCF"
TempData$(9) = "INCFSZ"
TempData$(10) = "IORWF"
TempData$(11) = "MOVF"
TempData$(12) = "MOVWF"
TempData$(13) = "NOP"
TempData$(14) = "RLF"
TempData$(15) = "RRF"
TempData$(16) = "SUBWF"
TempData$(17) = "SWAPF"
TempData$(18) = "XORWF"
TempData$(19) = "BCF"
TempData$(20) = "BSF"
TempData$(21) = "BTFSC"
TempData$(22) = "BTFSS"
TempData$(23) = "ADDLW"
TempData$(24) = "ANDLW"
TempData$(25) = "CALL"
TempData$(26) = "CLRWDT"
TempData$(27) = "IORLW"
TempData$(28) = "MOVLW"
TempData$(29) = "RETFIE"
TempData$(30) = "RETLW"
TempData$(31) = "RETURN"
TempData$(32) = "SLEEP"
TempData$(33) = "SUBLW"
TempData$(34) = "XORLW"
TempData$(35) = "MOVFW"
TempData$(36) = "TRIS"
TempData$(37) = "OPTION"

FOR PD% = 1 TO T%
 IF LEFT$(DS$, LEN(TempData$(PD%)) + 1) = TempData$(PD%) + " " THEN
  DS$ = LCASE$(LEFT$(DS$, LEN(TempData$(PD%)))) + MID$(DS$, LEN(TempData$(PD%)) + 1)
  DS$ = " " + DS$
 END IF
 IF DS$ = TempData$(PD%) THEN DS$ = " " + LCASE$(DS$)
NEXT


END FUNCTION

SUB CompileCalc (SUM$)

DO WHILE INSTR(SUM$, "--") <> 0: Replace SUM$, "--", "+": LOOP
DO WHILE INSTR(SUM$, "+-") <> 0: Replace SUM$, "+-", "-": LOOP

'Calculate brackets
CALCBRACKET:
 IF INSTR(SUM$, "(") <> 0 THEN

  T$ = MID$(SUM$, INSTR(SUM$, "("))
  BL% = 1
  FOR T% = 2 TO LEN(T$)
   IF MID$(T$, T%, 1) = "(" THEN BL% = BL% + 1
   IF MID$(T$, T%, 1) = ")" THEN BL% = BL% - 1
   IF BL% = 0 THEN T$ = LEFT$(T$, T%): EXIT FOR
  NEXT T%

  T2$ = MID$(T$, 2)
  T2$ = LEFT$(T2$, LEN(T2$) - 1)
  CompileCalc T2$
  Replace SUM$, T$, T2$
  GOTO CALCBRACKET
 END IF

 'Calculate *, /. Replace sum with variable containing answer
CALCMULTDIV:
 IF INSTR(SUM$, "*") <> 0 OR INSTR(SUM$, "/") <> 0 THEN
  'Read the sum
  FS% = 0
FINDMULT:
   FS% = FS% + 1
   ACT$ = MID$(SUM$, FS%, 1)
  IF ACT$ <> "*" AND ACT$ <> "/" THEN GOTO FINDMULT
  FV% = 0
  FOR T% = FS% - 1 TO 1 STEP -1
   T$ = MID$(SUM$, T%, 1)
   IF T$ = "{" OR T$ = "}" OR T$ = "=" OR T$ = "~" OR T$ = "<" OR T$ = ">" OR T$ = "*" OR T$ = "/" OR T$ = "+" OR T$ = "-" OR T$ = "&" OR T$ = "|" OR T$ = "#" OR T$ = "!" THEN FV% = T%: EXIT FOR
  NEXT T%
  V1$ = LEFT$(SUM$, INSTR(SUM$, ACT$) - 1): V1$ = MID$(V1$, FV% + 1)
  FOR T% = FS% + 1 TO LEN(SUM$)
   T$ = MID$(SUM$, T%, 1)
   IF T$ = "{" OR T$ = "}" OR T$ = "=" OR T$ = "~" OR T$ = "<" OR T$ = ">" OR T$ = "*" OR T$ = "/" OR T$ = "+" OR T$ = "-" OR T$ = "&" OR T$ = "|" OR T$ = "#" OR T$ = "!" THEN FV% = T%: EXIT FOR
   T$ = " "
  NEXT T%
  V2$ = MID$(SUM$, FS% + 1)
  IF INSTR(V2$, T$) < LEN(V2$) AND INSTR(V2$, T$) <> 0 THEN V2$ = LEFT$(V2$, INSTR(V2$, T$) - 1)
  V1O$ = V1$: V2O$ = V2$

 'Generate asm code for sum
  'Check if both are constants
  IF IsConst(V1$) AND IsConst(V2$) THEN
   IF ACT$ = "*" THEN AV$ = MID$(STR$(MakeDec(V1$) * MakeDec(V2$)), 2)
   IF ACT$ = "/" THEN AV$ = MID$(STR$(INT(MakeDec(V1$) / MakeDec(V2$))), 2)
   GOTO MultDivAnswer
  END IF
  
  'Declare SysCalcTempA, SysCalcTempB and SysCalcTempX
  VLC% = VLC% + 1: VARLIST$(VLC%) = "SysCalcTempA"
  VLC% = VLC% + 1: VARLIST$(VLC%) = "SysCalcTempB"
  VLC% = VLC% + 1: VARLIST$(VLC%) = "SysCalcTempX"
  
  IF ACT$ = "/" THEN
   VLC% = VLC% + 1: VARLIST$(VLC%) = "SysDivLoop"
  END IF
  
  'Move V1 into SysCalcTempA
  C$ = " movf " + GetByte$(V1$, 0) + ",W": IF IsConst(V1$) THEN C$ = " movlw " + GetByte$(V1$, 0)
  CSC% = CSC% + 1: TempData$(CSC%) = C$
  IF NOT IsConst(V1$) THEN VLC% = VLC% + 1: VARLIST$(VLC%) = V1$
  CSC% = CSC% + 1: TempData$(CSC%) = " movwf SysCalcTempA"

  'Move V2 into SysCalcTempB
  C$ = " movf " + GetByte$(V2$, 0) + ",W": IF IsConst(V2$) THEN C$ = " movlw " + GetByte$(V2$, 0)
  CSC% = CSC% + 1: TempData$(CSC%) = C$
  IF NOT IsConst(V2$) THEN VLC% = VLC% + 1: VARLIST$(VLC%) = V2$
  CSC% = CSC% + 1: TempData$(CSC%) = " movwf SysCalcTempB"
 
  IF ThisCalc% = 1 THEN
   'Move V1 into SysCalcTempA
   'V1 is constant
   IF IsConst(V1$) THEN
    CSC% = CSC% + 1: TempData$(CSC%) = " movlw " + GetByte$(V1$, 1)
    CSC% = CSC% + 1: TempData$(CSC%) = " movwf SysCalcTempA_H"
   END IF
   'V1 is word variable
   IF NOT IsConst(V1$) AND TypeOfVar$(V1$) = "WORD" THEN
    CSC% = CSC% + 1: TempData$(CSC%) = " movf " + GetByte$(V1$, 1) + ",W"
    VLC% = VLC% + 1: VARLIST$(VLC%) = V1$
    CSC% = CSC% + 1: TempData$(CSC%) = " movwf SysCalcTempA_H"
   END IF
   'V1 is byte variable
   IF NOT IsConst(V1$) AND TypeOfVar$(V1$) <> "WORD" THEN
    CSC% = CSC% + 1: TempData$(CSC%) = " clrf SysCalcTempA_H"
   END IF

   'Move V2 into SysCalcTempB
   'V2 is constant
   IF IsConst(V2$) THEN
    CSC% = CSC% + 1: TempData$(CSC%) = " movlw " + GetByte$(V2$, 1)
    CSC% = CSC% + 1: TempData$(CSC%) = " movwf SysCalcTempB_H"
   END IF
   'V2 is word variable
   IF NOT IsConst(V2$) AND TypeOfVar$(V2$) = "WORD" THEN
    CSC% = CSC% + 1: TempData$(CSC%) = " movf " + GetByte$(V2$, 1) + ",W"
    VLC% = VLC% + 1: VARLIST$(VLC%) = V2$
    CSC% = CSC% + 1: TempData$(CSC%) = " movwf SysCalcTempB_H"
   END IF
   'V2 is byte variable
   IF NOT IsConst(V2$) AND TypeOfVar$(V2$) <> "WORD" THEN
    CSC% = CSC% + 1: TempData$(CSC%) = " clrf SysCalcTempB_H"
   END IF

  END IF

  IF ACT$ = "*" THEN CSC% = CSC% + 1: TempData$(CSC%) = " call SysMultSub"
  IF ACT$ = "/" THEN CSC% = CSC% + 1: TempData$(CSC%) = " call SysDivSub"
  IF ThisCalc% = 1 THEN TempData$(CSC%) = TempData$(CSC%) + "16"

  'Write answer
  CV% = CV% + 1
  AV$ = "SysTemp" + MID$(STR$(CV%), 2)
  IF ThisCalc% = 1 THEN
   IF ACT$ = "*" THEN CSC% = CSC% + 1: TempData$(CSC%) = " movf SysCalcTempX_H,W"
   IF ACT$ = "/" THEN CSC% = CSC% + 1: TempData$(CSC%) = " movf SysCalcTempA_H,W"
   CSC% = CSC% + 1: TempData$(CSC%) = " movwf " + AV$ + "_H"
   VLC% = VLC% + 1: VARLIST$(VLC%) = AV$ + "_H"
  END IF
  IF ACT$ = "*" THEN CSC% = CSC% + 1: TempData$(CSC%) = " movf SysCalcTempX,W"
  IF ACT$ = "/" THEN CSC% = CSC% + 1: TempData$(CSC%) = " movf SysCalcTempA,W"
  CSC% = CSC% + 1: TempData$(CSC%) = " movwf " + AV$
  VLC% = VLC% + 1: VARLIST$(VLC%) = AV$
  IF ThisCalc% = 1 THEN
   VarType$(VLC%) = "WORD"
   SortVarList
  END IF

  'Replace sum with answer variable
MultDivAnswer:
  Replace SUM$, V1O$ + ACT$ + V2O$, AV$
  GOTO CALCMULTDIV
 END IF


 'Calculate +, -. Replace sum with variable containing answer
CALCADDSUB:
 IF INSTR(SUM$, "+") <> 0 OR INSTR(SUM$, "-") <> 0 THEN
  'Read the sum
  FS% = 0
FINDADDSUB:
   FS% = FS% + 1
   ACT$ = MID$(SUM$, FS%, 1)
  IF ACT$ <> "+" AND ACT$ <> "-" THEN GOTO FINDADDSUB
  FV% = 0
  FOR T% = FS% - 1 TO 1 STEP -1
   T$ = MID$(SUM$, T%, 1)
   IF T$ = "{" OR T$ = "}" OR T$ = "=" OR T$ = "~" OR T$ = "<" OR T$ = ">" OR T$ = "+" OR T$ = "-" OR T$ = "&" OR T$ = "|" OR T$ = "#" OR T$ = "!" THEN FV% = T%: EXIT FOR
  NEXT T%
  V1$ = LEFT$(SUM$, INSTR(SUM$, ACT$) - 1): V1$ = MID$(V1$, FV% + 1)
  FOR T% = FS% + 1 TO LEN(SUM$)
   T$ = MID$(SUM$, T%, 1)
   IF T$ = "{" OR T$ = "}" OR T$ = "=" OR T$ = "~" OR T$ = "<" OR T$ = ">" OR T$ = "+" OR T$ = "-" OR T$ = "&" OR T$ = "|" OR T$ = "#" OR T$ = "!" THEN FV% = T%: EXIT FOR
   T$ = " "
  NEXT T%
  V2$ = MID$(SUM$, FS% + 1)
  IF INSTR(V2$, T$) < LEN(V2$) AND INSTR(V2$, T$) <> 0 THEN V2$ = LEFT$(V2$, INSTR(V2$, T$) - 1)
  V1O$ = V1$: V2O$ = V2$
  
  'Generate asm code for sum
  'Check if both are constants
  IF IsConst(V1$) AND IsConst(V2$) THEN
   IF ACT$ = "+" THEN AV$ = STR$(MakeDec(V1$) + MakeDec(V2$))
   IF ACT$ = "-" THEN AV$ = STR$(MakeDec(V1$) - MakeDec(V2$))
   IF LEFT$(AV$, 1) = "-" THEN
    T% = VAL(AV$) + 256
    AV$ = STR$(T%)
   END IF
   IF LEFT$(AV$, 1) = " " THEN AV$ = MID$(AV$, 2)
   GOTO AddSubAnswer
  END IF

  IF ThisCalc% = 1 THEN
   IF ACT$ = "+" THEN CSC% = CSC% + 1: TempData$(CSC%) = " bcf STATUS, C"
   IF ACT$ = "-" THEN CSC% = CSC% + 1: TempData$(CSC%) = " bsf STATUS, C"
   V1$ = GetByte$(V1$, 0)
   V2$ = GetByte$(V2$, 0)
  END IF

  'Check if V1 is constant, and put into variable if it is
  IF IsConst(V1$) THEN
   CV% = CV% + 1
   CSC% = CSC% + 1: TempData$(CSC%) = " movlw " + V1$
   V1$ = "SysTemp" + MID$(STR$(CV%), 2)
   CSC% = CSC% + 1: TempData$(CSC%) = " movwf " + V1$
   VLC% = VLC% + 1: VARLIST$(VLC%) = V1$
  END IF
  'Move V2 into W
  C$ = " movf " + V2$ + ",W": IF IsConst(V2$) THEN C$ = " movlw " + V2$
  CSC% = CSC% + 1: TempData$(CSC%) = C$
  IF NOT IsConst(V2$) THEN VLC% = VLC% + 1: VARLIST$(VLC%) = V2$
  'Add/Subtract V2 to/from W
  VLC% = VLC% + 1: VARLIST$(VLC%) = V1$
  C$ = " addwf ": IF ACT$ = "-" THEN C$ = " subwf "
  CSC% = CSC% + 1: TempData$(CSC%) = C$ + V1$ + ",W"

  'Write W to answer
  CV% = CV% + 1
  AV$ = "SysTemp" + MID$(STR$(CV%), 2)
  CSC% = CSC% + 1: TempData$(CSC%) = " movwf " + AV$
  VLC% = VLC% + 1: VARLIST$(VLC%) = AV$

  'High Byte
  'Add:
  'Put V1 into var if necessary
  'movlw/movf ,W V2
  'btfsc STATUS, C
  'addlw 1
  'addwf V1, W
  'movwf SysTempN_H

  'Subtract:
  'Put V1 into var if necessary
  'movlw/movf ,W V2
  'btfss STATUS, C
  'addlw 1
  'subwf V1, W
  'movwf SysTempN_H

  IF ThisCalc% = 1 THEN
   VarType$(VLC%) = "WORD"
   V1$ = V1O$: V2$ = V2O$

   AVH$ = "SysTemp" + MID$(STR$(CV%), 2) + "_H"
   VLC% = VLC% + 1: VARLIST$(VLC%) = AVH$

   IF IsConst(V1$) THEN
    CSC% = CSC% + 1: TempData$(CSC%) = " movlw " + GetByte$(V1$, 1)
    V1$ = "SysTemp" + MID$(STR$(CV%), 2)
    VLC% = VLC% + 1: VARLIST$(VLC%) = V1$ + "_H"
    CSC% = CSC% + 1: TempData$(CSC%) = " movwf " + GetByte$(V1$, 1)
   END IF

   T$ = " movf " + GetByte$(V2$, 1) + ",W": IF IsConst(V2$) THEN T$ = " movlw " + GetByte$(V2$, 1)
   CSC% = CSC% + 1: TempData$(CSC%) = T$
   T$ = " btfsc ": IF ACT$ = "-" THEN T$ = " btfss "
   CSC% = CSC% + 1: TempData$(CSC%) = T$ + "STATUS,C"
   CSC% = CSC% + 1: TempData$(CSC%) = " addlw 1"
   IF ACT$ = "+" THEN CSC% = CSC% + 1: TempData$(CSC%) = " addwf " + GetByte$(V1$, 1) + ",W"
   IF ACT$ = "-" THEN CSC% = CSC% + 1: TempData$(CSC%) = " subwf " + GetByte$(V1$, 1) + ",W"
   CSC% = CSC% + 1: TempData$(CSC%) = " movwf " + AVH$

  END IF
  
  'Replace sum with answer variable
AddSubAnswer:
  Replace SUM$, V1O$ + ACT$ + V2O$, AV$
  GOTO CALCADDSUB
 END IF

'Calculate <,>,=,~. Replace sum with variable containing answer

'Unusual Tokens:
' ~ (not equal)
' } (equal or greater)
' { (less or equal)

CALCCONDITION:
 IF INSTR(SUM$, "{") <> 0 OR INSTR(SUM$, "}") <> 0 OR INSTR(SUM$, "=") <> 0 OR INSTR(SUM$, "~") <> 0 OR INSTR(SUM$, "<") <> 0 OR INSTR(SUM$, ">") <> 0 THEN
  'Read the sum
  FS% = 0
FINDCONDITION:
   FS% = FS% + 1
   ACT$ = MID$(SUM$, FS%, 1)
  IF ACT$ <> "=" AND ACT$ <> "~" AND ACT$ <> "<" AND ACT$ <> ">" AND ACT$ <> "{" AND ACT$ <> "}" THEN GOTO FINDCONDITION
  FV% = 0
  FOR T% = FS% - 1 TO 1 STEP -1
   T$ = MID$(SUM$, T%, 1)
   IF T$ = "{" OR T$ = "}" OR T$ = "=" OR T$ = "~" OR T$ = "<" OR T$ = ">" OR T$ = "*" OR T$ = "/" OR T$ = "+" OR T$ = "-" OR T$ = "&" OR T$ = "|" OR T$ = "#" OR T$ = "!" THEN FV% = T%: EXIT FOR
  NEXT T%
  V1$ = LEFT$(SUM$, INSTR(SUM$, ACT$) - 1): V1$ = MID$(V1$, FV% + 1)
  FOR T% = FS% + 1 TO LEN(SUM$)
   T$ = MID$(SUM$, T%, 1)
   IF T$ = "{" OR T$ = "}" OR T$ = "=" OR T$ = "~" OR T$ = "<" OR T$ = ">" OR T$ = "*" OR T$ = "/" OR T$ = "+" OR T$ = "-" OR T$ = "&" OR T$ = "|" OR T$ = "#" OR T$ = "!" THEN FV% = T%: EXIT FOR
   T$ = " "
  NEXT T%
  V2$ = MID$(SUM$, FS% + 1)
  IF INSTR(V2$, T$) < LEN(V2$) AND INSTR(V2$, T$) <> 0 THEN V2$ = LEFT$(V2$, INSTR(V2$, T$) - 1)
  V1O$ = V1$: V2O$ = V2$

 'Generate asm code for sum

  'Declare SysCalcTempA, SysCalcTempB and SysCalcTempX
  VLC% = VLC% + 1: VARLIST$(VLC%) = "SysCalcTempA"
  VLC% = VLC% + 1: VARLIST$(VLC%) = "SysCalcTempB"
  VLC% = VLC% + 1: VARLIST$(VLC%) = "SysCalcTempX"
  
  TCO% = ThisCalc%
  IF NOT IsWord(V1$ + ACT$ + V2$) THEN ThisCalc% = 0
  
  IF ThisCalc% = 0 OR ACT$ = "=" OR ACT$ = "~" THEN
   'Move V1 into SysCalcTempA
   C$ = " movf " + GetByte$(V1$, 0) + ",W": IF IsConst(V1$) THEN C$ = " movlw " + GetByte$(V1$, 0)
   CSC% = CSC% + 1: TempData$(CSC%) = C$
   IF NOT IsConst(V1$) THEN VLC% = VLC% + 1: VARLIST$(VLC%) = V1$
   CSC% = CSC% + 1: TempData$(CSC%) = " movwf SysCalcTempA"

   'Move V2 into SysCalcTempB
   C$ = " movf " + GetByte$(V2$, 0) + ",W": IF IsConst(V2$) THEN C$ = " movlw " + GetByte$(V2$, 0)
   CSC% = CSC% + 1: TempData$(CSC%) = C$
   IF NOT IsConst(V2$) THEN VLC% = VLC% + 1: VARLIST$(VLC%) = V2$
   CSC% = CSC% + 1: TempData$(CSC%) = " movwf SysCalcTempB"
  END IF

  IF ThisCalc% = 1 THEN

   'High Byte for =, ~
   IF ACT$ = "=" OR ACT$ = "~" THEN
   
    'Move V1 into SysCalcTempA
    'V1 is constant
    IF IsConst(V1$) THEN
     CSC% = CSC% + 1: TempData$(CSC%) = " movlw " + GetByte$(V1$, 1)
     CSC% = CSC% + 1: TempData$(CSC%) = " movwf SysCalcTempA_H"
    END IF
    'V1 is word variable
    IF NOT IsConst(V1$) AND TypeOfVar$(V1$) = "WORD" THEN
     CSC% = CSC% + 1: TempData$(CSC%) = " movf " + GetByte$(V1$, 1) + ",W"
     VLC% = VLC% + 1: VARLIST$(VLC%) = V1$
     CSC% = CSC% + 1: TempData$(CSC%) = " movwf SysCalcTempA_H"
    END IF
    'V1 is byte variable
    IF NOT IsConst(V1$) AND TypeOfVar$(V1$) <> "WORD" THEN
     CSC% = CSC% + 1: TempData$(CSC%) = " clrf SysCalcTempA_H"
    END IF
    
    'Move V2 into SysCalcTempB
    'V2 is constant
    IF IsConst(V2$) THEN
     CSC% = CSC% + 1: TempData$(CSC%) = " movlw " + GetByte$(V2$, 1)
     CSC% = CSC% + 1: TempData$(CSC%) = " movwf SysCalcTempB_H"
    END IF
    'V2 is word variable
    IF NOT IsConst(V2$) AND TypeOfVar$(V2$) = "WORD" THEN
     CSC% = CSC% + 1: TempData$(CSC%) = " movf " + GetByte$(V2$, 1) + ",W"
     VLC% = VLC% + 1: VARLIST$(VLC%) = V2$
     CSC% = CSC% + 1: TempData$(CSC%) = " movwf SysCalcTempB_H"
    END IF
    'V2 is byte variable
    IF NOT IsConst(V2$) AND TypeOfVar$(V2$) <> "WORD" THEN
     CSC% = CSC% + 1: TempData$(CSC%) = " clrf SysCalcTempB_H"
    END IF
    
   END IF

   IF ACT$ = "<" OR ACT$ = ">" OR ACT$ = "{" OR ACT$ = "}" THEN

    'Move whole word
    'Move V1 into SysCalcTempA
    'V1 is constant
    IF IsConst(V1$) THEN
     CSC% = CSC% + 1: TempData$(CSC%) = " movlw " + GetByte$(V1$, 0)
     CSC% = CSC% + 1: TempData$(CSC%) = " movwf SysCalcTempA_H"
     CSC% = CSC% + 1: TempData$(CSC%) = " movlw " + GetByte$(V1$, 1)
     CSC% = CSC% + 1: TempData$(CSC%) = " movwf SysCalcTempA"
    END IF
    'V1 is word variable
    IF NOT IsConst(V1$) THEN
     CSC% = CSC% + 1: TempData$(CSC%) = " movf " + GetByte$(V1$, 0) + ",W"
     VLC% = VLC% + 1: VARLIST$(VLC%) = V1$
     CSC% = CSC% + 1: TempData$(CSC%) = " movwf SysCalcTempA_H"
     IF TypeOfVar$(V1$) = "WORD" THEN
      CSC% = CSC% + 1: TempData$(CSC%) = " movf " + GetByte$(V1$, 1) + ",W"
      VLC% = VLC% + 1: VARLIST$(VLC%) = GetByte$(V1$, 1)
      CSC% = CSC% + 1: TempData$(CSC%) = " movwf SysCalcTempA"
     END IF
     IF TypeOfVar$(V1$) <> "WORD" THEN
      CSC% = CSC% + 1: TempData$(CSC%) = " clrf SysCalcTempA"
     END IF
    END IF
  
    'Move V2 into SysCalcTempB
    'V2 is constant
    IF IsConst(V2$) THEN
     CSC% = CSC% + 1: TempData$(CSC%) = " movlw " + GetByte$(V2$, 0)
     CSC% = CSC% + 1: TempData$(CSC%) = " movwf SysCalcTempB_H"
     CSC% = CSC% + 1: TempData$(CSC%) = " movlw " + GetByte$(V2$, 1)
     CSC% = CSC% + 1: TempData$(CSC%) = " movwf SysCalcTempB"
    END IF
    'V2 is word variable
    IF NOT IsConst(V2$) THEN
     CSC% = CSC% + 1: TempData$(CSC%) = " movf " + GetByte$(V2$, 0) + ",W"
     VLC% = VLC% + 1: VARLIST$(VLC%) = V2$
     CSC% = CSC% + 1: TempData$(CSC%) = " movwf SysCalcTempB_H"
     IF TypeOfVar$(V2$) = "WORD" THEN
      CSC% = CSC% + 1: TempData$(CSC%) = " movf " + GetByte$(V2$, 1) + ",W"
      VLC% = VLC% + 1: VARLIST$(VLC%) = GetByte$(V2$, 1)
      CSC% = CSC% + 1: TempData$(CSC%) = " movwf SysCalcTempB"
     END IF
     IF TypeOfVar$(V2$) <> "WORD" THEN
      CSC% = CSC% + 1: TempData$(CSC%) = " clrf SysCalcTempB"
     END IF
    END IF
   
   END IF

  END IF

  IF ACT$ = "=" THEN CSC% = CSC% + 1: TempData$(CSC%) = " call SysCompEqual"
  IF ACT$ = "~" THEN CSC% = CSC% + 1: TempData$(CSC%) = " call SysCompNotEqual"
  IF ACT$ = "<" THEN CSC% = CSC% + 1: TempData$(CSC%) = " call SysCompLessThan"
  IF ACT$ = ">" THEN CSC% = CSC% + 1: TempData$(CSC%) = " call SysCompMoreThan"
  IF ACT$ = "{" THEN CSC% = CSC% + 1: TempData$(CSC%) = " call SysCompLessOrEqual"
  IF ACT$ = "}" THEN CSC% = CSC% + 1: TempData$(CSC%) = " call SysCompMoreOrEqual"
  IF ThisCalc% = 1 THEN TempData$(CSC%) = TempData$(CSC%) + "16"

  'Write answer
  CSC% = CSC% + 1: TempData$(CSC%) = " movf SysCalcTempX,W"
  CV% = CV% + 1
  AV$ = "SysTemp" + MID$(STR$(CV%), 2)
  CSC% = CSC% + 1: TempData$(CSC%) = " movwf " + AV$

  'Replace sum with answer variable
  Replace SUM$, V1O$ + ACT$ + V2O$, AV$
  VLC% = VLC% + 1: VARLIST$(VLC%) = AV$

  'Restore ThisCalc%
  ThisCalc% = TCO%

  GOTO CALCCONDITION
 END IF

 'Calculate AND,OR,XOR,NOT
CALCLOGIC:
 IF INSTR(SUM$, "&") <> 0 OR INSTR(SUM$, "|") <> 0 OR INSTR(SUM$, "#") <> 0 OR INSTR(SUM$, "!") <> 0 THEN
  'Read the sum
  FS% = 0
FINDLOGICAL:
   FS% = FS% + 1
   ACT$ = MID$(SUM$, FS%, 1)
  IF ACT$ <> "&" AND ACT$ <> "|" AND ACT$ <> "#" AND ACT$ <> "!" THEN GOTO FINDLOGICAL
  IF ACT$ <> "!" THEN
   FV% = 0
   FOR T% = FS% - 1 TO 1 STEP -1
    T$ = MID$(SUM$, T%, 1)
    IF T$ = "&" OR T$ = "|" OR T$ = "#" OR T$ = "!" THEN FV% = T%: EXIT FOR
   NEXT T%
   V1$ = LEFT$(SUM$, INSTR(SUM$, ACT$) - 1): V1$ = MID$(V1$, FV% + 1)
  END IF

  FOR T% = FS% + 1 TO LEN(SUM$)
   T$ = MID$(SUM$, T%, 1)
   IF T$ = "&" OR T$ = "|" OR T$ = "#" OR T$ = "!" THEN FV% = T%: EXIT FOR
   T$ = " "
  NEXT T%
  V2$ = MID$(SUM$, FS% + 1)
  IF INSTR(V2$, T$) < LEN(V2$) AND INSTR(V2$, T$) <> 0 THEN V2$ = LEFT$(V2$, INSTR(V2$, T$) - 1)
  
  TCO% = ThisCalc%
  IF NOT IsWord(V1$ + ACT$ + V2$) THEN ThisCalc% = 0
  
  V1O$ = V1$: ACTO$ = ACT$: V2O$ = V2$
  
  'Generate asm code for sum

  'Check if V2 is a constant, and put it into variable if it is
  IF IsConst(V2$) THEN
   CV% = CV% + 1
   CSC% = CSC% + 1: TempData$(CSC%) = " movlw " + GetByte$(V2$, 0)
   V2$ = "SysTemp" + MID$(STR$(CV%), 2)
   CSC% = CSC% + 1: TempData$(CSC%) = " movwf " + V2$
   VLC% = VLC% + 1: VARLIST$(VLC%) = V2$
  END IF
  IF ACT$ <> "!" THEN
   'Move V1 into W
   C$ = " movf " + GetByte$(V1$, 0) + ",W": IF IsConst(V1$) THEN C$ = " movlw " + GetByte$(V1$, 0)
   CSC% = CSC% + 1: TempData$(CSC%) = C$
   IF NOT IsConst(V1$) THEN VLC% = VLC% + 1: VARLIST$(VLC%) = V1$
  END IF

  'AND/OR/XOR/NOT W with V2
  IF ACT$ = "&" THEN C$ = " andwf "
  IF ACT$ = "|" THEN C$ = " iorwf "
  IF ACT$ = "#" THEN C$ = " xorwf "
  IF ACT$ = "!" THEN C$ = " comf "
  VLC% = VLC% + 1: VARLIST$(VLC%) = V2$
  CSC% = CSC% + 1: TempData$(CSC%) = C$ + GetByte$(V2$, 0) + ",W"
  
  'Write W to answer
  CV% = CV% + 1
  AV$ = "SysTemp" + MID$(STR$(CV%), 2)
  CSC% = CSC% + 1: TempData$(CSC%) = " movwf " + AV$
  
  'Replace sum with answer variable
  Replace SUM$, V1O$ + ACTO$ + V2O$, AV$
  VLC% = VLC% + 1: VARLIST$(VLC%) = AV$

  'Repeat for high byte
  IF ThisCalc% = 1 THEN

   V1$ = V1O$: V2$ = V2O$

   'Check if V2 is a constant, and put it into variable if it is
   IF NOT IsConst(V2$) AND TypeOfVar$(V2$) <> "WORD" THEN V2$ = "0"
   IF IsConst(V2$) THEN
    CSC% = CSC% + 1: TempData$(CSC%) = " movlw " + GetByte$(V2$, 1)
    V2$ = "SysTemp" + MID$(STR$(CV% - 1), 2)
    CSC% = CSC% + 1: TempData$(CSC%) = " movwf " + V2$ + "_H"
    VLC% = VLC% + 1: VARLIST$(VLC%) = V2$
   END IF
   IF ACT$ <> "!" THEN
    'Move V1 into W
    C$ = " clrw"
    IF TypeOfVar$(V1$) = "WORD" THEN
     C$ = " movf " + GetByte$(V1$, 1) + ",W"
    END IF
    IF IsConst(V1$) THEN C$ = " movlw " + GetByte$(V1$, 1)
    CSC% = CSC% + 1: TempData$(CSC%) = C$
    IF NOT IsConst(V1$) THEN VLC% = VLC% + 1: VARLIST$(VLC%) = GetByte$(V1$, 1)
   END IF
 
   'AND/OR/XOR/NOT W with V2
   IF ACT$ = "&" THEN C$ = " andwf "
   IF ACT$ = "|" THEN C$ = " iorwf "
   IF ACT$ = "#" THEN C$ = " xorwf "
   IF ACT$ = "!" THEN C$ = " comf "
   VLC% = VLC% + 1: VARLIST$(VLC%) = GetByte$(V2$, 1)
   CSC% = CSC% + 1: TempData$(CSC%) = C$ + GetByte$(V2$, 1) + ",W"
 
   'Write W to answer
   AV$ = "SysTemp" + MID$(STR$(CV%), 2) + "_H"
   CSC% = CSC% + 1: TempData$(CSC%) = " movwf " + AV$
 
   VLC% = VLC% + 1: VARLIST$(VLC%) = AV$
   
  END IF

  ThisCalc% = TCO%

  GOTO CALCLOGIC
 END IF

END SUB

SUB CompileConditions (Condition$, IfTrue$)

 'Initialise
 FOR PD% = 1 TO 100
  CheckTemp$(PD%) = ""
 NEXT PD%
 COSC% = 0: CV% = 0

 'Decide whether to compile inline or using CompileCalc
 Complex = 0
 IF CountOccur(Condition$, "';=~<>{}.") = 0 THEN Complex = -1
 IF CountOccur(Condition$, "';=~<>{}+-*/&|#!") >= 2 THEN Complex = 1
 IF IsWord(Condition$) AND INSTR(Condition$, ".") = 0 THEN Complex = 1
 
 'One condition, so compile inline
 IF Complex = 0 THEN
  OP$ = ""
  IF INSTR(Condition$, ".") <> 0 THEN OP$ = "."
  IF INSTR(Condition$, "=") <> 0 THEN OP$ = "="
  IF INSTR(Condition$, "~") <> 0 THEN OP$ = "~"
  IF INSTR(Condition$, "<") <> 0 THEN OP$ = "<"
  IF INSTR(Condition$, ">") <> 0 THEN OP$ = ">"
  IF INSTR(Condition$, "{") <> 0 THEN OP$ = "{"
  IF INSTR(Condition$, "}") <> 0 THEN OP$ = "}"

  'If the condition is not a bit test, then run this code:
  IF OP$ <> "." THEN
   'Read input variables
   V1$ = UCASE$(LEFT$(Condition$, INSTR(Condition$, OP$) - 1))
   DO WHILE INSTR(V1$, " ") <> 0: Replace V1$, " ", "": LOOP
   V2$ = UCASE$(MID$(Condition$, INSTR(Condition$, OP$) + 1))
   DO WHILE INSTR(V2$, " ") <> 0: Replace V2$, " ", "": LOOP
   
   'IF TypeOfVar$(V1$) <> "BYTE" OR TypeOfVar$(V2$) <> "BYTE" THEN
   ' Complex = 1
   ' GOTO ComplexCondition
   'END IF

   IF NOT IsConst(V1$) THEN VLC% = VLC% + 1: VARLIST$(VLC%) = V1$
   IF NOT IsConst(V2$) THEN VLC% = VLC% + 1: VARLIST$(VLC%) = V2$

   'Code for equal/not equal
   IF OP$ = "=" OR OP$ = "~" THEN
    'V1 must always be a variable. V2 can be variable or constant.
    IF IsConst(V1$) AND NOT IsConst(V2$) THEN T$ = V1$: V1$ = V2$: V2$ = T$
    IF IsConst(V1$) AND IsConst(V2$) THEN
     COSC% = COSC% + 1: CheckTemp$(COSC%) = " movlw " + V1$
     COSC% = COSC% + 1: CheckTemp$(COSC%) = " movwf SysIFTemp"
     V1$ = "SysIFTemp": VLC% = VLC% + 1: VARLIST$(VLC%) = "SysIFTemp"
    END IF
    IF IsConst(V2$) THEN COSC% = COSC% + 1: CheckTemp$(COSC%) = " movlw " + V2$
    IF NOT IsConst(V2$) THEN COSC% = COSC% + 1: CheckTemp$(COSC%) = " movf " + V2$ + ",W"
    COSC% = COSC% + 1: CheckTemp$(COSC%) = " subwf " + V1$ + ",W"

    IF INSTR(UCASE$(IfTrue$), "TRUE") <> 0 THEN
     C$ = " btfss STATUS, Z"
     IF OP$ = "=" THEN C$ = " btfsc STATUS, Z"
    END IF
    IF INSTR(UCASE$(IfTrue$), "FALSE") <> 0 THEN
     C$ = " btfsc STATUS, Z"
     IF OP$ = "=" THEN C$ = " btfss STATUS, Z"
    END IF
    COSC% = COSC% + 1: CheckTemp$(COSC%) = C$
   END IF

   'Code for greater than/less than
   IF OP$ = "<" OR OP$ = ">" THEN
    IF OP$ = ">" THEN T$ = V1$: V1$ = V2$: V2$ = T$
    'Take bigger from smaller. V2 should be bigger. Take V2 from V1
    'mov small into W
    'sub big from W
    IF IsConst(V1$) THEN
     COSC% = COSC% + 1: CheckTemp$(COSC%) = " movlw " + V1$
     COSC% = COSC% + 1: CheckTemp$(COSC%) = " movwf SysIFTemp"
     V1$ = "SysIFTemp": VLC% = VLC% + 1: VARLIST$(VLC%) = "SysIFTemp"
    END IF
    IF IsConst(V2$) THEN C$ = " movlw " + V2$
    IF NOT IsConst(V2$) THEN C$ = " movf " + V2$ + ",W"
    COSC% = COSC% + 1: CheckTemp$(COSC%) = C$
    COSC% = COSC% + 1: CheckTemp$(COSC%) = " subwf " + V1$ + ",W"
    IF INSTR(UCASE$(IfTrue$), "TRUE") <> 0 THEN C$ = " btfss STATUS, C"
    IF INSTR(UCASE$(IfTrue$), "FALSE") <> 0 THEN C$ = " btfsc STATUS, C"
    COSC% = COSC% + 1: CheckTemp$(COSC%) = C$
   END IF

   'Code for less or equal/more or equal
   IF OP$ = "{" OR OP$ = "}" THEN
    IF OP$ = "{" THEN T$ = V1$: V1$ = V2$: V2$ = T$
    'Take smaller from bigger. V1 should be bigger or equal. Take V2 from V1
    'mov small into W
    'sub big from W
    IF IsConst(V1$) THEN
     COSC% = COSC% + 1: CheckTemp$(COSC%) = " movlw " + V1$
     COSC% = COSC% + 1: CheckTemp$(COSC%) = " movwf SysIFTemp"
     V1$ = "SysIFTemp": VLC% = VLC% + 1: VARLIST$(VLC%) = "SysIFTemp"
    END IF
    IF IsConst(V2$) THEN C$ = " movlw " + V2$
    IF NOT IsConst(V2$) THEN C$ = " movf " + V2$ + ",W"
    COSC% = COSC% + 1: CheckTemp$(COSC%) = C$
    COSC% = COSC% + 1: CheckTemp$(COSC%) = " subwf " + V1$ + ",W"
    IF INSTR(UCASE$(IfTrue$), "TRUE") <> 0 THEN C$ = " btfsc STATUS, C"
    IF INSTR(UCASE$(IfTrue$), "FALSE") <> 0 THEN C$ = " btfss STATUS, C"
    COSC% = COSC% + 1: CheckTemp$(COSC%) = C$
   END IF

  END IF

  'Code for a bit test
  IF OP$ = "." THEN
   T% = 1
   V$ = UCASE$(LEFT$(Condition$, INSTR(Condition$, ".") - 1))
   B$ = MID$(Condition$, INSTR(Condition$, ".") + 1): B$ = LEFT$(B$, INSTR(B$, " ") - 1)
   S% = VAL(MID$(Condition$, INSTR(Condition$, " ") + 1))

   'Allow use with vars > 8 bit
   IF VAL(B$) > 7 THEN
    B$ = MID$(STR$(VAL(B$) - 8), 2)
    V$ = V$ + "_H"
   END IF
   
   IF INSTR(UCASE$(IfTrue$), "TRUE") <> 0 THEN
    C$ = " btfss "
    IF S% = 1 THEN C$ = " btfsc "
   END IF
   IF INSTR(UCASE$(IfTrue$), "FALSE") <> 0 THEN
    C$ = " btfsc "
    IF S% = 1 THEN C$ = " btfss "
   END IF
   C$ = C$ + V$ + "," + B$
   COSC% = 1: CheckTemp$(COSC%) = C$
   VLC% = VLC% + 1: VARLIST$(VLC%) = V$
  END IF

 END IF

 'More than one condition, so compile as calculation
ComplexCondition:
 IF Complex = 1 THEN
  FOR T% = 1 TO 100
   TempData$(T%) = ""
  NEXT T%
  DO WHILE INSTR(Condition$, " ") <> 0: Replace Condition$, " ", "": LOOP
  T% = 0
  S$ = Condition$
  CSC% = 0
  ThisCalc% = 0
  IF IsWord(S$) THEN ThisCalc% = 1
  
  CompileCalc S$
  TempData$(CSC%) = " movwf SysIFTemp"
  FOR WD% = 1 TO CSC%
   CheckTemp$(WD%) = TempData$(WD%)
  NEXT WD%
  COSC% = CSC% + 1
  IF INSTR(UCASE$(IfTrue$), "TRUE") <> 0 THEN C$ = " btfss STATUS, Z"
  IF INSTR(UCASE$(IfTrue$), "FALSE") <> 0 THEN C$ = " btfsc STATUS, Z"
  CheckTemp$(COSC%) = C$
  VLC% = VLC% + 1: VARLIST$(VLC%) = "SysIFTemp"
 END IF

 'No conditions - check if variable is 0 or non-0
 IF Complex = -1 THEN
  COSC% = 2
  CheckTemp$(1) = "SysIFTemp=" + UCASE$(Condition$)
  IF IsConst(Condition$) THEN CheckTemp$(2) = " movf SysIFTemp, F": COSC% = COSC% + 1
  IF INSTR(UCASE$(IfTrue$), "TRUE") <> 0 THEN C$ = " btfss STATUS, Z"
  IF INSTR(UCASE$(IfTrue$), "FALSE") <> 0 THEN C$ = " btfsc STATUS, Z"
  CheckTemp$(COSC%) = C$
 END IF

END SUB

SUB CompileDir
CD% = 0
FoundCount% = 0

CompileDir:
 CD% = CD% + 1
 DS$ = PROG$(CD%)
 IF LEFT$(DS$, 4) = "DIR " THEN
  
  FoundCount% = FoundCount% + 1
  DS$ = LTRIM$(RTRIM$(MID$(DS$, 4)))
  D$ = LTRIM$(MID$(DS$, INSTR(DS$, " ") + 1))
  P$ = RTRIM$(LEFT$(DS$, INSTR(DS$, " ") - 1))
  IF INSTR(P$, "GPIO") <> 0 THEN Replace P$, "GPIO", "IO"
  IF INSTR(P$, "PORT") = 0 AND LEFT$(ChipName$, 2) = "16" AND LEN(P$) = 2 THEN P$ = "PORT" + LEFT$(P$, 1) + "." + MID$(P$, 2)
  Replace D$, "PUT", ""
  
  V$ = P$
  IF INSTR(V$, "PORT") = 0 THEN V$ = "TRIS" + V$: GOTO SetDir
  IF INSTR(V$, "PORT") <> 0 THEN Replace V$, "PORT", "TRIS"
  
SetDir:

  'Determine if DIR sets 1 bit or whole port
  DirPort% = 1
  IF INSTR(P$, ".") <> 0 THEN DirPort% = 0
  
  'Add code
  IF DirPort% = 1 THEN
   PROG$(CD%) = ""
   IF D$ = "IN" THEN PROG$(CD%) = V$ + "=255"
   IF D$ = "OUT" THEN PROG$(CD%) = " clrf " + V$
   IF PROG$(CD%) = "" THEN PROG$(CD%) = V$ + "=" + D$
  END IF

  IF DirPort% = 0 THEN
   Replace V$, ".", ","
   IF D$ = "IN" THEN PROG$(CD%) = " bsf " + V$
   IF D$ = "OUT" THEN PROG$(CD%) = " bcf " + V$
  END IF

 END IF
IF CD% < APC% THEN GOTO CompileDir

END SUB

SUB CompileDo
PD% = 0
DLC% = 0
DL% = 0
CompileDo:
PD% = PD% + 1
 DS$ = UCASE$(PROG$(PD%))
 IF LEFT$(DS$, 3) = "DO " OR DS$ = "DO" THEN
  CP% = 0
  IF LEFT$(DS$, 3) = "DO " THEN CP% = 1
  DL% = 1
  DLC% = DLC% + 1
  PROG$(PD%) = "SysDoLoop_S" + MID$(STR$(DLC%), 2)

  FOR CD% = PD% + 1 TO APC%
   T$ = UCASE$(PROG$(CD%))
   IF LEFT$(T$, 5) = "LOOP " OR T$ = "LOOP" THEN DL% = DL% - 1
   IF LEFT$(T$, 3) = "DO " OR T$ = "DO" THEN DL% = DL% + 1
   IF DL% = 0 THEN LL% = CD%: EXIT FOR
  NEXT CD%
  
  IF LEFT$(PROG$(LL%), 5) = "LOOP " THEN CP% = 2

  IF CP% = 1 THEN
   V$ = LTRIM$(MID$(DS$, 4))
   U$ = LCASE$(MID$(V$, INSTR(V$, " ") + 1))
   V$ = UCASE$(LEFT$(V$, INSTR(V$, " ") - 1))
   C$ = U$
  END IF
  IF CP% = 2 THEN
   V$ = LTRIM$(MID$(PROG$(LL%), 6))
   U$ = LCASE$(MID$(V$, INSTR(V$, " ") + 1))
   V$ = UCASE$(LEFT$(V$, INSTR(V$, " ") - 1))
   C$ = U$
  END IF

  IF CP% = 1 THEN
   T$ = "TRUE": IF V$ = "WHILE" THEN T$ = "FALSE"
   CompileConditions C$, T$
   COSC% = COSC% + 1: CheckTemp$(COSC%) = " goto SysDoLoop_E" + MID$(STR$(DLC%), 2)
   FOR WD% = 1 TO COSC%
    AddLine CheckTemp$(WD%), PD% + WD%
   NEXT WD%
   PD% = PD% + COSC%
   LL% = LL% + COSC%
  END IF
 
  IF CP% = 2 THEN
   T$ = "TRUE": IF V$ = "UNTIL" THEN T$ = "FALSE"
   CompileConditions C$, T$
   'COSC% = COSC% + 1: CheckTemp$(COSC%) = " goto SysDoLoop_E" + MID$(STR$(DLC%), 2)
   FOR WD% = 1 TO COSC%
    AddLine CheckTemp$(WD%), LL% + WD% - 1
   NEXT WD%
   PD% = PD% + COSC%
   LL% = LL% + COSC%
  END IF
  
  PROG$(LL%) = " goto SysDoLoop_S" + MID$(STR$(DLC%), 2)
  IF CP% <> 0 THEN AddLine "SysDoLoop_E" + MID$(STR$(DLC%), 2), LL% + 1
 END IF

IF PD% < APC% THEN GOTO CompileDo

FoundCount% = DLC%
END SUB

SUB CompileFor
PD% = 0
CompileFor:
PD% = PD% + 1
 T$ = PROG$(PD%)
 FL% = 0

 IF LEFT$(T$, 4) = "FOR " THEN
  FCO$ = T$
  Replace T$, " TO ", "~"
  IF INSTR(T$, " STEP ") <> 0 THEN Replace T$, " STEP ", "+"
  DO WHILE INSTR(T$, " ") <> 0: Replace T$, " ", "": LOOP
  V$ = MID$(T$, 4)
  V$ = LEFT$(V$, INSTR(V$, "=") - 1)
  SV$ = MID$(T$, INSTR(T$, "=") + 1)
  SV$ = LEFT$(SV$, INSTR(SV$, "~") - 1)
  EV$ = MID$(T$, INSTR(T$, "~") + 1)
  ST$ = "1"
  IF INSTR(T$, "+") <> 0 THEN
   EV$ = LEFT$(EV$, INSTR(EV$, "+") - 1)
   ST$ = MID$(T$, INSTR(T$, "+") + 1)
  END IF

  IF VAL(EV$) < VAL(SV$) AND IsConst(EV$) AND IsConst(SV$) AND INSTR(ST$, "-") = 0 THEN ST$ = "-" + ST$
  
  FLC% = FLC% + 1
  FL% = 1

  'Pseudo code:
  'V = SV - ST
  'SysForLoop(n):
  'V += ST
  '...
  'if V < EV then goto SysForLoop(n)
  
  'Starting code
  PROG$(PD%) = V$ + "=" + SV$ + "-" + ST$
  AddLine "SysForLoop" + MID$(STR$(FLC%), 2), PD% + 1
  AddLine V$ + "=" + V$ + "+" + ST$, PD% + 2

  'End code
  LL% = 0
  FOR CD% = PD% TO APC%
   T$ = UCASE$(PROG$(CD%))
   IF LEFT$(T$, 4) = "FOR " THEN FL% = FL% + 1
   IF T$ = "NEXT" THEN FL% = FL% - 1
   IF LEN(T$) > 4 THEN
    IF LEFT$(T$, 5) = "NEXT " THEN FL% = FL% - 1
   END IF
   IF FL% = 0 THEN LL% = CD%: EXIT FOR
  NEXT CD%
  
  IF LL% = 0 THEN
   ERC% = ERC% + 1
   T$ = Message$("NoNext")
   Replace T$, "%for%", CHR$(34) + FCO$ + CHR$(34)
   ERROR$(ERC%) = T$
  END IF
  IF LL% > 0 THEN
   IF INSTR(ST$, "-") = 0 THEN PROG$(LL%) = "IF " + V$ + " < " + EV$ + " THEN"
   IF INSTR(ST$, "-") <> 0 THEN PROG$(LL%) = "IF " + V$ + " > " + EV$ + " THEN"
   AddLine " goto SysForLoop" + MID$(STR$(FLC%), 2), LL% + 1
   AddLine "END IF", LL% + 2
  END IF
 END IF
IF PD% < APC% THEN GOTO CompileFor

FoundCount% = FLC%

END SUB

SUB CompilePot

PD% = 0
PotCompileStart:
 PD% = PD% + 1

 DS$ = PROG$(PD%)
 IF LEFT$(DS$, 4) = "POT " THEN
  P$ = MID$(DS$, 5)
  V$ = LTRIM$(MID$(P$, INSTR(P$, ",") + 1))
  P$ = LTRIM$(RTRIM$(LEFT$(P$, INSTR(P$, ",") - 1)))
  POC% = POC% + 1

  PROG$(PD%) = "DIR " + P$ + " OUT"
  AddLine "SET " + P$ + " 0", PD% + 1
  AddLine "WAIT 5 MS", PD% + 2
  AddLine "DIR " + P$ + " IN", PD% + 3
  AddLine V$ + "=0", PD% + 4
  AddLine "DO WHILE " + P$ + " OFF", PD% + 5
  AddLine V$ + "=" + V$ + "+1", PD% + 6
  AddLine "IF " + V$ + " = 255 THEN", PD% + 7
  AddLine "GOTO ENDPOT" + MID$(STR$(POC%), 2), PD% + 8
  AddLine "END IF", PD% + 9
  AddLine "WAIT 10 10US", PD% + 10
  AddLine "LOOP", PD% + 11
  AddLine "ENDPOT" + MID$(STR$(POC%), 2), PD% + 12
  PD% = PD% + 10
  FoundCount% = FoundCount% + 1

 END IF
IF PD% < APC% THEN GOTO PotCompileStart

END SUB

SUB CompilePulseOut

FoundCount% = 0

PD% = 0
CompilePulseOut:
PD% = PD% + 1

 DS$ = PROG$(PD%)
 IF LEFT$(DS$, 9) = "PULSEOUT " THEN

  P$ = LTRIM$(RTRIM$(MID$(DS$, 10)))
  D$ = LTRIM$(MID$(P$, INSTR(P$, ",") + 1))
  P$ = RTRIM$(LEFT$(P$, INSTR(P$, ",") - 1))

  PROG$(PD%) = "SET " + P$ + " 1"
  AddLine "WAIT " + D$, PD% + 1
  AddLine "SET " + P$ + " 0", PD% + 2
  PD% = PD% + 2
  
  FoundCount% = FoundCount% + 1
 END IF

IF PD% < APC% THEN GOTO CompilePulseOut

END SUB

SUB CompileRotate

FoundCount% = 0

PD% = 0
CompileRotate:
PD% = PD% + 1
 T$ = UCASE$(PROG$(PD%))
 IF LEFT$(T$, 7) = "ROTATE " THEN
  
  V$ = MID$(T$, INSTR(T$, " ") + 1)
  D$ = MID$(V$, INSTR(V$, " ") + 1)
  V$ = LEFT$(V$, INSTR(V$, " ") - 1)
  VT$ = TypeOfVar$(V$)

  IF VT$ = "WORD" AND D$ = "RIGHT" THEN
   AddLine " rrf " + V$ + "_H,F", PD%
   PD% = PD% + 1
  END IF

  C$ = " rrf ": IF D$ = "LEFT" THEN C$ = " rlf "
  PROG$(PD%) = C$ + V$ + ",F"
  VLC% = VLC% + 1: VARLIST$(VLC%) = V$

  IF VT$ = "WORD" AND D$ = "LEFT" THEN
   PD% = PD% + 1
   AddLine " rlf " + V$ + "_H,F", PD%
  END IF
  
  FoundCount% = FoundCount% + 1
 END IF
IF PD% < APC% THEN GOTO CompileRotate

END SUB

SUB CompileSet
FoundCount% = 0

FOR CD% = 1 TO APC%
 T$ = PROG$(CD%)
 IF UCASE$(LEFT$(T$, 4)) = "SET " THEN
  IF INSTR(T$, ".") = 0 THEN
   ERC% = ERC% + 1: ERROR$(ERC%) = Message$("NoBit")
   GOTO BADSET
  END IF
  P$ = MID$(T$, INSTR(T$, " ") + 1): P$ = LEFT$(P$, INSTR(P$, ".") - 1)
  B$ = MID$(T$, INSTR(T$, ".") + 1): B$ = LEFT$(B$, INSTR(B$, " ") - 1)
  S$ = MID$(T$, INSTR(INSTR(T$, " ") + 1, T$, " ") + 1): S$ = LEFT$(S$, 1)
  C$ = " bsf ": IF S$ = "0" THEN C$ = " bcf "
  P$ = UCASE$(P$)

  'Allow use with vars > 8 bit
  IF VAL(B$) > 7 THEN
   B$ = MID$(STR$(VAL(B$) - 8), 2)
   P$ = P$ + "_H"
  END IF

  PROG$(CD%) = C$ + P$ + "," + B$
  VLC% = VLC% + 1: VARLIST$(VLC%) = P$
  FoundCount% = FoundCount% + 1
 END IF
BADSET:
NEXT CD%
END SUB

SUB CompileWait

'Time Intervals: us, 10us, ms, 10ms, s, m, h

FoundCount% = 0

PD% = 0
CompileWaitLoop:
 PD% = PD% + 1
 T$ = UCASE$(PROG$(PD%))
 
 IF LEFT$(T$, 5) = "WAIT " THEN

  V$ = MID$(T$, 6)
  IF LEFT$(UCASE$(V$), 6) = "WHILE " OR LEFT$(UCASE$(V$), 6) = "UNTIL " THEN
   U$ = LCASE$(MID$(V$, INSTR(V$, " ") + 1))
   V$ = UCASE$(LEFT$(V$, INSTR(V$, " ") - 1))
   GOTO WaitDataFound
  END IF
  IF LEFT$(UCASE$(V$), 6) <> "WHILE " AND LEFT$(UCASE$(V$), 6) <> "UNTIL " THEN
   V$ = LTRIM$(RTRIM$(V$))
   FOR UP% = LEN(V$) TO 1 STEP -1
    IF MID$(V$, UP%, 1) = " " THEN
     U$ = LCASE$(LTRIM$(RTRIM$(MID$(V$, UP% + 1))))
     V$ = LTRIM$(RTRIM$(LEFT$(V$, UP% - 1)))
     EXIT FOR
    END IF
   NEXT UP%
  END IF

WaitDataFound:

  'Time-based wait
  IF V$ <> "UNTIL" AND V$ <> "WHILE" THEN
   IF INSTR(U$, "second") <> 0 THEN Replace U$, "second", "s"
   IF U$ = "us" OR U$ = "usec" THEN U$ = "Delay_US"
   IF U$ = "10us" OR U$ = "10usec" THEN U$ = "Delay_10US"
   IF U$ = "ms" OR U$ = "msec" THEN U$ = "Delay_MS"
   IF U$ = "10ms" OR U$ = "10msec" THEN U$ = "Delay_10MS"
   IF U$ = "s" OR U$ = "sec" THEN U$ = "Delay_S"
   IF U$ = "m" OR U$ = "min" THEN U$ = "Delay_M"
   IF U$ = "h" OR U$ = "hour" THEN U$ = "Delay_H"
   IF INSTR(U$, "Delay_") = 0 THEN ERC% = ERC% + 1: ERROR$(ERC%) = "Delay units not defined! Command:" + T$

   T$ = U$: Replace T$, "Delay_", ""
   
   IF LTRIM$(RTRIM$(V$)) = "0" OR VAL(V$) < 0 THEN
    DelLine PD%: PD% = PD% - 1
    'ERC% = ERC% + 1: ERROR$(
    GOTO EndWaitCompile
   END IF
   PROG$(PD%) = "SysWaitTemp" + T$ + "=" + V$
   AddLine " call " + U$, PD% + 1

   PD% = PD% + 1 'was + 2
   FoundCount% = FoundCount% + 1
  END IF

  'Condition-based Wait
  IF V$ = "WHILE" OR V$ = "UNTIL" THEN
   C$ = UCASE$(U$)
   OP$ = ""
   WSC% = WSC% + 1
   PROG$(PD%) = "SysWaitLoop" + MID$(STR$(WSC%), 2)

   T$ = "TRUE": IF V$ = "UNTIL" THEN T$ = "FALSE"
   CompileConditions C$, T$
   COSC% = COSC% + 1: CheckTemp$(COSC%) = "goto SysWaitLoop" + MID$(STR$(WSC%), 2)
   FOR WD% = 1 TO COSC%
    AddLine CheckTemp$(WD%), PD% + WD%
   NEXT WD%
   PD% = PD% + COSC%
   FoundCount% = FoundCount% + 1
  END IF

 END IF

EndWaitCompile:
IF PD% < APC% THEN GOTO CompileWaitLoop

END SUB

FUNCTION CountOccur (Source$, Search$)
 T% = 0

 IF LEFT$(Search$, 2) <> "';" THEN
  FOR CO% = 1 TO LEN(Source$) - (1 - LEN(Search$))
   IF MID$(UCASE$(Source$), CO%, LEN(Search$)) = UCASE$(Search$) THEN T% = T% + 1
  NEXT CO%
 END IF

 IF LEFT$(Search$, 2) = "';" THEN
  T$ = MID$(Search$, 3)
  FOR SC% = 1 TO LEN(T$)
   FOR CO% = 1 TO LEN(Source$)
    IF MID$(UCASE$(Source$), CO%, 1) = UCASE$(MID$(T$, SC%, 1)) THEN T% = T% + 1
   NEXT CO%
  NEXT SC%
 END IF

 CountOccur = T%
END FUNCTION

FUNCTION GetByte$ (DS$, BS%)

 'BS% is 0 for low, 1 for high

 'Check if variable
 IF NOT IsConst(DS$) THEN
  IF BS% = 0 THEN GetByte$ = DS$: EXIT FUNCTION
  IF BS% = 1 THEN GetByte$ = DS$ + "_H": EXIT FUNCTION
 END IF

 T! = 0

 'Convert to decimal
 IF DS$ = MID$(STR$(VAL(DS$)), 2) THEN T! = VAL(DS$)

 IF INSTR(LCASE$(DS$), "b'") <> 0 THEN
  T$ = MID$(DS$, INSTR(LCASE$(DS$), "b'") + 2)
  Replace T$, "'", ""
  T! = 0
  FOR PD% = 1 TO LEN(T$)
   T! = T! + 2 ^ (LEN(T$) - PD%) * VAL(MID$(T$, PD%, 1))
  NEXT PD%
 END IF

 IF INSTR(LCASE$(DS$), "0x") <> 0 THEN
  T$ = DS$
  Replace T$, "0x", "&h"
  T! = VAL(T$)
 END IF

 IF BS% = 0 THEN GetByte$ = MID$(STR$(T! AND 255), 2)
 IF BS% = 1 THEN GetByte$ = MID$(STR$((T! AND 65280) / 256), 2)

END FUNCTION

SUB InitCompiler (C$)

'Replace - with / in parameters
'Allows better DOSBox compatibility
IF INSTR(C$, "-O:") <> 0 THEN Replace C$, "-O:", "/O:"
IF INSTR(C$, "-A:") <> 0 THEN Replace C$, "-A:", "/A:"
IF INSTR(C$, "-D:") <> 0 THEN Replace C$, "-D:", "/D:"
IF INSTR(C$, "-V") <> 0 THEN Replace C$, "-V", "/V"
IF INSTR(C$, "-NC") <> 0 THEN Replace C$, "-NC", "/NC"
IF INSTR(C$, "-L") <> 0 THEN Replace C$, "-L", "/L"

'Get output filename from COMMAND$
OFI$ = ""
IF INSTR(C$, "/O:") <> 0 THEN
 T$ = MID$(C$, INSTR(C$, "/O:"))
 IF INSTR(T$, " ") <> 0 THEN T$ = LEFT$(T$, INSTR(T$, " ") - 1)
 Replace C$, T$, ""
 OFI$ = MID$(T$, 4)
END IF

'Get command to assemble program from COMMAND$
MakeASM$ = ""
IF INSTR(C$, "/A:") <> 0 THEN
 T$ = MID$(C$, INSTR(C$, "/A:"))
 IF INSTR(T$, " ") <> 0 THEN T$ = LEFT$(T$, INSTR(T$, " ") - 1)
 Replace C$, T$, ""
 MakeASM$ = ShortName$(MID$(T$, 4))
END IF

'Detect GCBASIC install directory
ID$ = CURDIR$
IF INSTR(C$, "/D:") <> 0 THEN
 T$ = MID$(C$, INSTR(C$, "/D:"))
 IF INSTR(T$, " ") <> 0 THEN T$ = LEFT$(T$, INSTR(T$, " ") - 1)
 Replace C$, T$, ""
 ID$ = ShortName$(MID$(T$, 4))
END IF

'Clear screen before compile?
IF INSTR(C$, "/NC") = 0 THEN CLS
Replace C$, "/NC", ""

'Verbose Mode?
VBS% = 0: IF INSTR(C$, "/V") <> 0 THEN VBS% = 1
Replace C$, "/V", ""

'Read message list
IF DIR$(ID$ + "\messages.dat") = "" THEN
 PRINT "Cannot find " + ID$ + "\messages.dat! Great Cow BASIC cannot operate"
 PRINT "without this file."
 PRINT
 PRINT "Press any key to continue"
 DO WHILE INKEY$ = "": LOOP
 END
END IF
OPEN ID$ + "\messages.dat" FOR INPUT AS #1
Block% = 0
DO WHILE NOT EOF(1)
 LINE INPUT #1, DS$
 DS$ = LTRIM$(RTRIM$(DS$))
 IF LEFT$(UCASE$(DS$), 6) = "BLOCK " THEN Block% = 1
 IF LEFT$(UCASE$(DS$), 9) = "END BLOCK" THEN Block% = 0
 IF LEFT$(DS$, 1) = "'" THEN DS$ = ""
 IF INSTR(DS$, "=") <> 0 THEN
  N$ = LEFT$(DS$, INSTR(DS$, "=") - 1)
  V$ = MID$(DS$, INSTR(DS$, "=") + 1)
  IF INSTR(V$, CHR$(34)) <> 0 THEN
   V$ = MID$(V$, INSTR(V$, CHR$(34)) + 1)
   V$ = LEFT$(V$, INSTR(V$, CHR$(34)) - 1)
  END IF
  MSGC% = MSGC% + 1
  Messages$(1, MSGC%) = LTRIM$(RTRIM$(UCASE$(N$)))
  Messages$(2, MSGC%) = V$
 END IF
LOOP
CLOSE #1

'Show Licence?
IF INSTR(C$, "/L") <> 0 THEN
 ShowBlock "License"
 END
END IF

FI$ = ShortName$(C$)
DO WHILE INSTR(FI$, " ") <> 0: Replace FI$, " ", "": LOOP

'Message if no filename specified
IF FI$ = "" THEN
 ShowBlock "NoPrompt"
 T$ = INKEY$
 PRINT
 PRINT Message$("AnyKey")
 DO WHILE INKEY$ = "": LOOP
 END
END IF

'Decide name for output file if not specified
IF OFI$ = "" THEN
 T$ = MID$(FI$, INSTR(FI$, ".") + 1)
 OFI$ = FI$
 Replace OFI$, T$, "asm"
END IF

'Find directory of source file (used for relative include)
ProgDir$ = CURDIR$
IF INSTR(FI$, "\") <> 0 THEN
 FOR T% = LEN(FI$) TO 1 STEP -1
  IF MID$(FI$, T%, 1) = "\" THEN EXIT FOR
 NEXT T%
 ProgDir$ = LEFT$(FI$, T% - 1)
END IF
IF RIGHT$(ProgDir$, 1) = "\" THEN ProgDir$ = LEFT$(ProgDir$, LEN(ProgDir$) - 1)

'Show version
PRINT "Great Cow BASIC (" + Version$ + ")"
PRINT

'Start Compile
PRINT Message$("Compiling")

IF DIR$(FI$) = "" THEN
 PRINT
 PRINT Message$("NoFile")
 END
END IF

END SUB

FUNCTION IsCalc (DS$)

 IsCalc = 0
 IF INSTR(DS$, "+") <> 0 THEN IsCalc = -1
 IF INSTR(DS$, "-") <> 0 THEN IsCalc = -1
 IF INSTR(DS$, "*") <> 0 THEN IsCalc = -1
 IF INSTR(DS$, "/") <> 0 THEN IsCalc = -1
 IF INSTR(DS$, "AND") <> 0 THEN IsCalc = -1
 IF INSTR(DS$, "OR") <> 0 THEN IsCalc = -1
 IF INSTR(DS$, "NOT") <> 0 THEN IsCalc = -1
 IF INSTR(DS$, "XOR") <> 0 THEN IsCalc = -1
 IF INSTR(DS$, "&") <> 0 THEN IsCalc = -1
 IF INSTR(DS$, "|") <> 0 THEN IsCalc = -1
 IF INSTR(DS$, "!") <> 0 THEN IsCalc = -1
 IF INSTR(DS$, "#") <> 0 THEN IsCalc = -1

END FUNCTION

FUNCTION IsConst (DS$)

T$ = LTRIM$(RTRIM$(DS$))
IF LEFT$(T$, 1) = "-" THEN T$ = MID$(T$, 2)

IsConst = 0
IF T$ = MID$(STR$(VAL(T$)), 2) THEN IsConst = -1
IF INSTR(LCASE$(T$), "b'") <> 0 THEN IsConst = -1
IF INSTR(LCASE$(T$), "0x") <> 0 THEN IsConst = -1

IF INSTR(T$, "+") <> 0 THEN IsConst = 0
IF INSTR(T$, "-") <> 0 THEN IsConst = 0
IF INSTR(T$, "*") <> 0 THEN IsConst = 0
IF INSTR(T$, "/") <> 0 THEN IsConst = 0
IF INSTR(T$, "&") <> 0 THEN IsConst = 0
IF INSTR(T$, "|") <> 0 THEN IsConst = 0
IF INSTR(T$, "!") <> 0 THEN IsConst = 0
IF INSTR(T$, "#") <> 0 THEN IsConst = 0


END FUNCTION

FUNCTION IsWord (T$)

IsWord = 0

IF INSTR(UCASE$(T$), "[WORD]") <> 0 THEN IsWord = -1: EXIT FUNCTION

FOR PD% = 1 TO VLC%
 DS$ = T$
 IF INSTR(UCASE$(DS$), UCASE$(VARLIST$(PD%))) <> 0 THEN
DelSimilar:
  IF WholeINSTR(UCASE$(DS$), UCASE$(VARLIST$(PD%))) <> 2 THEN
   Replace DS$, VARLIST$(PD%), ""
   IF INSTR(UCASE$(DS$), UCASE$(VARLIST$(PD%))) <> 0 THEN GOTO DelSimilar
  END IF
  IF WholeINSTR(UCASE$(DS$), UCASE$(VARLIST$(PD%))) = 2 AND UCASE$(VarType$(PD%)) = "WORD" THEN IsWord = -1: EXIT FUNCTION
 END IF
NEXT PD%

END FUNCTION

FUNCTION MakeDec (T$)
 DS$ = UCASE$(T$)

 IF INSTR(DS$, "0X") <> 0 THEN
  DS$ = MID$(DS$, INSTR(DS$, "0X") + 2)
  MakeDec = VAL("&H" + DS$)
  EXIT FUNCTION
 END IF

 IF DS$ = MID$(STR$(VAL(DS$)), 2) THEN
  MakeDec = VAL(DS$)
  EXIT FUNCTION
 END IF

 IF INSTR(DS$, "B'") <> 0 THEN
  DS$ = MID$(DS$, INSTR(DS$, "B'") + 2)
  DS$ = LEFT$(DS$, INSTR(DS$, "'") - 1)
  T% = 0
  FOR CB% = LEN(DS$) TO 1 STEP -1
   T% = T% + VAL(MID$(DS$, LEN(DS$) - CB% + 1, 1)) * 2 ^ (CB% - 1)
  NEXT CB%
  MakeDec = T%
 END IF

END FUNCTION

FUNCTION Message$ (DS$)

 'Find message
 DS$ = UCASE$(DS$)
 DS% = 0
 FOR T% = 1 TO MSGC%
  IF Messages$(1, T%) = DS$ THEN DS% = T%: EXIT FOR
 NEXT

 'Retrieve message
 IF DS% = 0 THEN Message$ = "Message " + DS$ + " not defined in messages.dat!": EXIT FUNCTION
 IF DS% <> 0 THEN M$ = Messages$(2, DS%)

 'Replace values
 T$ = UCASE$(M$)
 IF INSTR(T$, "%VERSION%") <> 0 THEN Replace M$, "%VERSION%", Version$
 IF INSTR(T$, "%FILENAME%") <> 0 THEN Replace M$, "%FILENAME%", FI$
 IF INSTR(T$, "%OUTPUTFILE%") <> 0 THEN Replace M$, "%OUTPUTFILE%", OFI$

 Message$ = M$

END FUNCTION

SUB Replace (VAR$, FIND$, REP$)

 VART$ = UCASE$(VAR$): FINDT$ = UCASE$(FIND$)
 IF INSTR(VART$, FINDT$) = 0 THEN VAR$ = VAR$ + REP$: EXIT SUB

 ND$ = LEFT$(VAR$, INSTR(VART$, FINDT$) - 1)
 ND$ = ND$ + REP$
 ND$ = ND$ + MID$(VAR$, INSTR(VART$, FINDT$) + LEN(FIND$))

 VAR$ = ND$
END SUB

SUB SCICONV (ST$)

DO WHILE INSTR(ST$, " ") <> 0: Replace ST$, " ", "": LOOP

IF INSTR(UCASE$(ST$), "E") <> 0 THEN
 T$ = "00000000000000000000"
 V$ = LEFT$(ST$, INSTR(ST$, "E") - 1)
 P$ = MID$(ST$, INSTR(ST$, "E") + 1)
 Replace V$, ".", ""
 P% = VAL(P$)
 S% = 1: IF INSTR(V$, "-") <> 0 THEN S% = -1: Replace V$, "-", ""
 IF SGN(P%) = -1 THEN ST$ = "0." + LEFT$(T$, P% * -1 - 1) + V$
 IF SGN(P%) = 1 THEN ST$ = V$ + LEFT$(T$, P%)
 IF S% = -1 THEN ST$ = "-" + ST$
END IF

IF INSTR(UCASE$(ST$), "D") <> 0 THEN
 T$ = "00000000000000000000"
 DV% = VAL(MID$(ST$, INSTR(ST$, "D") + 1))
 ST$ = LEFT$(ST$, INSTR(ST$, "D") - 1)
 DV% = DV% * SGN(DV%)
 IF DV% > 1 THEN DV% = DV% - 1
 DS$ = ST$
 Replace DS$, ".", ""
 Replace DS$, "-", ""
 Replace DS$, " ", ""
 M% = 0: IF INSTR(ST$, "-") <> 0 THEN M% = 1
 IF DV% > 7 THEN ST$ = ".0": EXIT SUB
 A% = 7 - DV%
 ST$ = "." + LEFT$(T$, DV%)
 ST$ = ST$ + LEFT$(DS$, A%)
 IF M% = 1 THEN ST$ = "-" + ST$
END IF

DO WHILE INSTR(ST$, " ") <> 0: Replace ST$, " ", "": LOOP

END SUB

FUNCTION ShortName$ (DS$)

'Get rid of "s
DO WHILE INSTR(DS$, CHR$(34)) <> 0
 Replace DS$, CHR$(34), ""
LOOP

T% = 0

DO WHILE INSTR(DS$, "\") <> 0
 T% = T% + 1
 TempData$(T%) = LTRIM$(RTRIM$(LEFT$(DS$, INSTR(DS$, "\") - 1)))
 DS$ = MID$(DS$, INSTR(DS$, "\") + 1)
LOOP

T% = T% + 1
TempData$(T%) = DS$

'Clean up filename
FOR PD% = 1 TO T%
 ThisLong% = 0
 Ext$ = ""
 DS$ = TempData$(PD%)
 DS$ = LTRIM$(RTRIM$(DS$))
 IF INSTR(DS$, ".") <> 0 THEN
  Ext$ = MID$(DS$, INSTR(DS$, ".") + 1)
  DS$ = LEFT$(DS$, INSTR(DS$, ".") - 1)
 END IF
 IF LEN(DS$) > 8 THEN ThisLong% = 1
 
 DO WHILE INSTR(DS$, " ") <> 0
  Replace DS$, " ", ""
  ThisLong% = 1
 LOOP

 IF ThisLong% = 1 THEN DS$ = LEFT$(DS$, 6) + "~1"
 IF Ext$ <> "" THEN DS$ = DS$ + "." + Ext$
 TempData$(PD%) = UCASE$(DS$)
NEXT

'Output filename
DS$ = ""
FOR PD% = 1 TO T%
 DS$ = DS$ + "\" + TempData$(PD%)
NEXT
ShortName$ = MID$(DS$, 2)

END FUNCTION

SUB ShowBlock (DS$)

 DS$ = UCASE$(LTRIM$(RTRIM$(DS$)))

 OPEN ID$ + "\messages.dat" FOR INPUT AS #9
 DO WHILE NOT EOF(9)
  LINE INPUT #9, L$
  L$ = UCASE$(LTRIM$(RTRIM$(L$)))
  IF L$ = "BLOCK " + DS$ THEN GOTO FoundBlock
 LOOP
 CLOSE #9
 EXIT SUB

FoundBlock:
 LINE INPUT #9, DS$
 IF UCASE$(LTRIM$(RTRIM$(DS$))) = "END BLOCK" THEN CLOSE #9: EXIT SUB

  IF INSTR(UCASE$(DS$), "%VERSION%") <> 0 THEN Replace DS$, "%VERSION%", Version$
  IF INSTR(UCASE$(DS$), "%FILENAME%") <> 0 THEN Replace DS$, "%FILENAME%", FI$
  IF INSTR(UCASE$(DS$), "%OUTPUTFILE%") <> 0 THEN Replace DS$, "%OUTPUTFILE%", OFI$

  PRINT DS$
 IF NOT EOF(9) THEN GOTO FoundBlock
 CLOSE #9

END SUB

FUNCTION TypeOfVar$ (VarName$)

TypeOfVar$ = "BYTE"

VarFound% = 0
T$ = UCASE$(VarName$)
FOR PD% = 1 TO VLC%
 IF UCASE$(VARLIST$(PD%)) = T$ THEN VarFound% = PD%: EXIT FOR
NEXT PD%

IF VarFound% <> 0 THEN
 T$ = VarType$(VarFound%)
 IF T$ <> "" THEN TypeOfVar$ = UCASE$(T$)
END IF

END FUNCTION

FUNCTION WholeINSTR (DS$, N$)
 IF INSTR(DS$, N$) = 0 THEN WholeINSTR = 0: EXIT FUNCTION

 T% = 0
 IF LEN(DS$) = LEN(N$) THEN T% = 2

 IF INSTR(DS$, N$) = 1 THEN T% = 1
 IF T% = 0 THEN
  T$ = MID$(DS$, INSTR(DS$, N$) - 1, 1)
  IF T$ = " " THEN T% = 1
  IF T$ = "(" THEN T% = 1
  IF T$ = ")" THEN T% = 1
  IF T$ = "," THEN T% = 1
  IF T$ = "." THEN T% = 1
  IF T$ = ":" THEN T% = 1
  IF T$ = "+" THEN T% = 1
  IF T$ = "-" THEN T% = 1
  IF T$ = "*" THEN T% = 1
  IF T$ = "/" THEN T% = 1
  IF T$ = "=" THEN T% = 1
  IF T$ = "!" THEN T% = 1
  IF T$ = "<" THEN T% = 1
  IF T$ = ">" THEN T% = 1
  IF T$ = "{" THEN T% = 1
  IF T$ = "}" THEN T% = 1
  IF T$ = "~" THEN T% = 1
  IF T$ = "&" THEN T% = 1
  IF T$ = "|" THEN T% = 1
  IF T$ = "#" THEN T% = 1
  T2$ = T$
 END IF

 IF INSTR(DS$, N$) + LEN(N$) - 1 = LEN(DS$) THEN T% = T% + 1
 IF T% < 2 THEN
  T$ = MID$(DS$, INSTR(DS$, N$) + LEN(N$), 1)
  IF T$ = " " THEN T% = T% + 1
  IF T$ = "(" THEN T% = T% + 1
  IF T$ = ")" THEN T% = T% + 1
  IF T$ = "," THEN T% = T% + 1
  IF T$ = "." THEN T% = T% + 1
  IF T$ = ":" THEN T% = T% + 1
  IF T$ = "+" THEN T% = T% + 1
  IF T$ = "-" THEN T% = T% + 1
  IF T$ = "*" THEN T% = T% + 1
  IF T$ = "/" THEN T% = T% + 1
  IF T$ = "=" THEN T% = T% + 1
  IF T$ = "!" THEN T% = T% + 1
  IF T$ = "<" THEN T% = T% + 1
  IF T$ = ">" THEN T% = T% + 1
  IF T$ = "{" THEN T% = T% + 1
  IF T$ = "}" THEN T% = T% + 1
  IF T$ = "~" THEN T% = T% + 1
  IF T$ = "&" THEN T% = T% + 1
  IF T$ = "|" THEN T% = T% + 1
  IF T$ = "#" THEN T% = T% + 1

 END IF

WholeINSTR = T%

END FUNCTION

