DECLARE SUB FindCalcSubs (DS$)
DECLARE FUNCTION SubListLocation! (SN$)
DECLARE SUB FindSubs (DS$)
DECLARE FUNCTION LocationOfSub! (SubName$)
DECLARE FUNCTION Message$ (DS$)
DECLARE FUNCTION ShortName$ (DS$)
DECLARE FUNCTION IsDefined! (Var$)
DECLARE SUB ProcessWords ()
DECLARE SUB CompileReadTable ()
DECLARE FUNCTION IsWord! (DS$)
DECLARE FUNCTION GetByte$ (DS$, BS%)
DECLARE SUB InitCompiler (C$)
DECLARE SUB CompilePot ()
DECLARE FUNCTION AsmTidy$ (DS$)
DECLARE FUNCTION TypeOfVar$ (VarName$)
DECLARE SUB FindLargeVars ()
DECLARE FUNCTION WholeINSTR (DS$, N$)
DECLARE FUNCTION MakeDec! (DS$)
DECLARE SUB ProcessArrays ()
DECLARE SUB TranslateArrays ()
DECLARE SUB FindArrays ()
DECLARE SUB DelSysVars ()
DECLARE SUB FindFreeRAM ()
DECLARE SUB CompilePulseOut ()
DECLARE SUB CompileConditions (Condition$, IfTrue$)
DECLARE FUNCTION CountOccur (Source$, Search$)
DECLARE SUB FixFunctions ()
DECLARE FUNCTION IsCalc! (DS$)
DECLARE SUB TranslateFunctions ()
DECLARE SUB ReplaceConstantsLine (DS$)
DECLARE SUB Calculate (SUM$)
DECLARE SUB DelSubLine (T%)
DECLARE SUB RunScripts ()
DECLARE SUB AddSubLine (DS$, T%)
DECLARE FUNCTION CheckLine! (DS$)
DECLARE SUB AddBankCommands ()
DECLARE SUB AddLine (DS$, T%)
DECLARE SUB CalcConfig ()
DECLARE SUB CompileCalc (SUM$)
DECLARE SUB CompileDir ()
DECLARE SUB CompileDo ()
DECLARE SUB CompileFor ()
DECLARE SUB CompileIF ()
DECLARE SUB CompileRotate ()
DECLARE SUB CompileSet ()
DECLARE SUB CompileVars ()
DECLARE SUB CompileWait ()
DECLARE SUB DelLine (T%)
DECLARE SUB FindRequiredSubs ()
DECLARE FUNCTION IsConst! (T$)
DECLARE SUB OptimiseIF ()
DECLARE SUB RemIfDefs ()
DECLARE SUB Replace (Var$, Find$, REP$)
DECLARE SUB ReplaceConstants ()
DECLARE SUB SortVarList ()
DECLARE SUB SplitLines ()
DECLARE SUB SubParams ()
DECLARE SUB PreProcessor ()
DECLARE SUB PrepareBuiltIn ()

'    GCBASIC - A BASIC Compiler for PIC microcontrollers
'    Copyright (C) 2006 Hugh Considine
'
'    This program is free software; you can redistribute it and/or modify
'    it under the terms of the GNU General Public License as published by
'    the Free Software Foundation; either version 2 of the License, or
'    (at your option) any later version.
'
'    This program is distributed in the hope that it will be useful,
'    but WITHOUT ANY WARRANTY; without even the implied warranty of
'    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
'    GNU General Public License for more details.
'
'    You should have received a copy of the GNU General Public License
'    along with this program; if not, write to the Free Software
'    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
'
'If you have any questions, please email me: hconsidine@bigpond.com
'
' Multiply and divide code has been written by Finn Stokes

'Initialise
'Misc Vars
COMMON SHARED APC%, ICC%, DFC%, VLC%, SBC%, SDC%, SLC%, IFC%, ERC%, WSC%, FLC%, DLC%, ARC%, SSC%, SASC%, POC%, COC%, DTC%, LVC%
COMMON SHARED CSC%, CV%, COSC%, MemSize%, FreeRAM%, FoundCount%, PotFound%, ThisCalc%, LongPresent%, DivMultPresent%
COMMON SHARED ChipName$, ChipMhz, OSC$, CONFIG$, Int$, ChipRam%, ConfWords%, DataPass%
COMMON SHARED FI$, OFI$, ID$, VBS%, Version$, SVC%, ProgDir$, CLD$, MakeASM$, ProgWillFail%, MSGC%

COMMON SHARED TempData$(), CheckTemp$(), ConfigOp$(), ERROR$(), FILE$()
COMMON SHARED VARLIST$(), VarType$()

COMMON SHARED /progmem/ PROG$()
COMMON SHARED Messages$()
COMMON SHARED SUBCODE$()

CLOSE
CLEAR , , 2048 'Needs to be 1024 when running in QBX, 2048 when compiled
IF DIR$("ERRORS.TXT") <> "" THEN KILL "ERRORS.TXT"

'Code Array
'$DYNAMIC
DIM SHARED PROG$(2000): APC% = 0

'Sub arrays
'$DYNAMIC
DIM SHARED SUBLIST$(150, 1 TO 2): SLC% = 0
DIM SHARED SUBCODE$(3000), SUBDATA$(150, 1 TO 4): SBC% = 0: SDC% = 0

'Processing Arrays
'$DYNAMIC
DIM SHARED CallEvery$(25): CEC% = 0
DIM SHARED DEFINE$(300, 1 TO 3): DFC% = 0
DIM SHARED INCLUDE$(20, 1 TO 2): ICC% = 0
DIM SHARED VARLIST$(400): VLC% = 0
DIM SHARED VarType$(400)
DIM SHARED ArrayData$(25, 1 TO 4): ARC% = 0 '1 - name, 2 - start, 3 - size, 4 - dim/sub
DIM SHARED TempData$(150)
DIM SHARED CheckTemp$(150)
DIM SHARED ERROR$(25): ERC% = 0
DIM SHARED SysVars$(150, 1 TO 2)
DIM SHARED FILE$(100)
DIM SHARED FreeMem(1) AS INTEGER
DIM SHARED VarLoc(400) AS INTEGER
DIM SHARED StringStore$(50): SSC% = 0: SASC% = 0
DIM SHARED ConfigOp$(100): COC% = 0
DIM SHARED DataTables$(25): DTC% = 0
DIM SHARED DataTable%(25, 250)
DIM SHARED LargeVars$(50, 1 TO 2): LVC% = 0
DIM SHARED Messages$(1 TO 2, 100): MSGC% = 0

WSC% = 0
Star80$ = ";********************************************************************************"
LongPresent% = 0
DivMultPresent% = 0

'Set version
Version$ = "0.9 12/10/2006"

'Clear program failure warning
ProgWillFail% = 0

'Get file to compile from COMMAND$
C$ = COMMAND$

'Show startup messages, and read COMMAND$
StartTime! = TIMER
InitCompiler COMMAND$

'Load files, and tidy them up
PreProcessor
MainProgramSize% = APC%

IF VBS% = 1 THEN PRINT : PRINT SPC(5); Message$("FindLargeVars")
FindLargeVars

'Convert functions to subs with values returned
IF VBS% = 1 THEN PRINT : PRINT SPC(5); Message$("TranslateFunctions")
TranslateFunctions

REDIM TempData$(100)
REDIM CheckTemp$(100)

IF VBS% = 1 THEN PRINT : PRINT SPC(5); Message$("FindRequiredSubs")
FindRequiredSubs

'Add code to prevent program continuing into subs
APC% = APC% + 1: PROG$(APC%) = "BASPROGRAMEND"
APC% = APC% + 1: PROG$(APC%) = " sleep"
APC% = APC% + 1: PROG$(APC%) = " goto $"
APC% = APC% + 1: PROG$(APC%) = ""

'Add string lookup tables
IF SSC% <> 0 THEN
 IF VBS% = 1 THEN PRINT : PRINT SPC(5); Message$("StringTable")
 VLC% = VLC% + 1: VARLIST$(VLC%) = "StringPointer"
 VLC% = VLC% + 1: VARLIST$(VLC%) = "DataPointer"
 APC% = APC% + 1: PROG$(APC%) = Star80$
 APC% = APC% + 1: PROG$(APC%) = ""
 APC% = APC% + 1: PROG$(APC%) = "; String Lookup Tables"
 FOR PD% = 1 TO SSC%

  TL$ = "StringTable" + MID$(STR$(PD%), 2)
  APC% = APC% + 1: PROG$(APC%) = "StringLookup" + MID$(STR$(PD%), 2)
  APC% = APC% + 1: PROG$(APC%) = " bcf STATUS, C"
  APC% = APC% + 1: PROG$(APC%) = " movf StringPointer, W"
  APC% = APC% + 1: PROG$(APC%) = " addlw 1"
  APC% = APC% + 1: PROG$(APC%) = " addlw low " + TL$
  APC% = APC% + 1: PROG$(APC%) = " movwf DataPointer"
  APC% = APC% + 1: PROG$(APC%) = " movlw high " + TL$
  APC% = APC% + 1: PROG$(APC%) = " btfsc STATUS, C"
  APC% = APC% + 1: PROG$(APC%) = " addlw 1"
  APC% = APC% + 1: PROG$(APC%) = " movwf PCLATH"
  APC% = APC% + 1: PROG$(APC%) = " movf DataPointer, W"
  APC% = APC% + 1: PROG$(APC%) = TL$
  APC% = APC% + 1: PROG$(APC%) = " movwf PCL"
  
  DS$ = StringStore$(PD%)
  APC% = APC% + 1: PROG$(APC%) = " retlw " + MID$(STR$(LEN(DS$)), 2)
  FOR SP% = 1 TO LEN(DS$)
   APC% = APC% + 1
   T$ = " retlw " + MID$(STR$(ASC(MID$(DS$, SP%, 1))), 2)
   IF MID$(DS$, SP%, 1) <> "=" THEN T$ = T$ + CHR$(9) + ";" + MID$(DS$, SP%, 1)
   IF MID$(DS$, SP%, 1) = "=" THEN T$ = T$ + CHR$(9) + "; (equals)"
   PROG$(APC%) = T$
  NEXT SP%
  APC% = APC% + 1: PROG$(APC%) = " return"
  APC% = APC% + 1: PROG$(APC%) = ""
 NEXT PD%
END IF

'Add data tables
IF DTC% > 0 THEN
 IF VBS% = 1 THEN PRINT : PRINT SPC(5); Message$("DataTable")
 VLC% = VLC% + 1: VARLIST$(VLC%) = "DataPointer"
 APC% = APC% + 1: PROG$(APC%) = Star80$
 APC% = APC% + 1: PROG$(APC%) = ""
 APC% = APC% + 1: PROG$(APC%) = "; Data Lookup Tables"
 FOR PD% = 1 TO DTC%
  TL$ = "Table" + DataTables$(PD%)
  APC% = APC% + 1: PROG$(APC%) = DataTables$(PD%)
  APC% = APC% + 1: PROG$(APC%) = " bcf STATUS, C"
  APC% = APC% + 1: PROG$(APC%) = " addlw 1"
  APC% = APC% + 1: PROG$(APC%) = " addlw low " + TL$
  APC% = APC% + 1: PROG$(APC%) = " movwf DataPointer"
  APC% = APC% + 1: PROG$(APC%) = " movlw high " + TL$
  APC% = APC% + 1: PROG$(APC%) = " btfsc STATUS, C"
  APC% = APC% + 1: PROG$(APC%) = " addlw 1"
  APC% = APC% + 1: PROG$(APC%) = " movwf PCLATH"
  APC% = APC% + 1: PROG$(APC%) = " movf DataPointer, W"
  APC% = APC% + 1: PROG$(APC%) = TL$
  APC% = APC% + 1: PROG$(APC%) = " movwf PCL"
  FOR SP% = 0 TO DataTable%(PD%, 0)
   APC% = APC% + 1: PROG$(APC%) = " retlw " + MID$(STR$(DataTable%(PD%, SP%)), 2)
  NEXT SP%
  APC% = APC% + 1: PROG$(APC%) = " return"
  APC% = APC% + 1: PROG$(APC%) = ""
 NEXT PD%
END IF

'Add required subroutines
IF SLC% > 0 THEN
 IF VBS% = 1 THEN PRINT : PRINT SPC(5); Message$("AddingSubs")
 APC% = APC% + 1: PROG$(APC%) = Star80$
 APC% = APC% + 1: PROG$(APC%) = ";Subroutines included in program"
 APC% = APC% + 1: PROG$(APC%) = Star80$
 FOR PD% = 1 TO SLC%
  IF VBS% = 1 THEN PRINT SPC(10); SUBLIST$(PD%, 1)
  APC% = APC% + 1: PROG$(APC%) = ""
  APC% = APC% + 1: PROG$(APC%) = SUBLIST$(PD%, 1)
  T% = VAL(SUBLIST$(PD%, 2))
  S% = VAL(SUBDATA$(T%, 2)): E% = VAL(SUBDATA$(T%, 3))
  FOR CD% = S% TO E%
   IF SUBCODE$(CD%) <> "" THEN APC% = APC% + 1: PROG$(APC%) = SUBCODE$(CD%)
   SUBCODE$(CD%) = ""
  NEXT CD%
  APC% = APC% + 1: PROG$(APC%) = " return"
  APC% = APC% + 1: PROG$(APC%) = ""
  APC% = APC% + 1: PROG$(APC%) = Star80$

 NEXT PD%
END IF

'Clear a couple of redundant arrays to save RAM
ERASE SUBCODE$
ERASE SUBLIST$
REDIM PRESERVE PROG$(4000)
REDIM PRESERVE ERROR$(50)

'Compile FOR commands
IF VBS% = 1 THEN PRINT : PRINT SPC(5); Message$("CompileFor")
CompileFor

IF VBS% = 1 THEN PRINT : PRINT SPC(5); Message$("FindArrays")
FindArrays

'Compile Sub parameters
IF VBS% = 1 THEN PRINT : PRINT SPC(5); Message$("SubParams")
SubParams
SortVarList

IF VBS% = 1 THEN PRINT : PRINT SPC(5); Message$("ProcessArrays")
ProcessArrays

'Clear another array to free RAM
ERASE DEFINE$

'Replace +=, -=
FOR PD% = 1 TO APC%
 DS$ = PROG$(PD%)
 IF INSTR(DS$, "+=") <> 0 THEN
  V$ = LEFT$(DS$, INSTR(DS$, "+=") - 1)
  T$ = MID$(DS$, INSTR(DS$, "+=") + 2)
  PROG$(PD%) = V$ + "=" + V$ + "+" + T$
 END IF
 IF INSTR(DS$, "-=") <> 0 THEN
  V$ = LEFT$(DS$, INSTR(DS$, "-=") - 1)
  T$ = MID$(DS$, INSTR(DS$, "-=") + 2)
  PROG$(PD%) = V$ + "=" + V$ + "-" + T$
 END IF
NEXT PD%

IF VBS% = 1 THEN PRINT : PRINT SPC(5); Message$("CompComs")

IF VBS% = 1 THEN PRINT SPC(10); Message$("CompileReadTable");
CompileReadTable
IF VBS% = 1 THEN PRINT Message$("Found2") + STR$(FoundCount%) + ")"
SortVarList

IF VBS% = 1 THEN PRINT SPC(10); Message$("CompilePot");
CompilePot
IF VBS% = 1 THEN PRINT Message$("Found2") + STR$(FoundCount%) + ")"
SortVarList

'Compile DO commands
IF VBS% = 1 THEN PRINT SPC(10); Message$("CompileDO");
CompileDo
IF VBS% = 1 THEN PRINT Message$("Found2") + STR$(FoundCount%) + ")"
SortVarList

'Compile misc. commands
IF VBS% = 1 THEN PRINT SPC(10); Message$("CompileDir");
CompileDir
IF VBS% = 1 THEN PRINT Message$("Found2") + STR$(FoundCount%) + ")"
SortVarList

IF VBS% = 1 THEN PRINT SPC(10); Message$("CompilePulseOut");
CompilePulseOut
IF VBS% = 1 THEN PRINT Message$("Found2") + STR$(FoundCount%) + ")"
SortVarList

IF VBS% = 1 THEN PRINT SPC(10); Message$("CompileWait");
CompileWait
IF VBS% = 1 THEN PRINT Message$("Found2") + STR$(FoundCount%) + ")"
SortVarList

IF VBS% = 1 THEN PRINT SPC(10); Message$("CompileSet");
CompileSet
IF VBS% = 1 THEN PRINT Message$("Found2") + STR$(FoundCount%) + ")"
SortVarList

IF VBS% = 1 THEN PRINT SPC(10); Message$("CompileRotate");
CompileRotate
IF VBS% = 1 THEN PRINT Message$("Found2") + STR$(FoundCount%) + ")"
SortVarList

IF VBS% = 1 THEN PRINT SPC(10); Message$("CompileExitSub");
FoundCount% = 0
FOR PD% = 1 TO APC%
 IF UCASE$(PROG$(PD%)) = "EXIT SUB" THEN PROG$(PD%) = " return": FoundCount% = FoundCount% + 1
 IF UCASE$(PROG$(PD%)) = "EXIT FUNCTION" THEN PROG$(PD%) = " return": FoundCount% = FoundCount% + 1
 IF UCASE$(PROG$(PD%)) = "END" THEN PROG$(PD%) = " goto BASPROGRAMEND": FoundCount% = FoundCount% + 1
NEXT PD%
IF VBS% = 1 THEN PRINT Message$("Found2") + STR$(FoundCount%) + ")"
SortVarList

'Compile IF commands
IF VBS% = 1 THEN PRINT SPC(10); Message$("CompileIF");
CompileIF
IF VBS% = 1 THEN PRINT Message$("Found2") + STR$(FoundCount%) + ")"
SortVarList

'Compile variable commands
IF VBS% = 1 THEN PRINT SPC(10); Message$("CompileVars");
CompileVars
IF VBS% = 1 THEN PRINT Message$("Found2") + STR$(FoundCount%) + ")"
SortVarList

'Compile GOSUBs and RETURNs
FoundCount% = 0
IF VBS% = 1 THEN PRINT SPC(10); Message$("CompileGOSUB");
FOR CD% = 1 TO APC%
 IF LEFT$(UCASE$(PROG$(CD%)), 6) = "GOSUB " THEN Replace PROG$(CD%), "GOSUB", " call": FoundCount% = FoundCount% + 1
 IF UCASE$(PROG$(CD%)) = "RETURN" THEN Replace PROG$(CD%), "RETURN", " return": FoundCount% = FoundCount% + 1
NEXT CD%
IF VBS% = 1 THEN PRINT Message$("Found2") + STR$(FoundCount%) + ")"

'Compile GOTOs and labels
FoundCount% = 0
IF VBS% = 1 THEN PRINT SPC(10); Message$("CompileGOTO");
FOR CD% = 1 TO APC%
 IF LEFT$(UCASE$(PROG$(CD%)), 4) = "GOTO" THEN Replace PROG$(CD%), "GOTO", " goto": FoundCount% = FoundCount% + 1
NEXT CD%
FOR CD% = 1 TO APC%
 IF RIGHT$(PROG$(CD%), 1) = ":" THEN Replace PROG$(CD%), ":", "": FoundCount% = FoundCount% + 1
NEXT CD%
IF VBS% = 1 THEN PRINT Message$("Found2") + STR$(FoundCount%) + ")"

IF VBS% = 1 THEN PRINT : PRINT SPC(5); Message$("TidyCode")

'Delete variables that are defined by the assembler from the list of
'variables to define (PORTA, STATUS, etc.)
DelSysVars

'Check for invalid variable names
FOR PD% = 1 TO VLC%
 DS$ = VARLIST$(PD%)
 T% = 0
 IF INSTR(DS$, " ") <> 0 THEN T% = 1
 IF LEN(DS$) = 1 THEN T% = 1
 IF T% = 1 THEN
  ERC% = ERC% + 1
  T$ = Message$("BadVarName")
  Replace T$, "%var%", DS$
  ERROR$(ERC%) = T$
 END IF
NEXT PD%

'Determine the correct setting for the CONFIG directive
IF VBS% = 1 THEN PRINT SPC(10); Message$("CalcConfig")
CalcConfig

'Set Bank
IF VBS% = 1 THEN PRINT SPC(10); Message$("AddBankCommands");
AddBankCommands
IF VBS% = 1 THEN PRINT

'Tidy up code
IF VBS% = 1 THEN PRINT SPC(10); Message$("OptimiseIf")
OptimiseIF

IF VBS% = 1 THEN PRINT SPC(10); Message$("OptimiseVars")
PD% = 0
TidyVarClear:
 PD% = PD% + 1
 IF PROG$(PD%) = " movlw 0" AND LEFT$(PROG$(PD% + 1), 7) = " movwf " THEN
  PROG$(PD%) = " clrf" + MID$(PROG$(PD% + 1), 7)
  DelLine PD% + 1
  PD% = PD% - 1
 END IF
IF PD% < APC% THEN GOTO TidyVarClear

IF VBS% = 1 THEN PRINT SPC(10); Message$("FixFunctions")
FixFunctions

IF VBS% = 1 THEN PRINT : PRINT SPC(5); Message$("WritingASM")
'Write .ASM program
OPEN OFI$ FOR OUTPUT AS #1
PRINT #1, ";Program compiled by GCBASIC, which is the best language for PICs, ever!"
PRINT #1, ";Something not working? Email me at hconsidine@bigpond.com"
PRINT #1, ";GCBASIC Version: " + Version$
PRINT #1, ""
PRINT #1, Star80$
PRINT #1, ""
PRINT #1, ";Set up the assembler options (Chip type, clock source, other bits and pieces)"
PRINT #1, " LIST p=" + ChipName$ + ", r=DEC"
PRINT #1, "#include <P" + ChipName$ + ".inc>"
IF ConfWords% < 2 THEN PRINT #1, " __CONFIG " + CONFIG$
IF ConfWords% > 1 THEN PRINT #1, " __CONFIG _CONFIG1, " + CONFIG$
PRINT #1, ""
IF VLC% > 0 THEN
 PRINT #1, Star80$
 PRINT #1, ""
 PRINT #1, ";Set aside memory locations for variables"
 FOR PD% = 1 TO VLC%
  VL% = VarLoc(PD%)
  'PRINT #1, VARLIST$(PD%) + " equ " + MID$(STR$(VL%), 2)
  T$ = VARLIST$(PD%) + " equ " + MID$(STR$(VL%), 2)
  PRINT #1, AsmTidy$(T$)
 NEXT PD%
 PRINT #1, ""
END IF
PRINT #1, Star80$
PRINT #1, ""
PRINT #1, ";Jump to initialisation code when PIC is reset"
PRINT #1, AsmTidy$(" ORG 0")
PRINT #1, AsmTidy$(" call INITSYS")
PRINT #1, AsmTidy$(" goto SystemInitialise")
PRINT #1, ""
PRINT #1, Star80$
PRINT #1, ""

'Check if interrupts are supported
T$ = "INTCON"
IntSupport% = 0
FOR PD% = 1 TO SVC%
 IF UCASE$(SysVars$(PD%, 1)) = UCASE$(T$) THEN IntSupport% = 1: EXIT FOR
NEXT PD%

IF IntSupport% = 0 THEN Int$ = ""
IF IntSupport% = 1 THEN
 PRINT #1, ";Interrupt routine"
 PRINT #1, AsmTidy$(" ORG 4")
 PRINT #1, "INTERRUPT"
 PRINT #1, ";Interrupt code will be inserted here in a later version"
 PRINT #1, AsmTidy$(" retfie")
 PRINT #1, ""
 PRINT #1, Star80$
 PRINT #1, ""
END IF

PRINT #1, ";Various initialisation routines, automatically called by GCBASIC"
PRINT #1, "SystemInitialise"
FOR PD% = 1 TO ICC%
 T$ = INCLUDE$(PD%, 2)
 T$ = LTRIM$(RTRIM$(T$))
 IF INSTR(T$, ";") = 0 AND T$ <> "" THEN PRINT #1, CHR$(9) + "call" + CHR$(9) + T$
NEXT PD%
PRINT #1, ""
IF Int$ <> "" THEN
 PRINT #1, ";Initialise interrupt"
 PRINT #1, AsmTidy$(" clrf INTCON")
 PRINT #1, AsmTidy$(" clrf TMR0")
 PRINT #1, AsmTidy$(" banksel OPTION_REG")
 PRINT #1, AsmTidy$(" bcf OPTION_REG, T0CS")
 PRINT #1, AsmTidy$(" bcf OPTION_REG, PSA")

 'Set prescaler here

 PRINT #1, AsmTidy$(" banksel INTCON")
 PRINT #1, AsmTidy$(" bsf INTCON, T0IE")
 PRINT #1, AsmTidy$(" bsf INTCON, GIE")
 PRINT #1, ""
END IF
PRINT #1, Star80$
PRINT #1, ""
PRINT #1, ";Start of the main program"
FOR PD% = 1 TO APC%
 PRINT #1, AsmTidy$(PROG$(PD%))
NEXT PD%
PRINT #1, ""
PRINT #1, " END"
CLOSE #1

PRINT
IF ERC% = 0 THEN
 PRINT Message$("Success");
 IF VBS% = 0 THEN PRINT
 IF VBS% = 1 THEN
  PRINT Message$("CompTime") + MID$(STR$(TIMER - StartTime!), 2) + Message$("CompSecs")
  PRINT
  PRINT Message$("Summary")
  PRINT SPC(5); Message$("DataRead")
  PRINT SPC(10); Message$("InLines") + STR$(SDC% + MainProgramSize%) + " (3000 max)"
  PRINT SPC(10); Message$("Vars") + STR$(VLC%) + " (300 max)"
  PRINT SPC(10); Message$("Consts") + STR$(DFC%) + " (200 max)"
  PRINT SPC(10); Message$("Subs") + STR$(SBC%) + " (200 max)"
  PRINT SPC(5); Message$("AssemblyWritten") + STR$(APC%) + " (4000 max)"
 END IF
END IF

IF ProgWillFail% = 1 THEN COLOR 14, 4
'T$ = " has": IF ERC% > 1 THEN T$ = "s have"
'IF ProgWillFail% = 0 THEN T$ = "Error" + T$
'IF ProgWillFail% = 1 THEN T$ = "Serious error" + T$
IF ProgWillFail% = 0 AND ERC% = 1 THEN T$ = Message$("Error")
IF ProgWillFail% = 0 AND ERC% > 1 THEN T$ = Message$("Errors")
IF ProgWillFail% = 1 AND ERC% = 1 THEN T$ = Message$("BadError")
IF ProgWillFail% = 1 AND ERC% > 1 THEN T$ = Message$("BadErrors")

IF ERC% > 0 THEN
 PRINT T$
 PRINT
 FOR PD% = 1 TO ERC%
  DS$ = "-" + ERROR$(PD%)
ShowError:
  IF LEN(DS$) <= 77 THEN PRINT SPC(2); DS$
  IF LEN(DS$) > 77 THEN
   FOR T% = 77 TO 1 STEP -1
    T$ = MID$(DS$, T%, 1)
    IF T$ = " " THEN
     PRINT SPC(2); LEFT$(DS$, T%)
     DS$ = MID$(DS$, T%)
     GOTO ShowError
    END IF
   NEXT T%
  END IF

 NEXT PD%
 PRINT
 PRINT Message$("ErrorLogged") + ID$ + "\ERRORS.TXT."
 OPEN ID$ + "\ERRORS.TXT" FOR OUTPUT AS #1
 PRINT #1, "GCBASIC error log for " + FI$ + " and included files."
 PRINT #1, "GCBASIC version: " + Version$
 PRINT #1, ""
 FOR PD% = 1 TO ERC%
  PRINT #1, ERROR$(PD%)
 NEXT PD%
 CLOSE
 PRINT
 PRINT Message$("AnyKey")
 DO WHILE INKEY$ = "": LOOP

END IF

COLOR 7, 0

IF MakeASM$ <> "" AND ERC% = 0 THEN
 PRINT
 PRINT Message$("MakeASM")
 IF VBS% = 1 THEN PRINT SPC(5); Message$("Calling") + MakeASM$
 SHELL MakeASM$
END IF

REM $STATIC
SUB AddBankCommands

PD% = 0
Bank% = 0
DetectBank:
PD% = PD% + 1
 T$ = PROG$(PD%)

 IF VBS% = 1 THEN
  LOCATE , 60: PRINT MID$(STR$(INT(PD% / APC% * 100)), 2); "%";
 END IF

 IF T$ = " return" AND Bank% <> 0 THEN
  AddLine " banksel STATUS", PD%
  PD% = PD% + 1
  Bank% = 0
  GOTO NextBankSet
 END IF

 IF LEFT$(T$, 6) = " call " AND Bank% <> 0 THEN
  AddLine " banksel STATUS", PD%
  PD% = PD% + 1
  Bank% = 0
  GOTO NextBankSet
 END IF

 FOR CD% = 1 TO SVC%
  IF WholeINSTR(T$, SysVars$(CD%, 1)) = 2 THEN
   NewBank% = VAL("&h" + SysVars$(CD%, 2)) AND 384
   IF NewBank% <> Bank% THEN
    AddLine " banksel " + SysVars$(CD%, 1), PD%
    PD% = PD% + 1
    Bank% = NewBank%
    GOTO NextBankSet
   END IF
  END IF
 NEXT CD%

 FOR CD% = 1 TO VLC%
  IF WholeINSTR(T$, VARLIST$(CD%)) = 2 THEN
   NewBank% = VarLoc(CD%) AND 384
   IF NewBank% <> Bank% THEN
    AddLine " banksel " + VARLIST$(CD%), PD%
    PD% = PD% + 1
    Bank% = NewBank%
    GOTO NextBankSet
   END IF
  END IF
 NEXT CD%

NextBankSet:

IF PD% < APC% THEN GOTO DetectBank

END SUB

SUB AddLine (DS$, T%)
FOR PD% = APC% TO T% STEP -1
 PROG$(PD% + 1) = PROG$(PD%)
NEXT PD%
APC% = APC% + 1
PROG$(T%) = DS$
END SUB

SUB AddSubLine (DS$, T%)

'Add line to list
FOR PD% = SDC% TO T% STEP -1
 SUBCODE$(PD% + 1) = SUBCODE$(PD%)
NEXT PD%
SDC% = SDC% + 1
SUBCODE$(T%) = DS$

T2% = T% - 1

'Adjust index
FOR PD% = 1 TO SBC%
 IF VAL(SUBDATA$(PD%, 2)) > T% THEN SUBDATA$(PD%, 2) = MID$(STR$(VAL(SUBDATA$(PD%, 2)) + 1), 2)
 IF VAL(SUBDATA$(PD%, 3)) >= T2% THEN SUBDATA$(PD%, 3) = MID$(STR$(VAL(SUBDATA$(PD%, 3)) + 1), 2)
NEXT PD%

END SUB

FUNCTION AsmTidy$ (DS$)

T$ = DS$

IF LEFT$(T$, 1) = ";" THEN AsmTidy$ = T$: EXIT FUNCTION

IF LEFT$(T$, 13) = " movwf TRISIO" THEN
 
 S$ = "TRISIO"
 TRISSupport% = 0
 FOR PD% = 1 TO SVC%
  IF UCASE$(SysVars$(PD%, 1)) = UCASE$(S$) THEN TRISSupport% = 1: EXIT FOR
 NEXT PD%
 
 IF TRISSupport% = 0 THEN
  T$ = " tris GPIO"
 END IF

END IF

Replace T$, " ", CHR$(9)
Replace T$, " ", CHR$(9)

AsmTidy$ = T$

END FUNCTION

SUB CompileIF

'Compile IF Commands
COMPILEIFS:
T% = 0
IL% = 0
CD% = 0
REPIF:
 CD% = CD% + 1
 IF UCASE$(LEFT$(PROG$(CD%), 3)) = "IF " THEN
  IL% = IL% + 1
  IF IL% = 1 THEN
   ILC% = ILC% + 1
   DS$ = PROG$(CD%)
   C$ = MID$(DS$, 4)
   C$ = LEFT$(C$, INSTR(UCASE$(C$), "THEN") - 1)
   CompileConditions C$, "FALSE"
   COSC% = COSC% + 1: CheckTemp$(COSC%) = " goto ENDIF" + MID$(STR$(ILC%), 2)
   PROG$(CD%) = CheckTemp$(1)
   FOR WD% = 2 TO COSC%
    AddLine CheckTemp$(WD%), CD% + WD% - 1
   NEXT WD%
   CD% = CD% + COSC% - 1
   T% = 1
  END IF
 END IF

 IF LEFT$(PROG$(CD%), 6) = "END IF" THEN
  IL% = IL% - 1
  IF IL% = 0 THEN PROG$(CD%) = "ENDIF" + MID$(STR$(ILC%), 2)
 END IF
IF CD% < APC% THEN GOTO REPIF
IF T% = 1 THEN GOTO COMPILEIFS

FoundCount% = ILC%

END SUB

SUB CompileReadTable
 FoundCount% = 0

 PD% = 0
CompileTables:
 PD% = PD% + 1
 DS$ = PROG$(PD%)
 IF LEFT$(DS$, 10) = "READTABLE " THEN

  'Get table name
  DS$ = LTRIM$(MID$(DS$, 11))
  TN$ = LTRIM$(RTRIM$(LEFT$(DS$, INSTR(DS$, ",") - 1)))
  DS$ = MID$(DS$, INSTR(DS$, ",") + 1)

  'Get table location
  TL$ = LTRIM$(RTRIM$(LEFT$(DS$, INSTR(DS$, ",") - 1)))
  DS$ = MID$(DS$, INSTR(DS$, ",") + 1)
  
  'Get output variable
  OV$ = LTRIM$(RTRIM$(DS$))

  'Write assembly
  'Pseudo code:
  ' movf/movlw TL$
  ' call TN$
  ' movwf OV$

  PROG$(PD%) = ""
  IF IsCalc(TL$) THEN PROG$(PD%) = "DataPointer=" + TL$
  IF IsConst(TL$) THEN PROG$(PD%) = " movlw " + TL$
  IF PROG$(PD%) = "" THEN
   PROG$(PD%) = " movwf " + TL$ + ", W"
   VLC% = VLC% + 1: VARLIST$(VLC%) = TL$
  END IF
  AddLine " call " + TN$, PD% + 1
  AddLine " movwf " + OV$, PD% + 2
  PD% = PD% + 1
  
 END IF

IF PD% < APC% THEN GOTO CompileTables
  

END SUB

SUB CompileVars
CD% = 0
FoundCount% = 0
CompVars:
 CD% = CD% + 1
 DS$ = PROG$(CD%)
 IF INSTR(DS$, "=") <> 0 THEN

  'Check if command involves moving a string into an array
  IF INSTR(DS$, "()") <> 0 AND INSTR(DS$, "%STRING") <> 0 THEN
   'Get string to copy
   StringToCopy$ = LTRIM$(RTRIM$(MID$(DS$, INSTR(DS$, "=") + 1)))
   StringToCopy% = VAL(MID$(StringToCopy$, 8))
   StringToCopy$ = StringStore$(StringToCopy%)
   
   'Find array address
   ArrayName$ = RTRIM$(LEFT$(DS$, INSTR(DS$, "(") - 1))
   AF% = 0
   FOR FA% = 1 TO ARC%
    IF ArrayName$ = ArrayData$(FA%, 1) THEN AF% = FA%: EXIT FOR
   NEXT FA%
   'If the array has not been declared, show error and compile next line
   IF AF% = 0 THEN
    ERC% = ERC% + 1
    ERROR$(ERC%) = "Array " + ArrayName$ + " has not been declared. Please use DIM to declare the size of this array before using it!"
    ProgWillFail% = 1
   END IF

   'Find array type
   IF ArrayData$(AF%, 4) = "DIM" THEN
    T% = VAL(ArrayData$(AF%, 2))
    T% = T% AND 255
    ArrayHandler$ = MID$(STR$(T%), 2)
    ArrayType% = 0
   END IF
   IF ArrayData$(AF%, 4) = "SUB" THEN
    ArrayHandler$ = "Sys" + N$ + "Handler"
    VLC% = VLC% + 1
    VARLIST$(VLC%) = ArrayHandler$
    ArrayType% = 1
   END IF

   'Add code to set FSR to correct starting location
   PROG$(CD%) = "FSR = " + ArrayHandler$

   IF ArrayType% = 0 THEN
    IF VAL(ArrayData$(AF%, 2)) < 256 THEN T$ = " bcf STATUS, IRP"
    IF VAL(ArrayData$(AF%, 2)) > 255 THEN T$ = " bsf STATUS, IRP"
    AddLine T$, CD%
   END IF
   IF ArrayType% = 1 THEN
    AddLine " bcf STATUS, IRP", CD%
    AddLine " btfsc " + ArrayHandler$ + "_H,0", CD% + 1
    AddLine " bsf STATUS, IRP", CD% + 2
    CD% = CD% + 2
   END IF
   
   'Add calls to lookup table
   'ASM code to produce:
   '    clrf StringPointer
   'Label
   '    Call StringLookupN
   '    movwf INDF
   '    incf StringPointer, F
   '    incf FSR, F
   '    movf StringPointer, W
   '    sublw [StringLength + 1]
   '    btfss STATUS, Z
   '    goto Label

   SASC% = SASC% + 1
   AddLine " clrf StringPointer", CD% + 2
   AddLine "SysReadString" + MID$(STR$(SASC%), 2), CD% + 3
   AddLine " call StringLookup" + MID$(STR$(StringToCopy%), 2), CD% + 4
   AddLine " movwf INDF", CD% + 5
   AddLine " incf StringPointer, F", CD% + 6
   AddLine " incf FSR, F", CD% + 7
   AddLine " movf StringPointer, W", CD% + 8
   AddLine " sublw" + STR$(LEN(StringToCopy$) + 1), CD% + 9
   AddLine " btfss STATUS, Z", CD% + 10
   AddLine " goto SysReadString" + MID$(STR$(SASC%), 2), CD% + 11
   
   GOTO CompNextVar
  END IF

  'Remove ALL spaces
  DO WHILE INSTR(DS$, " ") <> 0: Replace DS$, " ", "": LOOP
  
  'Check if command is simple setting to a constant
  T$ = MID$(DS$, INSTR(DS$, "=") + 1)
  IF IsConst(T$) THEN
   T% = 1: IF T$ = "0" THEN T% = 0
   V$ = LEFT$(DS$, INSTR(DS$, "=") - 1)
   VarFound% = 0
   FOR CheckDup% = 1 TO VLC%
    IF UCASE$(VARLIST$(CheckDup%)) = UCASE$(V$) THEN VarFound% = 1: EXIT FOR
   NEXT CheckDup%
   IF VarFound% = 0 THEN
    VLC% = VLC% + 1
    VARLIST$(VLC%) = V$
    VT$ = "BYTE"
   END IF
   IF VarFound% <> 0 THEN VT$ = TypeOfVar$(V$)
   
   IF VT$ = "BYTE" THEN
    FoundCount% = FoundCount% + 1
    IF T% = 0 THEN PROG$(CD%) = " clrf " + V$
    IF T% <> 0 THEN
     PROG$(CD%) = " movlw " + T$
     AddLine " movwf " + V$, CD% + 1
     CD% = CD% + 1
    END IF
   END IF

   IF VT$ = "WORD" THEN
    HB% = VAL(GetByte$(T$, 1))
    LB% = VAL(GetByte$(T$, 0))
    IF HB% = 0 THEN PROG$(CD%) = " clrf " + V$ + "_H"
    IF HB% <> 0 THEN
     PROG$(CD%) = " movlw" + STR$(HB%)
     AddLine " movwf " + V$ + "_H", CD% + 1
     CD% = CD% + 1
    END IF
    IF LB% = 0 THEN AddLine " clrf " + V$, CD% + 1
    IF LB% <> 0 THEN
     AddLine " movlw" + STR$(LB%), CD% + 1
     AddLine " movwf " + V$, CD% + 2
     CD% = CD% + 1
    END IF
    CD% = CD% + 1
   END IF
   GOTO CompNextVar
  END IF

  'Check if command is increment or decrement
  T$ = MID$(DS$, INSTR(DS$, "=") + 1)
  V$ = LEFT$(DS$, INSTR(DS$, "=") - 1)
  VT$ = TypeOfVar$(V$)
  IF VT$ = "BYTE" THEN
   IF V$ + "+1" = T$ OR V$ + "-1" = T$ THEN
    T% = 1: IF INSTR(T$, "-1") <> 0 THEN T% = 0
    VLC% = VLC% + 1: VARLIST$(VLC%) = V$
    FoundCount% = FoundCount% + 1
    IF T% = 0 THEN PROG$(CD%) = " decf " + V$ + ",F"
    IF T% = 1 THEN PROG$(CD%) = " incf " + V$ + ",F"
    GOTO CompNextVar
   END IF
  END IF

  'Prepare for calculation
  FOR T% = 1 TO 100
   TempData$(T%) = ""
  NEXT T%
  V$ = LEFT$(DS$, INSTR(DS$, "=") - 1)
  VarFound% = 0
  FOR CheckDup% = 1 TO VLC%
   IF UCASE$(VARLIST$(CheckDup%)) = UCASE$(V$) THEN VarFound% = 1: EXIT FOR
  NEXT CheckDup%
  IF VarFound% = 0 THEN
   VLC% = VLC% + 1
   VARLIST$(VLC%) = V$
   VT$ = "BYTE"
  END IF
  IF VarFound% <> 0 THEN VT$ = TypeOfVar$(V$)
  IF VLC% > 325 THEN SortVarList

  S$ = MID$(DS$, INSTR(DS$, "=") + 1)
  CSC% = 0: CV% = 0
  
  'Decide what output to request from CompileCalc
  ThisCalc% = 0 'Byte output
  WordForced% = 0
  IF VT$ = "WORD" THEN ThisCalc% = 1 'Word output
  IF INSTR(S$, "[WORD]") <> 0 THEN
   ThisCalc% = 1
   Replace S$, "[WORD]", ""
   WordForced% = 1
  END IF

  SO$ = S$
  CompileCalc S$
  
  'Finish Calculation
  IF CSC% <> 0 THEN
   IF ThisCalc% = 0 THEN TempData$(CSC%) = " movwf " + V$
   DNR% = WholeINSTR(SO$, V$)
   'IF WordForced% = 1 THEN DNR% = 2
   IF ThisCalc% = 1 AND DNR% <> 2 THEN
    FOR RN% = 1 TO CSC%
     IF WholeINSTR(TempData$(RN%), S$) = 2 THEN Replace TempData$(RN%), S$, V$
     IF WholeINSTR(TempData$(RN%), S$ + "_H") = 2 THEN
      IF WordForced% = 0 THEN Replace TempData$(RN%), S$, V$
      IF WordForced% = 1 THEN
       TempData$(RN%) = ""
       IF LEFT$(TempData$(RN% - 1), 6) = " movf " AND RIGHT$(TempData$(RN% - 1), 1) = "W" THEN TempData$(RN% - 1) = ""
      END IF
     END IF
    NEXT RN%

    T% = 0
    DV% = 0
DelDupCompVars:
     DV% = DV% + 1
     T$ = VARLIST$(DV%)
     IF T$ = S$ OR T$ = S$ + "_H" THEN
      T% = T% + 1
      VARLIST$(DV%) = VARLIST$(VLC%)
      VarType$(DV%) = VarType$(VLC%)
      VLC% = VLC% - 1
      DV% = DV% - 1
      IF T% = 2 THEN GOTO VarsTidied
     END IF
    IF DV% < VLC% THEN GOTO DelDupCompVars

VarsTidied:
   END IF

   IF ThisCalc% = 1 AND DNR% = 2 THEN
    CSC% = CSC% + 1: TempData$(CSC%) = " movf " + S$ + ",W"
    CSC% = CSC% + 1: TempData$(CSC%) = " movwf " + V$
    IF WordForced% = 0 THEN
     CSC% = CSC% + 1: TempData$(CSC%) = " movf " + S$ + "_H,W"
     CSC% = CSC% + 1: TempData$(CSC%) = " movwf " + V$ + "_H"
    END IF
   END IF
  END IF
  
  IF CSC% = 0 THEN
   CSC% = CSC% + 1
   IF NOT IsConst(S$) THEN
    TempData$(CSC%) = " movf " + S$ + ",W"
    CSC% = CSC% + 1
    VLC% = VLC% + 1: VARLIST$(VLC%) = S$
   END IF
   IF IsConst(S$) THEN
    TempData$(CSC%) = " movlw " + MID$(STR$(VAL(S$) AND 255), 2)
    CSC% = CSC% + 1
   END IF
   TempData$(CSC%) = " movwf " + V$

   IF ThisCalc% = 1 THEN
    CSC% = CSC% + 1

    IF NOT IsConst(S$) THEN
     DT$ = TypeOfVar$(S$)
     IF DT$ = "WORD" THEN
      TempData$(CSC%) = " movf " + S$ + "_H,W"
      CSC% = CSC% + 1
      VLC% = VLC% + 1: VARLIST$(VLC%) = S$
      TempData$(CSC%) = " movwf " + V$ + "_H"
     END IF
     IF DT$ <> "WORD" THEN
      TempData$(CSC%) = " clrw"
      CSC% = CSC% + 1
      TempData$(CSC%) = " movwf " + V$ + "_H"
     END IF
    END IF
    
    IF IsConst(S$) THEN
     TempData$(CSC%) = " movlw " + MID$(STR$((VAL(S$) AND 65280) / 256), 2)
     CSC% = CSC% + 1
     TempData$(CSC%) = " movwf " + V$ + "_H"
    END IF
    
   END IF
  END IF

  T$ = TempData$(CSC% - 1)
  IF INSTR(T$, V$) <> 0 AND INSTR(T$, "wf") <> 0 THEN
   TempData$(CSC%) = ""
   CSC% = CSC% - 1
   Replace TempData$(CSC%), ",W", ",F"
  END IF
  
  'Write the assembly code
  PROG$(CD%) = TempData$(1)
  LC% = 0
  FOR PD% = 2 TO CSC%
   IF TempData$(PD%) <> "" THEN
    LC% = LC% + 1
    AddLine TempData$(PD%), CD% + LC% 'PD% - 1
   END IF
  NEXT PD%
  FoundCount% = FoundCount% + 1
 END IF

CompNextVar:
IF CD% < APC% THEN GOTO CompVars

END SUB

SUB DelLine (T%)
 FOR PD% = T% TO APC% - 1
  PROG$(PD%) = PROG$(PD% + 1)
 NEXT PD%
 PROG$(APC%) = ""
 APC% = APC% - 1
END SUB

SUB DelSubLine (T%)

'Delete line from list
SDC% = SDC% - 1
FOR PD% = T% TO SDC%
 SUBCODE$(PD%) = SUBCODE$(PD% + 1)
NEXT PD%
SUBCODE$(SDC% + 1) = ""

'Adjust index
FOR PD% = 1 TO SBC%
 IF VAL(SUBDATA$(PD%, 2)) > T% THEN SUBDATA$(PD%, 2) = MID$(STR$(VAL(SUBDATA$(PD%, 2)) - 1), 2)
 IF VAL(SUBDATA$(PD%, 3)) >= T% THEN SUBDATA$(PD%, 3) = MID$(STR$(VAL(SUBDATA$(PD%, 3)) - 1), 2)
NEXT PD%

END SUB

SUB DelSysVars

DSV% = 0
DelSysVarsStart:
DSV% = DSV% + 1
 T$ = VARLIST$(DSV%)
 FOR PD% = 1 TO SVC%
  IF T$ = SysVars$(PD%, 1) THEN
   VLC% = VLC% - 1
   FOR DD% = DSV% TO VLC%
    VARLIST$(DD%) = VARLIST$(DD% + 1)
   NEXT DD%
   DSV% = DSV% - 1
  END IF
 NEXT PD%
IF DSV% < VLC% THEN GOTO DelSysVarsStart

END SUB

SUB FindArrays

'Determine whether or not a temporary array is required
TempArrayNeeded% = 0
FOR PD% = 1 TO APC%
 DS$ = PROG$(PD%)
 IF INSTR(DS$, "%STRING") <> 0 AND INSTR(DS$, "=") = 0 THEN TempArrayNeeded% = 1
NEXT PD%

IF TempArrayNeeded% = 1 THEN AddLine "DIM SYSTEMPARRAY(20)", 1

'Search through program to find arrays
PD% = 0
FindArrayStart:
PD% = PD% + 1
 IF LEFT$(PROG$(PD%), 4) = "DIM " AND INSTR(PROG$(PD%), " AS ") = 0 THEN
  'Read array name and size
  N$ = MID$(PROG$(PD%), 5)
  S% = VAL(MID$(N$, INSTR(N$, "(") + 1))
  N$ = LEFT$(N$, INSTR(N$, "(") - 1)
  DelLine PD%
  PD% = PD% - 1

  'Add to list
  T% = 0
  FOR CD% = 1 TO ARC%
   IF N$ = ArrayData$(CD%, 1) THEN
    IF VAL(V$) <= VAL(ArrayData$(CD%, 3)) THEN T% = 1: EXIT FOR
    IF VAL(V$) > VAL(ArrayData$(CD%, 3)) THEN T% = 2: EXIT FOR
   END IF
  NEXT CD%
  IF T% = 0 THEN
   ARC% = ARC% + 1
   ArrayData$(ARC%, 1) = N$
   ArrayData$(ARC%, 3) = MID$(STR$(S%), 2)
   ArrayData$(ARC%, 4) = "DIM"
  END IF
  IF T% = 2 THEN
   ArrayData$(CD%, 3) = MID$(STR$(S%), 2)
  END IF
 END IF

IF PD% < APC% THEN GOTO FindArrayStart

'Sort arrays in order of size
SortArrays:
T% = 0
FOR PD% = 1 TO ARC% - 1
 IF VAL(ArrayData$(PD%, 3)) < VAL(ArrayData$(PD% + 1, 3)) THEN
  T$ = ArrayData$(PD%, 3)
  ArrayData$(PD%, 3) = ArrayData$(PD% + 1, 3)
  ArrayData$(PD% + 1, 3) = T$
  T$ = ArrayData$(PD%, 1)
  ArrayData$(PD%, 1) = ArrayData$(PD% + 1, 1)
  ArrayData$(PD% + 1, 1) = T$
  T$ = ArrayData$(PD%, 4)
  ArrayData$(PD%, 4) = ArrayData$(PD% + 1, 4)
  ArrayData$(PD% + 1, 4) = T$
  T% = 1
 END IF
NEXT PD%
IF T% = 1 THEN GOTO SortArrays

'Allocate RAM to arrays
FOR PD% = 1 TO ARC%

 IF ArrayData$(PD%, 4) <> "DIM" THEN GOTO NextArray

 FL% = 0
 ArraySize% = VAL(ArrayData$(PD%, 3))

 FOR SR% = FreeRAM% - ArraySize% TO 1 STEP -1

  IF VarLoc(SR% + ArraySize%) - VarLoc(SR%) = ArraySize% THEN
   FL% = 1
   ArrayData$(PD%, 2) = MID$(STR$(VarLoc(SR%)), 2)
   FreeRAM% = FreeRAM% - ArraySize%
   FOR CD% = SR% TO FreeRAM%
    VarLoc(CD%) = VarLoc(CD% + ArraySize%)
   NEXT CD%
   GOTO NextArray
  END IF
 NEXT SR%

 IF FL% = 0 THEN
  ERC% = ERC% + 1
  T$ = Message$("ArrayTooBig")
  Replace T$, "%array%", ArrayData$(PD%, 1)
  ERROR$(ERC%) = T$
 END IF

NextArray:
NEXT PD%

END SUB

SUB FindCalcSubs (DS$)
 
 DataPass% = 0

 'FOR
 'Uses LessThan, MoreThan
 IF LEFT$(DS$, 4) = "FOR " AND IsWord(DS$) THEN
  ST% = 1
  IF INSTR(DS$, " STEP ") <> 0 THEN ST% = VAL(MID$(DS$, INSTR(DS$, " STEP ") + 5))
  IF ST% > 0 THEN T$ = "SysCompLessThan"
  IF ST% < 0 THEN T$ = "SysCompMoreThan"
  IF IsWord(DS$) THEN T$ = T$ + "16"
  DataPass% = DataPass% + 1
  TempData$(DataPass%) = T$
 END IF
 
 'Multiply
 IF INSTR(DS$, "*") <> 0 THEN
  T$ = "SYSMULTSUB"
  IF IsWord(DS$) THEN T$ = T$ + "16"
  DataPass% = DataPass% + 1
  TempData$(DataPass%) = T$
 END IF

 'Divide
 IF INSTR(DS$, "/") <> 0 THEN
  T$ = "SYSDIVSUB"
  IF IsWord(DS$) THEN T$ = T$ + "16"
  DataPass% = DataPass% + 1
  TempData$(DataPass%) = T$
 END IF

 'Condition checking
 T$ = DS$
 'If a var is being set, remove the first "=" sign
 IF MID$(T$, INSTR(T$, " ") + 1, 1) = "=" THEN Replace T$, "=", ""
 
 IF (CountOccur(T$, "';=~<>{}") > 0 AND CountOccur(T$, "';=~<>{}+-*/&|#!") >= 2) OR IsWord(T$) THEN
  ST$ = "": IF IsWord(T$) THEN ST$ = "16"
  IF INSTR(T$, "=") <> 0 THEN
   DataPass% = DataPass% + 1
   TempData$(DataPass%) = "SysCompEqual" + ST$
  END IF
  IF INSTR(T$, "~") <> 0 THEN
   DataPass% = DataPass% + 1
   TempData$(DataPass%) = "SysCompNotEqual" + ST$
  END IF
  IF INSTR(T$, "<") <> 0 THEN
   DataPass% = DataPass% + 1
   TempData$(DataPass%) = "SysCompLessThan" + ST$
  END IF
  IF INSTR(T$, ">") <> 0 THEN
   DataPass% = DataPass% + 1
   TempData$(DataPass%) = "SysCompMoreThan" + ST$
  END IF
  IF INSTR(T$, "{") <> 0 THEN
   DataPass% = DataPass% + 1
   TempData$(DataPass%) = "SysCompLessOrEqual" + ST$
  END IF
  IF INSTR(T$, "}") <> 0 THEN
   DataPass% = DataPass% + 1
   TempData$(DataPass%) = "SysCompMoreOrEqual" + ST$
  END IF
 END IF

END SUB

SUB FindFreeRAM

SVC% = 0

IF VBS% = 1 THEN PRINT SPC(10); Message$("ChipHeader")

'Try using MPASM definitions from GCBASIC directory
AF$ = ID$ + "\MPASM\P" + ChipName$ + ".inc"
IF VBS% = 1 THEN PRINT SPC(15); AF$;

'If there are no MPASM header files in the GCBASIC directory, try the default directory
IF DIR$(AF$) = "" THEN
 AF$ = "C:\progra~1\microc~1\MPASMS~1\P" + ChipName$ + ".inc"
 IF VBS% = 1 THEN
  PRINT " - "; Message$("NotFound")
  PRINT SPC(15); AF$
  IF MakeASM% = 1 THEN MakeASM% = 2
 END IF
END IF

'If there are no MPASM header files, try gputils
IF DIR$(AF$) = "" THEN
 AF$ = "C:\progra~1\gputils\header\P" + ChipName$ + ".inc"
 IF VBS% = 1 THEN
  PRINT " - "; Message$("NotFound")
  PRINT SPC(15); AF$
  IF MakeASM% = 1 THEN MakeASM% = 2
 END IF
END IF
IF DIR$(AF$) <> "" THEN PRINT

'If there are no MPASM or gputils header files, then show error and failure
IF DIR$(AF$) = "" THEN
 PRINT " - "; Message$("NotFound")
 ERC% = ERC% + 1
 ERROR$(ERC%) = "Chip definition files could not be found!"
 ProgWillFail% = 1
 EXIT SUB
END IF

'Read .INC file
OPEN AF$ FOR INPUT AS #1

'Get number of config words
SEEK #1, 1
ConfWords% = 1
DO WHILE NOT EOF(1)
 LINE INPUT #1, DS$
 DS$ = UCASE$(LTRIM$(DS$))
 IF LEFT$(DS$, 7) = "_CONFIG" THEN
  DO WHILE INSTR(DS$, CHR$(9)) <> 0: Replace DS$, CHR$(9), " ": LOOP
  DS$ = LEFT$(MID$(DS$, 8), 1)
  IF VAL(DS$) > ConfWords% THEN ConfWords% = VAL(DS$)
 END IF
LOOP

'Find valid CONFIG options
SEEK #1, 1
RC% = 0
COC% = 0
DO WHILE NOT EOF(1)
 LINE INPUT #1, DS$
 IF INSTR(DS$, "Bits") <> 0 THEN RC% = 0
 IF INSTR(DS$, "Configuration Bits") <> 0 THEN RC% = 1

 IF RC% = 1 AND INSTR(DS$, " EQU ") <> 0 THEN
  DO WHILE INSTR(DS$, CHR$(9)) <> 0: Replace DS$, CHR$(9), " ": LOOP
  DS$ = LTRIM$(RTRIM$(DS$))
  DS$ = LEFT$(DS$, INSTR(DS$, " EQU") - 1)
  IF LEFT$(DS$, 1) = "_" THEN DS$ = MID$(DS$, 2)

  COC% = COC% + 1
  ConfigOp$(COC%) = DS$
 END IF
LOOP

'Read the total amount of data memory
SEEK #1, 1
DO WHILE NOT EOF(1)
 LINE INPUT #1, DS$
 DS$ = LTRIM$(RTRIM$(DS$))
 IF LEFT$(DS$, 8) = "__MAXRAM" THEN MR$ = DS$: GOTO MaxRAMFound
LOOP

MaxRAMFound:
MR$ = MID$(DS$, INSTR(MR$, " ") + 1)
Replace MR$, "H'", ""
Replace MR$, "'", ""
MemSize% = VAL("&H" + MR$)

REDIM FreeMem(MemSize%) AS INTEGER

'Find data memory reserved for system variables
SEEK #1, 1
DisableRead% = 1
DO WHILE NOT EOF(1)
 LINE INPUT #1, DS$
 IF INSTR(DS$, "Register Files") <> 0 THEN DisableRead% = 0
 IF INSTR(DS$, "Bits") <> 0 AND INSTR(DS$, "-----") <> 0 THEN DisableRead% = 1
 IF INSTR(UCASE$(DS$), "EQU") <> 0 AND DisableRead% = 0 THEN
  DO WHILE INSTR(DS$, CHR$(9)) <> 0
   Replace DS$, CHR$(9), " "
  LOOP
  T$ = DS$
  L$ = MID$(T$, INSTR(T$, "H'") + 2)
  L$ = LEFT$(L$, LEN(L$) - 1)
  T$ = LEFT$(T$, INSTR(T$, " ") - 1)
  IF INSTR(L$, "'") <> 0 THEN L$ = LEFT$(L$, INSTR(L$, "'") - 1)
  FreeMem(VAL("&H" + L$)) = 1
  SVC% = SVC% + 1
  SysVars$(SVC%, 1) = T$
  SysVars$(SVC%, 2) = L$
 END IF
LOOP

'Read bad RAM locations
SEEK #1, 1
DO WHILE NOT EOF(1)
 LINE INPUT #1, DS$
 DS$ = LTRIM$(RTRIM$(DS$))
 IF LEFT$(DS$, 8) = "__BADRAM" THEN
  DS$ = MID$(DS$, 9)
DecodeBadRAM:
  T% = 0
  T$ = DS$
  IF INSTR(DS$, ",") <> 0 THEN
   T% = 1
   T$ = RTRIM$(LEFT$(DS$, INSTR(DS$, ",") - 1))
   DS$ = LTRIM$(MID$(DS$, INSTR(DS$, ",") + 1))
  END IF

  IF INSTR(T$, "-") = 0 THEN
   Replace T$, "H'", ""
   Replace T$, "'", ""
   T$ = LTRIM$(T$)
   FreeMem(VAL("&H" + T$)) = 1
  END IF

  IF INSTR(T$, "-") <> 0 THEN
   DO WHILE INSTR(T$, " ") <> 0: Replace T$, " ", "": LOOP
   S$ = LEFT$(T$, INSTR(T$, "-") - 1)
   E$ = MID$(T$, INSTR(T$, "-") + 1)
   Replace S$, "H'", "": Replace S$, "'", ""
   Replace E$, "H'", "": Replace E$, "'", ""
   S% = VAL("&H" + S$): E% = VAL("&H" + E$)
   FOR PD% = S% TO E%
    FreeMem(PD%) = 1
   NEXT PD%
  END IF
  IF T% <> 0 THEN GOTO DecodeBadRAM
 END IF
LOOP

'Mark duplicate registers as inaccessible

FOR PD% = 1 TO MemSize%
 IF FreeMem(PD%) = 0 THEN DS% = PD% - 1: EXIT FOR
NEXT PD%

'Start locations of each bank (-1)
Bank0 = 0
Bank1 = VAL("&H80")
Bank2 = VAL("&H100")
Bank3 = VAL("&H180")

FOR PD% = 1 TO MemSize%
 IF (PD% >= Bank0 AND PD% <= Bank0 + DS%) THEN FreeMem(PD%) = 1
 IF (PD% >= Bank1 AND PD% <= Bank1 + DS%) THEN FreeMem(PD%) = 1
 IF (PD% >= Bank2 AND PD% <= Bank2 + DS%) THEN FreeMem(PD%) = 1
 IF (PD% >= Bank3 AND PD% <= Bank3 + DS%) THEN FreeMem(PD%) = 1
NEXT PD%

'Note: For FreeMem(),  0 = Free and 1 = Used

'Mark known duplicate locations as bad
IF LEFT$(ChipName$, 2) = "16" THEN
 FOR PD% = 0 TO 15
  IF MemSize% >= (Bank0 + PD% + 240) THEN FreeMem(Bank0 + PD% + 240) = 1
  IF MemSize% >= (Bank1 + PD% + 240) THEN FreeMem(Bank1 + PD% + 240) = 1
  IF MemSize% >= (Bank2 + PD% + 240) THEN FreeMem(Bank2 + PD% + 240) = 1
  IF MemSize% >= (Bank3 + PD% + 240) THEN FreeMem(Bank3 + PD% + 240) = 1
 NEXT PD%
END IF

CLOSE #1

'Produce list of free memory locations
T% = 0
FOR PD% = 1 TO MemSize%
 IF FreeMem(PD%) = 0 THEN
  T% = T% + 1
  VarLoc(T%) = PD%
  IF T% = ChipRam% THEN EXIT FOR
 END IF
NEXT PD%

FreeRAM% = T%


END SUB

SUB FindLargeVars

'Find large variables defined using DIM AS
PD% = 0
FindDIMs:
 PD% = PD% + 1
 DS$ = PROG$(PD%)

 IF LEFT$(DS$, 4) = "DIM " AND INSTR(DS$, " AS ") <> 0 THEN
  DelLine PD%
  PD% = PD% - 1

  'Get variable name and type
  V$ = LTRIM$(RTRIM$(MID$(DS$, 5)))
  V$ = LTRIM$(RTRIM$(LEFT$(V$, INSTR(V$, " ") - 1)))
  Ty$ = LTRIM$(RTRIM$(MID$(DS$, INSTR(DS$, " AS ") + 4)))

  'Code for strings
  IF LEFT$(Ty$, 6) = "STRING" THEN
   StLen% = 20
   IF INSTR(Ty$, "*") <> 0 THEN
    StLen% = VAL(MID$(Ty$, INSTR(Ty$, "*") + 1))
   END IF
   AddLine "DIM " + V$ + "(" + MID$(STR$(StLen%), 2) + ")", 1
   PD% = PD% + 1
  END IF

  'Search variable list, and show error if duplicate definition occurs
  VarFound% = 0
  FOR SL% = 1 TO VLC%
   IF VARLIST$(SL%) = V$ THEN VarFound% = SL%: EXIT FOR
  NEXT SL%

  IF VarFound% = 0 THEN
   IF Ty$ = "WORD" THEN LongPresent% = 1
   VLC% = VLC% + 1: VARLIST$(VLC%) = V$
   VarType$(VLC%) = Ty$
   VLC% = VLC% + 1: VARLIST$(VLC%) = V$ + "_H"
  END IF
  IF VarFound% <> 0 AND VarType$(VarFound%) <> Ty$ THEN
   ERC% = ERC% + 1
   T$ = Message$("DupDef")
   Replace T$, "%var%", V$
   ERROR$(ERC%) = T$
  END IF

 END IF

NextDIM:
IF PD% < APC% THEN GOTO FindDIMs

'Search in subs, and add to possibly needed list
PD% = 0
SearchSubsLarge:
 PD% = PD% + 1
 DS$ = SUBCODE$(PD%)
 IF LEFT$(DS$, 4) = "DIM " AND INSTR(DS$, " AS ") <> 0 THEN
  FOR FS% = 1 TO SBC%
   IF VAL(SUBDATA$(FS%, 2)) <= PD% AND VAL(SUBDATA$(FS%, 3)) >= PD% THEN EXIT FOR
  NEXT FS%

  S$ = SUBDATA$(FS%, 1)
  IF INSTR(S$, "(") <> 0 THEN S$ = LEFT$(S$, INSTR(S$, "(") - 1)
  IF INSTR(S$, " ") <> 0 THEN S$ = LEFT$(S$, INSTR(S$, " ") - 1)
  S$ = RTRIM$(S$)
  
  LVC% = LVC% + 1
  LargeVars$(LVC%, 1) = DS$
  LargeVars$(LVC%, 2) = S$

  DelSubLine PD%
  PD% = PD% - 1
 END IF
IF PD% < SDC% THEN GOTO SearchSubsLarge

END SUB

SUB FindRequiredSubs

CalcSubs% = 0

'System initialisation sub
SLC% = SLC% + 1
SUBLIST$(SLC%, 1) = "InitSys"
SUBLIST$(SLC%, 2) = STR$(LocationOfSub("InitSys"))

'Find high level subs in main program
FOR PD% = 1 TO APC%
 FindSubs PROG$(PD%)
 IF TempData$(0) = " call " THEN PROG$(PD%) = " call " + PROG$(PD%)
 FOR AdS% = 1 TO DataPass%
  IF SubListLocation(TempData$(AdS%)) = 0 THEN
   SLC% = SLC% + 1
   SUBLIST$(SLC%, 1) = TempData$(AdS%)
   SUBLIST$(SLC%, 2) = STR$(LocationOfSub(TempData$(AdS%)))
  END IF
 NEXT
NEXT

'Find high level subs in subs
OO% = 1
GETSUBCALLS:
SA% = 0
 OO% = O%
 O% = SLC%
 FOR FS% = OO% TO O%
  CS% = VAL(SUBLIST$(FS%, 2))
  S% = VAL(SUBDATA$(CS%, 2)): E% = VAL(SUBDATA$(CS%, 3))
  FOR CD% = S% TO E%

   FindSubs SUBCODE$(CD%)
   IF TempData$(0) = " call " THEN SUBCODE$(CD%) = " call " + SUBCODE$(CD%)
   FOR AdS% = 1 TO DataPass%
    IF SubListLocation(TempData$(AdS%)) = 0 THEN
     SA% = 1
     SLC% = SLC% + 1
     SUBLIST$(SLC%, 1) = TempData$(AdS%)
     SUBLIST$(SLC%, 2) = STR$(LocationOfSub(TempData$(AdS%)))
    END IF
   NEXT

  NEXT CD%
 NEXT FS%

 'Find automatic initialisation routines for subs recently added
 FOR FS% = 1 TO ICC%
  T$ = LTRIM$(RTRIM$(INCLUDE$(FS%, 2)))
  IF INSTR(T$, ";") = 0 AND T$ <> "" AND SubListLocation(T$) = 0 THEN
   SLC% = SLC% + 1
   SUBLIST$(SLC%, 1) = T$
   SUBLIST$(SLC%, 2) = STR$(LocationOfSub(T$))
  END IF
 NEXT FS%
 
IF SA% = 1 THEN GOTO GETSUBCALLS
 
'Complete list of needed large (>byte) variables
'Large vars in main would already have been found
FOR FS% = 1 TO SLC%
 FOR CD% = 1 TO LVC%
  IF LargeVars$(CD%, 2) = SUBLIST$(FS%, 1) THEN
   DS$ = LargeVars$(CD%, 1)
 
   'Get variable name and type
   V$ = LTRIM$(RTRIM$(MID$(DS$, 5)))
   V$ = LTRIM$(RTRIM$(LEFT$(V$, INSTR(V$, " ") - 1)))
   Ty$ = LTRIM$(RTRIM$(MID$(DS$, INSTR(DS$, " AS ") + 4)))
 
   'Search variable list, and show error if duplicate definition occurs
   VarFound% = 0
   FOR SL% = 1 TO VLC%
    IF VARLIST$(SL%) = V$ THEN VarFound% = SL%: EXIT FOR
   NEXT SL%
     
   IF VarFound% = 0 THEN
    IF Ty$ = "WORD" THEN LongPresent% = 1
    VLC% = VLC% + 1: VARLIST$(VLC%) = V$
    VarType$(VLC%) = Ty$
    VLC% = VLC% + 1: VARLIST$(VLC%) = V$ + "_H"
   END IF
   IF VarFound% <> 0 AND VarType$(VarFound%) <> Ty$ THEN
    ERC% = ERC% + 1
    T$ = Message$("DupDef")
    Replace T$, "%var%", V$
    ERROR$(ERC%) = T$
   END IF

  END IF
 NEXT
NEXT

'Find low level subs in main program
FOR PD% = 1 TO APC%
 FindCalcSubs PROG$(PD%)
 FOR AdS% = 1 TO DataPass%
  IF SubListLocation(TempData$(AdS%)) = 0 THEN
   SLC% = SLC% + 1
   SUBLIST$(SLC%, 1) = TempData$(AdS%)
   SUBLIST$(SLC%, 2) = STR$(LocationOfSub(TempData$(AdS%)))
  END IF
 NEXT
NEXT

'Find low level subs in subs
IF CalcSubs% = 0 THEN LO% = 1
OLO% = LO%
LO% = SLC%
T% = 0
FOR FS% = OLO% TO LO%
 CS% = VAL(SUBLIST$(FS%, 2))
 S% = VAL(SUBDATA$(CS%, 2)): E% = VAL(SUBDATA$(CS%, 3))
 FOR CD% = S% TO E%
  FindCalcSubs SUBCODE$(CD%)
  FOR AdS% = 1 TO DataPass%
   IF SubListLocation(TempData$(AdS%)) = 0 THEN
    T% = 1
    SLC% = SLC% + 1
    SUBLIST$(SLC%, 1) = TempData$(AdS%)
    SUBLIST$(SLC%, 2) = STR$(LocationOfSub(TempData$(AdS%)))
   END IF
  NEXT
 NEXT CD%
NEXT FS%

'CalcSubs% = CalcSubs% + 1
'IF CalcSubs% < 3 THEN GOTO GETSUBCALLS
IF T% = 1 THEN GOTO GETSUBCALLS

'Sort list of subs
SORTSUBS:
T% = 0
FOR SC% = 1 TO SLC% - 1
 IF SUBLIST$(SC%, 1) > SUBLIST$(SC% + 1, 1) THEN
  N$ = SUBLIST$(SC% + 1, 1): V$ = SUBLIST$(SC% + 1, 2)
  SUBLIST$(SC% + 1, 1) = SUBLIST$(SC%, 1): SUBLIST$(SC% + 1, 2) = SUBLIST$(SC%, 2)
  SUBLIST$(SC%, 1) = N$: SUBLIST$(SC%, 2) = V$
  T% = 1
 END IF
NEXT SC%
IF T% = 1 THEN GOTO SORTSUBS

'Delete duplicate entries in list
CD% = 0
DELDUP:
 CD% = CD% + 1
 IF SUBLIST$(CD%, 1) = SUBLIST$(CD% + 1, 1) THEN
  FOR DL% = CD% TO SLC%
   SUBLIST$(DL%, 1) = SUBLIST$(DL% + 1, 1)
   SUBLIST$(DL%, 2) = SUBLIST$(DL% + 1, 2)
  NEXT DL%
  SLC% = SLC% - 1
  CD% = CD% - 1
 END IF
IF CD% < SLC% THEN GOTO DELDUP

END SUB

SUB FindSubs (DS$)

 TempData$(0) = ""
 TempData$(1) = ""
 DataPass% = 0

 'Check if startup sub is needed for the line because of a constant
 DO WHILE INSTR(UCASE$(DS$), ";STARTUP") <> 0
  T% = VAL(MID$(DS$, INSTR(UCASE$(DS$), ";STARTUP") + 8))
  T$ = ";STARTUP" + LTRIM$(STR$(T%))
  Replace DS$, T$, ""
  Replace INCLUDE$(T%, 2), ";", ""
 LOOP
 
 IF LEFT$(DS$, 4) = "POT " THEN
  'Add Delay_MS and Delay_10US
  DataPass% = DataPass% + 1: TempData$(DataPass%) = "Delay_MS"
  DataPass% = DataPass% + 1: TempData$(DataPass%) = "Delay_10US"
  EXIT SUB
 END IF

 IF LEFT$(DS$, 5) = "WAIT " OR LEFT$(DS$, 9) = "PULSEOUT " THEN
  V$ = MID$(DS$, 6)
  IF LEFT$(DS$, 9) = "PULSEOUT " THEN V$ = LTRIM$(MID$(DS$, INSTR(DS$, ",") + 1))
  U$ = LCASE$(MID$(V$, INSTR(V$, " ") + 1))
  V$ = LEFT$(V$, INSTR(V$, " ") - 1)
  T% = 0
  IF U$ = "us" OR U$ = "usec" THEN U$ = "Delay_US": T% = 1
  IF U$ = "10us" OR U$ = "10usec" THEN U$ = "Delay_10US": T% = 1
  IF U$ = "ms" OR U$ = "msec" THEN U$ = "Delay_MS": T% = 1
  IF U$ = "10ms" OR U$ = "10msec" THEN U$ = "Delay_10MS": T% = 1
  IF U$ = "s" OR U$ = "sec" THEN U$ = "Delay_S": T% = 1
  IF U$ = "m" OR U$ = "min" THEN U$ = "Delay_M": T% = 1
  IF U$ = "h" OR U$ = "hour" THEN U$ = "Delay_H": T% = 1
  IF T% = 1 THEN DataPass% = DataPass% + 1: TempData$(DataPass%) = U$
  EXIT SUB
 END IF

'Check for sub call
 T$ = LTRIM$(DS$)
 IF INSTR(T$, "(") <> 0 THEN T$ = LEFT$(T$, INSTR(T$, "(") - 1)
 IF INSTR(T$, " ") <> 0 THEN T$ = LEFT$(T$, INSTR(T$, " ") - 1)

 LO% = LocationOfSub(T$)
 IF LO% <> 0 THEN
  DataPass% = DataPass% + 1: TempData$(DataPass%) = T$
  TempData$(0) = " call "
  Replace INCLUDE$(VAL(SUBDATA$(LO%, 4)), 2), ";", ""
 END IF

END SUB

SUB FixFunctions

'Fix functions that are used by DO and WAIT, so they are updated inside
'the loops

FOR PD% = 1 TO APC%
 IF LEFT$(PROG$(PD%), 9) = " call FN_" THEN
  IF LEFT$(PROG$(PD% + 1), 11) = "SysWaitLoop" OR LEFT$(PROG$(PD% + 1), 11) = "SysDoLoop_S" THEN
   T$ = PROG$(PD%)
   PROG$(PD%) = PROG$(PD% + 1)
   PROG$(PD% + 1) = T$
  END IF
 END IF
NEXT PD%

END SUB

FUNCTION LocationOfSub (SubName$)

DS$ = UCASE$(LTRIM$(SubName$))
LocationOfSub = 0

'If a var is being set, don't bother checking to see if the var is a sub
IF MID$(DS$, INSTR(DS$, " ") + 1, 1) = "=" THEN EXIT FUNCTION

'Remove any parameters from the name
IF INSTR(DS$, "(") <> 0 THEN DS$ = LEFT$(DS$, INSTR(DS$, "(") - 1)
IF INSTR(DS$, " ") <> 0 THEN DS$ = LEFT$(DS$, INSTR(DS$, " ") - 1)

'Exit if SubName is a known, common command
'This code is meant to save time, so no point in checking for less common commands
T$ = LEFT$(DS$, 3)
IF T$ = "IF " THEN EXIT FUNCTION
IF T$ = "DO " THEN EXIT FUNCTION
T$ = LEFT$(DS$, 4)
IF T$ = "SET " THEN EXIT FUNCTION
IF T$ = "DIR " THEN EXIT FUNCTION
IF T$ = "FOR " THEN EXIT FUNCTION
IF T$ = "DIM " THEN EXIT FUNCTION
IF T$ = "END " THEN EXIT FUNCTION
T$ = LEFT$(DS$, 5)
IF T$ = "LOOP " THEN EXIT FUNCTION
IF T$ = "NEXT " THEN EXIT FUNCTION
IF T$ = "WAIT " THEN EXIT FUNCTION

'Returns the position of DS$ in SUBDATA$()
FOR T% = 1 TO SBC%
 T$ = UCASE$(LTRIM$(SUBDATA$(T%, 1)))
 IF INSTR(T$, "(") <> 0 THEN T$ = LEFT$(T$, INSTR(T$, "(") - 1)
 IF INSTR(T$, " ") <> 0 THEN T$ = LEFT$(T$, INSTR(T$, " ") - 1)
 IF T$ = DS$ THEN LocationOfSub = T%: EXIT FUNCTION
NEXT T%

END FUNCTION

SUB OptimiseIF
PD% = 0

IFOptimise:
PD% = PD% + 1
 T$ = PROG$(PD%)
 IF LEFT$(T$, 5) = "ENDIF" THEN
  IF PROG$(PD% - 2) = " goto " + T$ THEN
   DS$ = LEFT$(PROG$(PD% - 3), 6)
   IF DS$ = " btfsc" THEN T% = 0
   IF DS$ = " btfss" THEN T% = 1
   IF T% = 0 THEN Replace PROG$(PD% - 3), "btfsc", "btfss"
   IF T% = 1 THEN Replace PROG$(PD% - 3), "btfss", "btfsc"
   DelLine PD%
   DelLine PD% - 2
   PD% = PD% - 2
  END IF
 END IF
IF PD% < APC% THEN GOTO IFOptimise

END SUB

SUB PrepareBuiltIn
'Read built-in subs and constants

'Delay subs
'Time Intervals: us, 10us, ms, 10ms, sec, min, hour

'Delay_US
SBC% = SBC% + 1
SUBDATA$(SBC%, 1) = "Delay_US"
SUBDATA$(SBC%, 2) = MID$(STR$(SDC% + 1), 2)

'Each nop takes .2 us on 20 MHz chip
L% = ChipMhz / 4 - 3
IF L% < 0 THEN L% = 0
SDC% = SDC% + 1: SUBCODE$(SDC%) = "DUS_START"
FOR CD% = 1 TO L%
 SDC% = SDC% + 1: SUBCODE$(SDC%) = " nop"
NEXT CD%
SDC% = SDC% + 1: SUBCODE$(SDC%) = " decfsz SysWaitTempUS, F"
SDC% = SDC% + 1: SUBCODE$(SDC%) = " goto DUS_START"
SUBDATA$(SBC%, 3) = MID$(STR$(SDC%), 2)

'Delay_10US
SBC% = SBC% + 1
SUBDATA$(SBC%, 1) = "Delay_10US"
SUBDATA$(SBC%, 2) = MID$(STR$(SDC% + 1), 2)
L% = 10 * ChipMhz / 12 - .5
IF L% < 1 THEN L% = 1
D$ = MID$(STR$(L%), 2)
SDC% = SDC% + 1: SUBCODE$(SDC%) = "D10US_START"
SDC% = SDC% + 1: SUBCODE$(SDC%) = "DELAYTEMP = " + D$
SDC% = SDC% + 1: SUBCODE$(SDC%) = "D10US_LOOP"
SDC% = SDC% + 1: SUBCODE$(SDC%) = " decfsz DELAYTEMP, F"
SDC% = SDC% + 1: SUBCODE$(SDC%) = " goto D10US_LOOP"
SDC% = SDC% + 1: SUBCODE$(SDC%) = " decfsz SysWaitTemp10US, F"
SDC% = SDC% + 1: SUBCODE$(SDC%) = " goto D10US_START"
SUBDATA$(SBC%, 3) = MID$(STR$(SDC%), 2)

'Delay_MS
'Repeat 20(wait 50)
SBC% = SBC% + 1
SUBDATA$(SBC%, 1) = "Delay_MS"
SUBDATA$(SBC%, 2) = MID$(STR$(SDC% + 1), 2)
IF ChipMhz < 31 THEN
 L% = 100 * ChipMhz / 12 - .5
 IF L% < 1 THEN L% = 1
 IL$ = MID$(STR$(L%), 2)
 OL$ = "10"
END IF
IF ChipMhz > 30 THEN
 L% = 50 * ChipMhz / 12 - .5 - 2
 IF L% < 1 THEN L% = 1
 IL$ = MID$(STR$(L%), 2)
 OL$ = "20"
END IF

SDC% = SDC% + 1: SUBCODE$(SDC%) = "DMS_START"
SDC% = SDC% + 1: SUBCODE$(SDC%) = "DELAYTEMP2 = " + OL$
SDC% = SDC% + 1: SUBCODE$(SDC%) = "DMS_OUTER"
SDC% = SDC% + 1: SUBCODE$(SDC%) = "DELAYTEMP = " + IL$
SDC% = SDC% + 1: SUBCODE$(SDC%) = "DMS_INNER"
SDC% = SDC% + 1: SUBCODE$(SDC%) = " decfsz DELAYTEMP, F"
SDC% = SDC% + 1: SUBCODE$(SDC%) = " goto DMS_INNER"
SDC% = SDC% + 1: SUBCODE$(SDC%) = " decfsz DELAYTEMP2, F"
SDC% = SDC% + 1: SUBCODE$(SDC%) = " goto DMS_OUTER"
SDC% = SDC% + 1: SUBCODE$(SDC%) = " decfsz SysWaitTempMS, F"
SDC% = SDC% + 1: SUBCODE$(SDC%) = " goto DMS_START"
SUBDATA$(SBC%, 3) = MID$(STR$(SDC%), 2)

'Delay_10MS
SBC% = SBC% + 1
SUBDATA$(SBC%, 1) = "Delay_10MS"
SUBDATA$(SBC%, 2) = MID$(STR$(SDC% + 1), 2)
SDC% = SDC% + 1: SUBCODE$(SDC%) = "D10MS_START"
SDC% = SDC% + 1: SUBCODE$(SDC%) = "SysWaitTempMS = 10"
SDC% = SDC% + 1: SUBCODE$(SDC%) = "Delay_MS"
SDC% = SDC% + 1: SUBCODE$(SDC%) = " decfsz SysWaitTemp10MS, F"
SDC% = SDC% + 1: SUBCODE$(SDC%) = " goto D10MS_START"
SUBDATA$(SBC%, 3) = MID$(STR$(SDC%), 2)

'Delay_Sec
SBC% = SBC% + 1
SUBDATA$(SBC%, 1) = "Delay_S"
SUBDATA$(SBC%, 2) = MID$(STR$(SDC% + 1), 2)
SDC% = SDC% + 1: SUBCODE$(SDC%) = "DS_START"
SDC% = SDC% + 1: SUBCODE$(SDC%) = "DELAYTEMP4 = 10"
SDC% = SDC% + 1: SUBCODE$(SDC%) = "DS_OUTER"
SDC% = SDC% + 1: SUBCODE$(SDC%) = "SysWaitTempMS = 100"
SDC% = SDC% + 1: SUBCODE$(SDC%) = "Delay_MS"
SDC% = SDC% + 1: SUBCODE$(SDC%) = " decfsz DELAYTEMP4, F"
SDC% = SDC% + 1: SUBCODE$(SDC%) = " goto DS_OUTER"
SDC% = SDC% + 1: SUBCODE$(SDC%) = " decfsz SysWaitTempS, F"
SDC% = SDC% + 1: SUBCODE$(SDC%) = " goto DS_START"
SUBDATA$(SBC%, 3) = MID$(STR$(SDC%), 2)


'Delay_Min
SBC% = SBC% + 1
SUBDATA$(SBC%, 1) = "Delay_M"
SUBDATA$(SBC%, 2) = MID$(STR$(SDC% + 1), 2)
SDC% = SDC% + 1: SUBCODE$(SDC%) = "DMIN_START"
SDC% = SDC% + 1: SUBCODE$(SDC%) = "SysWaitTempS = 60"
SDC% = SDC% + 1: SUBCODE$(SDC%) = "Delay_S"
SDC% = SDC% + 1: SUBCODE$(SDC%) = " decfsz SysWaitTempM, F"
SDC% = SDC% + 1: SUBCODE$(SDC%) = " goto DMIN_START"
SUBDATA$(SBC%, 3) = MID$(STR$(SDC%), 2)


'Delay_Hour
SBC% = SBC% + 1
SUBDATA$(SBC%, 1) = "Delay_H"
SUBDATA$(SBC%, 2) = MID$(STR$(SDC% + 1), 2)
SDC% = SDC% + 1: SUBCODE$(SDC%) = "DHOUR_START"
SDC% = SDC% + 1: SUBCODE$(SDC%) = "SysWaitTempM = 60"
SDC% = SDC% + 1: SUBCODE$(SDC%) = "Delay_M"
SDC% = SDC% + 1: SUBCODE$(SDC%) = " decfsz SysWaitTempH, F"
SDC% = SDC% + 1: SUBCODE$(SDC%) = " goto DHOUR_START"
SUBDATA$(SBC%, 3) = MID$(STR$(SDC%), 2)

END SUB

SUB PreProcessor

'Find required files
IF VBS% = 1 THEN PRINT : PRINT SPC(5); Message$("FindSource")
ICC% = 1: INCLUDE$(1, 1) = ShortName$(FI$)
T% = 1

FindIncludeFiles:
T2% = T%
ICCO% = ICC%
FOR T% = T2% TO ICC%

 IF VBS% = 1 THEN PRINT SPC(10); INCLUDE$(T%, 1);
 IF DIR$(INCLUDE$(T%, 1)) = "" THEN
  IF VBS% = 0 THEN PRINT Message$("NoFile")
  IF VBS% = 1 THEN PRINT ": " + Message$("NotFound")
 END IF
 IF DIR$(INCLUDE$(T%, 1)) <> "" THEN
  OPEN INCLUDE$(T%, 1) FOR INPUT AS #1
  DO WHILE NOT EOF(1)
   LINE INPUT #1, T$
   T$ = UCASE$(LTRIM$(RTRIM$(T$)))
   IF LEFT$(T$, 8) = "#INCLUDE" THEN
    IF INSTR(T$, CHR$(34)) <> 0 THEN
     T$ = MID$(T$, INSTR(T$, CHR$(34)) + 1)
     T$ = LEFT$(T$, INSTR(T$, CHR$(34)) - 1)
     T$ = ProgDir$ + "\" + T$
    END IF
    IF INSTR(T$, "<") <> 0 THEN
     T$ = MID$(T$, INSTR(T$, "<") + 1)
     T$ = LEFT$(T$, INSTR(T$, ">") - 1)
     T$ = ID$ + "\INCLUDE\" + T$
    END IF
    T$ = ShortName$(T$)
    CE% = 0
    FOR PD% = 1 TO ICC%
     IF UCASE$(INCLUDE$(PD%, 1)) = UCASE$(T$) THEN CE% = 1: EXIT FOR
    NEXT PD%
    IF CE% = 0 THEN ICC% = ICC% + 1: INCLUDE$(ICC%, 1) = T$
   END IF
  LOOP

  CLOSE #1
  IF VBS% = 1 THEN PRINT ": " + Message$("found")
 END IF
NEXT T%
IF ICCO% < ICC% THEN GOTO FindIncludeFiles

'Add standard include files to list
OPEN ID$ + "\include\lowlevel.dat" FOR INPUT AS #1
DO WHILE NOT EOF(1)
 LINE INPUT #1, DS$
 DS$ = LTRIM$(RTRIM$(DS$))
 IF LEFT$(DS$, 1) <> "'" THEN
  DS$ = ShortName$(ID$ + "\INCLUDE\LOWLEVEL\" + DS$)
  CE% = 0
  FOR PD% = 1 TO ICC%
   IF UCASE$(INCLUDE$(PD%, 1)) = UCASE$(DS$) THEN CE% = 1: EXIT FOR
  NEXT PD%
  IF CE% = 0 THEN
   ICC% = ICC% + 1
   INCLUDE$(ICC%, 1) = DS$
   T$ = DIR$(DS$)
   IF T$ <> "" THEN T$ = ": " + Message$("found")
   IF T$ = "" THEN T$ = ": " + Message$("NotFound")
   IF VBS% = 1 THEN PRINT SPC(10); DS$; T$
  END IF
 END IF
LOOP
CLOSE

'Read all required files
IF VBS% = 1 THEN PRINT SPC(5); Message$("LoadSource");
FOR RF% = 1 TO ICC%
 OPEN INCLUDE$(RF%, 1) FOR INPUT AS #1
 DO WHILE NOT EOF(1)
LoadFileData:
  LINE INPUT #1, DS$

  'Remove comments and leading and trailing spaces, and capitalise line
  DSO$ = DS$
  DO WHILE INSTR(DS$, CHR$(9)) <> 0: Replace DS$, CHR$(9), " ": LOOP
  DS$ = UCASE$(LTRIM$(RTRIM$(DS$)))

  'Put strings back to how they were
  IF INSTR(DS$, CHR$(34)) <> 0 THEN
   ST$ = MID$(DS$, INSTR(DS$, CHR$(34)))
   ST$ = LEFT$(ST$, INSTR(2, ST$, CHR$(34)))
   STO$ = MID$(DSO$, INSTR(DSO$, CHR$(34)))
   STO$ = LEFT$(STO$, INSTR(2, STO$, CHR$(34)))
   Replace DS$, ST$, STO$
  END IF

  'Remove comments
  IF INSTR(DS$, "B'") <> 0 THEN
   Replace DS$, "B'", "%B%"
   Replace DS$, "'", "%S%"
  END IF
  IF INSTR(DS$, ";") > 1 THEN DS$ = LEFT$(DS$, INSTR(DS$, ";") - 1)
  IF INSTR(DS$, "'") > 1 THEN DS$ = LEFT$(DS$, INSTR(DS$, "'") - 1)
  IF INSTR(DS$, "%B%") <> 0 THEN
   Replace DS$, "%B%", "B'"
   Replace DS$, "%S%", "'"
  END IF
  DS$ = RTRIM$(DS$)

  'Only load line if it is valid
  T% = 0
  IF LEFT$(DS$, 1) = ";" THEN T% = 1
  IF LEFT$(DS$, 1) = "'" THEN T% = 1
  IF LEFT$(DS$, 4) = "REM " THEN T% = 1
  IF DS$ = "REM" THEN T% = 1
  IF DS$ = "" THEN T% = 1
  IF LEFT$(DS$, 8) = "#INCLUDE" THEN T% = 1
  IF T% = 0 THEN T% = CheckLine(DS$)

  'Remove any tabs and double spaces
  DO WHILE INSTR(DS$, CHR$(9)) <> 0: Replace DS$, CHR$(9), " ": LOOP
  DO WHILE INSTR(DS$, "  ") <> 0: Replace DS$, "  ", " ": LOOP

  'Load line
  IF T% = 0 THEN

MultiCommand:

   'Make adjustments to line if needed

   'Tokenise strings
   IF INSTR(DS$, CHR$(34)) <> 0 THEN
    StringTemp$ = MID$(DS$, INSTR(DS$, CHR$(34)) + 1)
    StringTemp$ = LEFT$(StringTemp$, INSTR(StringTemp$, CHR$(34)) - 1)
    SSC% = SSC% + 1
    StringStore$(SSC%) = StringTemp$
    Replace DS$, CHR$(34) + StringTemp$ + CHR$(34), "%STRING" + MID$(STR$(SSC%), 2) + "%"
   END IF

   'Remove LET commands
   IF LEFT$(DS$, 4) = "LET " THEN Replace DS$, "LET ", ""
   IF LEFT$(DS$, 5) = "CALL " THEN Replace DS$, "CALL ", ""

   'Convert single-line IFs to multiple line
   IF INSTR(DS$, "IF") <> 0 AND INSTR(DS$, "THEN") <> 0 AND LEN(DS$) > INSTR(DS$, "THEN") + 3 THEN
    Replace DS$, "THEN", "THEN:"
    DS$ = DS$ + ": END IF"
   END IF

   'Replace <> with ~ (not equal)
   IF INSTR(DS$, "<>") <> 0 THEN Replace DS$, "<>", "~"
   'Replace => with } (equal or greater)
   IF INSTR(DS$, "=>") <> 0 THEN Replace DS$, "=>", "}"
   IF INSTR(DS$, ">=") <> 0 THEN Replace DS$, ">=", "}"
   'Replace =< with { (less or equal)
   IF INSTR(DS$, "=<") <> 0 THEN Replace DS$, "=<", "{"
   IF INSTR(DS$, "<=") <> 0 THEN Replace DS$, "<=", "{"
   
   'Convert Function f(x) to sub FN_f(x)
   IF LEFT$(DS$, 9) = "FUNCTION " THEN
    T$ = "FN_" + LTRIM$(RTRIM$(MID$(DS$, 10)))
    DS$ = "SUB " + T$
   END IF
   IF LEFT$(DS$, 14) = "WORD FUNCTION " THEN
    T$ = "FN_" + LTRIM$(RTRIM$(MID$(DS$, 15)))
    N$ = T$
    IF INSTR(N$, "(") <> 0 THEN N$ = LEFT$(N$, INSTR(N$, "(") - 1)
    IF INSTR(N$, " ") <> 0 THEN N$ = LEFT$(N$, INSTR(N$, " ") - 1)
    Replace N$, "FN_", ""
    N$ = LTRIM$(RTRIM$(N$))
    
    DS$ = "SUB " + T$
    LVC% = LVC% + 1
    LargeVars$(LVC%, 1) = "DIM " + N$ + " AS WORD"
    LargeVars$(LVC%, 2) = "FN_" + N$

   END IF
   
   'Also convert END FUNCTION to END SUB
   IF DS$ = "END FUNCTION" THEN DS$ = "END SUB"
   IF DS$ = "EXIT FUNCTION" THEN DS$ = "EXIT SUB"

   'If [WORD] is included, ensure it is at the end of the line
   IF INSTR(DS$, "[WORD]") <> 0 THEN
    IF INSTR(DS$, "[WORD]") + 6 < LEN(DS$) THEN
     Replace DS$, "[WORD]", ""
     DS$ = LTRIM$(DS$) + " [WORD]"
    END IF
   END IF

   'Convert WHILE and WEND to DO WHILE and LOOP
   IF LEFT$(DS$, 6) = "WHILE " THEN DS$ = "DO " + DS$
   IF DS$ = "WEND" THEN DS$ = "LOOP"
   
   'Replace any string variable references with arrays, after adding string to list
   DO WHILE INSTR(DS$, "$") <> 0
    Replace DS$, "$", "()"
   LOOP
   
   'Remove any tabs and double spaces (again)
   DO WHILE INSTR(DS$, CHR$(9)) <> 0: Replace DS$, CHR$(9), " ": LOOP
   DO WHILE INSTR(DS$, "  ") <> 0: Replace DS$, "  ", " ": LOOP

   'Decide if the line read is part of a sub or not
   IF LEFT$(DS$, 4) = "SUB " THEN
    IF S% = 1 THEN
     SUBDATA$(SBC%, 3) = MID$(STR$(SDC%), 2)
    END IF
    S% = 1

    'Find any large vars used as parameters
    DO WHILE INSTR(DS$, " AS ") <> 0
     'Get sub name, var name and var type
     N$ = LTRIM$(MID$(DS$, 5))
     V$ = N$
     N$ = RTRIM$(LEFT$(N$, INSTR(N$, "(") - 1)) 'Sub name
     
     Ty$ = MID$(V$, INSTR(V$, " AS ") + 4)
     IF LEFT$(Ty$, 4) = "WORD" THEN Ty$ = LEFT$(Ty$, 4) 'Var type

     V$ = RTRIM$(LEFT$(V$, INSTR(V$, " AS ") - 1))
     DO WHILE INSTR(V$, " ") <> 0: Replace V$, " ", "": LOOP
     IF INSTR(V$, "(") <> 0 THEN Replace V$, "(", ","
     FOR T% = LEN(V$) TO 1 STEP -1
      IF MID$(V$, T%, 1) = "," THEN V$ = MID$(V$, T% + 1): EXIT FOR
     NEXT T%
     
     'Remove type from sub name to prevent confusion later on
     Replace DS$, " AS " + Ty$, ""
     
     LVC% = LVC% + 1
     LargeVars$(LVC%, 1) = "DIM " + V$ + " AS " + Ty$
     LargeVars$(LVC%, 2) = N$
    LOOP

    SBC% = SBC% + 1
    SUBDATA$(SBC%, 1) = MID$(DS$, 5)
    SUBDATA$(SBC%, 2) = MID$(STR$(SDC% + 1), 2)
    SUBDATA$(SBC%, 4) = STR$(RF%)
    GOTO LoadNextLine
   END IF

   IF LEFT$(DS$, 7) = "END SUB" THEN
    S% = 0
    SUBDATA$(SBC%, 3) = MID$(STR$(SDC%), 2)
    GOTO LoadNextLine
   END IF

   'Decide if the line read is part of a data table or not
   IF LEFT$(DS$, 6) = "TABLE " THEN
    IF S% > 1 THEN
     ERC% = ERC% + 1: ERROR$(ERC%) = "Data table " + SUBDATA$(SBC%, 1) + " does not have a corresponding END TABLE"
    END IF
    S% = S% OR 2
    DTC% = DTC% + 1
    DTLC% = 0
    DataTables$(DTC%) = LTRIM$(RTRIM$(MID$(DS$, 7)))
    GOTO LoadNextLine
   END IF
   IF LEFT$(DS$, 9) = "END TABLE" THEN
    S% = S% AND 253
    DataTable%(DTC%, 0) = DTLC%
    GOTO LoadNextLine
   END IF
   
   'Automatic initialisation preparation
   IF LEFT$(DS$, 8) = "#STARTUP" THEN INCLUDE$(RF%, 2) = ";" + LTRIM$(RTRIM$(MID$(DS$, 9))): GOTO LoadNextLine
   IF LEFT$(DS$, 7) = "#DEFINE" THEN DS$ = DS$ + "':" + STR$(RF%)

   'Does the command need to be inserted into the main routine, regardless of sub/not sub?
   ForceMain% = 0
   T$ = ""
   IF LEFT$(DS$, 8) = "#DEFINE " THEN ForceMain% = 1
   IF LEFT$(DS$, 5) = "#OSC " THEN ForceMain% = 1
   IF LEFT$(DS$, 8) = "#CONFIG " THEN ForceMain% = 1
   IF LEFT$(DS$, 5) = "#MEM " THEN ForceMain% = 1
   IF LEFT$(DS$, 5) = "#RAM " THEN ForceMain% = 1
   IF LEFT$(DS$, 5) = "#INT " THEN ForceMain% = 1
   IF LEFT$(DS$, 6) = "#CHIP " THEN ForceMain% = 1
   
   IF INSTR(DS$, ":") <> 0 AND RIGHT$(DS$, 1) <> ":" AND LEFT$(DS$, 8) <> "#DEFINE " THEN
    IF INSTR(DS$, ":") > INSTR(DS$, CHR$(34)) AND INSTR(INSTR(DS$, ":"), DS$, CHR$(34)) <> 0 THEN GOTO DontSplitLoad
    T$ = DS$
    DS$ = RTRIM$(LEFT$(DS$, INSTR(DS$, ":") - 1))
    T$ = LTRIM$(MID$(T$, INSTR(T$, ":") + 1))
   END IF
DontSplitLoad:

   IF S% = 0 OR ForceMain% = 1 THEN APC% = APC% + 1: PROG$(APC%) = DS$
   IF S% = 1 AND ForceMain% = 0 THEN SDC% = SDC% + 1: SUBCODE$(SDC%) = DS$
   IF S% = 2 THEN DTLC% = DTLC% + 1: DataTable%(DTC%, DTLC%) = MakeDec(DS$)

   IF T$ <> "" THEN DS$ = T$: GOTO MultiCommand
  END IF
LoadNextLine:
 LOOP
 
 IF S% = 1 THEN
  SUBDATA$(SBC%, 3) = MID$(STR$(SDC%), 2)
  S% = 0
 END IF
 CLOSE
 IF VBS% = 1 THEN LOCATE , 60: PRINT MID$(STR$(INT(RF% / ICC% * 100)), 2); "% ";
NEXT RF%
IF VBS% = 1 THEN PRINT

'Find compiler directives, except SCRIPT, ENDSCRIPT, IFDEF and ENDIF
IF VBS% = 1 THEN
 PRINT SPC(5); Message$("CompDirs");
END IF
PD% = 0
RemoveCompDirs:
PD% = PD% + 1
 T$ = PROG$(PD%)
 IF LEFT$(T$, 1) = "#" AND INSTR(T$, "IFDEF") = 0 AND INSTR(T$, "ENDIF") = 0 AND INSTR(T$, "SCRIPT") = 0 AND INSTR(T$, "ENDSCRIPT") = 0 THEN
  DelLine PD%: PD% = PD% - 1

  IF LEFT$(T$, 7) = "#DEFINE" THEN
   N$ = MID$(T$, INSTR(T$, " ") + 1): N$ = LTRIM$(RTRIM$(N$))
   T$ = RTRIM$(LEFT$(N$, INSTR(N$, "'") - 1))

   IF INSTR(T$, " ") = 0 THEN
    N$ = T$
    F$ = ""
    V$ = ""
   END IF
   IF INSTR(T$, " ") <> 0 THEN
    V$ = MID$(N$, INSTR(N$, " ") + 1)
    F$ = LTRIM$(RTRIM$(MID$(V$, INSTR(V$, "':") + 2)))
    V$ = LTRIM$(RTRIM$(LEFT$(V$, INSTR(V$, "':") - 1)))
    N$ = LEFT$(N$, INSTR(N$, " ") - 1)
   END IF

   IF LEFT$(V$, 1) = "=" THEN
    V$ = MID$(V$, 2)
    Calculate V$
    V$ = LTRIM$(RTRIM$(V$))
   END IF
   T% = 0
   FOR CE% = 1 TO DFC%
    IF N$ = DEFINE$(CE%, 1) THEN T% = 1: EXIT FOR
   NEXT CE%
   IF T% = 0 THEN
    DFC% = DFC% + 1
    DEFINE$(DFC%, 1) = N$
    DEFINE$(DFC%, 2) = V$
    DEFINE$(DFC%, 3) = F$
   END IF
  END IF

  IF LEFT$(T$, 5) = "#CHIP" AND ChipName$ = "" THEN
   ChipName$ = MID$(T$, 6)
   ChipMhz = VAL(MID$(ChipName$, INSTR(ChipName$, ",") + 1))
   ChipName$ = LTRIM$(RTRIM$(LEFT$(ChipName$, INSTR(ChipName$, ",") - 1)))
   IF LEFT$(UCASE$(ChipName$), 3) = "PIC" THEN ChipName$ = MID$(ChipName$, 4)
   IF LEFT$(UCASE$(ChipName$), 1) = "P" THEN ChipName$ = MID$(ChipName$, 2)
  END IF

  IF LEFT$(T$, 4) = "#OSC" AND OSC$ = "" THEN OSC$ = LTRIM$(RTRIM$(MID$(T$, 5)))

  IF LEFT$(T$, 4) = "#INT" AND Int$ = "" THEN Int$ = LTRIM$(RTRIM$(MID$(T$, 5)))
  
  IF LEFT$(T$, 7) = "#CONFIG" THEN
   T$ = LTRIM$(RTRIM$(MID$(T$, 8)))
   IF CONFIG$ <> "" THEN T$ = "," + T$
   CONFIG$ = CONFIG$ + T$
  END IF

  IF LEFT$(T$, 4) = "#RAM" AND ChipRam% = 0 THEN ChipRam% = VAL(LTRIM$(RTRIM$(MID$(T$, 5))))
  IF LEFT$(T$, 4) = "#MEM" AND ChipRam% = 0 THEN ChipRam% = VAL(LTRIM$(RTRIM$(MID$(T$, 5))))
  
 END IF
 IF VBS% = 1 THEN LOCATE , 60: PRINT MID$(STR$(INT(PD% / APC% * 100)), 2); "%";
IF PD% < APC% THEN GOTO RemoveCompDirs

'Ensure that oscillator is selected
IF OSC$ = "" AND INSTR(CONFIG$, "_OSC") = 0 THEN OSC$ = "HS_OSC"
IF VBS% = 1 THEN
 PRINT
 PRINT SPC(10); Message$("ChipS")
 PRINT SPC(15); Message$("ChipM") + ChipName$
 PRINT SPC(15); Message$("ChipC") + MID$(STR$(ChipMhz), 2)
 PRINT SPC(15); Message$("ChipO") + OSC$
END IF
'Set chip config defines for #IFDEF and #SCRIPT use
DFC% = DFC% + 1: DEFINE$(DFC%, 1) = "CHIPNAME": DEFINE$(DFC%, 2) = ChipName$
DFC% = DFC% + 1: DEFINE$(DFC%, 1) = "CHIPMHZ": DEFINE$(DFC%, 2) = MID$(STR$(ChipMhz), 2)
DFC% = DFC% + 1: DEFINE$(DFC%, 1) = "OSC": DEFINE$(DFC%, 2) = OSC$

'Initialise built-in data, and prepare built-in subs
PrepareBuiltIn

'Find and run compiler scripts
IF VBS% = 1 THEN PRINT SPC(5); Message$("RunScripts")
RunScripts

IF VBS% = 1 THEN PRINT : PRINT SPC(5); Message$("FindFreeRAM")
FindFreeRAM

'Remove any #IFDEFs that do not apply to the program
IF VBS% = 1 THEN PRINT : PRINT SPC(5); Message$("RemIfDefs")
RemIfDefs

'Replace constants with their values
IF VBS% = 1 THEN PRINT SPC(5); Message$("RepDefs");
ReplaceConstants
IF VBS% = 1 THEN PRINT

'Break up lines with multiple commands
IF VBS% = 1 THEN PRINT SPC(5); Message$("SplitLines")
SplitLines

END SUB

SUB ProcessArrays

PD% = 0
ProcessArrayCalls:
PD% = PD% + 1

 DS$ = PROG$(PD%)
 ATV% = 0 'Number of array temporary variables
 
 'Does the line contain an array?
CheckArrayAgain:
 AF% = 0
 FOR CD% = 1 TO ARC%
  N$ = ArrayData$(CD%, 1)
  
  T% = 0
  IF INSTR(DS$, N$) <> 0 THEN
   IF LEN(DS$) = LEN(N$) THEN T% = 2

   IF INSTR(DS$, N$) = 1 THEN T% = 1
   IF T% = 0 THEN
    T$ = MID$(DS$, INSTR(DS$, N$) - 1, 1)
    T$ = LEFT$(T$, 1)
    IF T$ = " " THEN T% = 1
    IF T$ = "(" THEN T% = 1
    IF T$ = ")" THEN T% = 1
    IF T$ = "," THEN T% = 1
    IF T$ = "." THEN T% = 1
    IF T$ = ":" THEN T% = 1
    IF T$ = "+" THEN T% = 1
    IF T$ = "-" THEN T% = 1
    IF T$ = "*" THEN T% = 1
    IF T$ = "/" THEN T% = 1
    IF T$ = "=" THEN T% = 1
    IF T$ = "!" THEN T% = 1
    IF T$ = "<" THEN T% = 1
    IF T$ = ">" THEN T% = 1
   END IF

   IF INSTR(DS$, N$) + LEN(N$) - 1 = LEN(DS$) THEN T% = T% + 1
   IF T% < 2 THEN
    T$ = MID$(DS$, INSTR(DS$, N$) + LEN(N$), 1)
    IF T$ = " " THEN T% = T% + 1
    IF T$ = "(" THEN T% = T% + 1
    IF T$ = ")" THEN T% = T% + 1
    IF T$ = "," THEN T% = T% + 1
    IF T$ = "." THEN T% = T% + 1
    IF T$ = ":" THEN T% = T% + 1
    IF T$ = "+" THEN T% = T% + 1
    IF T$ = "-" THEN T% = T% + 1
    IF T$ = "*" THEN T% = T% + 1
    IF T$ = "/" THEN T% = T% + 1
    IF T$ = "=" THEN T% = T% + 1
    IF T$ = "!" THEN T% = T% + 1
    IF T$ = "<" THEN T% = T% + 1
    IF T$ = ">" THEN T% = T% + 1
   END IF
  END IF
  
  IF T% = 2 THEN
   IF INSTR(DS$, "()") <> 0 THEN
    T$ = MID$(DS$, INSTR(DS$, N$) + LEN(N$))
    T$ = LEFT$(T$, 2)
    IF T$ = "()" THEN AF% = 0: EXIT FOR
   END IF
   AF% = CD%: EXIT FOR
  END IF

 NEXT CD%

 'Show error if array has not been found
 IF AF% = 0 AND INSTR(DS$, "(") <> 0 AND INSTR(DS$, "()") = 0 THEN
  DS$ = LEFT$(DS$, INSTR(DS$, "(") - 1)
  FOR SS% = LEN(DS$) TO 1 STEP -1
   IF MID$(DS$, SS%, 1) = " " THEN DS$ = MID$(DS$, SS% + 1)
  NEXT SS%
  IF DS$ <> "" THEN
   T% = ASC(UCASE$(RIGHT$(DS$, 1)))
   IF (T% > 64 AND T% < 91) OR (T% > 47 AND T% < 58) THEN
    ERC% = ERC% + 1
    T$ = Message$("ArrayNoDec")
    Replace T$, "%Name%", DS$
    ERROR$(ERC%) = T$
   END IF
  END IF
 END IF

 'Array has been found, so generate code to access it
 IF AF% <> 0 THEN
  
  'Is array being read or set?
  ArrayDir% = 0 '0 = read, 1 = set
  'These commands set variables:
  IF LEFT$(DS$, 4) = "SET " THEN ArrayDir% = 1
  IF INSTR(DS$, "=") > INSTR(DS$, N$) THEN ArrayDir% = 1
  IF LCASE$(LEFT$(LTRIM$(DS$), 6)) = "movwf " THEN ArrayDir% = 1
  'These commands read variables, but may appear to set them based on above
  IF LEFT$(DS$, 3) = "IF " THEN ArrayDir% = 0
  IF LEFT$(DS$, 3) = "DO " THEN ArrayDir% = 0
  IF LEFT$(DS$, 5) = "WAIT " THEN ArrayDir% = 0
  
  'Remove array from line, and replace with a temporary value
  T$ = MID$(DS$, INSTR(DS$, N$))
  L% = 1
  P% = INSTR(T$, "(")
FindEndBracket:
  P% = P% + 1
   IF MID$(T$, P%, 1) = "(" THEN L% = L% + 1
   IF MID$(T$, P%, 1) = ")" THEN L% = L% - 1
  IF L% <> 0 AND P% < LEN(T$) THEN GOTO FindEndBracket
  IF L% <> 0 THEN
   FOR AB% = 1 TO L%
    DS$ = DS$ + ")"
   NEXT AB%
   L% = 0
  END IF

  IF L% = 0 THEN
   T$ = LEFT$(T$, P%)

   'Alter line
   ATV% = ATV% + 1
   AV$ = "SysArrayTemp" + MID$(STR$(ATV%), 2)
   VLC% = VLC% + 1: VARLIST$(VLC%) = AV$
   Replace DS$, T$, AV$
   PROG$(PD%) = DS$

   'Find array location
   ArrayPosition$ = MID$(T$, INSTR(T$, "(") + 1)
   ArrayPosition$ = LEFT$(ArrayPosition$, LEN(ArrayPosition$) - 1)
   
   'Find array type
   IF ArrayData$(AF%, 4) = "DIM" THEN
    T% = VAL(ArrayData$(AF%, 2))
    T% = T% AND 255
    ArrayHandler$ = MID$(STR$(T%), 2)
    ArrayType% = 0
   END IF
   IF ArrayData$(AF%, 4) = "SUB" THEN
    ArrayHandler$ = "Sys" + N$ + "Handler"
    VLC% = VLC% + 1
    VARLIST$(VLC%) = ArrayHandler$
    ArrayType% = 1
   END IF

   'Add code to read/set array
   AddLine "FSR = " + ArrayHandler$ + "+" + ArrayPosition$, PD% + ArrayDir%
   IF ArrayType% = 0 THEN
    IF VAL(ArrayData$(AF%, 2)) < 256 THEN T$ = " bcf STATUS, IRP"
    IF VAL(ArrayData$(AF%, 2)) > 255 THEN T$ = " bsf STATUS, IRP"
    PD% = PD% + 1
    AddLine T$, PD%
   END IF
   IF ArrayType% = 1 THEN
    AddLine " bcf STATUS, IRP", PD% + ArrayDir% + 1
    AddLine " btfsc " + ArrayHandler$ + "_H,0", PD% + ArrayDir% + 2
    AddLine " bsf STATUS, IRP", PD% + ArrayDir% + 3
    PD% = PD% + 3
   END IF
   IF ArrayDir% = 0 THEN AddLine AV$ + " = INDF", PD% + 1
   IF ArrayDir% = 1 THEN AddLine "INDF = " + AV$, PD% + 2
  END IF
  PD% = PD% - 1
  GOTO CheckArrayAgain
 END IF

IF PD% < APC% THEN GOTO ProcessArrayCalls

END SUB

SUB RemIfDefs
'Remove IFDEFs that are not applicable

RIDM% = 0
RemIfDefMode:
DS% = 0
IL% = 0
RemIfDef:
 DS% = DS% + 1
 IF RIDM% = 0 THEN T$ = PROG$(DS%)
 IF RIDM% = 1 THEN T$ = SUBCODE$(DS%)
 T% = 0

 IF LEFT$(UCASE$(T$), 6) = "#IFDEF" AND IL% = 0 THEN
  IF INSTR(T$, ";") <> 0 THEN T$ = LEFT$(T$, INSTR(T$, ";") - 1)
  T% = 1
  SV% = DS%
  
  'Read real and test values
  C$ = LTRIM$(RTRIM$(MID$(T$, 8)))
  CheckValue% = 0
  IF INSTR(C$, " ") <> 0 THEN
   CheckValue% = 1
   V$ = MID$(C$, INSTR(C$, " ") + 1)
   C$ = LEFT$(C$, INSTR(C$, " ") - 1)
  END IF

  IF INSTR(C$, "VAR(") <> 0 THEN
   FV% = 0: IF INSTR(C$, "NOVAR(") <> 0 THEN FV% = 1

   T$ = MID$(C$, INSTR(C$, "(") + 1)
   T$ = LEFT$(T$, INSTR(T$, ")") - 1)

   ConstFound% = 0
   FOR FC% = 1 TO SVC%
    IF SysVars$(FC%, 1) = T$ THEN ConstFound% = 1: EXIT FOR
   NEXT FC%
   T% = 1
   IF ConstFound% = 1 THEN T% = 2

   IF FV% = 1 THEN
    IF T% = 1 THEN T% = 3
    IF T% = 2 THEN T% = 1
    IF T% = 3 THEN T% = 2
   END IF
   
   GOTO IfDefProcessed
  END IF

  IF CheckValue% = 0 THEN
   ConstFound% = 0
   FOR FC% = 1 TO DFC%
    IF DEFINE$(FC%, 1) = C$ THEN ConstFound% = 1: EXIT FOR
   NEXT FC%
   T% = 1
   IF ConstFound% = 1 THEN T% = 2

   GOTO IfDefProcessed
  END IF

  VC% = 0
  DO WHILE INSTR(V$, ",") <> 0
   VC% = VC% + 1
   TempData$(VC%) = LEFT$(V$, INSTR(V$, ",") - 1)
   V$ = MID$(V$, INSTR(V$, ",") + 1)
   V$ = LTRIM$(V$)
  LOOP
  VC% = VC% + 1
  TempData$(VC%) = V$
  AD% = 0

  'Replace names of test constants with values
  FOR SD% = 1 TO VC%
   TV% = 0
   FOR FV% = 1 TO DFC%
    IF UCASE$(TempData$(SD%)) = UCASE$(DEFINE$(FV%, 1)) THEN TV% = FV%: EXIT FOR
   NEXT FV%
   IF TV% <> 0 THEN TempData$(SD%) = DEFINE$(FV%, 2)
  NEXT SD%
  T% = 1

  TV$ = C$
  ReplaceConstantsLine TV$
  IF INSTR(TV$, ";") <> 0 THEN TV$ = LEFT$(TV$, INSTR(TV$, ";") - 1)

  'Compare real and test values
  FOR SD% = 1 TO VC%
   IF UCASE$(TempData$(SD%)) = UCASE$(TV$) THEN T% = 2: EXIT FOR
  NEXT SD%

IfDefProcessed:
  'T% is 2 if true, 1 if false
  'Remove everything up to the #ENDIF
  IF T% = 1 THEN
   IF RIDM% = 0 THEN
    FOR CD% = SV% TO APC%
     IF UCASE$(LEFT$(PROG$(CD%), 6)) = "#IFDEF" THEN IL% = IL% + 1
     IF UCASE$(LEFT$(PROG$(CD%), 6)) = "#ENDIF" THEN IL% = IL% - 1
     IF IL% = 0 THEN EV% = CD%: EXIT FOR
    NEXT CD%
    FOR CD% = SV% TO EV%
     DelLine SV%
    NEXT CD%
   END IF
   IF RIDM% = 1 THEN
    FOR CD% = SV% TO SDC%
     IF UCASE$(LEFT$(SUBCODE$(CD%), 6)) = "#IFDEF" THEN IL% = IL% + 1
     IF UCASE$(LEFT$(SUBCODE$(CD%), 6)) = "#ENDIF" THEN IL% = IL% - 1
     IF IL% = 0 THEN EV% = CD%: EXIT FOR
    NEXT CD%
    FOR CD% = SV% TO EV%
     'DelSubLine SV%
     SUBCODE$(CD%) = ""
    NEXT CD%
   END IF
   DS% = DS% - 1
  END IF
  
  'Remove the IFDEF and corresponding #ENDIF
  IF T% = 2 THEN
   IF RIDM% = 0 THEN
    FOR CD% = SV% TO APC%
     IF UCASE$(LEFT$(PROG$(CD%), 6)) = "#IFDEF" THEN IL% = IL% + 1
     IF UCASE$(LEFT$(PROG$(CD%), 6)) = "#ENDIF" THEN IL% = IL% - 1
     IF IL% = 0 THEN EV% = CD%: EXIT FOR
    NEXT CD%
    'DelLine EV%
    'DelLine SV%
    SUBCODE$(EV%) = ""
    SUBCODE$(SV%) = ""
   END IF
   IF RIDM% = 1 THEN
    FOR CD% = SV% TO SDC%
     IF UCASE$(LEFT$(SUBCODE$(CD%), 6)) = "#IFDEF" THEN IL% = IL% + 1
     IF UCASE$(LEFT$(SUBCODE$(CD%), 6)) = "#ENDIF" THEN IL% = IL% - 1
     IF IL% = 0 THEN EV% = CD%: EXIT FOR
    NEXT CD%
    DelSubLine EV%
    DelSubLine SV%
   END IF

   DS% = DS% - 1
  END IF

 END IF

IF RIDM% = 0 AND DS% < APC% THEN GOTO RemIfDef
IF RIDM% = 0 THEN RIDM% = 1: GOTO RemIfDefMode
IF RIDM% = 1 AND DS% < SDC% THEN GOTO RemIfDef

END SUB

SUB ReplaceConstants

'Replace constants with their values

FOR DS% = 1 TO 2
 PDC% = APC%
 IF DS% = 2 THEN PDC% = SDC%

 FOR PD% = 1 TO PDC%
  IF DS% = 1 THEN DS$ = PROG$(PD%) ELSE DS$ = SUBCODE$(PD%)

  IF VBS% = 1 THEN
   LOCATE , 60: PRINT MID$(STR$(INT((PD% + (DS% - 1) * APC%) / (APC% + SDC%) * 100)), 2); "%";
  END IF

  T% = 0

ReplaceNestedConstants:
  T$ = DS$
  ReplaceConstantsLine DS$
  IF UCASE$(T$) <> UCASE$(DS$) THEN T% = 1: GOTO ReplaceNestedConstants
  IF T% = 1 THEN
   IF DS% = 1 THEN PROG$(PD%) = DS$ ELSE SUBCODE$(PD%) = DS$
  END IF
 NEXT PD%
NEXT DS%

END SUB

SUB ReplaceConstantsLine (DS$)

 FOR CL% = 1 TO DFC%
  N$ = DEFINE$(CL%, 1)
  RC$ = DEFINE$(CL%, 2)
  SF$ = DEFINE$(CL%, 3)

REPCONST:
  IF INSTR(DS$, N$) <> 0 THEN
   T% = 0
   IF LEN(DS$) = LEN(N$) THEN T% = 2

   IF INSTR(DS$, N$) = 1 THEN T% = 1
   IF T% = 0 THEN
    T$ = MID$(DS$, INSTR(DS$, N$) - 1, 1)
    IF T$ = " " THEN T% = 1: GOTO LeftEndFound
    IF T$ = "(" THEN T% = 1: GOTO LeftEndFound
    IF T$ = ")" THEN T% = 1: GOTO LeftEndFound
    IF T$ = "," THEN T% = 1: GOTO LeftEndFound
    IF T$ = "." THEN T% = 1: GOTO LeftEndFound
    IF T$ = ":" THEN T% = 1: GOTO LeftEndFound
    IF T$ = "+" THEN T% = 1: GOTO LeftEndFound
    IF T$ = "-" THEN T% = 1: GOTO LeftEndFound
    IF T$ = "*" THEN T% = 1: GOTO LeftEndFound
    IF T$ = "/" THEN T% = 1: GOTO LeftEndFound
    IF T$ = "=" THEN T% = 1: GOTO LeftEndFound
    IF T$ = "!" THEN T% = 1: GOTO LeftEndFound
    IF T$ = "<" THEN T% = 1: GOTO LeftEndFound
    IF T$ = ">" THEN T% = 1
LeftEndFound:
    T2$ = T$
   END IF
   
   IF INSTR(DS$, N$) + LEN(N$) - 1 = LEN(DS$) THEN T% = T% + 1
   IF T% < 2 THEN
    T$ = MID$(DS$, INSTR(DS$, N$) + LEN(N$), 1)
    IF T$ = " " THEN T% = T% + 1: GOTO RightEndFound
    IF T$ = "(" THEN T% = T% + 1: GOTO RightEndFound
    IF T$ = ")" THEN T% = T% + 1: GOTO RightEndFound
    IF T$ = "," THEN T% = T% + 1: GOTO RightEndFound
    IF T$ = "." THEN T% = T% + 1: GOTO RightEndFound
    IF T$ = ":" THEN T% = T% + 1: GOTO RightEndFound
    IF T$ = ";" THEN T% = T% + 1: GOTO RightEndFound
    IF T$ = "+" THEN T% = T% + 1: GOTO RightEndFound
    IF T$ = "-" THEN T% = T% + 1: GOTO RightEndFound
    IF T$ = "*" THEN T% = T% + 1: GOTO RightEndFound
    IF T$ = "/" THEN T% = T% + 1: GOTO RightEndFound
    IF T$ = "=" THEN T% = T% + 1: GOTO RightEndFound
    IF T$ = "!" THEN T% = T% + 1: GOTO RightEndFound
    IF T$ = "<" THEN T% = T% + 1: GOTO RightEndFound
    IF T$ = ">" THEN T% = T% + 1
RightEndFound:
   END IF

   IF T% = 2 THEN
    Replace DS$, N$, RC$
    IF SF$ <> "" AND INSTR(DS$, ";STARTUP" + DEFINE$(CL%, 3)) = 0 THEN DS$ = DS$ + ";STARTUP" + DEFINE$(CL%, 3)
    GOTO REPCONST
   END IF
   IF T% < 2 THEN
    Replace DS$, N$, "`"
   END IF
   GOTO REPCONST
  END IF

  DO WHILE INSTR(DS$, "`") <> 0: Replace DS$, "`", N$: LOOP
 NEXT CL%

END SUB

SUB RunScripts

'Read Scripts
'Read from main program
PD% = 0
ReadScriptMain:
 PD% = PD% + 1
 IF PROG$(PD%) = "#SCRIPT" THEN
  S% = PD%
  T% = 0
ReadScriptLinesMain:
  PD% = PD% + 1
  IF PROG$(PD%) <> "#ENDSCRIPT" THEN
   T% = T% + 1
   TempData$(T%) = PROG$(PD%)
   GOTO ReadScriptLinesMain
  END IF
  E% = PD%
  FOR CD% = S% TO E%
   DelLine S%
  NEXT CD%
  PD% = S% - 1
  GOSUB ExecScript
 END IF
IF PD% < APC% THEN GOTO ReadScriptMain

'Read from subs
PD% = 0
ReadScriptSubs:
 PD% = PD% + 1
 IF SUBCODE$(PD%) = "#SCRIPT" THEN
  S% = PD%
  T% = 0
ReadScriptLinesSubs:
  PD% = PD% + 1
  IF SUBCODE$(PD%) <> "#ENDSCRIPT" THEN
   T% = T% + 1
   TempData$(T%) = SUBCODE$(PD%)
   GOTO ReadScriptLinesSubs
  END IF
  E% = PD%
  FOR CD% = S% TO E%
   DelSubLine S%
  NEXT CD%
  PD% = S% - 1
  GOSUB ExecScript
 END IF
IF PD% < SDC% THEN GOTO ReadScriptSubs

EXIT SUB

'Execute Script
ExecScript:
 SC% = 0
RunScript:
 SC% = SC% + 1
 CO$ = TempData$(SC%)
 IF INSTR(CO$, ";") <> 0 THEN CO$ = LEFT$(CO$, INSTR(CO$, ";") - 1)
 
'Prepare a version of the command with constants replaced by values
 COCR$ = CO$
 T% = 0
TokeniseQuotes:
 IF INSTR(COCR$, CHR$(34)) <> 0 THEN
  T% = T% + 1
  T$ = MID$(COCR$, INSTR(COCR$, CHR$(34)) + 1)
  T$ = LEFT$(T$, INSTR(T$, CHR$(34)) - 1)
  FILE$(T%) = T$
  Replace COCR$, CHR$(34) + T$ + CHR$(34), "$" + MID$(STR$(T%), 2) + "$"
  GOTO TokeniseQuotes
 END IF

 ReplaceConstantsLine COCR$

 IF INSTR(COCR$, ";") <> 0 THEN COCR$ = LEFT$(COCR$, INSTR(COCR$, ";") - 1)

 DO WHILE INSTR(COCR$, "$") <> 0
  T% = VAL(MID$(COCR$, INSTR(COCR$, "$") + 1))
  T$ = "$" + MID$(STR$(T%), 2) + "$"
  Replace COCR$, T$, FILE$(T%)
 LOOP
 
 'IF
 IF LEFT$(CO$, 3) = "IF " THEN
  C$ = MID$(COCR$, 4)
  IF INSTR(C$, "THEN") <> 0 THEN C$ = LEFT$(C$, INSTR(C$, "THEN") - 1)
  C$ = LTRIM$(RTRIM$(C$))
  IF INSTR(C$, "=") <> 0 THEN ACT$ = "="
  IF INSTR(C$, "!") <> 0 THEN ACT$ = "!"
  IF INSTR(C$, "<") <> 0 THEN ACT$ = "<"
  IF INSTR(C$, ">") <> 0 THEN ACT$ = ">"
  V1$ = RTRIM$(LEFT$(C$, INSTR(C$, ACT$) - 1))
  V2$ = LTRIM$(MID$(C$, INSTR(C$, ACT$) + 1))
  T% = VAL(V1$): T$ = LTRIM$(STR$(T%))
  IF T$ = LEFT$(V$, LEN(T$)) THEN Calculate V1$
  T% = VAL(V2$): T$ = LTRIM$(STR$(T%))
  IF T$ = LEFT$(V$, LEN(T$)) THEN Calculate V2$
  
  T% = 0
  IF ACT$ = "=" AND V1$ = V2$ THEN T% = 1
  IF ACT$ = "!" AND V1$ <> V2$ THEN T% = 1
  IF ACT$ = "<" AND VAL(V1$) < VAL(V2$) THEN T% = 1
  IF ACT$ = ">" AND VAL(V1$) > VAL(V2$) THEN T% = 1
  IF T% = 0 THEN
   TL% = 1
   DO WHILE TL% > 0
    SC% = SC% + 1
    T$ = TempData$(SC%)
    IF LEFT$(T$, 3) = "IF " THEN TL% = TL% + 1
    IF LEFT$(T$, 6) = "END IF" THEN TL% = TL% - 1
   LOOP
  END IF
 END IF

 'ERROR
 IF LEFT$(CO$, 6) = "ERROR " THEN
  T$ = MID$(COCR$, 7)
  IF LEFT$(T$, 1) = "%" AND RIGHT$(T$, 1) = "%" THEN
   Replace T$, "%", ""
   Replace T$, "%", ""
   T$ = Message$(T$)
  END IF
  ERC% = ERC% + 1
  ERROR$(ERC%) = T$
 END IF

 'CALCULATE
 IF INSTR(CO$, "=") <> 0 AND LEFT$(CO$, 3) <> "IF " THEN
  'Get data and output name
  O$ = LTRIM$(RTRIM$(LEFT$(CO$, INSTR(CO$, "=") - 1)))
  V$ = LTRIM$(RTRIM$(MID$(COCR$, INSTR(COCR$, "=") + 1)))
  
  'Check if the data is a sum, and calculate if it is
  DO WHILE INSTR(V$, "&") <> 0: Replace V$, "&", "AND": LOOP
  T$ = RTRIM$(LTRIM$(STR$(VAL(V$))))
  
  IF T$ = LEFT$(V$, LEN(T$)) OR INSTR(V$, "/") <> 0 OR INSTR(V$, "*") <> 0 OR INSTR(V$, "+") <> 0 OR INSTR(V$, "-") <> 0 OR INSTR(V$, "AND") <> 0 OR INSTR(V$, "OR") <> 0 OR INSTR(V$, "XOR") <> 0 THEN Calculate V$
  V$ = UCASE$(V$)

  'Write the data to the output
  T% = 0
  FOR CD% = 1 TO DFC%
   IF DEFINE$(CD%, 1) = O$ THEN T% = 1: EXIT FOR
  NEXT CD%
  V$ = LTRIM$(RTRIM$(V$))
  IF T% = 0 THEN
   DFC% = DFC% + 1
   DEFINE$(DFC%, 1) = O$
   DEFINE$(DFC%, 2) = V$
  END IF
  IF T% = 1 THEN DEFINE$(CD%, 2) = V$
 END IF

 IF SC% < (E% - S% - 1) THEN GOTO RunScript
RETURN

END SUB

SUB SortVarList

IF VLC% = 0 THEN EXIT SUB

'Sort list of vars
SORTVARS:
T% = 0
FOR SC% = 1 TO VLC% - 1
 IF UCASE$(VARLIST$(SC%)) > UCASE$(VARLIST$(SC% + 1)) THEN
  'Swap name
  N$ = VARLIST$(SC% + 1)
  VARLIST$(SC% + 1) = VARLIST$(SC%)
  VARLIST$(SC%) = N$
  'Swap type
  N$ = VarType$(SC% + 1)
  VarType$(SC% + 1) = VarType$(SC%)
  VarType$(SC%) = N$
  T% = 1
 END IF
NEXT SC%
IF T% = 1 THEN GOTO SORTVARS

'Delete duplicate entries in list
CD% = 0
DELDUPVARS:
 CD% = CD% + 1
 IF UCASE$(VARLIST$(CD%)) = UCASE$(VARLIST$(CD% + 1)) THEN
  IF VarType$(CD% + 1) = "" AND VarType$(CD%) <> "" THEN VarType$(CD% + 1) = VarType$(CD%)
  FOR DL% = CD% TO VLC%
   VARLIST$(DL%) = VARLIST$(DL% + 1)
   VarType$(DL%) = VarType$(DL% + 1)
  NEXT DL%
  VLC% = VLC% - 1
  CD% = CD% - 1
 END IF
IF CD% < VLC% THEN GOTO DELDUPVARS

END SUB

SUB SplitLines

'Search main program
PD% = 0
SplitMain:
 PD% = PD% + 1
 IF INSTR(PROG$(PD%), ":") <> 0 AND RIGHT$(PROG$(PD%), 1) <> ":" THEN
  T$ = PROG$(PD%)
  T2$ = LTRIM$(MID$(T$, INSTR(T$, ":") + 1))
  PROG$(PD%) = RTRIM$(LEFT$(T$, INSTR(T$, ":") - 1))
  AddLine T2$, PD% + 1
  PD% = PD% - 1
 END IF
IF PD% < APC% THEN GOTO SplitMain

'Search Subroutines
PD% = 0
SplitSubs:
 PD% = PD% + 1
 IF INSTR(SUBCODE$(PD%), ":") <> 0 AND RIGHT$(SUBCODE$(PD%), 1) <> ":" THEN
  T$ = SUBCODE$(PD%)
  T2$ = LTRIM$(RTRIM$(MID$(T$, INSTR(T$, ":") + 1)))
  SUBCODE$(PD%) = LTRIM$(RTRIM$(LEFT$(T$, INSTR(T$, ":") - 1)))
  AddSubLine T2$, PD% + 1
 END IF
IF PD% < SDC% THEN GOTO SplitSubs

END SUB

FUNCTION SubListLocation (SN$)

SubListLocation = 0
T$ = LTRIM$(RTRIM$(UCASE$(SN$)))

FOR T% = 1 TO SLC%
 IF LTRIM$(RTRIM$(UCASE$(SUBLIST$(T%, 1)))) = T$ THEN SubListLocation = T%: EXIT FUNCTION
NEXT

END FUNCTION

SUB SubParams
PD% = 0
REPSUBPARAM:
 PD% = PD% + 1
 T$ = PROG$(PD%)

 TP$ = MID$(T$, INSTR(T$, " call ") + 6)
 IF LEFT$(T$, 6) = " call " AND (INSTR(T$, "(") <> 0 OR INSTR(TP$, " ") <> 0) THEN
  FP% = INSTR(7, T$, " ") + 1
  IF INSTR(TP$, " ") <> 0 AND (INSTR(T$, "(") = 0 OR INSTR(T$, "(") > FP%) THEN
   SCT$ = LEFT$(T$, INSTR(7, T$, " "))
   Replace T$, SCT$, SCT$ + "("
   T$ = T$ + ")"
   PROG$(PD%) = T$
  END IF

  S$ = MID$(T$, 7): S$ = LEFT$(S$, INSTR(S$, "(") - 1)
  
  DO WHILE INSTR(S$, " ") <> 0: Replace S$, " ", "": LOOP
  FOR DS% = 1 TO SBC%
   DS$ = SUBDATA$(DS%, 1): T2$ = DS$
   IF INSTR(DS$, "(") <> 0 THEN DS$ = LEFT$(DS$, INSTR(DS$, "(") - 1)
   DS$ = LTRIM$(RTRIM$(DS$))
   IF DS$ = S$ THEN GOTO SubParamFound
  NEXT DS%
  IF PD% < APC% THEN GOTO REPSUBPARAM
  EXIT SUB

SubParamFound:
  'Check number of parameters is the same
  T% = 0
  IF INSTR(PROG$(PD%), "(") <> 0 THEN T% = T% + 1
  IF INSTR(T2$, "(") <> 0 THEN T% = T% - 1
  FOR CD% = 1 TO LEN(PROG$(PD%))
   IF MID$(PROG$(PD%), CD%, 1) = "," THEN T% = T% + 1
  NEXT CD%
  FOR CD% = 1 TO LEN(T2$)
   IF MID$(T2$, CD%, 1) = "," THEN T% = T% - 1
  NEXT CD%
  IF T% <> 0 THEN
   ERC% = ERC% + 1
   T$ = Message$("BadParam")
   Replace T$, "%sub%", PROG$(PD%)
   Replace T$, " call ", ""
   T3$ = T2$
   Replace T3$, "#NR", ""
   Replace T$, "%correct%", RTRIM$(T3$)
   ERROR$(ERC%) = T$
   'ERROR$(ERC%) = "Incorrect number of parameters: " + PROG$(PD%) + ". Correct syntax: " + T2$
   'ProgWillFail% = 1
   IF PD% < APC% THEN GOTO REPSUBPARAM
   EXIT SUB
  END IF

  T$ = MID$(T$, INSTR(T$, "(") + 1): T2$ = MID$(T2$, INSTR(T2$, "(") + 1)
  NR% = 0: IF INSTR(T2$, "#NR") <> 0 THEN NR% = 1
  IF T$ = ")" OR T2$ = ")" THEN GOTO NEXTSUBPARAM
  
  T$ = LTRIM$(RTRIM$(T$))
  IF RIGHT$(T$, 1) = ")" THEN T$ = LEFT$(T$, LEN(T$) - 1)
  'T$ = LEFT$(T$, INSTR(T$, ")") - 1)
  IF INSTR(T2$, "#NR") <> 0 THEN Replace T2$, "#NR", ""
  T2$ = LTRIM$(RTRIM$(T2$))
  IF RIGHT$(T2$, 1) = ")" THEN T2$ = LEFT$(T2$, LEN(T2$) - 1)
  'T2$ = LEFT$(T2$, INSTR(T2$, ")") - 1)

  T% = 0
  DO WHILE INSTR(T$, ",") <> 0
   T% = T% + 1
   FILE$(T%) = LEFT$(T$, INSTR(T$, ",") - 1)
   FILE$(T% + 25) = LEFT$(T2$, INSTR(T2$, ",") - 1)
   IF RIGHT$(FILE$(T%), 1) = " " THEN FILE$(T%) = LEFT$(FILE$(T%), LEN(FILE$(T%)) - 1)
   IF RIGHT$(FILE$(T% + 25), 1) = " " THEN FILE$(T% + 25) = LEFT$(FILE$(T% + 25), LEN(FILE$(T% + 25)) - 1)
   T$ = MID$(T$, INSTR(T$, ",") + 1)
   T2$ = MID$(T2$, INSTR(T2$, ",") + 1)
   IF LEFT$(T$, 1) = " " THEN T$ = MID$(T$, 2)
   IF LEFT$(T2$, 1) = " " THEN T2$ = MID$(T2$, 2)
  LOOP
  T% = T% + 1
  FILE$(T%) = T$
  FILE$(T% + 25) = T2$
  PROG$(PD%) = LEFT$(PROG$(PD%), INSTR(PROG$(PD%), "(") - 1)
  
  FOR CD% = 1 TO T%
   C% = 0
   IF IsConst(FILE$(CD%)) THEN C% = 1
   IF IsCalc(FILE$(CD%)) THEN C% = 2
   IF INSTR(FILE$(CD% + 25), "()") <> 0 THEN C% = 3
   IF INSTR(FILE$(CD%), "%STRING") <> 0 THEN C% = 4

   IF C% = 0 OR C% = 1 OR C% = 2 THEN

    AddLine FILE$(CD% + 25) + " = " + FILE$(CD%), PD%
    PD% = PD% + 1
    IF C% = 0 AND NR% = 0 THEN
     AddLine FILE$(CD%) + " = " + FILE$(CD% + 25), PD% + 1
    END IF
   END IF

   'Pass array using SYSTEMPARRAY
   IF C% = 4 THEN
    AddLine "SYSTEMPARRAY()=" + FILE$(CD%), PD%
    FILE$(CD%) = "SYSTEMPARRAY()"
    PD% = PD% + 1
    C% = 3
   END IF

   'Pass array by reference
   IF C% = 3 THEN
    SA$ = FILE$(CD%)
    SA$ = LEFT$(SA$, INSTR(SA$, "(") - 1)
    
    DA$ = FILE$(CD% + 25)
    DA$ = LEFT$(DA$, INSTR(DA$, "(") - 1)
    
    'Find source array location
    FOR SA% = 1 TO ARC%
     IF SA$ = ArrayData$(SA%, 1) THEN EXIT FOR
    NEXT SA%
    
    'Create destination array if necessary
    AF% = 0
    FOR DA% = 1 TO ARC%
     IF DA$ = ArrayData$(DA%, 1) THEN AF% = 1: EXIT FOR
    NEXT DA%
    IF AF% = 0 THEN
     ARC% = ARC% + 1
     ArrayData$(ARC%, 1) = DA$
     ArrayData$(ARC%, 4) = "SUB"
    END IF
    
    'Set handler
    ArrayHandler$ = "Sys" + DA$ + "Handler"
    VLC% = VLC% + 1: VARLIST$(VLC%) = ArrayHandler$
    VLC% = VLC% + 1: VARLIST$(VLC%) = ArrayHandler$ + "_H"
    ArrayLoc% = VAL(ArrayData$(SA%, 2)) AND 255

    AddLine " movlw " + MID$(STR$(ArrayLoc%), 2), PD%
    AddLine " movwf " + ArrayHandler$, PD% + 1
    T% = 0
    IF VAL(ArrayData$(SA%, 2)) > 255 THEN T% = 1
    IF T% = 0 THEN AddLine " bcf " + ArrayHandler$ + "_H,0", PD% + 2
    IF T% = 1 THEN AddLine " bsf " + ArrayHandler$ + "_H,0", PD% + 2
    PD% = PD% + 3
   END IF
  NEXT CD%
 END IF
NEXTSUBPARAM:
IF PD% < APC% THEN GOTO REPSUBPARAM

END SUB

SUB TranslateFunctions

'Prepare list of functions
FC% = 0
FOR CD% = 1 TO SBC%
 IF INSTR(SUBDATA$(CD%, 1), "FN_") <> 0 THEN
  FC% = FC% + 1
  TempData$(FC%) = STR$(CD%)
 END IF
NEXT CD%

'Find functions
FOR DS% = 1 TO 2

 CD% = 0
FindFunctions:
  CD% = CD% + 1

FindFunctionsAgain:
  IF DS% = 1 THEN DS$ = PROG$(CD%)
  IF DS% = 2 THEN DS$ = SUBCODE$(CD%)
  
  'Run through list of functions
  FOR PD% = 1 TO FC%

   N$ = MID$(SUBDATA$(VAL(TempData$(PD%)), 1), 4)
   NO$ = N$
   IF INSTR(N$, "(") <> 0 THEN N$ = LEFT$(N$, INSTR(N$, "(") - 1)
   
   'Check to see if a line contains a function
   GOSUB FindContents

   'If it does, call a sub, and get the value after
   IF T% = 2 THEN
    'Replace the function in the line
    L$ = LEFT$(DS$, INSTR(DS$, N$) - 1)
    
    IF INSTR(NO$, "(") <> 0 THEN
     R$ = LTRIM$(RTRIM$(MID$(DS$, INSTR(DS$, N$) + LEN(N$))))
     BL% = 0
     FOR FB% = 1 TO LEN(R$)
      IF MID$(R$, FB%, 1) = "(" THEN BL% = BL% + 1
      IF MID$(R$, FB%, 1) = ")" THEN BL% = BL% - 1
      IF BL% = 0 THEN R$ = MID$(R$, FB% + 1): EXIT FOR
     NEXT FB%
    END IF

    IF INSTR(NO$, "(") = 0 THEN R$ = MID$(DS$, INSTR(DS$, N$) + LEN(N$))

    DSO$ = DS$
    Replace DSO$, L$, ""
    Replace DSO$, R$, ""
    DSO$ = LTRIM$(RTRIM$(DSO$))
    DS$ = L$ + "%F" + TempData$(PD%) + "F%" + R$
    
    DO WHILE INSTR(DS$, "%~%") <> 0
     Replace DS$, "%~%", N$
    LOOP
    
    IF DS% = 1 THEN
     PROG$(CD%) = DS$
     AddLine "FN_" + DSO$, CD%
     CD% = CD% + 1
     GOTO FindFunctionsAgain
    END IF

    IF DS% = 2 THEN
     SUBCODE$(CD%) = DS$
     AddSubLine "FN_" + DSO$, CD%
     CD% = CD% + 1
     GOTO FindFunctionsAgain
    END IF
   
   END IF
   
  NEXT PD%
         
 IF DS% = 1 AND CD% < APC% THEN GOTO FindFunctions
 IF DS% = 2 AND CD% < SDC% THEN GOTO FindFunctions
NEXT DS%

'Replace %F FN No. F% with function name
FOR DS% = 1 TO 2
 CD% = 0
CallFunctions:
  CD% = CD% + 1

  IF DS% = 1 THEN DS$ = PROG$(CD%)
  IF DS% = 2 THEN DS$ = SUBCODE$(CD%)
  IF INSTR(DS$, "%F") <> 0 AND INSTR(DS$, "F%") <> 0 THEN
   T% = VAL(MID$(DS$, INSTR(DS$, "%F") + 2))
   N$ = MID$(SUBDATA$(T%, 1), 4)
   IF INSTR(N$, "(") <> 0 THEN N$ = LEFT$(N$, INSTR(N$, "(") - 1)
   R$ = MID$(DS$, INSTR(DS$, "%F"))
   R$ = LEFT$(R$, INSTR(R$, "F%") + 1)
   Replace DS$, R$, N$
   IF DS% = 1 THEN PROG$(CD%) = DS$
   IF DS% = 2 THEN SUBCODE$(CD%) = DS$
   CD% = CD% - 1
  END IF
  
 IF DS% = 1 AND CD% < APC% THEN GOTO CallFunctions
 IF DS% = 2 AND CD% < SDC% THEN GOTO CallFunctions
NEXT DS%

EXIT SUB

'Check if function N$ is in DS$
FindContents:
 T% = 0
 IF INSTR(DS$, N$) <> 0 THEN
  IF LEN(DS$) = LEN(N$) THEN T% = 2

  IF INSTR(DS$, N$) = 1 THEN T% = 1
  IF T% = 0 THEN
   T$ = MID$(DS$, INSTR(DS$, N$) - 1, 1)
   IF T$ = " " THEN T% = 1
   IF T$ = "(" THEN T% = 1
   IF T$ = ")" THEN T% = 1
   IF T$ = "," THEN T% = 1
   IF T$ = "." THEN T% = 1
   IF T$ = ":" THEN T% = 1
   IF T$ = "+" THEN T% = 1
   IF T$ = "-" THEN T% = 1
   IF T$ = "*" THEN T% = 1
   IF T$ = "/" THEN T% = 1
   IF T$ = "=" THEN T% = 1
   IF T$ = "!" THEN T% = 1
   IF T$ = "<" THEN T% = 1
   IF T$ = ">" THEN T% = 1
  END IF

  IF INSTR(DS$, N$) + LEN(N$) - 1 = LEN(DS$) THEN T% = T% + 1
  IF T% < 2 THEN
   T$ = MID$(DS$, INSTR(DS$, N$) + LEN(N$), 1)
   IF T$ = " " THEN T% = T% + 1
   IF T$ = "(" THEN T% = T% + 1
   IF T$ = ")" THEN T% = T% + 1
   IF T$ = "," THEN T% = T% + 1
   IF T$ = "." THEN T% = T% + 1
   IF T$ = ":" THEN T% = T% + 1
   IF T$ = "+" THEN T% = T% + 1
   IF T$ = "-" THEN T% = T% + 1
   IF T$ = "*" THEN T% = T% + 1
   IF T$ = "/" THEN T% = T% + 1
   IF T$ = "=" THEN T% = T% + 1
   IF T$ = "!" THEN T% = T% + 1
   IF T$ = "<" THEN T% = T% + 1
   IF T$ = ">" THEN T% = T% + 1
  END IF
 END IF

 IF T% = 0 AND INSTR(DS$, N$) <> 0 THEN
  Replace DS$, N$, "%~%"
  GOTO FindContents
 END IF

 'Avoid calling functions from themselves
 IF DS% = 2 AND T% = 2 THEN
  S% = VAL(SUBDATA$(VAL(TempData$(PD%)), 2))
  E% = VAL(SUBDATA$(VAL(TempData$(PD%)), 3))
  IF CD% >= S% AND CD% - 1 <= E% THEN T% = 0: RETURN
 END IF
RETURN
 
END SUB

