'    Ultrasonic distance sensor routines for the GCBASIC compiler
'    Copyright (C) 2006 Hugh Considine

'    This library is free software; you can redistribute it and/or
'    modify it under the terms of the GNU Lesser General Public
'    License as published by the Free Software Foundation; either
'    version 2.1 of the License, or (at your option) any later version.

'    This library is distributed in the hope that it will be useful,
'    but WITHOUT ANY WARRANTY; without even the implied warranty of
'    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
'    Lesser General Public License for more details.

'    You should have received a copy of the GNU Lesser General Public
'    License along with this library; if not, write to the Free Software
'    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

'These routines were designed and tested with the SRF04 ultrasonic sensors. They have not been tried with any
'other models of ultrasonic sensor, and may require some modification to work.

'To read a sensor:
'	1. Use #define to set USUnits to mm, cm, feet or inch (Optional, defaults to cm)
'	2. If there is more than one sensor, set USSensors to the number of sensors
'	3. For each sensor, set USxPing and USxEcho to the trigger and echo ports
'	   respectively, where x is the number of the sensor
'	4. Call the function USDistance(US_Sensor), where US_Sensor is the number
'	   of the sensor to read. For example, to take a measurement with sensor 2
'	   and store the reading in the variable Distance:
'		Distance = USDistance(2)

'If a sensor that does not exist/is faulty is read, or if the reading is out of range,
'then the USDistance function will return 0.

'Initialisation (Prevents crash if a sensor is not attached)
#startup InitUSSensor

'Number of Sensors (Default 1, max 4)
#define USSensors 1

'Time for 1 unit
#define cm 54 us
#define mm 5 ms
#define inch 144 us
#define feet 44 10us

'Units (default cm) 
#define USUnits cm

'Sensor default I/O ports
#define US1Ping SysUSTemp.0
#define US1Echo SysUSTemp.0
#define US2Ping SysUSTemp.0
#define US2Echo SysUSTemp.0
#define US3Ping SysUSTemp.0
#define US3Echo SysUSTemp.0
#define US4Ping SysUSTemp.0
#define US4Echo SysUSTemp.0

function USDistance(US_Sensor)
 USDistance = 0

 'Send ping
 if US_Sensor = 1 then SET US1Ping ON: Wait 1 10us: SET US1Ping OFF
#ifdef USSensors 2,3,4
 if US_Sensor = 2 then SET US2Ping ON: Wait 1 10us: SET US2Ping OFF
#endif
#ifdef USSensors 3,4
 if US_Sensor = 3 then SET US3Ping ON: Wait 1 10us: SET US3Ping OFF
#endif
#ifdef USSensors 4
 if US_Sensor = 4 then SET US4Ping ON: Wait 1 10us: SET US4Ping OFF
#endif

 'Measure time for echo
 if US_Sensor = 1 then
  wait until US1Echo ON
  USDistance = 0
  do while US1Echo ON
   USDistance = USDistance + 1
   IF USDistance = 0 then exit function
   Wait USUnits
  loop
 end if
   
#ifdef USSensors 2,3,4
 if US_Sensor = 2 then
  wait until US2Echo ON
  USDistance = 0
  do while US2Echo ON
   USDistance = USDistance + 1
   IF USDistance = 0 then exit function
   Wait USUnits
  loop
 end if   
#endif
#ifdef USSensors 3,4
 if US_Sensor = 3 then
  wait until US3Echo ON
  USDistance = 0
  do while US3Echo ON
   USDistance = USDistance + 1
   IF USDistance = 0 then exit function
   Wait USUnits
  loop
 end if   
#endif
#ifdef USSensors 4
 if US_Sensor = 4 then
  wait until US4Echo ON
  USDistance = 0
  do while US4Echo ON
   USDistance = USDistance + 1
   IF USDistance = 0 then exit function
   Wait USUnits
  loop
 end if   
#endif

end function

sub InitUSSensor
 Set SysUSTemp.0 ON
end sub