'    Sound/Tone generation routines for the GCBASIC compiler
'    Copyright (C) 2006 Hugh Considine

'    This library is free software; you can redistribute it and/or
'    modify it under the terms of the GNU Lesser General Public
'    License as published by the Free Software Foundation; either
'    version 2.1 of the License, or (at your option) any later version.

'    This library is distributed in the hope that it will be useful,
'    but WITHOUT ANY WARRANTY; without even the implied warranty of
'    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
'    Lesser General Public License for more details.

'    You should have received a copy of the GNU Lesser General Public
'    License along with this library; if not, write to the Free Software
'    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

'********************************************************************************
'IMPORTANT:
'THIS FILE IS ESSENTIAL FOR SOME OF THE COMMANDS IN GCBASIC. DO NOT ALTER THIS FILE
'UNLESS YOU KNOW WHAT YOU ARE DOING. CHANGING THIS FILE COULD RENDER SOME GCBASIC
'COMMANDS UNUSABLE!
'********************************************************************************

#define SoundOut SysTemp.0 'Set to port for sound output

'Frequency is Hz/10, Duration is in 10 ms units
sub Tone (Frequency, Duration) #NR
 Period = 250/Frequency*2
 if Duration =< 4 then Frequency = Frequency/4
 if Duration > 4 then Duration = Duration/4

 for ToneLoop = 1 to Duration
  for ToneLoop2 = 1 to Frequency
   SET SoundOut ON
   ToneDelay
   SET SoundOut OFF
   ToneDelay
  next
 next
end sub

'Frequency is Hz/10, Duration is in 1 ms units
sub ShortTone (Frequency, Duration) #NR

 Period = 250/Frequency
 Frequency = Frequency / 10
 if Duration =< 4 then Frequency = Frequency/4
 if Duration > 4 then Duration = Duration/4

 for ToneLoop = 1 to Duration
  for ToneLoop2 = 1 to Frequency
   SET SoundOut ON
   ToneDelay
   SET SoundOut OFF
   ToneDelay
  next
 next
end sub

sub ToneDelay
 for ToneDelayLoop = 1 to Period
  Wait 9 10us
 next
end sub