'    Pulse Width Modulation routines for the GCBASIC compiler
'    Copyright (C) 2006 Hugh Considine

'    This library is free software; you can redistribute it and/or
'    modify it under the terms of the GNU Lesser General Public
'    License as published by the Free Software Foundation; either
'    version 2.1 of the License, or (at your option) any later version.

'    This library is distributed in the hope that it will be useful,
'    but WITHOUT ANY WARRANTY; without even the implied warranty of
'    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
'    Lesser General Public License for more details.

'    You should have received a copy of the GNU Lesser General Public
'    License along with this library; if not, write to the Free Software
'    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

'********************************************************************************
'IMPORTANT:
'THIS FILE IS ESSENTIAL FOR SOME OF THE COMMANDS IN GCBASIC. DO NOT ALTER THIS FILE
'UNLESS YOU KNOW WHAT YOU ARE DOING. CHANGING THIS FILE COULD RENDER SOME GCBASIC
'COMMANDS UNUSABLE!
'********************************************************************************

'Defaults:
#define PWM_Freq 38 'Frequency of PWM in KHz
#define PWM_Duty 50 'Duty cycle of PWM (%)

'Compile options
#define PWM_Count 1 'Number of PWM module modules available. Default is 1, but some chips support more)

#startup InitPWM

sub InitPWM
'Script to calculate constants required for given Frequency and Duty Cycle
#script
 PR2Temp = int((1/PWM_Freq)/(4*(1/(ChipMHz*1000))))
 T2PR = 1
 if PR2Temp > 255 then
  PR2Temp = int((1/PWM_Freq)/(16*(1/(ChipMHz*1000))))
  T2PR = 4
  if PR2Temp > 255 then
   PR2Temp = int((1/PWM_Freq)/(64*(1/(ChipMHz*1000))))
   T2PR = 16
   if PR2Temp > 255 then
    error Invalid PWM Frequency value
   end if
  end if
 end if

 DutyCycle = PWM_Duty*10.24
 DutyCycleH = (DutyCycle AND 1020)/4
 DutyCycleL = DutyCycle AND 3
#endscript

'Set PWM Period
PR2 = PR2Temp
#ifdef T2PR 1
 SET T2CON.T2CKPS0 OFF
 SET T2CON.T2CKPS1 OFF
#endif
#ifdef T2PR 4
 SET T2CON.T2CKPS0 ON
 SET T2CON.T2CKPS1 OFF
#endif
#ifdef T2PR 16
 SET T2CON.T2CKPS0 OFF
 SET T2CON.T2CKPS1 ON
#endif

'Set Duty cycle
CCPR1L = DutyCycleH
#ifdef DutyCycleL 0
 SET CCPCONCache.CCP1Y OFF
 SET CCPCONCache.CCP1X OFF
#endif
#ifdef DutyCycleL 1
 SET CCPCONCache.CCP1Y ON
 SET CCPCONCache.CCP1X OFF
#endif
#ifdef DutyCycleL 2
 SET CCPCONCache.CCP1Y OFF
 SET CCPCONCache.CCP1X ON
#endif
#ifdef DutyCycleL 3
 SET CCPCONCache.CCP1Y ON
 SET CCPCONCache.CCP1X ON
#endif

'Finish preparing CCP*CON
 SET CCPCONCache.CCP1M3 ON
 SET CCPCONCache.CCP1M2 ON
 SET CCPCONCache.CCP1M1 OFF
 SET CCPCONCache.CCP1M0 OFF

'Enable Timer 2
SET T2CON.TMR2ON ON

end sub

sub PWMOn
 CCP1CON = CCPCONCache
end sub

sub PWMOff
 CCP1CON = 0
end sub
