'    Liquid Crystal Display routines for the GCBASIC compiler
'    Copyright (C) 2006 Hugh Considine

'    This library is free software; you can redistribute it and/or
'    modify it under the terms of the GNU Lesser General Public
'    License as published by the Free Software Foundation; either
'    version 2.1 of the License, or (at your option) any later version.

'    This library is distributed in the hope that it will be useful,
'    but WITHOUT ANY WARRANTY; without even the implied warranty of
'    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
'    Lesser General Public License for more details.

'    You should have received a copy of the GNU Lesser General Public
'    License along with this library; if not, write to the Free Software
'    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

'********************************************************************************
'IMPORTANT:
'THIS FILE IS ESSENTIAL FOR SOME OF THE COMMANDS IN GCBASIC. DO NOT ALTER THIS FILE
'UNLESS YOU KNOW WHAT YOU ARE DOING. CHANGING THIS FILE COULD RENDER SOME GCBASIC
'COMMANDS UNUSABLE!
'********************************************************************************

#startup InitLCD

'I/O Ports
#define LCD_IO 4 'Number of pins used for LCD data bus (4 or 8)
#define LCD_DATA_PORT SysLCDTemp 'Port to connect to LCD data bus. Used in 8-bit mode
#define LCD_DB4 SysLCDTemp.0 'Output bit to interface with LCD data bus. Used in 4-bit mode
#define LCD_DB5 SysLCDTemp.0 'Output bit to interface with LCD data bus. Used in 4-bit mode
#define LCD_DB6 SysLCDTemp.0 'Output bit to interface with LCD data bus. Used in 4-bit mode
#define LCD_DB7 SysLCDTemp.0 'Output bit to interface with LCD data bus. Used in 4-bit mode

#define LCD_RS SysLCDTemp.0 'Output bit to control LCD Register Select
#define LCD_RW SysLCDTemp.0 'Output bit to select read/write
#define LCD_Enable SysLCDTemp.0 'Output bit to enable/disable LCD

'Misc Settings
#define LCD_Write_Delay 8 10us
#define FLASH 2

sub PUT (LCDPutLine, LCDPutColumn, LCDChar) #NR
 LOCATE LCDPutLine, LCDPutColumn
 LCDWriteChar(LCDChar)
end sub

function GET (LCDPutLine, LCDPutColumn)
 LOCATE LCDPutLine, LCDPutColumn
 set LCD_RS on
 GET = LCDReadByte
end function

sub CLS
 SET LCD_RS OFF
'Clear screen
 LCDWriteByte (b'00000001')
 wait 2 ms

'Move to start of visible DDRAM
 LCDWriteByte(0x80)
 wait 5 10us
end sub

sub PRINT (PrintData$)
 'PrintLen = LEN(PrintData$)
 PrintLen = PrintData(0)

 if PrintLen = 0 then goto NoPrintData
 
 'Write Data
 for SysPrintTemp = 1 to PrintLen
  LCDWriteChar(PrintData(SysPrintTemp))
 next

NoPrintData:
 'Move cursor to start of next line
 
end sub

'LCDColumn is 0 to screen width-1, LCDLine is 0 to screen height-1
sub LOCATE (LCDLine, LCDColumn) #NR
 set LCD_RS off
 if LCDLine > 1 then 
  LCDLine = LCDLine - 2
  LCDColumn = LCDColumn + 20
 end if
 LCDWriteByte(0x80 or 0x40 * LCDLine + LCDColumn)
 wait 5 10us
end sub

sub LCDInt(LCDValue) #NR
 LCDValueTemp = 0
 IF LCDValue >= 100 then 
  LCDValueTemp = LCDValue / 100
  LCDWriteChar(LCDValueTemp + 48)
  LCDValue = LCDValue - LCDValueTemp * 100
 end if
 IF LCDValueTemp > 0 or LCDValue >= 10 then
  LCDValueTemp = LCDValue / 10
  LCDWriteChar(LCDValueTemp + 48)
  LCDValue = LCDValue - LCDValueTemp * 10
 end if
 LCDWriteChar (LCDValue + 48)
end sub

sub LCDHex(LCDValue) #NR
 LCDValueTemp = 0
 IF LCDValue >= 0x10 then
  LCDValueTemp = LCDValue / 0x10
  LCDHexValueTemp = LCDValueTemp
  if LCDHexValueTemp > 9 then LCDHexValueTemp = LCDHexValueTemp + 7 
  LCDWriteChar(LCDHexValueTemp + 48)
  LCDValue = LCDValue - LCDValueTemp * 0x10
 end if
 LCDHexValueTemp = LCDValue
 if LCDHexValueTemp > 9 then LCDHexValueTemp = LCDHexValueTemp + 7
 LCDWriteChar (LCDHexValueTemp + 48)
end sub

sub LCDWriteChar(LCDChar) #NR
 set LCD_RS on
 LCDWriteByte(LCDChar)
end sub

function LCDReady
 LCDReady = FALSE
 SET LCD_RW ON
 SET LCD_RS OFF
 SET LCD_Enable ON
 wait 5 10us
#IFDEF LCD_IO 4
 dir LCD_DB7 IN
 if LCD_DB7 OFF THEN LCDReady = TRUE
#ENDIF
#IFDEF LCD_IO 8
 dir LCD_DATA_PORT 255
 if LCD_DATA_PORT.7 OFF THEN LCDReady = TRUE
#ENDIF
 SET LCD_Enable OFF
 wait 5 10us
end sub

sub LCDWriteByte(LCDByte) #NR
 wait until LCDReady

 set LCD_RW OFF 'Write mode

#IFDEF LCD_IO 4
 'Set pins to output
 DIR LCD_DB4 OUT
 DIR LCD_DB5 OUT
 DIR LCD_DB6 OUT
 DIR LCD_DB7 OUT

 'Write upper nibble to output pins
 set LCD_DB4 OFF
 set LCD_DB5 OFF
 set LCD_DB6 OFF
 set LCD_DB7 OFF
 if LCDByte.7 ON THEN SET LCD_DB7 ON
 if LCDByte.6 ON THEN SET LCD_DB6 ON
 if LCDByte.5 ON THEN SET LCD_DB5 ON
 if LCDByte.4 ON THEN SET LCD_DB4 ON

 'Pulse enable pin
 PULSEOUT LCD_Enable, 5 10us
 Wait 5 10us

 'Write lower nibble to output pins
 set LCD_DB4 OFF
 set LCD_DB5 OFF
 set LCD_DB6 OFF
 set LCD_DB7 OFF
 if LCDByte.3 ON THEN SET LCD_DB7 ON
 if LCDByte.2 ON THEN SET LCD_DB6 ON
 if LCDByte.1 ON THEN SET LCD_DB5 ON
 if LCDByte.0 ON THEN SET LCD_DB4 ON
 
 'Pulse enable pin
 PULSEOUT LCD_Enable, 5 10us
 Wait 5 10us

 'Set data pins low again
 SET LCD_DB7 OFF
 SET LCD_DB6 OFF
 SET LCD_DB5 OFF
 SET LCD_DB4 OFF
#ENDIF

#IFDEF LCD_IO 8
 'Set data port to output, and write a value to it
 DIR LCD_DATA_PORT 0
 LCD_DATA_PORT = LCDByte
 
 'Pulse enable pin
 PULSEOUT LCD_Enable, 5 10us
 Wait 5 10us
 
 'Clear port again, in case it is shared with something else
 LCD_DATA_PORT = 0
#ENDIF
end sub

function LCDReadByte
 set LCD_RW ON 'Read mode
 LCDReadByte = 0

#IFDEF LCD_IO 4
 'Set pins to input
 DIR LCD_DB4 IN
 DIR LCD_DB5 IN
 DIR LCD_DB6 IN
 DIR LCD_DB7 IN

 'Read upper nibble from input pins
 if LCD_DB7 ON then SET LCDReadByte.7 ON
 if LCD_DB6 ON THEN SET LCDReadByte.6 ON
 if LCD_DB5 ON then SET LCDReadByte.5 ON
 if LCD_DB4 ON THEN SET LCDReadByte.4 ON
 SET LCD_Enable ON
 Wait LCD_Write_Delay
 SET LCD_Enable OFF
 Wait 2 10us

 'Read lower nibble from input pins
 if LCD_DB7 ON then SET LCDReadByte.3 ON
 if LCD_DB6 ON THEN SET LCDReadByte.2 ON
 if LCD_DB5 ON then SET LCDReadByte.1 ON
 if LCD_DB4 ON THEN SET LCDReadByte.0 ON
 SET LCD_Enable ON
 Wait LCD_Write_Delay
 SET LCD_Enable OFF
 Wait 2 10us
#ENDIF

#IFDEF LCD_IO 8
 DIR LCD_DATA_PORT 255
 LCDReadByte = LCD_DATA_PORT
 SET LCD_Enable ON
 Wait LCD_Write_Delay
 SET LCD_Enable OFF
 Wait 2 10us
#ENDIF
end function

sub InitLCD
 DIR LCD_RS OUT
 DIR LCD_RW OUT
 DIR LCD_Enable OUT
 wait 10 ms
 Wait until LCDReady

'Set data bus width
 SET LCD_RS OFF
#IFDEF LCD_IO 8
 LCDWriteByte(b'00111000') 
#ENDIF
#IFDEF LCD_IO 4
 'LCDWriteByte(b'00100000')
 'Need to write nibble, so can't use LCDWriteByte
 wait until LCDReady
 DIR LCD_DB4 OUT
 DIR LCD_DB5 OUT
 DIR LCD_DB6 OUT
 DIR LCD_DB7 OUT
 set LCD_DB4 ON
 set LCD_DB5 ON
 set LCD_DB6 OFF
 set LCD_DB7 OFF
 SET LCD_Enable ON
 Wait 5 10us
 SET LCD_Enable OFF
 Wait 5 10us 
#ENDIF
 wait 5 10us

'Set Cursor movement
 SET LCD_RS OFF
 LCDWriteByte(b'00000110')
 wait 5 10us
'Turn off cursor
 LCDWriteByte(b'00001100')
 wait 5 10us

'Clear screen
 CLS
end sub

sub LCDCursor(LCDCRSR)
 'Can be ON, FLASH or OFF
 set LCD_RW OFF
 LCDTemp = 0
 if LCDCRSR = ON then LCDTemp = 2
 if LCDCRSR = FLASH then LCDTemp = 3
 if LCDCRSR = OFF then LCDTemp = 0
 LCDWriteByte(LCDTemp or 12)
 wait 5 10us
end sub
