'    EEPROM routines for the GCBASIC compiler
'    Copyright (C) 2006  Hugh Considine

'    This library is free software; you can redistribute it and/or
'    modify it under the terms of the GNU Lesser General Public
'    License as published by the Free Software Foundation; either
'    version 2.1 of the License, or (at your option) any later version.

'    This library is distributed in the hope that it will be useful,
'    but WITHOUT ANY WARRANTY; without even the implied warranty of
'    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
'    Lesser General Public License for more details.

'    You should have received a copy of the GNU Lesser General Public
'    License along with this library; if not, write to the Free Software
'    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

'********************************************************************************
'IMPORTANT:
'THIS FILE IS ESSENTIAL FOR SOME OF THE COMMANDS IN GCBASIC. DO NOT ALTER THIS FILE
'UNLESS YOU KNOW WHAT YOU ARE DOING. CHANGING THIS FILE COULD RENDER SOME GCBASIC
'COMMANDS UNUSABLE!
'********************************************************************************

'Updates:
' 3/5/2006: Program EEPROM read/write added
' 16/5/2006: Write disabled at end of EPWrite
' 23/5/2006: EPWrite and EPRead changed to stop use of temporary vars
' 19/8/2006: Program EEPROM altered to take input as word

sub EPWrite(EEADR, EEDATA) #NR
 IntStore = INTCON
 INTCON = 0
 SET EECON1.EEPGD OFF
 SET EECON1.WREN ON
 EECON2 = 0x55
 EECON2 = 0xAA
 SET EECON1.WR ON
 SET EECON1.WREN OFF
 WAIT WHILE EECON1.WR ON
 SET EECON1.WREN OFF
 INTCON = IntStore
end sub

sub EPRead(EEADR, EEDATA)
 IntStore = INTCON
 INTCON = 0
 SET EECON1.EEPGD OFF
 SET EECON1.RD ON
 Wait 1 us
 INTCON = IntStore
end sub

function ReadEP(EEADR)
 IntStore = INTCON
 INTCON = 0
 SET EECON1.EEPGD OFF
 SET EECON1.RD ON
 Wait 1 us
 ReadEP = EEDATA
 INTCON = IntStore
end sub

sub ProgramWrite(EEAddress as word, EEDataWord as word) #NR
 EEADR = EEAddress
 EEADRH = EEAddress_H
 EEDATA = EEDataWord
 EEDATH = EEDataWord_H

 IntStore = INTCON
 INTCON = 0
 SET EECON1.EEPGD ON
 SET EECON1.WREN ON
 SET EECON1.FREE OFF
 EECON2 = 0x55
 EECON2 = 0xAA
 SET EECON1.WR ON
 NOP
 NOP
 SET EECON1.WREN OFF
 INTCON = IntStore
end sub

sub ProgramRead(EEAddress as word, EEDataWord as word)
 EEADR = EEAddress
 EEADRH = EEAddress_H
 IntStore = INTCON
 INTCON = 0
 SET EECON1.EEPGD ON
 SET EECON1.RD ON
 NOP
 NOP
 INTCON = IntStore

 EEDataWord = EEDATA
 EEDataWord_H = EEDATH

end sub

sub ProgramErase(EEAddress as word)
 EEADR = EEAddress
 EEADRH = EEAddress_H

 IntStore = INTCON
 INTCON = 0
 SET EECON1.EEPGD ON
 SET EECON1.WREN ON
 SET EECON1.FREE ON
 EECON2 = 0x55
 EECON2 = 0xAA
 SET EECON1.WR ON
 NOP
 NOP
 SET EECON1.FREE OFF
 SET EECON1.WREN OFF
 INTCON = IntStore
end sub