'    Analog to Digital conversion routines for the GCBASIC compiler
'    Copyright (C) 2006 Hugh Considine

'    This library is free software; you can redistribute it and/or
'    modify it under the terms of the GNU Lesser General Public
'    License as published by the Free Software Foundation; either
'    version 2.1 of the License, or (at your option) any later version.

'    This library is distributed in the hope that it will be useful,
'    but WITHOUT ANY WARRANTY; without even the implied warranty of
'    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
'    Lesser General Public License for more details.

'    You should have received a copy of the GNU Lesser General Public
'    License along with this library; if not, write to the Free Software
'    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

'********************************************************************************
'IMPORTANT:
'THIS FILE IS ESSENTIAL FOR SOME OF THE COMMANDS IN GCBASIC. DO NOT ALTER THIS FILE
'UNLESS YOU KNOW WHAT YOU ARE DOING. CHANGING THIS FILE COULD RENDER SOME GCBASIC
'COMMANDS UNUSABLE!
'********************************************************************************

'Known Supported Chips:
'16F819
'16F872
'16F873/4/6/7
'Note: Many other PIC chips will work, but the documentation has not been checked.
'      The constants and subroutines in this file should support all PIC chips
'      that are equipped with analog-digital conversion modules.

'Commands:
'var = ReadAD(port)	Reads port, without prior setup. Recommended for its ease of use.

'ADPort(port)	Sets port to do AD on. Use 0 to set it off
'ADFormat(type)	Choose Left or Right justified
'ADOn		Set A/D converter on
'ADOff		Set A/D converter off
'ConvertAD	Start the conversion, and wait for it to finish

#define Format_Left 0
#define Format_Right 255

'Acquisition time. Can be reduced in some circumstances - see PIC manual for details
#define AD_Delay 2 10us

'Optimisation
#define ADSpeed MediumSpeed

#define HighSpeed 255
#define MediumSpeed 128
#define LowSpeed 0
#define InternalClock 192

'Port names
#define AN0 0
#define AN1 1
#define AN2 2
#define AN3 3
#define AN4 4
#define AN5 5
#define AN6 6
#define AN7 7

function ReadAD(ADReadPort)

'Set up A/D
 SET ADCON1.PCFG3 OFF
 SET ADCON1.PCFG2 OFF
 SET ADCON1.PCFG1 OFF
 SET ADCON1.PCFG0 OFF

'Set conversion clock
#IFDEF ADSpeed HighSpeed
 SET ADCON0.ADCS1 OFF
 SET ADCON0.ADCS0 OFF
#ENDIF
#IFDEF ADSpeed MediumSpeed
 SET ADCON0.ADCS1 OFF
 SET ADCON0.ADCS0 ON
#ENDIF
#IFDEF ADSpeed LowSpeed
 SET ADCON0.ADCS1 ON
 SET ADCON0.ADCS0 ON
#ENDIF
#IFDEF ADSpeed InternalClock
 SET ADCON0.ADCS1 ON
 SET ADCON0.ADCS0 ON
#ENDIF

'Choose port
 SET ADCON0.CHS0 OFF
 SET ADCON0.CHS1 OFF
 SET ADCON0.CHS2 OFF
 IF ADReadPort = AN1 THEN SET ADCON0.CHS0 ON
 IF ADReadPort = AN2 THEN SET ADCON0.CHS1 ON
 IF ADReadPort = AN3 THEN SET ADCON0.CHS0 ON: SET ADCON0.CHS1 ON
 IF ADReadPort > AN3 THEN SET ADCON0.CHS2 ON
 IF ADReadPort = AN5 THEN SET ADCON0.CHS0 ON
 IF ADReadPort = AN6 THEN SET ADCON0.CHS1 ON
 IF ADReadPort = AN7 THEN SET ADCON0.CHS0 ON: SET ADCON0.CHS1 ON

'Enable A/D
 SET ADCON0.ADON ON

'Acquisition Delay
 Wait AD_Delay
 
'Read A/D
 SET ADCON0.GO_DONE ON
 Wait While ADCON0.GO_DONE ON

'Switch off A/D
 SET ADCON0.ADON OFF
 SET ADCON1.PCFG3 OFF
 SET ADCON1.PCFG2 ON
 SET ADCON1.PCFG1 ON
 SET ADCON1.PCFG0 OFF

'Write output
 ReadAD = ADRESH
end function

sub ConvertAD
 SET ADCON0.GO_DONE ON
ConvertADWait:
 IF GO_DONE ON THEN GOTO ConvertADWait
end sub

sub ADOn
 SET ADCON1.PCFG3 OFF
 SET ADCON1.PCFG2 ON
 SET ADCON1.PCFG1 ON
 SET ADCON1.PCFG0 OFF
 SET ADCON0.ADCS1 OFF
 SET ADCON0.ADCS0 OFF
 SET ADCON0.ADON ON
end sub

sub ADPort(ADReadPort)
 SET ADCON0.CHS0 OFF
 SET ADCON0.CHS1 OFF
 SET ADCON0.CHS2 OFF
 IF ADReadPort = AN1 THEN SET ADCON0.CHS0 ON
 IF ADReadPort = AN2 THEN SET ADCON0.CHS1 ON
 IF ADReadPort = AN3 THEN SET ADCON0.CHS0 ON: SET ADCON0.CHS1 ON
 IF ADReadPort = AN4 THEN SET ADCON0.CHS2 ON
end sub

sub ADFormat(ADReadFormat)
 SET ADCON1.ADFM OFF
 IF ADReadFormat.1 ON THEN SET ADCON1.ADFM ON  
end sub

sub ADOff
'Disable the A/D converter, and set all ports to digital.
 SET ADCON0.ADON OFF
 SET ADCON1.PCFG3 OFF
 SET ADCON1.PCFG2 ON
 SET ADCON1.PCFG1 ON
 SET ADCON1.PCFG0 OFF
end sub