DECLARE FUNCTION IsWord! (DS$)
DECLARE FUNCTION GetByte$ (DS$, BS%)
DECLARE FUNCTION AsmTidy$ (DS$)
DECLARE FUNCTION TypeOfVar$ (VarName$)
DECLARE FUNCTION WholeINSTR (DS$, N$)
DECLARE FUNCTION CompleteINSTR! ()
DECLARE FUNCTION MakeDec! (DS$)
DECLARE SUB CompileCalc (SUM$)
DECLARE SUB AddLine (DS$, T%)
DECLARE SUB DelLine (T%)
DECLARE FUNCTION CountOccur! (Source$, Search$)
DECLARE FUNCTION CheckLine! (DS$)
DECLARE FUNCTION IsCalc! (DS$)
DECLARE FUNCTION IsConst! (T$)
DECLARE SUB SCICONV (ST$)
DECLARE SUB Replace (VAR$, FIND$, REP$)

COMMON SHARED APC%, ICC%, DFC%, VLC%, SBC%, SDC%, SLC%, IFC%, ERC%, WSC%, FLC%, DLC%, ARC%, SSC%, SASC%, POC%
COMMON SHARED CSC%, CV%, COSC%, MemSize%, FreeRAM%, FoundCount%, PotFound%, ThisCalc%, LongPresent%, DivMultPresent%
COMMON SHARED ChipName$, ChipMhz, OSC$, CONFIG$, Int$, ChipRam%
COMMON SHARED FI$, OFI$, ID$, VBS%, Version$, SVC%, ProgDir$, CLD$, MakeASM$, ProgWillFail%

COMMON SHARED TempData$(), VARLIST$(), CheckTemp$(), VarType$()
DIM SHARED FILE$(100)
DIM SHARED TempData$(100)
DIM SHARED VARLIST$(400)
DIM SHARED CheckTemp$(100)
DIM SHARED VarType$(400)

FUNCTION AsmTidy$ (DS$)

T$ = DS$

IF LEFT$(T$, 1) = ";" THEN AsmTidy$ = T$: EXIT FUNCTION

Replace T$, " ", CHR$(9)
Replace T$, " ", CHR$(9)

AsmTidy$ = T$

END FUNCTION

SUB CalcConfig

'Add #OSC to CONFIG
IF OSC$ <> "" THEN
 IF INSTR(OSC$, "OSC") = 0 THEN OSC$ = OSC$ + "_OSC"
 IF CONFIG$ <> "" THEN T$ = ","
 CONFIG$ = CONFIG$ + T$ + OSC$
END IF

'Set defaults for WDT and LVP
IF INSTR(CONFIG$, "WDT_") = 0 THEN
 IF CONFIG$ <> "" THEN T$ = ","
 CONFIG$ = CONFIG$ + T$ + "WDT_OFF"
END IF
T$ = LEFT$(ChipName$, 2)

IF INSTR(CONFIG$, "LVP_") = 0 AND T$ <> "10" AND T$ <> "12" THEN
 IF CONFIG$ <> "" THEN T$ = ","
 CONFIG$ = CONFIG$ + T$ + "LVP_OFF"
END IF

'Prepare CONFIG
DO WHILE INSTR(CONFIG$, " ") <> 0: Replace CONFIG$, " ", "": LOOP
DO WHILE INSTR(CONFIG$, ",_") <> 0: Replace CONFIG$, ",_", ",": LOOP
IF LEFT$(CONFIG$, 1) = "_" THEN CONFIG$ = MID$(CONFIG$, 2)

T% = 0
ADDDASH:
T% = T% + 1
IF MID$(CONFIG$, T%, 1) = "," THEN CONFIG$ = LEFT$(CONFIG$, T%) + "_" + RIGHT$(CONFIG$, LEN(CONFIG$) - T%)
IF T% < LEN(CONFIG$) THEN GOTO ADDDASH
IF CONFIG$ <> "" THEN CONFIG$ = "_" + CONFIG$


DO WHILE INSTR(CONFIG$, ",") <> 0: Replace CONFIG$, ",", " & ": LOOP

END SUB

SUB Calculate (SUM$)

SUM$ = UCASE$(SUM$)

REM Replace AND, OR, NOT, XOR with symbols
REPLOGIC:
IF INSTR(SUM$, "AND") <> 0 THEN Replace SUM$, "AND", "&": GOTO REPLOGIC
IF INSTR(SUM$, "OR") <> 0 THEN Replace SUM$, "OR", "|": GOTO REPLOGIC
IF INSTR(SUM$, "XOR") <> 0 THEN Replace SUM$, "XOR", "#": GOTO REPLOGIC

BEGINCALC:
REM Remove all Spaces
Replace SUM$, " ", ""
IF INSTR(SUM$, " ") <> 0 THEN GOTO BEGINCALC
SUM$ = " " + LCASE$(SUM$)
IF INSTR(SUM$, "%") <> 0 THEN GOTO PERCDIFF

REM Calculate Sine, Cosine, Tangent, Arctangent and Pi
PISWAP:
IF INSTR(SUM$, "pi") <> 0 THEN
 Replace SUM$, "pi", "3.14159"
 GOTO PISWAP
END IF

INSMULT:
IF INSTR(SUM$, ")(") <> 0 THEN
 Replace SUM$, ")(", ")*("
 GOTO INSMULT
END IF

FILE$(1) = "cos("
FILE$(2) = "sin("
FILE$(3) = "tan("
FILE$(4) = "atn("
FILE$(5) = "sqr("
FILE$(6) = "abs("
FILE$(7) = "sgn("
FILE$(8) = "int("
FILE$(9) = "log("

FOR CA% = 1 TO 9
CALCLOOP:
 IF INSTR(LCASE$(SUM$), FILE$(CA%)) <> 0 THEN

  CT$ = ""
  PD% = INSTR(LCASE$(SUM$), FILE$(CA%)) + 4
  T% = 1
GETFUNCTION:
   CT$ = CT$ + MID$(SUM$, PD%, 1)
   IF MID$(SUM$, PD%, 1) = "(" THEN T% = T% + 1
   IF MID$(SUM$, PD%, 1) = ")" THEN T% = T% - 1
   PD% = PD% + 1
  IF T% > 0 THEN GOTO GETFUNCTION
  CT$ = LEFT$(CT$, LEN(CT$) - 1)

  OSS$ = FILE$(CA%) + CT$ + ")"
  CLDO$ = CLD$
  CLD$ = "no"
  Calculate CT$
  CLD$ = CLDO$

  IF CA% = 1 THEN CT$ = STR$(COS(VAL(CT$)))
  IF CA% = 2 THEN CT$ = STR$(SIN(VAL(CT$)))
  IF CA% = 3 THEN CT$ = STR$(TAN(VAL(CT$)))
  IF CA% = 4 THEN CT$ = STR$(ATN(VAL(CT$)))
  IF CA% = 5 THEN CT$ = STR$(SQR(VAL(CT$)))
  IF CA% = 6 THEN CT$ = STR$(ABS(VAL(CT$)))
  IF CA% = 7 THEN CT$ = STR$(SGN(VAL(CT$)))
  IF CA% = 8 THEN CT$ = STR$(INT(VAL(CT$)))
  IF CA% = 9 THEN CT$ = STR$(LOG(VAL(CT$)))
  SCICONV CT$
  IF LEFT$(CT$, 1) = " " THEN CT$ = MID$(CT$, 2)
  Replace SUM$, OSS$, CT$
  'IF CLD$ = "" THEN PRINT SUM$
  GOTO CALCLOOP
 END IF
NEXT CA%

REM Solve Brackets using recursion
BRACKETS:
IF INSTR(SUM$, "(") = 0 AND INSTR(SUM$, ")") = 0 THEN GOTO ENDBRACKET
TS$ = ""
PD% = INSTR(SUM$, "(")
T% = 0
GETBRACKET:
 TS$ = TS$ + MID$(SUM$, PD%, 1)
 IF MID$(SUM$, PD%, 1) = "(" THEN T% = T% + 1
 IF MID$(SUM$, PD%, 1) = ")" THEN T% = T% - 1
 PD% = PD% + 1
IF T% > 0 THEN GOTO GETBRACKET
OSS$ = TS$
Replace TS$, "(", "": Replace TS$, ")", ""

CLDO$ = CLD$
CLD$ = "no"
Calculate TS$
SCICONV TS$
CLD$ = CLDO$
DO WHILE INSTR(TS$, " ") <> 0: Replace TS$, " ", "": LOOP
Replace SUM$, OSS$, TS$
GOTO BRACKETS
ENDBRACKET:

REM Find Exponentiation
EXPONENT:
IF INSTR(SUM$, "^") = 0 THEN GOTO ENDEXPONENT
FD% = 0
FINDEXP:
FD% = FD% + 1
T$ = MID$(SUM$, FD%, 1)
IF T$ <> "^" THEN GOTO FINDEXP
ACT$ = T$: AP = FD%

FOR FS% = AP - 1 TO 1 STEP -1
 T$ = MID$(SUM$, FS%, 1)
 IF (T$ <> RIGHT$(STR$(VAL(T$)), 1) AND T$ <> "." AND T$ <> "-" AND T$ <> "E") OR T$ = " " THEN FS% = FS% + 1: EXIT FOR
 M$ = MID$(SUM$, FS% - 1, 1)
 IF T$ = "-" AND (M$ <> "^" AND M$ <> "/" AND M$ <> "*" AND M$ <> "-" AND M$ <> "+" AND M$ <> "&" AND M$ <> "#" AND M$ <> "|" AND M$ <> "!") THEN EXIT FOR
NEXT FS%

N1$ = MID$(SUM$, FS%, AP - FS%)
N1 = VAL(N1$)
N2$ = MID$(SUM$, AP + 1)

IF INSTR(N2$, "^") <> 0 THEN N2$ = LEFT$(N2$, INSTR(N2$, "^") - 1)
IF INSTR(N2$, "/") <> 0 THEN N2$ = LEFT$(N2$, INSTR(N2$, "/") - 1)
IF INSTR(N2$, "*") <> 0 THEN N2$ = LEFT$(N2$, INSTR(N2$, "*") - 1)
IF INSTR(2, N2$, "-") <> 0 THEN N2$ = LEFT$(N2$, INSTR(2, N2$, "-") - 1)
IF INSTR(N2$, "+") <> 0 THEN N2$ = LEFT$(N2$, INSTR(N2$, "+") - 1)

N2 = VAL(N2$)
OS$ = N1$ + ACT$ + N2$
DO WHILE INSTR(OS$, " ") <> 0
Replace OS$, " ", ""
LOOP

IF N1 = 0 AND N2 = 0 THEN Replace SUM$, OS$, "0": GOTO EXPONENT

ANS$ = ""
'IF CLD$ = "" THEN PRINT SUM$

RES = N1 ^ N2

ANS$ = STR$(RES)
IF LEFT$(ANS$, 1) = " " THEN ANS$ = MID$(ANS$, 2)
SCICONV ANS$
IF LEFT$(ANS$, 1) = " " THEN ANS$ = MID$(ANS$, 2)
Replace SUM$, OS$, ANS$
GOTO EXPONENT
ENDEXPONENT:

REM Find Division and Multiplication
DIVMULT:
IF INSTR(SUM$, "/") = 0 AND INSTR(SUM$, "*") = 0 AND INSTR(SUM$, "x") = 0 THEN GOTO ENDDIVMULT
FD% = 0
FINDDIV:
FD% = FD% + 1
T$ = MID$(SUM$, FD%, 1)
IF T$ <> "/" AND T$ <> "*" AND T$ <> "x" THEN GOTO FINDDIV
ACT$ = T$: AP = FD%

FOR FS% = AP - 1 TO 1 STEP -1
 T$ = MID$(SUM$, FS%, 1)
 IF (T$ <> MID$(STR$(VAL(T$)), 2) AND T$ <> ".") OR T$ = " " THEN FS% = FS% + 1: EXIT FOR
 M$ = MID$(SUM$, FS% - 1, 1)
 IF T$ = "-" AND (M$ <> LTRIM$(STR$(VAL(M$))) AND M$ <> "^" AND M$ <> "/" AND M$ <> "*" AND M$ <> "-" AND M$ <> "+" AND M$ <> "&" AND M$ <> "#" AND M$ <> "|" AND M$ <> "!") THEN FS% = FS% - 1: EXIT FOR
NEXT FS%

N1$ = MID$(SUM$, FS%, AP - FS%)
N1 = VAL(N1$)
N2$ = MID$(SUM$, AP + 1)

IF INSTR(N2$, "/") <> 0 THEN N2$ = LEFT$(N2$, INSTR(N2$, "/") - 1)
IF INSTR(N2$, "*") <> 0 THEN N2$ = LEFT$(N2$, INSTR(N2$, "*") - 1)
IF INSTR(2, N2$, "-") <> 0 THEN N2$ = LEFT$(N2$, INSTR(2, N2$, "-") - 1)
IF INSTR(N2$, "+") <> 0 THEN N2$ = LEFT$(N2$, INSTR(N2$, "+") - 1)

N2 = VAL(N2$)
OS$ = N1$ + ACT$ + N2$
DO WHILE INSTR(OS$, " ") <> 0
Replace OS$, " ", ""
LOOP
'IF CLD$ = "" THEN PRINT SUM$

RES = 0
IF ACT$ = "/" AND N2 <> 0 THEN RES = N1 / N2
IF ACT$ = "*" THEN RES = N1 * N2
ANS$ = STR$(RES)
SCICONV ANS$
DO WHILE INSTR(ANS$, " ") <> 0: Replace ANS$, " ", "": LOOP
Replace SUM$, OS$, ANS$
GOTO DIVMULT
ENDDIVMULT:

REM Replace all occurances of "--" with "+"
REMMINUS:
IF INSTR(SUM$, "--") <> 0 THEN
 Replace SUM$, "--", "+"
 GOTO REMMINUS
END IF
IF INSTR(SUM$, "+-") <> 0 THEN
 Replace SUM$, "+-", "-"
 GOTO REMMINUS
END IF

REM Addition and Subtraction
FD% = 0
ADDSUB:
IF INSTR(SUM$, "+") = 0 AND INSTR(FD% + 1, SUM$, "-") = 0 THEN GOTO ENDADDSUB
FINDADD:
 FD% = FD% + 1
 T$ = MID$(SUM$, FD%, 1)
IF T$ <> "+" AND T$ <> "-" THEN GOTO FINDADD

ACT$ = T$: AP = FD%
FOR FS% = AP - 1 TO 1 STEP -1
 T$ = MID$(SUM$, FS%, 1)
 IF (T$ <> RIGHT$(STR$(VAL(T$)), 1) AND T$ <> "." AND T$ <> "-" AND T$ <> "E") OR T$ = " " THEN FS% = FS% + 1: EXIT FOR
 M$ = MID$(SUM$, FS% - 1, 1)
 IF T$ = "-" AND (M$ <> "^" AND M$ <> "/" AND M$ <> "*" AND M$ <> "-" AND M$ <> "+" AND M$ <> "&" AND M$ <> "#" AND M$ <> "|" AND M$ <> "!") THEN FS% = FS% - 1: EXIT FOR
NEXT FS%

N1$ = MID$(SUM$, FS%, AP - FS%)
IF N1$ = " " OR N1$ = "" THEN GOTO ADDSUB
N1 = VAL(N1$)
N2$ = MID$(SUM$, AP + 1)

IF INSTR(2, N2$, "-") <> 0 THEN N2$ = LEFT$(N2$, INSTR(2, N2$, "-") - 1)
IF INSTR(N2$, "+") <> 0 THEN N2$ = LEFT$(N2$, INSTR(N2$, "+") - 1)
IF INSTR(N2$, "&") <> 0 THEN N2$ = LEFT$(N2$, INSTR(N2$, "&") - 1)
IF INSTR(N2$, "|") <> 0 THEN N2$ = LEFT$(N2$, INSTR(N2$, "|") - 1)
IF INSTR(N2$, "#") <> 0 THEN N2$ = LEFT$(N2$, INSTR(N2$, "#") - 1)

N2 = VAL(N2$)
OS$ = N1$ + ACT$ + N2$
DO WHILE INSTR(OS$, " ") <> 0
Replace OS$, " ", ""
LOOP
'IF CLD$ = "" THEN PRINT SUM$

IF ACT$ = "+" THEN ANS$ = STR$(N1 + N2)
IF ACT$ = "-" THEN ANS$ = STR$(N1 - N2)
IF LEFT$(ANS$, 1) = " " THEN ANS$ = MID$(ANS$, 2)
IF N1 = 0 AND N2 <> 0 AND ACT$ = "-" THEN FD% = FD% + 1: GOTO ADDSUB
SCICONV ANS$
Replace SUM$, OS$, ANS$
FD% = FD% + LEN(OS$) - LEN(ANS$) + 1
FD% = 0

MINUS:
IF INSTR(SUM$, "--") <> 0 THEN
 Replace SUM$, "--", "+"
 GOTO MINUS
END IF
GOTO ADDSUB
ENDADDSUB:

REM Find Logical operation results (AND, OR, XOR)
LOGICALOP:
IF INSTR(SUM$, "&") = 0 AND INSTR(SUM$, "|") = 0 AND INSTR(SUM$, "#") = 0 THEN GOTO ENDLOGICALOP
FD% = 0
FINDLOGIC:
FD% = FD% + 1
T$ = MID$(SUM$, FD%, 1)
IF T$ <> "&" AND T$ <> "|" AND T$ <> "#" THEN GOTO FINDLOGIC
ACT$ = T$: AP = FD%

FOR FS% = AP - 1 TO 1 STEP -1
 T$ = MID$(SUM$, FS%, 1)
 IF (T$ <> MID$(STR$(VAL(T$)), 2) AND T$ <> ".") OR T$ = " " THEN FS% = FS% + 1: EXIT FOR
 M$ = MID$(SUM$, FS% - 1, 1)
 IF T$ = "-" AND (M$ <> LTRIM$(STR$(VAL(M$))) AND M$ <> "^" AND M$ <> "/" AND M$ <> "*" AND M$ <> "-" AND M$ <> "+" AND M$ <> "&" AND M$ <> "#" AND M$ <> "|" AND M$ <> "!") THEN FS% = FS% - 1: EXIT FOR
NEXT FS%

N1$ = MID$(SUM$, FS%, AP - FS%)
N1 = VAL(N1$)
N2$ = MID$(SUM$, AP + 1)

IF INSTR(N2$, "/") <> 0 THEN N2$ = LEFT$(N2$, INSTR(N2$, "/") - 1)
IF INSTR(N2$, "*") <> 0 THEN N2$ = LEFT$(N2$, INSTR(N2$, "*") - 1)
IF INSTR(2, N2$, "-") <> 0 THEN N2$ = LEFT$(N2$, INSTR(2, N2$, "-") - 1)
IF INSTR(N2$, "+") <> 0 THEN N2$ = LEFT$(N2$, INSTR(N2$, "+") - 1)
IF INSTR(N2$, "&") <> 0 THEN N2$ = LEFT$(N2$, INSTR(N2$, "&") - 1)
IF INSTR(N2$, "|") <> 0 THEN N2$ = LEFT$(N2$, INSTR(N2$, "|") - 1)
IF INSTR(N2$, "#") <> 0 THEN N2$ = LEFT$(N2$, INSTR(N2$, "#") - 1)

N2 = VAL(N2$)
OS$ = N1$ + ACT$ + N2$
DO WHILE INSTR(OS$, " ") <> 0
Replace OS$, " ", ""
LOOP
'IF CLD$ = "" THEN PRINT SUM$

RES = 0
IF ACT$ = "&" AND N2 <> 0 THEN RES = N1 AND N2
IF ACT$ = "|" THEN RES = N1 OR N2
IF ACT$ = "#" THEN RES = N1 XOR N2
ANS$ = STR$(RES)
SCICONV ANS$
DO WHILE INSTR(ANS$, " ") <> 0: Replace ANS$, " ", "": LOOP
Replace SUM$, OS$, ANS$
GOTO LOGICALOP
ENDLOGICALOP:

REM Test Sum
TESTSUM:
IF INSTR(SUM$, "=") = 0 AND INSTR(SUM$, "<") = 0 AND INSTR(SUM$, ">") = 0 THEN GOTO ENDTESTSUM
FD% = 0
FINDTEST:
FD% = FD% + 1
T$ = MID$(SUM$, FD%, 1)
IF T$ <> "=" AND T$ <> "<" AND T$ <> ">" THEN GOTO FINDTEST
ACT$ = T$: AP = FD%

FOR FS% = AP - 1 TO 1 STEP -1
T$ = MID$(SUM$, FS%, 1)
IF (T$ <> MID$(STR$(VAL(T$)), 2) AND T$ <> "." AND T$ <> "-" AND T$ <> "E") OR T$ = " " THEN FS% = FS% + 1: EXIT FOR
M$ = MID$(SUM$, FS% - 1, 1)
IF T$ = "-" AND (M$ <> "^" AND M$ <> "/" AND M$ <> "*" AND M$ <> "-" AND M$ <> "+") THEN FS% = FS% - 1: EXIT FOR
NEXT FS%

N1$ = MID$(SUM$, FS%, AP - FS%)
N1 = VAL(N1$)
N2$ = MID$(SUM$, AP + 1)

IF INSTR(N2$, "=") <> 0 THEN N2$ = LEFT$(N2$, INSTR(N2$, "=") - 1)
IF INSTR(N2$, "<") <> 0 THEN N2$ = LEFT$(N2$, INSTR(N2$, "<") - 1)
IF INSTR(N2$, ">") <> 0 THEN N2$ = LEFT$(N2$, INSTR(N2$, ">") - 1)
IF INSTR(2, N2$, "-") <> 0 THEN N2$ = LEFT$(N2$, INSTR(2, N2$, "-") - 1)
IF INSTR(N2$, "+") <> 0 THEN N2$ = LEFT$(N2$, INSTR(N2$, "+") - 1)

N2 = VAL(N2$)
OS$ = N1$ + ACT$ + N2$
DO WHILE INSTR(OS$, " ") <> 0
Replace OS$, " ", ""
LOOP
'IF CLD$ = "" THEN PRINT SUM$

IF ACT$ = "=" THEN RES = (N1 = N2) * -1
IF ACT$ = "<" THEN RES = (N1 < N2) * -1
IF ACT$ = ">" THEN RES = (N1 > N2) * -1
ANS$ = STR$(RES)
SCICONV ANS$
IF LEFT$(ANS$, 1) = " " THEN ANS$ = RIGHT$(ANS$, LEN(ANS$) - 1)
Replace SUM$, OS$, ANS$
GOTO TESTSUM
ENDTESTSUM:

REM End of normal calculate
SOL = VAL(SUM$)
EXIT SUB

REM Percentage Section
PERCDIFF:
FD% = 0
FINDSIGN:
FD% = FD% + 1
T$ = MID$(SUM$, FD%, 1)
IF T$ <> "+" AND T$ <> "." AND T$ <> "-" AND T$ <> "x" AND T$ <> "*" AND T$ <> "/" THEN GOTO FINDSIGN
ACT$ = T$: AP = FD%

FOR FS% = AP - 1 TO 1 STEP -1
T$ = MID$(SUM$, FS%, 1)
IF T$ <> RIGHT$(STR$(VAL(T$)), 1) OR T$ = " " AND T$ <> "." THEN EXIT FOR
NEXT FS%

N1 = VAL(MID$(SUM$, FS%, AP - FS%))
N2 = VAL(RIGHT$(SUM$, LEN(SUM$) - AP))
ACT2$ = RIGHT$(SUM$, 1)

IF ACT$ = "+" THEN SOL = (N2 + N1) / N2 * 100
IF ACT$ = "-" THEN SOL = (N2 - N1) / N2 * 100
IF ACT$ = "/" THEN SOL = N1 / N2 * 100
IF ACT$ = "x" OR ACT$ = "*" THEN
 SOL = N1 * (N2 / 100)
 IF ACT2$ = "+" THEN SOL = SOL + N1
 IF ACT2$ = "-" THEN SOL = SOL - N1
END IF
SOL = SOL * SGN(SOL)
SUM$ = STR$(SOL)
END SUB

FUNCTION CheckLine (DS$)

'Check that the line is a known command, and that it has all necessary parameters

'Tidy assembly instructions
T% = 35
TempData$(1) = "ADDWF"
TempData$(2) = "ANDWF"
TempData$(3) = "CLRF"
TempData$(4) = "CLRW"
TempData$(5) = "COMF"
TempData$(6) = "DECF"
TempData$(7) = "DECFSZ"
TempData$(8) = "INCF"
TempData$(9) = "INCFSZ"
TempData$(10) = "IORWF"
TempData$(11) = "MOVF"
TempData$(12) = "MOVWF"
TempData$(13) = "NOP"
TempData$(14) = "RLF"
TempData$(15) = "RRF"
TempData$(16) = "SUBWF"
TempData$(17) = "SWAPF"
TempData$(18) = "XORWF"
TempData$(19) = "BCF"
TempData$(20) = "BSF"
TempData$(21) = "BTFSC"
TempData$(22) = "BTFSS"
TempData$(23) = "ADDLW"
TempData$(24) = "ANDLW"
TempData$(25) = "CALL"
TempData$(26) = "CLRWDT"
TempData$(27) = "IORLW"
TempData$(28) = "MOVLW"
TempData$(29) = "RETFIE"
TempData$(30) = "RETLW"
TempData$(31) = "RETURN"
TempData$(32) = "SLEEP"
TempData$(33) = "SUBLW"
TempData$(34) = "XORLW"
TempData$(35) = "RETURN"

FOR PD% = 1 TO T%
 IF LEFT$(DS$, LEN(TempData$(PD%)) + 1) = TempData$(PD%) + " " THEN
  DS$ = LCASE$(LEFT$(DS$, LEN(TempData$(PD%)))) + MID$(DS$, LEN(TempData$(PD%)) + 1)
  DS$ = " " + DS$
 END IF
NEXT


END FUNCTION

SUB CompileCalc (SUM$)

DO WHILE INSTR(SUM$, "--") <> 0: Replace SUM$, "--", "+": LOOP
DO WHILE INSTR(SUM$, "+-") <> 0: Replace SUM$, "+-", "-": LOOP

'Calculate brackets
CALCBRACKET:
 IF INSTR(SUM$, "(") <> 0 THEN

  T$ = MID$(SUM$, INSTR(SUM$, "("))
  BL% = 1
  FOR T% = 2 TO LEN(T$)
   IF MID$(T$, T%, 1) = "(" THEN BL% = BL% + 1
   IF MID$(T$, T%, 1) = ")" THEN BL% = BL% - 1
   IF BL% = 0 THEN T$ = LEFT$(T$, T%): EXIT FOR
  NEXT T%

  T2$ = MID$(T$, 2)
  T2$ = LEFT$(T2$, LEN(T2$) - 1)
  CompileCalc T2$
  Replace SUM$, T$, T2$
  GOTO CALCBRACKET
 END IF

 'Calculate *, /. Replace sum with variable containing answer
CALCMULTDIV:
 IF INSTR(SUM$, "*") <> 0 OR INSTR(SUM$, "/") <> 0 THEN
  'Read the sum
  FS% = 0
FINDMULT:
   FS% = FS% + 1
   ACT$ = MID$(SUM$, FS%, 1)
  IF ACT$ <> "*" AND ACT$ <> "/" THEN GOTO FINDMULT
  FV% = 0
  FOR T% = FS% - 1 TO 1 STEP -1
   T$ = MID$(SUM$, T%, 1)
   IF T$ = "{" OR T$ = "}" OR T$ = "=" OR T$ = "~" OR T$ = "<" OR T$ = ">" OR T$ = "*" OR T$ = "/" OR T$ = "+" OR T$ = "-" OR T$ = "&" OR T$ = "|" OR T$ = "#" OR T$ = "!" THEN FV% = T%: EXIT FOR
  NEXT T%
  V1$ = LEFT$(SUM$, INSTR(SUM$, ACT$) - 1): V1$ = MID$(V1$, FV% + 1)
  FOR T% = FS% + 1 TO LEN(SUM$)
   T$ = MID$(SUM$, T%, 1)
   IF T$ = "{" OR T$ = "}" OR T$ = "=" OR T$ = "~" OR T$ = "<" OR T$ = ">" OR T$ = "*" OR T$ = "/" OR T$ = "+" OR T$ = "-" OR T$ = "&" OR T$ = "|" OR T$ = "#" OR T$ = "!" THEN FV% = T%: EXIT FOR
   T$ = " "
  NEXT T%
  V2$ = MID$(SUM$, FS% + 1)
  IF INSTR(V2$, T$) < LEN(V2$) AND INSTR(V2$, T$) <> 0 THEN V2$ = LEFT$(V2$, INSTR(V2$, T$) - 1)
  V1O$ = V1$: V2O$ = V2$

 'Generate asm code for sum
  'Check if both are constants
  IF IsConst(V1$) AND IsConst(V2$) THEN
   IF ACT$ = "*" THEN AV$ = MID$(STR$(MakeDec(V1$) * MakeDec(V2$)), 2)
   IF ACT$ = "/" THEN AV$ = MID$(STR$(INT(MakeDec(V1$) / MakeDec(V2$))), 2)
   GOTO MultDivAnswer
  END IF
  
  'Declare SysCalcTempA, SysCalcTempB and SysCalcTempX
  IF LongPresent% = 0 THEN
   VLC% = VLC% + 1: VARLIST$(VLC%) = "SysCalcTempA"
   VLC% = VLC% + 1: VARLIST$(VLC%) = "SysCalcTempB"
   VLC% = VLC% + 1: VARLIST$(VLC%) = "SysCalcTempX"
  END IF

  IF ACT$ = "/" THEN
   VLC% = VLC% + 1: VARLIST$(VLC%) = "SysDivLoop"
  END IF
  
  'Move V1 into SysCalcTempA
  C$ = " movf " + GetByte$(V1$, 0) + ",W": IF IsConst(V1$) THEN C$ = " movlw " + GetByte$(V1$, 0)
  CSC% = CSC% + 1: TempData$(CSC%) = C$
  IF NOT IsConst(V1$) THEN VLC% = VLC% + 1: VARLIST$(VLC%) = V1$
  CSC% = CSC% + 1: TempData$(CSC%) = " movwf SysCalcTempA"

  'Move V2 into SysCalcTempB
  C$ = " movf " + GetByte$(V2$, 0) + ",W": IF IsConst(V2$) THEN C$ = " movlw " + GetByte$(V2$, 0)
  CSC% = CSC% + 1: TempData$(CSC%) = C$
  IF NOT IsConst(V2$) THEN VLC% = VLC% + 1: VARLIST$(VLC%) = V2$
  CSC% = CSC% + 1: TempData$(CSC%) = " movwf SysCalcTempB"
 
  IF ThisCalc% = 1 THEN
   'Move V1 into SysCalcTempA
   'V1 is constant
   IF IsConst(V1$) THEN
    CSC% = CSC% + 1: TempData$(CSC%) = " movlw " + GetByte$(V1$, 1)
    CSC% = CSC% + 1: TempData$(CSC%) = " movwf SysCalcTempA_H"
   END IF
   'V1 is word variable
   IF NOT IsConst(V1$) AND TypeOfVar$(V1$) = "WORD" THEN
    CSC% = CSC% + 1: TempData$(CSC%) = " movf " + GetByte$(V1$, 1) + ",W"
    VLC% = VLC% + 1: VARLIST$(VLC%) = V1$
    CSC% = CSC% + 1: TempData$(CSC%) = " movwf SysCalcTempA_H"
   END IF
   'V1 is byte variable
   IF NOT IsConst(V1$) AND TypeOfVar$(V1$) <> "WORD" THEN
    CSC% = CSC% + 1: TempData$(CSC%) = " clrf SysCalcTempA_H"
   END IF

   'Move V2 into SysCalcTempB
   'V2 is constant
   IF IsConst(V2$) THEN
    CSC% = CSC% + 1: TempData$(CSC%) = " movlw " + GetByte$(V2$, 1)
    CSC% = CSC% + 1: TempData$(CSC%) = " movwf SysCalcTempB_H"
   END IF
   'V2 is word variable
   IF NOT IsConst(V2$) AND TypeOfVar$(V2$) = "WORD" THEN
    CSC% = CSC% + 1: TempData$(CSC%) = " movf " + GetByte$(V2$, 1) + ",W"
    VLC% = VLC% + 1: VARLIST$(VLC%) = V2$
    CSC% = CSC% + 1: TempData$(CSC%) = " movwf SysCalcTempB_H"
   END IF
   'V2 is byte variable
   IF NOT IsConst(V2$) AND TypeOfVar$(V2$) <> "WORD" THEN
    CSC% = CSC% + 1: TempData$(CSC%) = " clrf SysCalcTempB_H"
   END IF

  END IF

  IF ACT$ = "*" THEN CSC% = CSC% + 1: TempData$(CSC%) = " call SysMultSub"
  IF ACT$ = "/" THEN CSC% = CSC% + 1: TempData$(CSC%) = " call SysDivSub"
  IF ThisCalc% = 1 THEN TempData$(CSC%) = TempData$(CSC%) + "16"

  'Write answer
  CV% = CV% + 1
  AV$ = "SysTemp" + MID$(STR$(CV%), 2)
  IF ThisCalc% = 1 THEN
   IF ACT$ = "*" THEN CSC% = CSC% + 1: TempData$(CSC%) = " movf SysCalcTempX_H,W"
   IF ACT$ = "/" THEN CSC% = CSC% + 1: TempData$(CSC%) = " movf SysCalcTempA_H,W"
   CSC% = CSC% + 1: TempData$(CSC%) = " movwf " + AV$ + "_H"
   VLC% = VLC% + 1: VARLIST$(VLC%) = AV$ + "_H"
  END IF
  IF ACT$ = "*" THEN CSC% = CSC% + 1: TempData$(CSC%) = " movf SysCalcTempX,W"
  IF ACT$ = "/" THEN CSC% = CSC% + 1: TempData$(CSC%) = " movf SysCalcTempA,W"
  CSC% = CSC% + 1: TempData$(CSC%) = " movwf " + AV$
  VLC% = VLC% + 1: VARLIST$(VLC%) = AV$

  'Replace sum with answer variable
MultDivAnswer:
  Replace SUM$, V1O$ + ACT$ + V2O$, AV$
  GOTO CALCMULTDIV
 END IF


 'Calculate +, -. Replace sum with variable containing answer
CALCADDSUB:
 IF INSTR(SUM$, "+") <> 0 OR INSTR(SUM$, "-") <> 0 THEN
  'Read the sum
  FS% = 0
FINDADDSUB:
   FS% = FS% + 1
   ACT$ = MID$(SUM$, FS%, 1)
  IF ACT$ <> "+" AND ACT$ <> "-" THEN GOTO FINDADDSUB
  FV% = 0
  FOR T% = FS% - 1 TO 1 STEP -1
   T$ = MID$(SUM$, T%, 1)
   IF T$ = "{" OR T$ = "}" OR T$ = "=" OR T$ = "~" OR T$ = "<" OR T$ = ">" OR T$ = "+" OR T$ = "-" OR T$ = "&" OR T$ = "|" OR T$ = "#" OR T$ = "!" THEN FV% = T%: EXIT FOR
  NEXT T%
  V1$ = LEFT$(SUM$, INSTR(SUM$, ACT$) - 1): V1$ = MID$(V1$, FV% + 1)
  FOR T% = FS% + 1 TO LEN(SUM$)
   T$ = MID$(SUM$, T%, 1)
   IF T$ = "{" OR T$ = "}" OR T$ = "=" OR T$ = "~" OR T$ = "<" OR T$ = ">" OR T$ = "+" OR T$ = "-" OR T$ = "&" OR T$ = "|" OR T$ = "#" OR T$ = "!" THEN FV% = T%: EXIT FOR
   T$ = " "
  NEXT T%
  V2$ = MID$(SUM$, FS% + 1)
  IF INSTR(V2$, T$) < LEN(V2$) AND INSTR(V2$, T$) <> 0 THEN V2$ = LEFT$(V2$, INSTR(V2$, T$) - 1)
  V1O$ = V1$: V2O$ = V2$
  
  'Generate asm code for sum
  'Check if both are constants
  IF IsConst(V1$) AND IsConst(V2$) THEN
   IF ACT$ = "+" THEN AV$ = MID$(STR$(MakeDec(V1$) + MakeDec(V2$)), 2)
   IF ACT$ = "-" THEN AV$ = MID$(STR$(MakeDec(V1$) - MakeDec(V2$)), 2)
   GOTO AddSubAnswer
  END IF

  IF ThisCalc% = 1 THEN
   CSC% = CSC% + 1: TempData$(CSC%) = " bcf STATUS, C"
   V1$ = GetByte$(V1$, 0)
   V2$ = GetByte$(V2$, 0)
  END IF

  'Check if V1 is constant, and put into variable if it is
  IF IsConst(V1$) THEN
   CV% = CV% + 1
   CSC% = CSC% + 1: TempData$(CSC%) = " movlw " + V1$
   V1$ = "SysTemp" + MID$(STR$(CV%), 2)
   CSC% = CSC% + 1: TempData$(CSC%) = " movwf " + V1$
   VLC% = VLC% + 1: VARLIST$(VLC%) = V1$
  END IF
  'Move V2 into W
  C$ = " movf " + V2$ + ",W": IF IsConst(V2$) THEN C$ = " movlw " + V2$
  CSC% = CSC% + 1: TempData$(CSC%) = C$
  IF NOT IsConst(V2$) THEN VLC% = VLC% + 1: VARLIST$(VLC%) = V2$
  'Add/Subtract V2 to/from W
  VLC% = VLC% + 1: VARLIST$(VLC%) = V1$
  C$ = " addwf ": IF ACT$ = "-" THEN C$ = " subwf "
  CSC% = CSC% + 1: TempData$(CSC%) = C$ + V1$ + ",W"

  'Write W to answer
  CV% = CV% + 1
  AV$ = "SysTemp" + MID$(STR$(CV%), 2)
  CSC% = CSC% + 1: TempData$(CSC%) = " movwf " + AV$
  VLC% = VLC% + 1: VARLIST$(VLC%) = AV$

  'High Byte
  IF ThisCalc% = 1 THEN
   VarType$(VLC%) = "WORD"
   V1$ = V1O$: V2$ = V2O$

   AVH$ = "SysTemp" + MID$(STR$(CV%), 2) + "_H"
   VLC% = VLC% + 1: VARLIST$(VLC%) = AVH$

   'Carry from low byte
   CSC% = CSC% + 1: TempData$(CSC%) = " clrf " + AVH$

   IF ACT$ = "+" THEN
    CSC% = CSC% + 1: TempData$(CSC%) = " btfsc STATUS,C"
    CSC% = CSC% + 1: TempData$(CSC%) = " incf " + AVH$ + ",F"
   END IF
   IF ACT$ = "-" THEN
    CSC% = CSC% + 1: TempData$(CSC%) = " btfss STATUS,C"
    CSC% = CSC% + 1: TempData$(CSC%) = " decf " + AVH$ + ",F"
   END IF
   
   'Move high byte A into AVH
   IF IsConst(V1$) THEN
    CSC% = CSC% + 1: TempData$(CSC%) = " movlw " + GetByte$(V1$, 1)
    CSC% = CSC% + 1: TempData$(CSC%) = " addwf " + AVH$ + ",F"
   END IF
   IF NOT IsConst(V1$) AND TypeOfVar$(V1$) = "WORD" THEN
    CSC% = CSC% + 1: TempData$(CSC%) = " movf " + GetByte$(V1$, 1) + ",W"
    CSC% = CSC% + 1: TempData$(CSC%) = " addwf " + AVH$ + ",F"
   END IF

   'Add/subtract high byte B, if it exists
   IF IsConst(V2$) AND VAL(GetByte$(V2$, 1)) <> 0 THEN
    CSC% = CSC% + 1: TempData$(CSC%) = " movf " + AVH$ + ", W"
    IF ACT$ = "+" THEN CSC% = CSC% + 1: TempData$(CSC%) = " addlw " + GetByte$(V2$, 1)
    IF ACT$ = "-" THEN CSC% = CSC% + 1: TempData$(CSC%) = " sublw " + GetByte$(V2$, 1)
    CSC% = CSC% + 1: TempData$(CSC%) = " movwf " + AVH$
   END IF
   IF TypeOfVar$(V2$) = "WORD" THEN
    IF ACT$ = "+" THEN
     CSC% = CSC% + 1: TempData$(CSC%) = " movf " + V2$ + "_H,W"
     CSC% = CSC% + 1: TempData$(CSC%) = " addwf " + AVH$ + ",F"
    END IF
    IF ACT$ = "-" THEN
     CSC% = CSC% + 1: TempData$(CSC%) = " movf " + V2$ + "_H,W"
     CSC% = CSC% + 1: TempData$(CSC%) = " subwf " + AVH$ + ",F"
    END IF
   END IF

  END IF
  
  'Replace sum with answer variable
AddSubAnswer:
  Replace SUM$, V1O$ + ACT$ + V2O$, AV$
  GOTO CALCADDSUB
 END IF

'Calculate <,>,=,~. Replace sum with variable containing answer

'Unusual Tokens:
' ~ (not equal)
' } (equal or greater)
' { (less or equal)

CALCCONDITION:
 IF INSTR(SUM$, "{") <> 0 OR INSTR(SUM$, "}") <> 0 OR INSTR(SUM$, "=") <> 0 OR INSTR(SUM$, "~") <> 0 OR INSTR(SUM$, "<") <> 0 OR INSTR(SUM$, ">") <> 0 THEN
  'Read the sum
  FS% = 0
FINDCONDITION:
   FS% = FS% + 1
   ACT$ = MID$(SUM$, FS%, 1)
  IF ACT$ <> "=" AND ACT$ <> "~" AND ACT$ <> "<" AND ACT$ <> ">" AND ACT$ <> "{" AND ACT$ <> "}" THEN GOTO FINDCONDITION
  FV% = 0
  FOR T% = FS% - 1 TO 1 STEP -1
   T$ = MID$(SUM$, T%, 1)
   IF T$ = "{" OR T$ = "}" OR T$ = "=" OR T$ = "~" OR T$ = "<" OR T$ = ">" OR T$ = "*" OR T$ = "/" OR T$ = "+" OR T$ = "-" OR T$ = "&" OR T$ = "|" OR T$ = "#" OR T$ = "!" THEN FV% = T%: EXIT FOR
  NEXT T%
  V1$ = LEFT$(SUM$, INSTR(SUM$, ACT$) - 1): V1$ = MID$(V1$, FV% + 1)
  FOR T% = FS% + 1 TO LEN(SUM$)
   T$ = MID$(SUM$, T%, 1)
   IF T$ = "{" OR T$ = "}" OR T$ = "=" OR T$ = "~" OR T$ = "<" OR T$ = ">" OR T$ = "*" OR T$ = "/" OR T$ = "+" OR T$ = "-" OR T$ = "&" OR T$ = "|" OR T$ = "#" OR T$ = "!" THEN FV% = T%: EXIT FOR
   T$ = " "
  NEXT T%
  V2$ = MID$(SUM$, FS% + 1)
  IF INSTR(V2$, T$) < LEN(V2$) AND INSTR(V2$, T$) <> 0 THEN V2$ = LEFT$(V2$, INSTR(V2$, T$) - 1)
  V1O$ = V1$: V2O$ = V2$

 'Generate asm code for sum

  'Declare SysCalcTempA, SysCalcTempB and SysCalcTempX
  IF LongPresent% = 0 THEN
   VLC% = VLC% + 1: VARLIST$(VLC%) = "SysCalcTempA"
   VLC% = VLC% + 1: VARLIST$(VLC%) = "SysCalcTempB"
   VLC% = VLC% + 1: VARLIST$(VLC%) = "SysCalcTempX"
  END IF
  
  IF ThisCalc% = 0 OR ACT$ = "=" OR ACT$ = "~" THEN
   'Move V1 into SysCalcTempA
   C$ = " movf " + GetByte$(V1$, 0) + ",W": IF IsConst(V1$) THEN C$ = " movlw " + GetByte$(V1$, 0)
   CSC% = CSC% + 1: TempData$(CSC%) = C$
   IF NOT IsConst(V1$) THEN VLC% = VLC% + 1: VARLIST$(VLC%) = V1$
   CSC% = CSC% + 1: TempData$(CSC%) = " movwf SysCalcTempA"

   'Move V2 into SysCalcTempB
   C$ = " movf " + GetByte$(V2$, 0) + ",W": IF IsConst(V2$) THEN C$ = " movlw " + GetByte$(V2$, 0)
   CSC% = CSC% + 1: TempData$(CSC%) = C$
   IF NOT IsConst(V2$) THEN VLC% = VLC% + 1: VARLIST$(VLC%) = V2$
   CSC% = CSC% + 1: TempData$(CSC%) = " movwf SysCalcTempB"
  END IF

  IF ThisCalc% = 1 THEN

   'High Byte for =, ~
   IF ACT$ = "=" OR ACT$ = "~" THEN
   
    'Move V1 into SysCalcTempA
    'V1 is constant
    IF IsConst(V1$) THEN
     CSC% = CSC% + 1: TempData$(CSC%) = " movlw " + GetByte$(V1$, 1)
     CSC% = CSC% + 1: TempData$(CSC%) = " movwf SysCalcTempA_H"
    END IF
    'V1 is word variable
    IF NOT IsConst(V1$) AND TypeOfVar$(V1$) = "WORD" THEN
     CSC% = CSC% + 1: TempData$(CSC%) = " movf " + GetByte$(V1$, 1) + ",W"
     VLC% = VLC% + 1: VARLIST$(VLC%) = V1$
     CSC% = CSC% + 1: TempData$(CSC%) = " movwf SysCalcTempA_H"
    END IF
    'V1 is byte variable
    IF NOT IsConst(V1$) AND TypeOfVar$(V1$) <> "WORD" THEN
     CSC% = CSC% + 1: TempData$(CSC%) = " clrf SysCalcTempA_H"
    END IF
    
    'Move V2 into SysCalcTempB
    'V2 is constant
    IF IsConst(V2$) THEN
     CSC% = CSC% + 1: TempData$(CSC%) = " movlw " + GetByte$(V2$, 1)
     CSC% = CSC% + 1: TempData$(CSC%) = " movwf SysCalcTempB_H"
    END IF
    'V2 is word variable
    IF NOT IsConst(V2$) AND TypeOfVar$(V2$) = "WORD" THEN
     CSC% = CSC% + 1: TempData$(CSC%) = " movf " + GetByte$(V2$, 1) + ",W"
     VLC% = VLC% + 1: VARLIST$(VLC%) = V2$
     CSC% = CSC% + 1: TempData$(CSC%) = " movwf SysCalcTempB_H"
    END IF
    'V2 is byte variable
    IF NOT IsConst(V2$) AND TypeOfVar$(V2$) <> "WORD" THEN
     CSC% = CSC% + 1: TempData$(CSC%) = " clrf SysCalcTempB_H"
    END IF
    
   END IF

   IF ACT$ = "<" OR ACT$ = ">" OR ACT$ = "{" OR ACT$ = "}" THEN

    'Move whole word
    'Move V1 into SysCalcTempA
    'V1 is constant
    IF IsConst(V1$) THEN
     CSC% = CSC% + 1: TempData$(CSC%) = " movlw " + GetByte$(V1$, 0)
     CSC% = CSC% + 1: TempData$(CSC%) = " movwf SysCalcTempA_H"
     CSC% = CSC% + 1: TempData$(CSC%) = " movlw " + GetByte$(V1$, 1)
     CSC% = CSC% + 1: TempData$(CSC%) = " movwf SysCalcTempA"
    END IF
    'V1 is word variable
    IF NOT IsConst(V1$) THEN
     CSC% = CSC% + 1: TempData$(CSC%) = " movf " + GetByte$(V1$, 0) + ",W"
     VLC% = VLC% + 1: VARLIST$(VLC%) = V1$
     CSC% = CSC% + 1: TempData$(CSC%) = " movwf SysCalcTempA_H"
     IF TypeOfVar$(V1$) = "WORD" THEN
      CSC% = CSC% + 1: TempData$(CSC%) = " movf " + GetByte$(V1$, 1) + ",W"
      VLC% = VLC% + 1: VARLIST$(VLC%) = GetByte$(V1$, 1)
      CSC% = CSC% + 1: TempData$(CSC%) = " movwf SysCalcTempA"
     END IF
     IF TypeOfVar$(V1$) <> "WORD" THEN
      CSC% = CSC% + 1: TempData$(CSC%) = " clrf SysCalcTempA"
     END IF
    END IF
  
    'Move V2 into SysCalcTempB
    'V2 is constant
    IF IsConst(V2$) THEN
     CSC% = CSC% + 1: TempData$(CSC%) = " movlw " + GetByte$(V2$, 0)
     CSC% = CSC% + 1: TempData$(CSC%) = " movwf SysCalcTempB_H"
     CSC% = CSC% + 1: TempData$(CSC%) = " movlw " + GetByte$(V2$, 1)
     CSC% = CSC% + 1: TempData$(CSC%) = " movwf SysCalcTempB"
    END IF
    'V2 is word variable
    IF NOT IsConst(V2$) THEN
     CSC% = CSC% + 1: TempData$(CSC%) = " movf " + GetByte$(V2$, 0) + ",W"
     VLC% = VLC% + 1: VARLIST$(VLC%) = V2$
     CSC% = CSC% + 1: TempData$(CSC%) = " movwf SysCalcTempB_H"
     IF TypeOfVar$(V2$) = "WORD" THEN
      CSC% = CSC% + 1: TempData$(CSC%) = " movf " + GetByte$(V2$, 1) + ",W"
      VLC% = VLC% + 1: VARLIST$(VLC%) = GetByte$(V2$, 1)
      CSC% = CSC% + 1: TempData$(CSC%) = " movwf SysCalcTempB"
     END IF
     IF TypeOfVar$(V2$) <> "WORD" THEN
      CSC% = CSC% + 1: TempData$(CSC%) = " clrf SysCalcTempB"
     END IF
    END IF
   
   END IF

  END IF

  IF ACT$ = "=" THEN CSC% = CSC% + 1: TempData$(CSC%) = " call SysCompEqual"
  IF ACT$ = "~" THEN CSC% = CSC% + 1: TempData$(CSC%) = " call SysCompNotEqual"
  IF ACT$ = "<" THEN CSC% = CSC% + 1: TempData$(CSC%) = " call SysCompLessThan"
  IF ACT$ = ">" THEN CSC% = CSC% + 1: TempData$(CSC%) = " call SysCompMoreThan"
  IF ACT$ = "{" THEN CSC% = CSC% + 1: TempData$(CSC%) = " call SysCompLessOrEqual"
  IF ACT$ = "}" THEN CSC% = CSC% + 1: TempData$(CSC%) = " call SysCompMoreOrEqual"
  IF ThisCalc% = 1 THEN TempData$(CSC%) = TempData$(CSC%) + "16"

  'Write answer
  CSC% = CSC% + 1: TempData$(CSC%) = " movf SysCalcTempX,W"
  CV% = CV% + 1
  AV$ = "SysTemp" + MID$(STR$(CV%), 2)
  CSC% = CSC% + 1: TempData$(CSC%) = " movwf " + AV$

  'Replace sum with answer variable
  Replace SUM$, V1O$ + ACT$ + V2O$, AV$
  VLC% = VLC% + 1: VARLIST$(VLC%) = AV$
  GOTO CALCCONDITION
 END IF

 'Calculate AND,OR,XOR,NOT
CALCLOGIC:
 IF INSTR(SUM$, "&") <> 0 OR INSTR(SUM$, "|") <> 0 OR INSTR(SUM$, "#") <> 0 OR INSTR(SUM$, "!") <> 0 THEN
  'Read the sum
  FS% = 0
FINDLOGICAL:
   FS% = FS% + 1
   ACT$ = MID$(SUM$, FS%, 1)
  IF ACT$ <> "&" AND ACT$ <> "|" AND ACT$ <> "#" AND ACT$ <> "!" THEN GOTO FINDLOGICAL
  IF ACT$ <> "!" THEN
   FV% = 0
   FOR T% = FS% - 1 TO 1 STEP -1
    T$ = MID$(SUM$, T%, 1)
    IF T$ = "&" OR T$ = "|" OR T$ = "#" OR T$ = "!" THEN FV% = T%: EXIT FOR
   NEXT T%
   V1$ = LEFT$(SUM$, INSTR(SUM$, ACT$) - 1): V1$ = MID$(V1$, FV% + 1)
  END IF

  FOR T% = FS% + 1 TO LEN(SUM$)
   T$ = MID$(SUM$, T%, 1)
   IF T$ = "&" OR T$ = "|" OR T$ = "#" OR T$ = "!" THEN FV% = T%: EXIT FOR
   T$ = " "
  NEXT T%
  V2$ = MID$(SUM$, FS% + 1)
  IF INSTR(V2$, T$) < LEN(V2$) AND INSTR(V2$, T$) <> 0 THEN V2$ = LEFT$(V2$, INSTR(V2$, T$) - 1)
  
  V1O$ = V1$: ACTO$ = ACT$: V2O$ = V2$
  
  'Generate asm code for sum

  'Check if V2 is a constant, and put it into variable if it is
  IF IsConst(V2$) THEN
   CV% = CV% + 1
   CSC% = CSC% + 1: TempData$(CSC%) = " movlw " + GetByte$(V2$, 0)
   V2$ = "SysTemp" + MID$(STR$(CV%), 2)
   CSC% = CSC% + 1: TempData$(CSC%) = " movwf " + V2$
   VLC% = VLC% + 1: VARLIST$(VLC%) = V2$
  END IF
  IF ACT$ <> "!" THEN
   'Move V1 into W
   C$ = " movf " + GetByte$(V1$, 0) + ",W": IF IsConst(V1$) THEN C$ = " movlw " + GetByte$(V1$, 0)
   CSC% = CSC% + 1: TempData$(CSC%) = C$
   IF NOT IsConst(V1$) THEN VLC% = VLC% + 1: VARLIST$(VLC%) = V1$
  END IF

  'AND/OR/XOR/NOT W with V2
  IF ACT$ = "&" THEN C$ = " andwf "
  IF ACT$ = "|" THEN C$ = " iorwf "
  IF ACT$ = "#" THEN C$ = " xorwf "
  IF ACT$ = "!" THEN C$ = " comf "
  VLC% = VLC% + 1: VARLIST$(VLC%) = V2$
  CSC% = CSC% + 1: TempData$(CSC%) = C$ + GetByte$(V2$, 0) + ",W"
  
  'Write W to answer
  CV% = CV% + 1
  AV$ = "SysTemp" + MID$(STR$(CV%), 2)
  CSC% = CSC% + 1: TempData$(CSC%) = " movwf " + AV$
  
  'Replace sum with answer variable
  Replace SUM$, V1O$ + ACTO$ + V2O$, AV$
  VLC% = VLC% + 1: VARLIST$(VLC%) = AV$

  'Repeat for high byte
  IF ThisCalc% = 1 THEN

   V1$ = V1O$: V2$ = V2O$

   'Check if V2 is a constant, and put it into variable if it is
   IF NOT IsConst(V2$) AND TypeOfVar$(V2$) <> "WORD" THEN V2$ = "0"
   IF IsConst(V2$) THEN
    CSC% = CSC% + 1: TempData$(CSC%) = " movlw " + GetByte$(V2$, 1)
    V2$ = "SysTemp" + MID$(STR$(CV% - 1), 2)
    CSC% = CSC% + 1: TempData$(CSC%) = " movwf " + V2$ + "_H"
    VLC% = VLC% + 1: VARLIST$(VLC%) = V2$
   END IF
   IF ACT$ <> "!" THEN
    'Move V1 into W
    C$ = " clrw"
    IF TypeOfVar$(V1$) = "WORD" THEN
     C$ = " movf " + GetByte$(V1$, 1) + ",W"
    END IF
    IF IsConst(V1$) THEN C$ = " movlw " + GetByte$(V1$, 1)
    CSC% = CSC% + 1: TempData$(CSC%) = C$
    IF NOT IsConst(V1$) THEN VLC% = VLC% + 1: VARLIST$(VLC%) = GetByte$(V1$, 1)
   END IF
 
   'AND/OR/XOR/NOT W with V2
   IF ACT$ = "&" THEN C$ = " andwf "
   IF ACT$ = "|" THEN C$ = " iorwf "
   IF ACT$ = "#" THEN C$ = " xorwf "
   IF ACT$ = "!" THEN C$ = " comf "
   VLC% = VLC% + 1: VARLIST$(VLC%) = GetByte$(V2$, 1)
   CSC% = CSC% + 1: TempData$(CSC%) = C$ + GetByte$(V2$, 1) + ",W"
 
   'Write W to answer
   AV$ = "SysTemp" + MID$(STR$(CV%), 2) + "_H"
   CSC% = CSC% + 1: TempData$(CSC%) = " movwf " + AV$
 
   VLC% = VLC% + 1: VARLIST$(VLC%) = AV$
   
  END IF

  GOTO CALCLOGIC
 END IF

END SUB

SUB CompileConditions (Condition$, IfTrue$)

 'Initialise
 FOR PD% = 1 TO 100
  CheckTemp$(PD%) = ""
 NEXT PD%
 COSC% = 0: CV% = 0

 'Decide whether to compile inline or using CompileCalc
 Complex = 0
 IF CountOccur(Condition$, "';=~<>{}.") = 0 THEN Complex = -1
 IF CountOccur(Condition$, "';=~<>{}+-*/&|#!") >= 2 THEN Complex = 1

 'One condition, so compile inline
 IF Complex = 0 THEN
  OP$ = ""
  IF INSTR(Condition$, "=") <> 0 THEN OP$ = "="
  IF INSTR(Condition$, "~") <> 0 THEN OP$ = "~"
  IF INSTR(Condition$, ".") <> 0 THEN OP$ = "."
  IF INSTR(Condition$, "<") <> 0 THEN OP$ = "<"
  IF INSTR(Condition$, ">") <> 0 THEN OP$ = ">"
  IF INSTR(Condition$, "{") <> 0 THEN OP$ = "{"
  IF INSTR(Condition$, "}") <> 0 THEN OP$ = "}"

  'If the condition is not a bit test, then run this code:
  IF OP$ <> "." THEN
   'Read input variables
   V1$ = UCASE$(LEFT$(Condition$, INSTR(Condition$, OP$) - 1))
   DO WHILE INSTR(V1$, " ") <> 0: Replace V1$, " ", "": LOOP
   V2$ = UCASE$(MID$(Condition$, INSTR(Condition$, OP$) + 1))
   DO WHILE INSTR(V2$, " ") <> 0: Replace V2$, " ", "": LOOP
   
   IF TypeOfVar$(V1$) <> "BYTE" OR TypeOfVar$(V2$) <> "BYTE" THEN
    Complex = 1
    GOTO ComplexCondition
   END IF

   IF NOT IsConst(V1$) THEN VLC% = VLC% + 1: VARLIST$(VLC%) = V1$
   IF NOT IsConst(V2$) THEN VLC% = VLC% + 1: VARLIST$(VLC%) = V2$

   'Code for equal/not equal
   IF OP$ = "=" OR OP$ = "~" THEN
    'V1 must always be a variable. V2 can be variable or constant.
    IF IsConst(V1$) AND NOT IsConst(V2$) THEN T$ = V1$: V1$ = V2$: V2$ = T$
    IF IsConst(V1$) AND IsConst(V2$) THEN
     COSC% = COSC% + 1: CheckTemp$(COSC%) = " movlw " + V1$
     COSC% = COSC% + 1: CheckTemp$(COSC%) = " movwf SysIFTemp"
     V1$ = "SysIFTemp": VLC% = VLC% + 1: VARLIST$(VLC%) = "SysIFTemp"
    END IF
    IF IsConst(V2$) THEN COSC% = COSC% + 1: CheckTemp$(COSC%) = " movlw " + V2$
    IF NOT IsConst(V2$) THEN COSC% = COSC% + 1: CheckTemp$(COSC%) = " movf " + V2$ + ",W"
    COSC% = COSC% + 1: CheckTemp$(COSC%) = " subwf " + V1$ + ",W"

    IF INSTR(UCASE$(IfTrue$), "TRUE") <> 0 THEN
     C$ = " btfss STATUS, Z"
     IF OP$ = "=" THEN C$ = " btfsc STATUS, Z"
    END IF
    IF INSTR(UCASE$(IfTrue$), "FALSE") <> 0 THEN
     C$ = " btfsc STATUS, Z"
     IF OP$ = "=" THEN C$ = " btfss STATUS, Z"
    END IF
    COSC% = COSC% + 1: CheckTemp$(COSC%) = C$
   END IF

   'Code for greater than/less than
   IF OP$ = "<" OR OP$ = ">" THEN
    IF OP$ = ">" THEN T$ = V1$: V1$ = V2$: V2$ = T$
    'Take bigger from smaller. V2 should be bigger. Take V2 from V1
    'mov small into W
    'sub big from W
    IF IsConst(V1$) THEN
     COSC% = COSC% + 1: CheckTemp$(COSC%) = " movlw " + V1$
     COSC% = COSC% + 1: CheckTemp$(COSC%) = " movwf SysIFTemp"
     V1$ = "SysIFTemp": VLC% = VLC% + 1: VARLIST$(VLC%) = "SysIFTemp"
    END IF
    IF IsConst(V2$) THEN C$ = " movlw " + V2$
    IF NOT IsConst(V2$) THEN C$ = " movf " + V2$ + ",W"
    COSC% = COSC% + 1: CheckTemp$(COSC%) = C$
    COSC% = COSC% + 1: CheckTemp$(COSC%) = " subwf " + V1$ + ",W"
    IF INSTR(UCASE$(IfTrue$), "TRUE") <> 0 THEN C$ = " btfss STATUS, C"
    IF INSTR(UCASE$(IfTrue$), "FALSE") <> 0 THEN C$ = " btfsc STATUS, C"
    COSC% = COSC% + 1: CheckTemp$(COSC%) = C$
   END IF

   'Code for less or equal/more or equal
   IF OP$ = "{" OR OP$ = "}" THEN
    IF OP$ = "{" THEN T$ = V1$: V1$ = V2$: V2$ = T$
    'Take smaller from bigger. V1 should be bigger or equal. Take V2 from V1
    'mov small into W
    'sub big from W
    IF IsConst(V1$) THEN
     COSC% = COSC% + 1: CheckTemp$(COSC%) = " movlw " + V1$
     COSC% = COSC% + 1: CheckTemp$(COSC%) = " movwf SysIFTemp"
     V1$ = "SysIFTemp": VLC% = VLC% + 1: VARLIST$(VLC%) = "SysIFTemp"
    END IF
    IF IsConst(V2$) THEN C$ = " movlw " + V2$
    IF NOT IsConst(V2$) THEN C$ = " movf " + V2$ + ",W"
    COSC% = COSC% + 1: CheckTemp$(COSC%) = C$
    COSC% = COSC% + 1: CheckTemp$(COSC%) = " subwf " + V1$ + ",W"
    IF INSTR(UCASE$(IfTrue$), "TRUE") <> 0 THEN C$ = " btfsc STATUS, C"
    IF INSTR(UCASE$(IfTrue$), "FALSE") <> 0 THEN C$ = " btfss STATUS, C"
    COSC% = COSC% + 1: CheckTemp$(COSC%) = C$
   END IF

  END IF

  'Code for a bit test
  IF OP$ = "." THEN
   T% = 1
   V$ = UCASE$(LEFT$(Condition$, INSTR(Condition$, ".") - 1))
   B$ = MID$(Condition$, INSTR(Condition$, ".") + 1): B$ = LEFT$(B$, INSTR(B$, " ") - 1)
   S% = VAL(MID$(Condition$, INSTR(Condition$, " ") + 1))

   'Allow use with vars > 8 bit
   IF VAL(B$) > 7 THEN
    B$ = MID$(STR$(VAL(B$) - 8), 2)
    V$ = V$ + "_H"
   END IF
   
   IF INSTR(UCASE$(IfTrue$), "TRUE") <> 0 THEN
    C$ = " btfss "
    IF S% = 1 THEN C$ = " btfsc "
   END IF
   IF INSTR(UCASE$(IfTrue$), "FALSE") <> 0 THEN
    C$ = " btfsc "
    IF S% = 1 THEN C$ = " btfss "
   END IF
   C$ = C$ + V$ + "," + B$
   COSC% = 1: CheckTemp$(COSC%) = C$
   VLC% = VLC% + 1: VARLIST$(VLC%) = V$
  END IF

 END IF

 'More than one condition, so compile as calculation
ComplexCondition:
 IF Complex = 1 THEN
  FOR T% = 1 TO 100
   TempData$(T%) = ""
  NEXT T%
  DO WHILE INSTR(Condition$, " ") <> 0: Replace Condition$, " ", "": LOOP
  T% = 0
  S$ = Condition$
  CSC% = 0
  ThisCalc% = 0
  IF IsWord(S$) THEN ThisCalc% = 1

  CompileCalc S$
  TempData$(CSC%) = " movwf SysIFTemp"
  FOR WD% = 1 TO CSC%
   CheckTemp$(WD%) = TempData$(WD%)
  NEXT WD%
  COSC% = CSC% + 1
  IF INSTR(UCASE$(IfTrue$), "TRUE") <> 0 THEN C$ = " btfss STATUS, Z"
  IF INSTR(UCASE$(IfTrue$), "FALSE") <> 0 THEN C$ = " btfsc STATUS, Z"
  CheckTemp$(COSC%) = C$
  VLC% = VLC% + 1: VARLIST$(VLC%) = "SysIFTemp"
 END IF

 'No conditions - check if variable is 0 or non-0
 IF Complex = -1 THEN
  COSC% = 2
  CheckTemp$(1) = "SysIFTemp=" + UCASE$(Condition$)
  IF INSTR(UCASE$(IfTrue$), "TRUE") <> 0 THEN C$ = " btfss STATUS, Z"
  IF INSTR(UCASE$(IfTrue$), "FALSE") <> 0 THEN C$ = " btfsc STATUS, Z"
  CheckTemp$(2) = C$
 END IF

END SUB

FUNCTION CountOccur (Source$, Search$)
 T% = 0

 IF LEFT$(Search$, 2) <> "';" THEN
  FOR CO% = 1 TO LEN(Source$) - (1 - LEN(Search$))
   IF MID$(UCASE$(Source$), CO%, LEN(Search$)) = UCASE$(Search$) THEN T% = T% + 1
  NEXT CO%
 END IF

 IF LEFT$(Search$, 2) = "';" THEN
  T$ = MID$(Search$, 3)
  FOR SC% = 1 TO LEN(T$)
   FOR CO% = 1 TO LEN(Source$)
    IF MID$(UCASE$(Source$), CO%, 1) = UCASE$(MID$(T$, SC%, 1)) THEN T% = T% + 1
   NEXT CO%
  NEXT SC%
 END IF

 CountOccur = T%
END FUNCTION

FUNCTION GetByte$ (DS$, BS%)

 'BS% is 0 for low, 1 for high

 'Check if variable
 IF NOT IsConst(DS$) THEN
  IF BS% = 0 THEN GetByte$ = DS$: EXIT FUNCTION
  IF BS% = 1 THEN GetByte$ = DS$ + "_H": EXIT FUNCTION
 END IF

 T! = 0

 'Convert to decimal
 IF DS$ = MID$(STR$(VAL(DS$)), 2) THEN T! = VAL(DS$)

 IF INSTR(LCASE$(DS$), "b'") <> 0 THEN
  T$ = MID$(DS$, INSTR(LCASE$(DS$), "b'") + 2)
  Replace T$, "'", ""
  T! = 0
  FOR PD% = 1 TO LEN(T$)
   T! = T! + 2 ^ (LEN(T$) - PD%) * VAL(MID$(T$, PD%, 1))
  NEXT PD%
 END IF

 IF INSTR(LCASE$(DS$), "0x") <> 0 THEN
  T$ = DS$
  Replace T$, "0x", "&h"
  T! = VAL(T$)
 END IF

 IF BS% = 0 THEN GetByte$ = MID$(STR$(T! AND 255), 2)
 IF BS% = 1 THEN GetByte$ = MID$(STR$((T! AND 65280) / 256), 2)

END FUNCTION

SUB InitCompiler (C$)

'Replace - with / in parameters
'Allows better DOSBox compatibility
IF INSTR(C$, "-O:") <> 0 THEN Replace C$, "-O:", "/O:"
IF INSTR(C$, "-A:") <> 0 THEN Replace C$, "-A:", "/A:"
IF INSTR(C$, "-D:") <> 0 THEN Replace C$, "-D:", "/D:"
IF INSTR(C$, "-V") <> 0 THEN Replace C$, "-V", "/V"
IF INSTR(C$, "-NC") <> 0 THEN Replace C$, "-NC", "/NC"
IF INSTR(C$, "-L") <> 0 THEN Replace C$, "-L", "/L"


'Get output filename from COMMAND$
OFI$ = ""
IF INSTR(C$, "/O:") <> 0 THEN
 T$ = MID$(C$, INSTR(C$, "/O:"))
 IF INSTR(T$, " ") <> 0 THEN T$ = LEFT$(T$, INSTR(T$, " ") - 1)
 Replace C$, T$, ""
 OFI$ = MID$(T$, 4)
END IF

'Get command to assemble program from COMMAND$
MakeASM$ = ""
IF INSTR(C$, "/A:") <> 0 THEN
 T$ = MID$(C$, INSTR(C$, "/A:"))
 IF INSTR(T$, " ") <> 0 THEN T$ = LEFT$(T$, INSTR(T$, " ") - 1)
 Replace C$, T$, ""
 MakeASM$ = MID$(T$, 4)
END IF

'Detect GCBASIC install directory
ID$ = CURDIR$
IF INSTR(C$, "/D:") <> 0 THEN
 T$ = MID$(C$, INSTR(C$, "/D:"))
 IF INSTR(T$, " ") <> 0 THEN T$ = LEFT$(T$, INSTR(T$, " ") - 1)
 Replace C$, T$, ""
 ID$ = MID$(T$, 4)
END IF

'Clear screen before compile?
IF INSTR(C$, "/NC") = 0 THEN CLS
Replace C$, "/NC", ""

'Verbose Mode?
VBS% = 0: IF INSTR(C$, "/V") <> 0 THEN VBS% = 1
Replace C$, "/V", ""

'Show Licence?
IF INSTR(C$, "/L") <> 0 THEN
 PRINT "Great Cow BASIC - A BASIC Compiler for PIC microcontrollers"
 PRINT "Copyright (C) 2006 Hugh Considine"
 PRINT
 PRINT "This program is free software; you can redistribute it and/or modify"
 PRINT "it under the terms of the GNU General Public License as published by"
 PRINT "the Free Software Foundation; either version 2 of the License, or"
 PRINT "(at your option) any later version."
 PRINT
 PRINT "This program is distributed in the hope that it will be useful,"
 PRINT "but WITHOUT ANY WARRANTY; without even the implied warranty of"
 PRINT "MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the"
 PRINT "GNU General Public License for more details."
 PRINT
 PRINT "You should have received a copy of the GNU General Public License"
 PRINT "along with this program; if not, write to the Free Software"
 PRINT "Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA"
 PRINT
 PRINT "If you have any questions, please email me: hconsidine@bigpond.com"
 PRINT
 END
END IF

FI$ = C$
DO WHILE INSTR(FI$, " ") <> 0: Replace FI$, " ", "": LOOP

'Message if no filename specified
IF FI$ = "" THEN
 PRINT "GCBASIC [/D:directory] [/O:output.asm] [/A:filename.bat] [/NC] filename"
 PRINT
 PRINT "Version: " + Version$
 PRINT
 PRINT "A BASIC compiler for PIC chips"
 PRINT
 PRINT "To compile a file, drag and drop it onto the icon for this program."
 PRINT
 PRINT "Alternatively, open a command prompt, and use the commands given."
 PRINT
 PRINT "Command line switches:"
 PRINT "        /D:directory    Specifies the directory that GCBASIC.EXE is in"
 PRINT "        /O:output.asm   Set an output filename other than the default"
 PRINT "        /V              Verbose mode"
 PRINT "        /L              Show license"
 PRINT "        /A:filename.bat Batch file to call if compilation is successful"
 PRINT "        /NC             Do not clear screen. Use in batch files."
 PRINT
 PRINT "You may use - in place of /, such as -V instead of /V."
 PRINT
 PRINT "Please see readme.txt for more info"
 END
END IF

'Decide name for output file if not specified
IF OFI$ = "" THEN
 T$ = MID$(FI$, INSTR(FI$, ".") + 1)
 OFI$ = FI$
 Replace OFI$, T$, "asm"
END IF

'Find directory of source file (used for relative include)
ProgDir$ = CURDIR$
IF INSTR(FI$, "\") <> 0 THEN
 FOR T% = LEN(FI$) TO 1 STEP -1
  IF MID$(FI$, T%, 1) = "\" THEN EXIT FOR
 NEXT T%
 ProgDir$ = LEFT$(FI$, T% - 1)
END IF
IF RIGHT$(ProgDir$, 1) = "\" THEN ProgDir$ = LEFT$(ProgDir$, LEN(ProgDir$) - 1)

'Show version
PRINT "Great Cow BASIC (" + Version$ + ")"
PRINT

'Start Compile
PRINT "Compiling " + FI$ + " ..."

IF DIR$(FI$) = "" THEN
 PRINT
 PRINT "Cannot find " + FI$ + "!"
 END
END IF

END SUB

FUNCTION IsCalc (DS$)

 IsCalc = 0
 IF INSTR(DS$, "+") <> 0 THEN IsCalc = -1
 IF INSTR(DS$, "-") <> 0 THEN IsCalc = -1
 IF INSTR(DS$, "*") <> 0 THEN IsCalc = -1
 IF INSTR(DS$, "/") <> 0 THEN IsCalc = -1
 IF INSTR(DS$, "AND") <> 0 THEN IsCalc = -1
 IF INSTR(DS$, "OR") <> 0 THEN IsCalc = -1
 IF INSTR(DS$, "NOT") <> 0 THEN IsCalc = -1
 IF INSTR(DS$, "XOR") <> 0 THEN IsCalc = -1
 IF INSTR(DS$, "&") <> 0 THEN IsCalc = -1
 IF INSTR(DS$, "|") <> 0 THEN IsCalc = -1
 IF INSTR(DS$, "!") <> 0 THEN IsCalc = -1
 IF INSTR(DS$, "#") <> 0 THEN IsCalc = -1

END FUNCTION

FUNCTION IsConst (DS$)

T$ = LTRIM$(RTRIM$(DS$))
IF LEFT$(T$, 1) = "-" THEN T$ = MID$(T$, 2)

IsConst = 0
IF T$ = MID$(STR$(VAL(T$)), 2) THEN IsConst = -1
IF INSTR(LCASE$(T$), "b'") <> 0 THEN IsConst = -1
IF INSTR(LCASE$(T$), "0x") <> 0 THEN IsConst = -1

IF INSTR(T$, "+") <> 0 THEN IsConst = 0
IF INSTR(T$, "-") <> 0 THEN IsConst = 0
IF INSTR(T$, "*") <> 0 THEN IsConst = 0
IF INSTR(T$, "/") <> 0 THEN IsConst = 0
IF INSTR(T$, "&") <> 0 THEN IsConst = 0
IF INSTR(T$, "|") <> 0 THEN IsConst = 0
IF INSTR(T$, "!") <> 0 THEN IsConst = 0
IF INSTR(T$, "#") <> 0 THEN IsConst = 0


END FUNCTION

FUNCTION IsWord (DS$)

IsWord = 0

FOR PD% = 1 TO VLC%
 IF WholeINSTR(UCASE$(DS$), UCASE$(VARLIST$(PD%))) = 2 AND VarType$(PD%) = "WORD" THEN IsWord = -1: EXIT FUNCTION
NEXT PD%

END FUNCTION

FUNCTION MakeDec (T$)
 DS$ = UCASE$(T$)

 IF INSTR(DS$, "0X") <> 0 THEN
  DS$ = MID$(DS$, INSTR(DS$, "0X") + 2)
  MakeDec = VAL("&H" + DS$)
  EXIT FUNCTION
 END IF

 IF DS$ = MID$(STR$(VAL(DS$)), 2) THEN
  MakeDec = VAL(DS$)
  EXIT FUNCTION
 END IF

 IF INSTR(DS$, "B'") <> 0 THEN
  DS$ = MID$(DS$, INSTR(DS$, "B'") + 2)
  DS$ = LEFT$(DS$, INSTR(DS$, "'") - 1)
  T% = 0
  FOR CB% = LEN(DS$) TO 1 STEP -1
   T% = T% + VAL(MID$(DS$, LEN(DS$) - CB% + 1, 1)) * 2 ^ (CB% - 1)
  NEXT CB%
  MakeDec = T%
 END IF

END FUNCTION

SUB Replace (VAR$, FIND$, REP$)

 VART$ = UCASE$(VAR$): FINDT$ = UCASE$(FIND$)
 IF INSTR(VART$, FINDT$) = 0 THEN VAR$ = VAR$ + REP$: EXIT SUB

 ND$ = LEFT$(VAR$, INSTR(VART$, FINDT$) - 1)
 ND$ = ND$ + REP$
 ND$ = ND$ + MID$(VAR$, INSTR(VART$, FINDT$) + LEN(FIND$))

 VAR$ = ND$
END SUB

SUB SCICONV (ST$)

DO WHILE INSTR(ST$, " ") <> 0: Replace ST$, " ", "": LOOP

IF INSTR(UCASE$(ST$), "E") <> 0 THEN
 T$ = "00000000000000000000"
 V$ = LEFT$(ST$, INSTR(ST$, "E") - 1)
 P$ = MID$(ST$, INSTR(ST$, "E") + 1)
 Replace V$, ".", ""
 P% = VAL(P$)
 S% = 1: IF INSTR(V$, "-") <> 0 THEN S% = -1: Replace V$, "-", ""
 IF SGN(P%) = -1 THEN ST$ = "0." + LEFT$(T$, P% * -1 - 1) + V$
 IF SGN(P%) = 1 THEN ST$ = V$ + LEFT$(T$, P%)
 IF S% = -1 THEN ST$ = "-" + ST$
END IF

IF INSTR(UCASE$(ST$), "D") <> 0 THEN
 T$ = "00000000000000000000"
 DV% = VAL(MID$(ST$, INSTR(ST$, "D") + 1))
 ST$ = LEFT$(ST$, INSTR(ST$, "D") - 1)
 DV% = DV% * SGN(DV%)
 IF DV% > 1 THEN DV% = DV% - 1
 DS$ = ST$
 Replace DS$, ".", ""
 Replace DS$, "-", ""
 Replace DS$, " ", ""
 M% = 0: IF INSTR(ST$, "-") <> 0 THEN M% = 1
 IF DV% > 7 THEN ST$ = ".0": EXIT SUB
 A% = 7 - DV%
 ST$ = "." + LEFT$(T$, DV%)
 ST$ = ST$ + LEFT$(DS$, A%)
 IF M% = 1 THEN ST$ = "-" + ST$
END IF

DO WHILE INSTR(ST$, " ") <> 0: Replace ST$, " ", "": LOOP

END SUB

FUNCTION TypeOfVar$ (VarName$)

TypeOfVar$ = "BYTE"

VarFound% = 0
FOR PD% = 1 TO VLC%
 IF VARLIST$(PD%) = VarName$ THEN VarFound% = PD%: EXIT FOR
NEXT PD%

IF VarFound% <> 0 THEN
 T$ = VarType$(VarFound%)
 IF T$ <> "" THEN TypeOfVar$ = T$
END IF

END FUNCTION

FUNCTION WholeINSTR (DS$, N$)
 IF INSTR(DS$, N$) = 0 THEN WholeINSTR = 0: EXIT FUNCTION

 T% = 0
 IF LEN(DS$) = LEN(N$) THEN T% = 2

 IF INSTR(DS$, N$) = 1 THEN T% = 1
 IF T% = 0 THEN
  T$ = MID$(DS$, INSTR(DS$, N$) - 1, 1)
  IF T$ = " " THEN T% = 1
  IF T$ = "(" THEN T% = 1
  IF T$ = ")" THEN T% = 1
  IF T$ = "," THEN T% = 1
  IF T$ = "." THEN T% = 1
  IF T$ = ":" THEN T% = 1
  IF T$ = "+" THEN T% = 1
  IF T$ = "-" THEN T% = 1
  IF T$ = "*" THEN T% = 1
  IF T$ = "/" THEN T% = 1
  IF T$ = "=" THEN T% = 1
  IF T$ = "!" THEN T% = 1
  IF T$ = "<" THEN T% = 1
  IF T$ = ">" THEN T% = 1
  T2$ = T$
 END IF

 IF INSTR(DS$, N$) + LEN(N$) - 1 = LEN(DS$) THEN T% = T% + 1
 IF T% < 2 THEN
  T$ = MID$(DS$, INSTR(DS$, N$) + LEN(N$), 1)
  IF T$ = " " THEN T% = T% + 1
  IF T$ = "(" THEN T% = T% + 1
  IF T$ = ")" THEN T% = T% + 1
  IF T$ = "," THEN T% = T% + 1
  IF T$ = "." THEN T% = T% + 1
  IF T$ = ":" THEN T% = T% + 1
  IF T$ = "+" THEN T% = T% + 1
  IF T$ = "-" THEN T% = T% + 1
  IF T$ = "*" THEN T% = T% + 1
  IF T$ = "/" THEN T% = T% + 1
  IF T$ = "=" THEN T% = T% + 1
  IF T$ = "!" THEN T% = T% + 1
  IF T$ = "<" THEN T% = T% + 1
  IF T$ = ">" THEN T% = T% + 1
 END IF

WholeINSTR = T%

END FUNCTION

